/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.accounts.Account;
import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.FragmentActivity;
import android.support.v4.util.ArrayMap;
import android.view.View;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.internal.zzaaa;
import com.google.android.gms.internal.zzaad;
import com.google.android.gms.internal.zzaag;
import com.google.android.gms.internal.zzaat;
import com.google.android.gms.internal.zzabd;
import com.google.android.gms.internal.zzabh;
import com.google.android.gms.internal.zzabq;
import com.google.android.gms.internal.zzabx;
import com.google.android.gms.internal.zzbah;
import com.google.android.gms.internal.zzbai;
import com.google.android.gms.internal.zzbaj;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

public abstract class GoogleApiClient {
    private static final Set<GoogleApiClient> zzazc = Collections.newSetFromMap(new WeakHashMap());
    public static final int SIGN_IN_MODE_REQUIRED = 1;
    public static final int SIGN_IN_MODE_OPTIONAL = 2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpAll(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        Set<GoogleApiClient> set = zzazc;
        synchronized (set) {
            int n = 0;
            String string3 = String.valueOf(string2).concat("  ");
            for (GoogleApiClient googleApiClient : zzazc) {
                printWriter.append(string2).append("GoogleApiClient#").println(n++);
                googleApiClient.dump(string3, fileDescriptor, printWriter, stringArray);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<GoogleApiClient> zzvm() {
        Set<GoogleApiClient> set = zzazc;
        synchronized (set) {
            return zzazc;
        }
    }

    public <A extends Api.zzb, R extends Result, T extends zzaad.zza<R, A>> T zza(@NonNull T t) {
        throw new UnsupportedOperationException();
    }

    public <A extends Api.zzb, T extends zzaad.zza<? extends Result, A>> T zzb(@NonNull T t) {
        throw new UnsupportedOperationException();
    }

    public <L> zzabh<L> zzr(@NonNull L l) {
        throw new UnsupportedOperationException();
    }

    @NonNull
    public <C extends Api.zze> C zza(@NonNull Api.zzc<C> zzc2) {
        throw new UnsupportedOperationException();
    }

    public boolean zza(@NonNull Api<?> api) {
        throw new UnsupportedOperationException();
    }

    public abstract boolean hasConnectedApi(@NonNull Api<?> var1);

    @NonNull
    public abstract ConnectionResult getConnectionResult(@NonNull Api<?> var1);

    public Context getContext() {
        throw new UnsupportedOperationException();
    }

    public Looper getLooper() {
        throw new UnsupportedOperationException();
    }

    public boolean zza(zzabq zzabq2) {
        throw new UnsupportedOperationException();
    }

    public void zzvn() {
        throw new UnsupportedOperationException();
    }

    public abstract void connect();

    public void connect(int n) {
        throw new UnsupportedOperationException();
    }

    public abstract ConnectionResult blockingConnect();

    public abstract ConnectionResult blockingConnect(long var1, @NonNull TimeUnit var3);

    public abstract void disconnect();

    public abstract void reconnect();

    public abstract PendingResult<Status> clearDefaultAccountAndReconnect();

    public abstract void stopAutoManage(@NonNull FragmentActivity var1);

    public abstract boolean isConnected();

    public abstract boolean isConnecting();

    public abstract void registerConnectionCallbacks(@NonNull ConnectionCallbacks var1);

    public abstract boolean isConnectionCallbacksRegistered(@NonNull ConnectionCallbacks var1);

    public abstract void unregisterConnectionCallbacks(@NonNull ConnectionCallbacks var1);

    public abstract void registerConnectionFailedListener(@NonNull OnConnectionFailedListener var1);

    public abstract boolean isConnectionFailedListenerRegistered(@NonNull OnConnectionFailedListener var1);

    public abstract void unregisterConnectionFailedListener(@NonNull OnConnectionFailedListener var1);

    public abstract void dump(String var1, FileDescriptor var2, PrintWriter var3, String[] var4);

    public void zza(zzabx zzabx2) {
        throw new UnsupportedOperationException();
    }

    public void zzb(zzabx zzabx2) {
        throw new UnsupportedOperationException();
    }

    public static final class Builder {
        private Account zzahh;
        private final Set<Scope> zzazd = new HashSet<Scope>();
        private final Set<Scope> zzaze = new HashSet<Scope>();
        private int zzazf;
        private View zzazg;
        private String zzaiq;
        private String zzazh;
        private final Map<Api<?>, zzg.zza> zzazi = new ArrayMap();
        private final Context mContext;
        private final Map<Api<?>, Api.ApiOptions> zzazj = new ArrayMap();
        private zzabd zzazk;
        private int zzazl = -1;
        private OnConnectionFailedListener zzazm;
        private Looper zzrs;
        private GoogleApiAvailability zzazn = GoogleApiAvailability.getInstance();
        private Api.zza<? extends zzbai, zzbaj> zzazo = zzbah.zzaie;
        private final ArrayList<ConnectionCallbacks> zzazp = new ArrayList();
        private final ArrayList<OnConnectionFailedListener> zzazq = new ArrayList();
        private boolean zzazr = false;

        public Builder(@NonNull Context context) {
            this.mContext = context;
            this.zzrs = context.getMainLooper();
            this.zzaiq = context.getPackageName();
            this.zzazh = context.getClass().getName();
        }

        public Builder(@NonNull Context context, @NonNull ConnectionCallbacks connectionCallbacks, @NonNull OnConnectionFailedListener onConnectionFailedListener) {
            this(context);
            zzac.zzb((Object)connectionCallbacks, (Object)"Must provide a connected listener");
            this.zzazp.add(connectionCallbacks);
            zzac.zzb((Object)onConnectionFailedListener, (Object)"Must provide a connection failed listener");
            this.zzazq.add(onConnectionFailedListener);
        }

        public Builder setHandler(@NonNull Handler handler) {
            zzac.zzb((Object)handler, (Object)"Handler must not be null");
            this.zzrs = handler.getLooper();
            return this;
        }

        public Builder addConnectionCallbacks(@NonNull ConnectionCallbacks connectionCallbacks) {
            zzac.zzb((Object)connectionCallbacks, (Object)"Listener must not be null");
            this.zzazp.add(connectionCallbacks);
            return this;
        }

        public Builder addOnConnectionFailedListener(@NonNull OnConnectionFailedListener onConnectionFailedListener) {
            zzac.zzb((Object)onConnectionFailedListener, (Object)"Listener must not be null");
            this.zzazq.add(onConnectionFailedListener);
            return this;
        }

        public Builder setViewForPopups(@NonNull View view) {
            zzac.zzb((Object)view, (Object)"View must not be null");
            this.zzazg = view;
            return this;
        }

        public Builder addScope(@NonNull Scope scope) {
            zzac.zzb((Object)scope, (Object)"Scope must not be null");
            this.zzazd.add(scope);
            return this;
        }

        public Builder addApi(@NonNull Api<? extends Api.ApiOptions.NotRequiredOptions> api) {
            zzac.zzb(api, (Object)"Api must not be null");
            this.zzazj.put(api, null);
            List<Scope> list = api.zzve().zzp(null);
            this.zzaze.addAll(list);
            this.zzazd.addAll(list);
            return this;
        }

        public Builder addApiIfAvailable(@NonNull Api<? extends Api.ApiOptions.NotRequiredOptions> api, Scope ... scopeArray) {
            zzac.zzb(api, (Object)"Api must not be null");
            this.zzazj.put(api, null);
            this.zza(api, null, scopeArray);
            return this;
        }

        public <O extends Api.ApiOptions.HasOptions> Builder addApi(@NonNull Api<O> api, @NonNull O o) {
            zzac.zzb(api, (Object)"Api must not be null");
            zzac.zzb(o, (Object)"Null options are not permitted for this Api");
            this.zzazj.put(api, o);
            List<Scope> list = api.zzve().zzp(o);
            this.zzaze.addAll(list);
            this.zzazd.addAll(list);
            return this;
        }

        public <O extends Api.ApiOptions.HasOptions> Builder addApiIfAvailable(@NonNull Api<O> api, @NonNull O o, Scope ... scopeArray) {
            zzac.zzb(api, (Object)"Api must not be null");
            zzac.zzb(o, (Object)"Null options are not permitted for this Api");
            this.zzazj.put(api, o);
            this.zza(api, o, scopeArray);
            return this;
        }

        public Builder setAccountName(String string2) {
            this.zzahh = string2 == null ? null : new Account(string2, "com.google");
            return this;
        }

        public Builder zze(Account account) {
            this.zzahh = account;
            return this;
        }

        public Builder useDefaultAccount() {
            return this.setAccountName("<<default account>>");
        }

        public Builder setGravityForPopups(int n) {
            this.zzazf = n;
            return this;
        }

        public Builder enableAutoManage(@NonNull FragmentActivity fragmentActivity, int n, @Nullable OnConnectionFailedListener onConnectionFailedListener) {
            return this.zza(new zzabd((Activity)fragmentActivity), n, onConnectionFailedListener);
        }

        private Builder zza(@NonNull zzabd zzabd2, int n, @Nullable OnConnectionFailedListener onConnectionFailedListener) {
            zzac.zzb((n >= 0 ? 1 : 0) != 0, (Object)"clientId must be non-negative");
            this.zzazl = n;
            this.zzazm = onConnectionFailedListener;
            this.zzazk = zzabd2;
            return this;
        }

        public Builder enableAutoManage(@NonNull FragmentActivity fragmentActivity, @Nullable OnConnectionFailedListener onConnectionFailedListener) {
            return this.enableAutoManage(fragmentActivity, 0, onConnectionFailedListener);
        }

        public zzg zzvp() {
            zzbaj zzbaj2 = zzbaj.zzbEl;
            if (this.zzazj.containsKey(zzbah.API)) {
                zzbaj2 = (zzbaj)this.zzazj.get(zzbah.API);
            }
            return new zzg(this.zzahh, this.zzazd, this.zzazi, this.zzazf, this.zzazg, this.zzaiq, this.zzazh, zzbaj2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public GoogleApiClient build() {
            zzac.zzb((!this.zzazj.isEmpty() ? 1 : 0) != 0, (Object)"must call addApi() to add at least one API");
            GoogleApiClient googleApiClient = this.zzvq();
            Set set = zzazc;
            synchronized (set) {
                zzazc.add(googleApiClient);
            }
            if (this.zzazl >= 0) {
                this.zzf(googleApiClient);
            }
            return googleApiClient;
        }

        private GoogleApiClient zzvq() {
            zzg zzg2 = this.zzvp();
            Api<?> api = null;
            boolean bl = false;
            Map<Api<?>, zzg.zza> map = zzg2.zzxN();
            ArrayMap arrayMap = new ArrayMap();
            ArrayMap arrayMap2 = new ArrayMap();
            ArrayList<zzaag> arrayList = new ArrayList<zzaag>();
            for (Api<?> api2 : this.zzazj.keySet()) {
                Api.ApiOptions apiOptions = this.zzazj.get(api2);
                boolean bl2 = map.get(api2) != null;
                arrayMap.put(api2, bl2);
                zzaag zzaag2 = new zzaag(api2, bl2);
                arrayList.add(zzaag2);
                Object object = api2.zzvf();
                Api.zza<?, ?> zza2 = object;
                Object obj = Builder.zza(object, apiOptions, this.mContext, this.zzrs, zzg2, zzaag2, zzaag2);
                arrayMap2.put(api2.zzvg(), obj);
                if (zza2.getPriority() == 1) {
                    boolean bl3 = bl = apiOptions != null;
                }
                if (!obj.zzrr()) continue;
                if (api != null) {
                    object = String.valueOf(api2.getName());
                    String string2 = String.valueOf(api.getName());
                    throw new IllegalStateException(new StringBuilder(21 + String.valueOf(object).length() + String.valueOf(string2).length()).append((String)object).append(" cannot be used with ").append(string2).toString());
                }
                api = api2;
            }
            if (api != null) {
                if (bl) {
                    String string3 = String.valueOf(api.getName());
                    throw new IllegalStateException(new StringBuilder(82 + String.valueOf(string3).length()).append("With using ").append(string3).append(", GamesOptions can only be specified within GoogleSignInOptions.Builder").toString());
                }
                zzac.zza((this.zzahh == null ? 1 : 0) != 0, (String)"Must not set an account in GoogleApiClient.Builder when using %s. Set account in GoogleSignInOptions.Builder instead", (Object[])new Object[]{api.getName()});
                zzac.zza((boolean)this.zzazd.equals(this.zzaze), (String)"Must not set scopes in GoogleApiClient.Builder when using %s. Set account in GoogleSignInOptions.Builder instead.", (Object[])new Object[]{api.getName()});
            }
            int n = zzaat.zza(arrayMap2.values(), true);
            return new zzaat(this.mContext, new ReentrantLock(), this.zzrs, zzg2, this.zzazn, this.zzazo, (Map<Api<?>, Boolean>)arrayMap, (List<ConnectionCallbacks>)this.zzazp, (List<OnConnectionFailedListener>)this.zzazq, (Map<Api.zzc<?>, Api.zze>)arrayMap2, this.zzazl, n, arrayList, false);
        }

        private void zzf(GoogleApiClient googleApiClient) {
            zzaaa.zza(this.zzazk).zza(this.zzazl, googleApiClient, this.zzazm);
        }

        private <O extends Api.ApiOptions> void zza(Api<O> api, O o, Scope ... scopeArray) {
            HashSet<Scope> hashSet = new HashSet<Scope>(api.zzve().zzp(o));
            for (Scope scope : scopeArray) {
                hashSet.add(scope);
            }
            this.zzazi.put(api, new zzg.zza(hashSet));
        }

        private static <C extends Api.zze, O> C zza(Api.zza<C, O> zza2, Object object, Context context, Looper looper, zzg zzg2, ConnectionCallbacks connectionCallbacks, OnConnectionFailedListener onConnectionFailedListener) {
            return zza2.zza(context, looper, zzg2, object, connectionCallbacks, onConnectionFailedListener);
        }
    }

    public static interface OnConnectionFailedListener {
        public void onConnectionFailed(@NonNull ConnectionResult var1);
    }

    public static interface ConnectionCallbacks {
        public static final int CAUSE_SERVICE_DISCONNECTED = 1;
        public static final int CAUSE_NETWORK_LOST = 2;

        public void onConnected(@Nullable Bundle var1);

        public void onConnectionSuspended(int var1);
    }
}

