/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.signin;

import android.accounts.Account;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.auth.api.signin.GoogleSignInOptionsExtension;
import com.google.android.gms.auth.api.signin.internal.zzn;
import com.google.android.gms.auth.api.signin.internal.zzo;
import com.google.android.gms.auth.api.signin.zzc;
import com.google.android.gms.auth.api.signin.zzd;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.zzbo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GoogleSignInOptions
extends zza
implements Api.ApiOptions.Optional,
ReflectedParcelable {
    public static final Scope zzalV = new Scope("profile");
    public static final Scope zzalW = new Scope("email");
    public static final Scope zzalX = new Scope("openid");
    private static Scope SCOPE_GAMES = new Scope("https://www.googleapis.com/auth/games");
    public static final GoogleSignInOptions DEFAULT_SIGN_IN = new Builder().requestId().requestProfile().build();
    public static final GoogleSignInOptions DEFAULT_GAMES_SIGN_IN = new Builder().requestScopes(SCOPE_GAMES, new Scope[0]).build();
    public static final Parcelable.Creator<GoogleSignInOptions> CREATOR = new zzd();
    private int versionCode;
    private final ArrayList<Scope> zzalY;
    private Account zzajb;
    private boolean zzalh;
    private final boolean zzalZ;
    private final boolean zzama;
    private String zzali;
    private String zzamb;
    private ArrayList<zzn> zzamc;
    private Map<Integer, zzn> zzamd;
    private static Comparator<Scope> zzalU = new zzc();

    @Nullable
    public static GoogleSignInOptions zzbQ(@Nullable String string2) throws JSONException {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        JSONObject jSONObject = new JSONObject(string2);
        HashSet<Scope> hashSet = new HashSet<Scope>();
        JSONArray jSONArray = jSONObject.getJSONArray("scopes");
        int n = jSONArray.length();
        for (int i = 0; i < n; ++i) {
            hashSet.add(new Scope(jSONArray.getString(i)));
        }
        Account account = null;
        String string3 = jSONObject.optString("accountName", null);
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            account = new Account(string3, "com.google");
        }
        return new GoogleSignInOptions(3, new ArrayList<Scope>(hashSet), account, jSONObject.getBoolean("idTokenRequested"), jSONObject.getBoolean("serverAuthRequested"), jSONObject.getBoolean("forceCodeForRefreshToken"), jSONObject.optString("serverClientId", null), jSONObject.optString("hostedDomain", null), new HashMap<Integer, zzn>());
    }

    GoogleSignInOptions(int n, ArrayList<Scope> arrayList, Account account, boolean bl, boolean bl2, boolean bl3, String string2, String string3, ArrayList<zzn> arrayList2) {
        this(n, arrayList, account, bl, bl2, bl3, string2, string3, GoogleSignInOptions.zzw(arrayList2));
    }

    private GoogleSignInOptions(int n, ArrayList<Scope> arrayList, Account account, boolean bl, boolean bl2, boolean bl3, String string2, String string3, Map<Integer, zzn> map) {
        this.versionCode = n;
        this.zzalY = arrayList;
        this.zzajb = account;
        this.zzalh = bl;
        this.zzalZ = bl2;
        this.zzama = bl3;
        this.zzali = string2;
        this.zzamb = string3;
        this.zzamc = new ArrayList<zzn>(map.values());
        this.zzamd = map;
    }

    public final ArrayList<Scope> zzmA() {
        return new ArrayList<Scope>(this.zzalY);
    }

    public Scope[] getScopeArray() {
        return this.zzalY.toArray(new Scope[this.zzalY.size()]);
    }

    public final Account getAccount() {
        return this.zzajb;
    }

    public final boolean isIdTokenRequested() {
        return this.zzalh;
    }

    public final boolean zzmB() {
        return this.zzalZ;
    }

    public final String getServerClientId() {
        return this.zzali;
    }

    private static Map<Integer, zzn> zzw(@Nullable List<zzn> list) {
        HashMap<Integer, zzn> hashMap = new HashMap<Integer, zzn>();
        if (list == null) {
            return hashMap;
        }
        for (zzn zzn2 : list) {
            hashMap.put(zzn2.getType(), zzn2);
        }
        return hashMap;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        GoogleSignInOptions googleSignInOptions = this;
        int n2 = com.google.android.gms.common.internal.safeparcel.zzd.zze((Parcel)parcel2);
        com.google.android.gms.common.internal.safeparcel.zzd.zzc((Parcel)parcel2, (int)1, (int)googleSignInOptions.versionCode);
        com.google.android.gms.common.internal.safeparcel.zzd.zzc((Parcel)parcel2, (int)2, googleSignInOptions.zzmA(), (boolean)false);
        com.google.android.gms.common.internal.safeparcel.zzd.zza((Parcel)parcel2, (int)3, (Parcelable)googleSignInOptions.zzajb, (int)n, (boolean)false);
        com.google.android.gms.common.internal.safeparcel.zzd.zza((Parcel)parcel2, (int)4, (boolean)googleSignInOptions.zzalh);
        com.google.android.gms.common.internal.safeparcel.zzd.zza((Parcel)parcel2, (int)5, (boolean)googleSignInOptions.zzalZ);
        com.google.android.gms.common.internal.safeparcel.zzd.zza((Parcel)parcel2, (int)6, (boolean)googleSignInOptions.zzama);
        com.google.android.gms.common.internal.safeparcel.zzd.zza((Parcel)parcel2, (int)7, (String)googleSignInOptions.zzali, (boolean)false);
        com.google.android.gms.common.internal.safeparcel.zzd.zza((Parcel)parcel2, (int)8, (String)googleSignInOptions.zzamb, (boolean)false);
        com.google.android.gms.common.internal.safeparcel.zzd.zzc((Parcel)parcel2, (int)9, googleSignInOptions.zzamc, (boolean)false);
        com.google.android.gms.common.internal.safeparcel.zzd.zzI((Parcel)parcel2, (int)n2);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        try {
            GoogleSignInOptions googleSignInOptions = (GoogleSignInOptions)object;
            if (this.zzamc.size() > 0 || googleSignInOptions.zzamc.size() > 0) {
                return false;
            }
            if (this.zzalY.size() != googleSignInOptions.zzmA().size() || !this.zzalY.containsAll(googleSignInOptions.zzmA())) {
                return false;
            }
            return (this.zzajb == null ? googleSignInOptions.zzajb == null : this.zzajb.equals((Object)googleSignInOptions.zzajb)) && (TextUtils.isEmpty((CharSequence)this.zzali) ? TextUtils.isEmpty((CharSequence)googleSignInOptions.zzali) : this.zzali.equals(googleSignInOptions.zzali)) && this.zzama == googleSignInOptions.zzama && this.zzalh == googleSignInOptions.zzalh && this.zzalZ == googleSignInOptions.zzalZ;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int hashCode() {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Scope> arrayList2 = this.zzalY;
        int n = arrayList2.size();
        for (int i = 0; i < n; ++i) {
            Scope scope = arrayList2.get(i);
            Scope scope2 = scope;
            arrayList.add(scope2.zzpp());
        }
        Collections.sort(arrayList);
        return new zzo().zzo(arrayList).zzo(this.zzajb).zzo(this.zzali).zzP(this.zzama).zzP(this.zzalh).zzP(this.zzalZ).zzmJ();
    }

    public final String zzmC() {
        return this.zzmz().toString();
    }

    private final JSONObject zzmz() {
        JSONObject jSONObject = new JSONObject();
        try {
            JSONArray jSONArray = new JSONArray();
            Collections.sort(this.zzalY, zzalU);
            ArrayList<Scope> arrayList = this.zzalY;
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                Scope scope = arrayList.get(i);
                Scope scope2 = scope;
                jSONArray.put((Object)scope2.zzpp());
            }
            jSONObject.put("scopes", (Object)jSONArray);
            if (this.zzajb != null) {
                jSONObject.put("accountName", (Object)this.zzajb.name);
            }
            jSONObject.put("idTokenRequested", this.zzalh);
            jSONObject.put("forceCodeForRefreshToken", this.zzama);
            jSONObject.put("serverAuthRequested", this.zzalZ);
            if (!TextUtils.isEmpty((CharSequence)this.zzali)) {
                jSONObject.put("serverClientId", (Object)this.zzali);
            }
            if (!TextUtils.isEmpty((CharSequence)this.zzamb)) {
                jSONObject.put("hostedDomain", (Object)this.zzamb);
            }
            return jSONObject;
        }
        catch (JSONException jSONException) {
            throw new RuntimeException(jSONException);
        }
    }

    /* synthetic */ GoogleSignInOptions(int n, ArrayList arrayList, Account account, boolean bl, boolean bl2, boolean bl3, String string2, String string3, Map map, zzc zzc2) {
        this(3, (ArrayList<Scope>)arrayList, account, bl, bl2, bl3, string2, string3, map);
    }

    public static final class Builder {
        private Set<Scope> zzame = new HashSet<Scope>();
        private boolean zzalZ;
        private boolean zzama;
        private boolean zzalh;
        private String zzali;
        private Account zzajb;
        private String zzamb;
        private Map<Integer, zzn> zzamf = new HashMap<Integer, zzn>();

        public Builder() {
        }

        public Builder(@NonNull GoogleSignInOptions googleSignInOptions) {
            zzbo.zzu((Object)googleSignInOptions);
            this.zzame = new HashSet<Scope>(googleSignInOptions.zzalY);
            this.zzalZ = googleSignInOptions.zzalZ;
            this.zzama = googleSignInOptions.zzama;
            this.zzalh = googleSignInOptions.zzalh;
            this.zzali = googleSignInOptions.zzali;
            this.zzajb = googleSignInOptions.zzajb;
            this.zzamb = googleSignInOptions.zzamb;
            this.zzamf = GoogleSignInOptions.zzw(googleSignInOptions.zzamc);
        }

        public final Builder requestId() {
            this.zzame.add(zzalX);
            return this;
        }

        public final Builder requestEmail() {
            this.zzame.add(zzalW);
            return this;
        }

        public final Builder requestProfile() {
            this.zzame.add(zzalV);
            return this;
        }

        public final Builder requestScopes(Scope scope, Scope ... scopeArray) {
            this.zzame.add(scope);
            this.zzame.addAll(Arrays.asList(scopeArray));
            return this;
        }

        public final Builder requestIdToken(String string2) {
            this.zzalh = true;
            this.zzali = this.zzbR(string2);
            return this;
        }

        public final Builder requestServerAuthCode(String string2) {
            return this.requestServerAuthCode(string2, false);
        }

        public final Builder requestServerAuthCode(String string2, boolean bl) {
            this.zzalZ = true;
            this.zzali = this.zzbR(string2);
            this.zzama = bl;
            return this;
        }

        public final Builder setAccountName(String string2) {
            this.zzajb = new Account(zzbo.zzcF((String)string2), "com.google");
            return this;
        }

        public final Builder setHostedDomain(String string2) {
            this.zzamb = zzbo.zzcF((String)string2);
            return this;
        }

        public final Builder addExtension(GoogleSignInOptionsExtension googleSignInOptionsExtension) {
            if (this.zzamf.containsKey(1)) {
                throw new IllegalStateException("Only one extension per type may be added");
            }
            this.zzamf.put(1, new zzn(googleSignInOptionsExtension));
            return this;
        }

        public final GoogleSignInOptions build() {
            if (this.zzalh && (this.zzajb == null || !this.zzame.isEmpty())) {
                this.requestId();
            }
            return new GoogleSignInOptions(3, new ArrayList<Scope>(this.zzame), this.zzajb, this.zzalh, this.zzalZ, this.zzama, this.zzali, this.zzamb, this.zzamf, null);
        }

        private final String zzbR(String string2) {
            zzbo.zzcF((String)string2);
            zzbo.zzb((this.zzali == null || this.zzali.equals(string2) ? 1 : 0) != 0, (Object)"two different server client ids provided");
            return string2;
        }
    }
}

