/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzq;
import com.google.android.gms.common.internal.zzr;
import com.google.android.gms.common.zze;
import com.google.android.gms.internal.zzbas;
import com.google.android.gms.internal.zzbax;
import com.google.android.gms.internal.zzbbh;
import com.google.android.gms.internal.zzbbn;
import com.google.android.gms.internal.zzbbq;
import com.google.android.gms.internal.zzbbr;
import com.google.android.gms.internal.zzbco;
import com.google.android.gms.internal.zzbda;
import com.google.android.gms.internal.zzbdo;
import com.google.android.gms.internal.zzbeh;
import com.google.android.gms.internal.zzbgu;
import com.google.android.gms.internal.zzctj;
import com.google.android.gms.internal.zzctk;
import com.google.android.gms.tasks.OnCompleteListener;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;

public final class zzbbo
implements zzbdo {
    private final Map<Api.zzc<?>, zzbbn<?>> zzaCB = new HashMap();
    private final Map<Api.zzc<?>, zzbbn<?>> zzaCC = new HashMap();
    private final Map<Api<?>, Boolean> zzaCD;
    private final zzbda zzaAN;
    private final zzbco zzaCE;
    private final Lock zzaCv;
    private final Looper zzrO;
    private final zze zzaCF;
    private final Condition zzaCG;
    private final zzq zzaCA;
    private final boolean zzaCH;
    private final boolean zzaCI;
    private final Queue<zzbax<?, ?>> zzaCJ = new LinkedList();
    private boolean zzaCK;
    private Map<zzbas<?>, ConnectionResult> zzaCL;
    private Map<zzbas<?>, ConnectionResult> zzaCM;
    private zzbbr zzaCN;
    private ConnectionResult zzaCO;

    public zzbbo(Context context, Lock lock, Looper looper, zze zze2, Map<Api.zzc<?>, Api.zze> map, zzq zzq2, Map<Api<?>, Boolean> map2, Api.zza<? extends zzctj, zzctk> zza2, ArrayList<zzbbh> arrayList, zzbco zzbco2, boolean bl) {
        this.zzaCv = lock;
        this.zzrO = looper;
        this.zzaCG = lock.newCondition();
        this.zzaCF = zze2;
        this.zzaCE = zzbco2;
        this.zzaCD = map2;
        this.zzaCA = zzq2;
        this.zzaCH = bl;
        HashMap hashMap = new HashMap();
        for (Api<?> api : map2.keySet()) {
            hashMap.put(api.zzpd(), api);
        }
        HashMap hashMap2 = new HashMap();
        ArrayList<zzbbh> arrayList2 = arrayList;
        int n = arrayList2.size();
        for (int i = 0; i < n; ++i) {
            zzbbh zzbbh2 = arrayList2.get(i);
            zzbbh zzbbh3 = zzbbh2;
            hashMap2.put(zzbbh3.zzayW, zzbbh3);
        }
        boolean bl2 = false;
        boolean bl3 = true;
        boolean bl4 = false;
        for (Map.Entry<Api.zzc<?>, Api.zze> entry : map.entrySet()) {
            Api api = (Api)hashMap.get(entry.getKey());
            Api.zze zze3 = entry.getValue();
            if (zze3.zzpe()) {
                bl4 = true;
                if (!this.zzaCD.get(api).booleanValue()) {
                    bl2 = true;
                }
            } else {
                bl3 = false;
            }
            zzbbh zzbbh4 = (zzbbh)hashMap2.get(api);
            zzbbn zzbbn2 = new zzbbn(context, api, looper, zze3, zzbbh4, zzq2, zza2);
            this.zzaCB.put(entry.getKey(), zzbbn2);
            if (!zze3.zzmv()) continue;
            this.zzaCC.put(entry.getKey(), zzbbn2);
        }
        this.zzaCI = bl4 && !bl3 && !bl2;
        this.zzaAN = zzbda.zzqk();
    }

    @Override
    public final <A extends Api.zzb, R extends Result, T extends zzbax<R, A>> T zzd(@NonNull T t) {
        if (this.zzaCH && this.zzg(t)) {
            return t;
        }
        if (!this.isConnected()) {
            this.zzaCJ.add(t);
            return t;
        }
        this.zzaCE.zzaDL.zzb(t);
        return this.zzaCB.get(t.zzpd()).zza(t);
    }

    @Override
    public final <A extends Api.zzb, T extends zzbax<? extends Result, A>> T zze(@NonNull T t) {
        Api.zzc<A> zzc2 = t.zzpd();
        if (this.zzaCH && this.zzg(t)) {
            return t;
        }
        this.zzaCE.zzaDL.zzb(t);
        return this.zzaCB.get(zzc2).zzb(t);
    }

    private final <T extends zzbax<? extends Result, ? extends Api.zzb>> boolean zzg(@NonNull T t) {
        Api.zzc<? extends Api.zzb> zzc2 = t.zzpd();
        ConnectionResult connectionResult = this.zzb(zzc2);
        if (connectionResult != null && connectionResult.getErrorCode() == 4) {
            t.zzr(new Status(4, null, this.zzaAN.zza(this.zzaCB.get(zzc2).zzph(), System.identityHashCode(this.zzaCE))));
            return true;
        }
        return false;
    }

    @Override
    public final void connect() {
        this.zzaCv.lock();
        try {
            if (this.zzaCK) {
                return;
            }
            this.zzaCK = true;
            this.zzaCL = null;
            this.zzaCM = null;
            this.zzaCN = null;
            this.zzaCO = null;
            this.zzaAN.zzps();
            this.zzaAN.zza(this.zzaCB.values()).addOnCompleteListener((Executor)new zzbgu(this.zzrO), (OnCompleteListener)new zzbbq(this, null));
            return;
        }
        finally {
            this.zzaCv.unlock();
        }
    }

    @Override
    public final ConnectionResult blockingConnect() {
        this.connect();
        while (this.isConnecting()) {
            try {
                this.zzaCG.await();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return new ConnectionResult(15, null);
            }
        }
        if (this.isConnected()) {
            return ConnectionResult.zzazX;
        }
        if (this.zzaCO != null) {
            return this.zzaCO;
        }
        return new ConnectionResult(13, null);
    }

    @Override
    public final ConnectionResult blockingConnect(long l, TimeUnit timeUnit) {
        this.connect();
        long l2 = timeUnit.toNanos(l);
        while (this.isConnecting()) {
            try {
                if (l2 <= 0L) {
                    this.disconnect();
                    return new ConnectionResult(14, null);
                }
                l2 = this.zzaCG.awaitNanos(l2);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return new ConnectionResult(15, null);
            }
        }
        if (this.isConnected()) {
            return ConnectionResult.zzazX;
        }
        if (this.zzaCO != null) {
            return this.zzaCO;
        }
        return new ConnectionResult(13, null);
    }

    @Override
    public final void disconnect() {
        this.zzaCv.lock();
        try {
            this.zzaCK = false;
            this.zzaCL = null;
            this.zzaCM = null;
            if (this.zzaCN != null) {
                this.zzaCN.cancel();
                this.zzaCN = null;
            }
            this.zzaCO = null;
            while (!this.zzaCJ.isEmpty()) {
                zzbax<?, ?> zzbax2 = this.zzaCJ.remove();
                zzbax2.zza(null);
                zzbax2.cancel();
            }
            this.zzaCG.signalAll();
            return;
        }
        finally {
            this.zzaCv.unlock();
        }
    }

    @Override
    @Nullable
    public final ConnectionResult getConnectionResult(@NonNull Api<?> api) {
        return this.zzb(api.zzpd());
    }

    @Nullable
    private final ConnectionResult zzb(@NonNull Api.zzc<?> zzc2) {
        this.zzaCv.lock();
        try {
            zzbbn<?> zzbbn2 = this.zzaCB.get(zzc2);
            if (this.zzaCL != null && zzbbn2 != null) {
                ConnectionResult connectionResult = this.zzaCL.get(zzbbn2.zzph());
                return connectionResult;
            }
            return null;
        }
        finally {
            this.zzaCv.unlock();
        }
    }

    @Override
    public final boolean isConnected() {
        this.zzaCv.lock();
        try {
            boolean bl = this.zzaCL != null && this.zzaCO == null;
            return bl;
        }
        finally {
            this.zzaCv.unlock();
        }
    }

    @Override
    public final boolean isConnecting() {
        this.zzaCv.lock();
        try {
            boolean bl = this.zzaCL == null && this.zzaCK;
            return bl;
        }
        finally {
            this.zzaCv.unlock();
        }
    }

    private final boolean zzpK() {
        this.zzaCv.lock();
        try {
            if (!this.zzaCK || !this.zzaCH) {
                return false;
            }
            for (Api.zzc<?> zzc2 : this.zzaCC.keySet()) {
                ConnectionResult connectionResult = this.zzb(zzc2);
                if (connectionResult != null && connectionResult.isSuccess()) continue;
                return false;
            }
            return true;
        }
        finally {
            this.zzaCv.unlock();
        }
    }

    @Override
    public final boolean zza(zzbeh zzbeh2) {
        this.zzaCv.lock();
        try {
            if (this.zzaCK && !this.zzpK()) {
                this.zzaAN.zzps();
                this.zzaCN = new zzbbr(this, zzbeh2);
                this.zzaAN.zza(this.zzaCC.values()).addOnCompleteListener((Executor)new zzbgu(this.zzrO), (OnCompleteListener)this.zzaCN);
                return true;
            }
            return false;
        }
        finally {
            this.zzaCv.unlock();
        }
    }

    @Override
    public final void zzpl() {
        this.zzaCv.lock();
        try {
            this.zzaAN.zzpl();
            if (this.zzaCN != null) {
                this.zzaCN.cancel();
                this.zzaCN = null;
            }
            if (this.zzaCM == null) {
                this.zzaCM = new ArrayMap(this.zzaCC.size());
            }
            ConnectionResult connectionResult = new ConnectionResult(4);
            for (zzbbn<?> zzbbn2 : this.zzaCC.values()) {
                this.zzaCM.put(zzbbn2.zzph(), connectionResult);
            }
            if (this.zzaCL != null) {
                this.zzaCL.putAll(this.zzaCM);
            }
            return;
        }
        finally {
            this.zzaCv.unlock();
        }
    }

    @Override
    public final void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
    }

    @Override
    public final void zzpE() {
    }

    private final void zzpL() {
        if (this.zzaCA == null) {
            this.zzaCE.zzaDG = Collections.emptySet();
            return;
        }
        HashSet<Scope> hashSet = new HashSet<Scope>(this.zzaCA.zzrn());
        Map<Api<?>, zzr> map = this.zzaCA.zzrp();
        for (Api<?> api : map.keySet()) {
            ConnectionResult connectionResult = this.getConnectionResult(api);
            if (connectionResult == null || !connectionResult.isSuccess()) continue;
            hashSet.addAll(map.get(api).zzame);
        }
        this.zzaCE.zzaDG = hashSet;
    }

    private final void zzpM() {
        while (!this.zzaCJ.isEmpty()) {
            this.zze(this.zzaCJ.remove());
        }
        this.zzaCE.zzm(null);
    }

    private final boolean zza(zzbbn<?> zzbbn2, ConnectionResult connectionResult) {
        return !connectionResult.isSuccess() && !connectionResult.hasResolution() && this.zzaCD.get(zzbbn2.zzpg()) != false && zzbbn2.zzpJ().zzpe() && this.zzaCF.isUserResolvableError(connectionResult.getErrorCode());
    }

    @Nullable
    private final ConnectionResult zzpN() {
        ConnectionResult connectionResult = null;
        int n = 0;
        ConnectionResult connectionResult2 = null;
        int n2 = 0;
        for (zzbbn<?> zzbbn2 : this.zzaCB.values()) {
            int n3;
            Api api = zzbbn2.zzpg();
            zzbas zzbas2 = zzbbn2.zzph();
            ConnectionResult connectionResult3 = this.zzaCL.get(zzbas2);
            if (connectionResult3.isSuccess() || this.zzaCD.get(api).booleanValue() && !connectionResult3.hasResolution() && !this.zzaCF.isUserResolvableError(connectionResult3.getErrorCode())) continue;
            if (connectionResult3.getErrorCode() == 4 && this.zzaCH) {
                n3 = api.zzpb().getPriority();
                if (connectionResult2 != null && n2 <= n3) continue;
                connectionResult2 = connectionResult3;
                n2 = n3;
                continue;
            }
            n3 = api.zzpb().getPriority();
            if (connectionResult != null && n <= n3) continue;
            connectionResult = connectionResult3;
            n = n3;
        }
        if (connectionResult != null && connectionResult2 != null && n > n2) {
            return connectionResult2;
        }
        return connectionResult;
    }

    static /* synthetic */ Lock zza(zzbbo zzbbo2) {
        return zzbbo2.zzaCv;
    }

    static /* synthetic */ boolean zzb(zzbbo zzbbo2) {
        return zzbbo2.zzaCK;
    }

    static /* synthetic */ Map zza(zzbbo zzbbo2, Map map) {
        zzbbo2.zzaCL = map;
        return zzbbo2.zzaCL;
    }

    static /* synthetic */ Map zzc(zzbbo zzbbo2) {
        return zzbbo2.zzaCB;
    }

    static /* synthetic */ Map zzd(zzbbo zzbbo2) {
        return zzbbo2.zzaCL;
    }

    static /* synthetic */ boolean zze(zzbbo zzbbo2) {
        return zzbbo2.zzaCI;
    }

    static /* synthetic */ boolean zza(zzbbo zzbbo2, zzbbn zzbbn2, ConnectionResult connectionResult) {
        return zzbbo2.zza(zzbbn2, connectionResult);
    }

    static /* synthetic */ ConnectionResult zza(zzbbo zzbbo2, ConnectionResult connectionResult) {
        zzbbo2.zzaCO = connectionResult;
        return zzbbo2.zzaCO;
    }

    static /* synthetic */ ConnectionResult zzf(zzbbo zzbbo2) {
        return zzbbo2.zzpN();
    }

    static /* synthetic */ Map zzg(zzbbo zzbbo2) {
        return zzbbo2.zzaCM;
    }

    static /* synthetic */ ConnectionResult zzh(zzbbo zzbbo2) {
        return zzbbo2.zzaCO;
    }

    static /* synthetic */ void zzi(zzbbo zzbbo2) {
        zzbbo2.zzpL();
    }

    static /* synthetic */ void zzj(zzbbo zzbbo2) {
        zzbbo2.zzpM();
    }

    static /* synthetic */ boolean zza(zzbbo zzbbo2, boolean bl) {
        zzbbo2.zzaCK = false;
        return false;
    }

    static /* synthetic */ zzbco zzk(zzbbo zzbbo2) {
        return zzbbo2.zzaCE;
    }

    static /* synthetic */ Condition zzl(zzbbo zzbbo2) {
        return zzbbo2.zzaCG;
    }

    static /* synthetic */ Map zzb(zzbbo zzbbo2, Map map) {
        zzbbo2.zzaCM = map;
        return zzbbo2.zzaCM;
    }

    static /* synthetic */ Map zzm(zzbbo zzbbo2) {
        return zzbbo2.zzaCC;
    }
}

