/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApi;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zza;
import com.google.android.gms.common.api.internal.zzah;
import com.google.android.gms.common.api.internal.zzbp;
import com.google.android.gms.common.api.internal.zzbs;
import com.google.android.gms.common.api.internal.zzbt;
import com.google.android.gms.common.api.internal.zzbu;
import com.google.android.gms.common.api.internal.zzbv;
import com.google.android.gms.common.api.internal.zzcl;
import com.google.android.gms.common.api.internal.zzcs;
import com.google.android.gms.common.api.internal.zzcw;
import com.google.android.gms.common.api.internal.zzf;
import com.google.android.gms.common.api.internal.zzh;
import com.google.android.gms.common.api.internal.zzj;
import com.google.android.gms.common.api.internal.zzx;
import com.google.android.gms.common.internal.zzby;
import com.google.android.gms.internal.zzcpm;
import com.google.android.gms.tasks.TaskCompletionSource;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;

public final class zzbr<O extends Api.ApiOptions>
implements GoogleApiClient.ConnectionCallbacks,
GoogleApiClient.OnConnectionFailedListener,
zzx {
    private final Queue<zza> zzfnp = new LinkedList<zza>();
    private final Api.zze zzfkb;
    private final Api.zzb zzfnq;
    private final zzh<O> zzfgm;
    private final zzah zzfnr;
    private final Set<zzj> zzfns = new HashSet<zzj>();
    private final Map<zzcl<?>, zzcs> zzfnt = new HashMap();
    private final int zzfnu;
    private final zzcw zzfnv;
    private boolean zzfmc;
    private ConnectionResult zzfnw = null;
    private /* synthetic */ zzbp zzfno;

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    @WorkerThread
    public zzbr(zzbp zzbp2, GoogleApi googleApi) {
        this.zzfno = zzbp2;
        this.zzfkb = googleApi.zza(zzbp.zza(zzbp2).getLooper(), this);
        this.zzfnq = this.zzfkb instanceof zzby ? zzby.zzako() : this.zzfkb;
        this.zzfgm = googleApi.zzafj();
        this.zzfnr = new zzah();
        this.zzfnu = googleApi.getInstanceId();
        if (this.zzfkb.zzaaa()) {
            this.zzfnv = googleApi.zza(zzbp.zzb(zzbp2), zzbp.zza(zzbp2));
            return;
        }
        this.zzfnv = null;
    }

    @Override
    public final void onConnected(@Nullable Bundle bundle) {
        if (Looper.myLooper() == zzbp.zza(this.zzfno).getLooper()) {
            this.zzaht();
            return;
        }
        zzbp.zza(this.zzfno).post((Runnable)new zzbs(this));
    }

    @WorkerThread
    private final void zzaht() {
        this.zzahw();
        this.zzi(ConnectionResult.zzfez);
        this.zzahy();
        for (zzcs zzcs2 : this.zzfnt.values()) {
            try {
                zzcs2.zzfhx.zzb(this.zzfnq, (TaskCompletionSource<Void>)new TaskCompletionSource());
            }
            catch (DeadObjectException deadObjectException) {
                this.onConnectionSuspended(1);
                this.zzfkb.disconnect();
                break;
            }
            catch (RemoteException remoteException) {
            }
        }
        zzbr zzbr2 = this;
        while (zzbr2.zzfkb.isConnected() && !zzbr2.zzfnp.isEmpty()) {
            zza zza2 = zzbr2.zzfnp.remove();
            zzbr2.zzb(zza2);
        }
        this.zzahz();
    }

    @Override
    public final void onConnectionSuspended(int n) {
        if (Looper.myLooper() == zzbp.zza(this.zzfno).getLooper()) {
            this.zzahu();
            return;
        }
        zzbp.zza(this.zzfno).post((Runnable)new zzbt(this));
    }

    @WorkerThread
    private final void zzahu() {
        this.zzahw();
        this.zzfmc = true;
        this.zzfnr.zzagt();
        zzbp.zza(this.zzfno).sendMessageDelayed(Message.obtain((Handler)zzbp.zza(this.zzfno), (int)9, this.zzfgm), zzbp.zzc(this.zzfno));
        zzbp.zza(this.zzfno).sendMessageDelayed(Message.obtain((Handler)zzbp.zza(this.zzfno), (int)11, this.zzfgm), zzbp.zzd(this.zzfno));
        zzbp.zza(this.zzfno, -1);
    }

    @WorkerThread
    public final void zzh(@NonNull ConnectionResult connectionResult) {
        com.google.android.gms.common.internal.zzbp.zza((Handler)zzbp.zza(this.zzfno));
        this.zzfkb.disconnect();
        this.onConnectionFailed(connectionResult);
    }

    @Override
    public final void zza(ConnectionResult connectionResult, Api<?> api, boolean bl) {
        if (Looper.myLooper() == zzbp.zza(this.zzfno).getLooper()) {
            this.onConnectionFailed(connectionResult);
            return;
        }
        zzbp.zza(this.zzfno).post((Runnable)new zzbu(this, connectionResult));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WorkerThread
    public final void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
        com.google.android.gms.common.internal.zzbp.zza((Handler)zzbp.zza(this.zzfno));
        if (this.zzfnv != null) {
            this.zzfnv.zzaim();
        }
        this.zzahw();
        zzbp.zza(this.zzfno, -1);
        this.zzi(connectionResult);
        if (connectionResult.getErrorCode() == 4) {
            this.zzu(zzbp.zzahr());
            return;
        }
        if (this.zzfnp.isEmpty()) {
            this.zzfnw = connectionResult;
            return;
        }
        Object object = zzbp.zzahs();
        synchronized (object) {
            if (zzbp.zze(this.zzfno) != null && zzbp.zzf(this.zzfno).contains(this.zzfgm)) {
                zzbp.zze(this.zzfno).zzb(connectionResult, this.zzfnu);
                return;
            }
        }
        if (!this.zzfno.zzc(connectionResult, this.zzfnu)) {
            if (connectionResult.getErrorCode() == 18) {
                this.zzfmc = true;
            }
            if (this.zzfmc) {
                zzbp.zza(this.zzfno).sendMessageDelayed(Message.obtain((Handler)zzbp.zza(this.zzfno), (int)9, this.zzfgm), zzbp.zzc(this.zzfno));
                return;
            }
            object = this.zzfgm.zzafu();
            this.zzu(new Status(17, new StringBuilder(38 + String.valueOf(object).length()).append("API: ").append((String)object).append(" is not available on this device.").toString()));
        }
    }

    @WorkerThread
    public final void zza(zza zza2) {
        com.google.android.gms.common.internal.zzbp.zza((Handler)zzbp.zza(this.zzfno));
        if (this.zzfkb.isConnected()) {
            this.zzb(zza2);
            this.zzahz();
            return;
        }
        this.zzfnp.add(zza2);
        if (this.zzfnw != null && this.zzfnw.hasResolution()) {
            this.onConnectionFailed(this.zzfnw);
            return;
        }
        this.connect();
    }

    @WorkerThread
    public final void signOut() {
        com.google.android.gms.common.internal.zzbp.zza((Handler)zzbp.zza(this.zzfno));
        this.zzu(zzbp.zzfne);
        this.zzfnr.zzags();
        for (zzcl<?> zzcl2 : this.zzfnt.keySet()) {
            this.zza(new zzf(zzcl2, (TaskCompletionSource<Void>)new TaskCompletionSource()));
        }
        this.zzi(new ConnectionResult(4));
        this.zzfkb.disconnect();
    }

    public final Api.zze zzagm() {
        return this.zzfkb;
    }

    public final Map<zzcl<?>, zzcs> zzahv() {
        return this.zzfnt;
    }

    @WorkerThread
    public final void zzahw() {
        com.google.android.gms.common.internal.zzbp.zza((Handler)zzbp.zza(this.zzfno));
        this.zzfnw = null;
    }

    @WorkerThread
    public final ConnectionResult zzahx() {
        com.google.android.gms.common.internal.zzbp.zza((Handler)zzbp.zza(this.zzfno));
        return this.zzfnw;
    }

    @WorkerThread
    private final void zzb(zza zza2) {
        zza2.zza(this.zzfnr, this.zzaaa());
        try {
            zza2.zza(this);
            return;
        }
        catch (DeadObjectException deadObjectException) {
            this.onConnectionSuspended(1);
            this.zzfkb.disconnect();
            return;
        }
    }

    @WorkerThread
    public final void zzu(Status status) {
        com.google.android.gms.common.internal.zzbp.zza((Handler)zzbp.zza(this.zzfno));
        Iterator iterator = this.zzfnp.iterator();
        while (iterator.hasNext()) {
            ((zza)iterator.next()).zzq(status);
        }
        this.zzfnp.clear();
    }

    @WorkerThread
    public final void resume() {
        com.google.android.gms.common.internal.zzbp.zza((Handler)zzbp.zza(this.zzfno));
        if (this.zzfmc) {
            this.connect();
        }
    }

    @WorkerThread
    private final void zzahy() {
        if (this.zzfmc) {
            zzbp.zza(this.zzfno).removeMessages(11, this.zzfgm);
            zzbp.zza(this.zzfno).removeMessages(9, this.zzfgm);
            this.zzfmc = false;
        }
    }

    @WorkerThread
    public final void zzahg() {
        com.google.android.gms.common.internal.zzbp.zza((Handler)zzbp.zza(this.zzfno));
        if (this.zzfmc) {
            this.zzahy();
            Status status = zzbp.zzg(this.zzfno).isGooglePlayServicesAvailable(zzbp.zzb(this.zzfno)) == 18 ? new Status(8, "Connection timed out while waiting for Google Play services update to complete.") : new Status(8, "API failed to connect while resuming due to an unknown error.");
            this.zzu(status);
            this.zzfkb.disconnect();
        }
    }

    private final void zzahz() {
        zzbp.zza(this.zzfno).removeMessages(12, this.zzfgm);
        zzbp.zza(this.zzfno).sendMessageDelayed(zzbp.zza(this.zzfno).obtainMessage(12, this.zzfgm), zzbp.zzh(this.zzfno));
    }

    @WorkerThread
    public final void zzaia() {
        com.google.android.gms.common.internal.zzbp.zza((Handler)zzbp.zza(this.zzfno));
        if (this.zzfkb.isConnected() && this.zzfnt.size() == 0) {
            if (this.zzfnr.zzagr()) {
                this.zzahz();
                return;
            }
            this.zzfkb.disconnect();
        }
    }

    @WorkerThread
    public final void connect() {
        com.google.android.gms.common.internal.zzbp.zza((Handler)zzbp.zza(this.zzfno));
        if (this.zzfkb.isConnected() || this.zzfkb.isConnecting()) {
            return;
        }
        if (this.zzfkb.zzafe() && zzbp.zzi(this.zzfno) != 0) {
            zzbp.zza(this.zzfno, zzbp.zzg(this.zzfno).isGooglePlayServicesAvailable(zzbp.zzb(this.zzfno)));
            if (zzbp.zzi(this.zzfno) != 0) {
                ConnectionResult connectionResult = new ConnectionResult(zzbp.zzi(this.zzfno), null);
                this.onConnectionFailed(connectionResult);
                return;
            }
        }
        zzbv zzbv2 = new zzbv(this.zzfno, this.zzfkb, this.zzfgm);
        if (this.zzfkb.zzaaa()) {
            this.zzfnv.zza(zzbv2);
        }
        this.zzfkb.zza(zzbv2);
    }

    @WorkerThread
    public final void zza(zzj zzj2) {
        com.google.android.gms.common.internal.zzbp.zza((Handler)zzbp.zza(this.zzfno));
        this.zzfns.add(zzj2);
    }

    @WorkerThread
    private final void zzi(ConnectionResult connectionResult) {
        Iterator<zzj> iterator = this.zzfns.iterator();
        while (iterator.hasNext()) {
            iterator.next().zza(this.zzfgm, connectionResult);
        }
        this.zzfns.clear();
    }

    final boolean isConnected() {
        return this.zzfkb.isConnected();
    }

    public final boolean zzaaa() {
        return this.zzfkb.zzaaa();
    }

    public final int getInstanceId() {
        return this.zzfnu;
    }

    final zzcpm zzaib() {
        if (this.zzfnv == null) {
            return null;
        }
        return this.zzfnv.zzaib();
    }

    static /* synthetic */ void zzc(zzbr zzbr2) {
        zzbr2.zzaht();
    }

    static /* synthetic */ void zzd(zzbr zzbr2) {
        zzbr2.zzahu();
    }
}

