/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.SystemClock;
import com.google.android.gms.internal.zzbbx;
import com.google.android.gms.internal.zzbbz;

public final class zzbbv
extends Drawable
implements Drawable.Callback {
    private int zzfrs = 0;
    private long zzdqy;
    private int mFrom;
    private int zzfrt;
    private int zzfru = 255;
    private int zzfrv;
    private int zzfrw = 0;
    private boolean zzfrn = true;
    private boolean zzfrx;
    private zzbbz zzfry;
    private Drawable zzfrz;
    private Drawable zzfsa;
    private boolean zzfsb;
    private boolean zzfsc;
    private boolean zzfsd;
    private int zzfse;

    public zzbbv(Drawable drawable2, Drawable drawable3) {
        this(null);
        if (drawable2 == null) {
            drawable2 = zzbbx.zzajb();
        }
        this.zzfrz = drawable2;
        drawable2.setCallback((Drawable.Callback)this);
        this.zzfry.zzfsh |= drawable2.getChangingConfigurations();
        if (drawable3 == null) {
            drawable3 = zzbbx.zzajb();
        }
        this.zzfsa = drawable3;
        drawable3.setCallback((Drawable.Callback)this);
        this.zzfry.zzfsh |= drawable3.getChangingConfigurations();
    }

    zzbbv(zzbbz zzbbz2) {
        this.zzfry = new zzbbz(zzbbz2);
    }

    public final void invalidateDrawable(Drawable drawable2) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.invalidateDrawable((Drawable)this);
        }
    }

    public final void scheduleDrawable(Drawable drawable2, Runnable runnable, long l) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.scheduleDrawable((Drawable)this, runnable, l);
        }
    }

    public final void unscheduleDrawable(Drawable drawable2, Runnable runnable) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.unscheduleDrawable((Drawable)this, runnable);
        }
    }

    public final int getChangingConfigurations() {
        return super.getChangingConfigurations() | this.zzfry.mChangingConfigurations | this.zzfry.zzfsh;
    }

    public final void setAlpha(int n) {
        if (this.zzfrw == this.zzfru) {
            this.zzfrw = n;
        }
        this.zzfru = n;
        this.invalidateSelf();
    }

    public final void setColorFilter(ColorFilter colorFilter) {
        this.zzfrz.setColorFilter(colorFilter);
        this.zzfsa.setColorFilter(colorFilter);
    }

    public final int getIntrinsicWidth() {
        return Math.max(this.zzfrz.getIntrinsicWidth(), this.zzfsa.getIntrinsicWidth());
    }

    public final int getIntrinsicHeight() {
        return Math.max(this.zzfrz.getIntrinsicHeight(), this.zzfsa.getIntrinsicHeight());
    }

    protected final void onBoundsChange(Rect rect) {
        this.zzfrz.setBounds(rect);
        this.zzfsa.setBounds(rect);
    }

    public final Drawable.ConstantState getConstantState() {
        if (this.canConstantState()) {
            this.zzfry.mChangingConfigurations = this.getChangingConfigurations();
            return this.zzfry;
        }
        return null;
    }

    public final int getOpacity() {
        if (!this.zzfsd) {
            this.zzfse = Drawable.resolveOpacity((int)this.zzfrz.getOpacity(), (int)this.zzfsa.getOpacity());
            this.zzfsd = true;
        }
        return this.zzfse;
    }

    private final boolean canConstantState() {
        if (!this.zzfsb) {
            this.zzfsc = this.zzfrz.getConstantState() != null && this.zzfsa.getConstantState() != null;
            this.zzfsb = true;
        }
        return this.zzfsc;
    }

    public final Drawable mutate() {
        if (!this.zzfrx && super.mutate() == this) {
            if (!this.canConstantState()) {
                throw new IllegalStateException("One or more children of this LayerDrawable does not have constant state; this drawable cannot be mutated.");
            }
            this.zzfrz.mutate();
            this.zzfsa.mutate();
            this.zzfrx = true;
        }
        return this;
    }

    public final Drawable zzaja() {
        return this.zzfsa;
    }

    public final void startTransition(int n) {
        this.mFrom = 0;
        this.zzfrt = this.zzfru;
        this.zzfrw = 0;
        this.zzfrv = 250;
        this.zzfrs = 1;
        this.invalidateSelf();
    }

    public final void draw(Canvas canvas) {
        boolean bl = true;
        switch (this.zzfrs) {
            case 1: {
                this.zzdqy = SystemClock.uptimeMillis();
                bl = false;
                this.zzfrs = 2;
                break;
            }
            case 2: {
                float f;
                if (this.zzdqy < 0L) break;
                float f2 = (float)(SystemClock.uptimeMillis() - this.zzdqy) / (float)this.zzfrv;
                bl = f >= 1.0f;
                if (bl) {
                    this.zzfrs = 0;
                }
                f2 = Math.min(f2, 1.0f);
                this.zzfrw = (int)(0.0f + (float)this.zzfrt * f2);
            }
        }
        int n = this.zzfrw;
        boolean bl2 = this.zzfrn;
        Drawable drawable2 = this.zzfrz;
        Drawable drawable3 = this.zzfsa;
        if (bl) {
            if (!bl2 || n == 0) {
                drawable2.draw(canvas);
            }
            if (n == this.zzfru) {
                drawable3.setAlpha(this.zzfru);
                drawable3.draw(canvas);
            }
            return;
        }
        if (bl2) {
            drawable2.setAlpha(this.zzfru - n);
        }
        drawable2.draw(canvas);
        if (bl2) {
            drawable2.setAlpha(this.zzfru);
        }
        if (n > 0) {
            drawable3.setAlpha(n);
            drawable3.draw(canvas);
            drawable3.setAlpha(this.zzfru);
        }
        this.invalidateSelf();
    }
}

