/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.accounts.Account;
import android.content.Context;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.auth.api.signin.internal.zzy;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzam;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.internal.zzd;
import com.google.android.gms.common.internal.zzj;
import com.google.android.gms.common.internal.zzm;
import com.google.android.gms.common.internal.zzq;
import com.google.android.gms.internal.zzcpm;
import com.google.android.gms.internal.zzcpn;
import com.google.android.gms.internal.zzcps;
import com.google.android.gms.internal.zzcpu;
import com.google.android.gms.internal.zzcpv;
import com.google.android.gms.internal.zzcpx;
import com.google.android.gms.internal.zzcpz;

public final class zzcpw
extends zzaa<zzcpu>
implements zzcpm {
    private final boolean zzjnk;
    private final zzq zzfkd;
    private final Bundle zzjnl;
    private Integer zzfto;

    private zzcpw(Context context, Looper looper, boolean bl, zzq zzq2, Bundle bundle, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        super(context, looper, 44, zzq2, connectionCallbacks, onConnectionFailedListener);
        this.zzjnk = true;
        this.zzfkd = zzq2;
        this.zzjnl = bundle;
        this.zzfto = zzq2.zzajy();
    }

    public zzcpw(Context context, Looper looper, boolean bl, zzq zzq2, zzcpn zzcpn2, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        this(context, looper, true, zzq2, zzcpw.zza(zzq2), connectionCallbacks, onConnectionFailedListener);
    }

    @Override
    public final boolean zzaaa() {
        return this.zzjnk;
    }

    @Override
    public final void zza(zzam zzam2, boolean bl) {
        try {
            ((zzcpu)this.zzajj()).zza(zzam2, this.zzfto, bl);
            return;
        }
        catch (RemoteException remoteException) {
            Log.w((String)"SignInClientImpl", (String)"Remote service probably died when saveDefaultAccount is called");
            return;
        }
    }

    @Override
    public final void zzbbt() {
        try {
            ((zzcpu)this.zzajj()).zzeb(this.zzfto);
            return;
        }
        catch (RemoteException remoteException) {
            Log.w((String)"SignInClientImpl", (String)"Remote service probably died when clearAccountFromSessionStore is called");
            return;
        }
    }

    @Override
    public final void zza(zzcps zzcps2) {
        zzbp.zzb((Object)zzcps2, (Object)"Expecting a valid ISignInCallbacks");
        try {
            zzcpw zzcpw2 = this;
            Account account = zzcpw2.zzfkd.zzajp();
            GoogleSignInAccount googleSignInAccount = null;
            if ("<<default account>>".equals(account.name)) {
                googleSignInAccount = zzy.zzbm(zzcpw2.getContext()).zzaar();
            }
            zzbq zzbq2 = new zzbq(account, zzcpw2.zzfto, googleSignInAccount);
            ((zzcpu)this.zzajj()).zza(new zzcpx(zzbq2), zzcps2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.w((String)"SignInClientImpl", (String)"Remote service probably died when signIn is called");
            try {
                zzcps2.zzb(new zzcpz(8));
                return;
            }
            catch (RemoteException remoteException2) {
                Log.wtf((String)"SignInClientImpl", (String)"ISignInCallbacks#onSignInComplete should be executed from the same process, unexpected RemoteException.", (Throwable)remoteException);
                return;
            }
        }
    }

    protected final String zzhc() {
        return "com.google.android.gms.signin.service.START";
    }

    protected final String zzhd() {
        return "com.google.android.gms.signin.internal.ISignInService";
    }

    protected final Bundle zzzs() {
        String string2 = this.zzfkd.zzaju();
        if (!this.getContext().getPackageName().equals(string2)) {
            this.zzjnl.putString("com.google.android.gms.signin.internal.realClientPackageName", this.zzfkd.zzaju());
        }
        return this.zzjnl;
    }

    @Override
    public final void connect() {
        this.zza((zzj)new zzm((zzd)this));
    }

    public static Bundle zza(zzq zzq2) {
        zzcpn zzcpn2 = zzq2.zzajx();
        Integer n = zzq2.zzajy();
        Bundle bundle = new Bundle();
        bundle.putParcelable("com.google.android.gms.signin.internal.clientRequestedAccount", (Parcelable)zzq2.getAccount());
        if (n != null) {
            bundle.putInt("com.google.android.gms.common.internal.ClientSettings.sessionId", n.intValue());
        }
        if (zzcpn2 != null) {
            bundle.putBoolean("com.google.android.gms.signin.internal.offlineAccessRequested", zzcpn2.zzbbu());
            bundle.putBoolean("com.google.android.gms.signin.internal.idTokenRequested", zzcpn2.isIdTokenRequested());
            bundle.putString("com.google.android.gms.signin.internal.serverClientId", zzcpn2.getServerClientId());
            bundle.putBoolean("com.google.android.gms.signin.internal.usePromptModeForAuthCode", true);
            bundle.putBoolean("com.google.android.gms.signin.internal.forceCodeForRefreshToken", zzcpn2.zzbbv());
            bundle.putString("com.google.android.gms.signin.internal.hostedDomain", zzcpn2.zzbbw());
            bundle.putBoolean("com.google.android.gms.signin.internal.waitForAccessTokenRefresh", zzcpn2.zzbbx());
            if (zzcpn2.zzbby() != null) {
                bundle.putLong("com.google.android.gms.signin.internal.authApiSignInModuleVersion", zzcpn2.zzbby().longValue());
            }
            if (zzcpn2.zzbbz() != null) {
                bundle.putLong("com.google.android.gms.signin.internal.realClientLibraryVersion", zzcpn2.zzbbz().longValue());
            }
        }
        return bundle;
    }

    protected final /* synthetic */ IInterface zze(IBinder iBinder) {
        IBinder iBinder2 = iBinder;
        if (iBinder2 == null) {
            return null;
        }
        IInterface iInterface = iBinder2.queryLocalInterface("com.google.android.gms.signin.internal.ISignInService");
        if (iInterface instanceof zzcpu) {
            return (zzcpu)iInterface;
        }
        return new zzcpv(iBinder2);
    }
}

