/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.accounts.Account;
import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.internal.zzak;
import com.google.android.gms.common.api.internal.zzbp;
import com.google.android.gms.common.api.internal.zzbr;
import com.google.android.gms.common.api.internal.zzbx;
import com.google.android.gms.common.api.internal.zzcw;
import com.google.android.gms.common.api.internal.zzcz;
import com.google.android.gms.common.api.internal.zzdd;
import com.google.android.gms.common.api.internal.zzg;
import com.google.android.gms.common.api.internal.zzh;
import com.google.android.gms.common.api.internal.zzm;
import com.google.android.gms.common.api.zzc;
import com.google.android.gms.common.api.zzd;
import com.google.android.gms.common.internal.zzq;
import com.google.android.gms.common.internal.zzr;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import java.util.Collections;

public class GoogleApi<O extends Api.ApiOptions> {
    private final Context mContext;
    private final Api<O> zzfdg;
    private final O zzfgr;
    private final zzh<O> zzfgs;
    private final Looper zzakg;
    private final int mId;
    private final GoogleApiClient zzfgt;
    private final zzcz zzfgu;
    protected final zzbp zzfgv;

    protected GoogleApi(@NonNull Context context, Api<O> api, Looper looper) {
        com.google.android.gms.common.internal.zzbp.zzb((Object)context, (Object)"Null context is not permitted.");
        com.google.android.gms.common.internal.zzbp.zzb(api, (Object)"Api must not be null.");
        com.google.android.gms.common.internal.zzbp.zzb((Object)looper, (Object)"Looper must not be null.");
        this.mContext = context.getApplicationContext();
        this.zzfdg = api;
        this.zzfgr = null;
        this.zzakg = looper;
        this.zzfgs = zzh.zzb(api);
        this.zzfgt = new zzbx(this);
        this.zzfgv = zzbp.zzca(this.mContext);
        this.mId = this.zzfgv.zzahq();
        this.zzfgu = new zzg();
    }

    @Deprecated
    public GoogleApi(@NonNull Context context, Api<O> api, O o, Looper looper, zzcz zzcz2) {
        this(context, api, null, new zzd().zza(looper).zza(zzcz2).zzafn());
    }

    @MainThread
    public GoogleApi(@NonNull Activity activity, Api<O> api, O o, zza zza2) {
        com.google.android.gms.common.internal.zzbp.zzb((Object)activity, (Object)"Null activity is not permitted.");
        com.google.android.gms.common.internal.zzbp.zzb(api, (Object)"Api must not be null.");
        com.google.android.gms.common.internal.zzbp.zzb((Object)zza2, (Object)"Settings must not be null; use Settings.DEFAULT_SETTINGS instead.");
        this.mContext = activity.getApplicationContext();
        this.zzfdg = api;
        this.zzfgr = o;
        this.zzakg = zza2.zzfgy;
        this.zzfgs = zzh.zza(this.zzfdg, this.zzfgr);
        this.zzfgt = new zzbx(this);
        this.zzfgv = zzbp.zzca(this.mContext);
        this.mId = this.zzfgv.zzahq();
        this.zzfgu = zza2.zzfgx;
        zzak.zza(activity, this.zzfgv, this.zzfgs);
        this.zzfgv.zza(this);
    }

    public GoogleApi(@NonNull Context context, Api<O> api, O o, zza zza2) {
        com.google.android.gms.common.internal.zzbp.zzb((Object)context, (Object)"Null context is not permitted.");
        com.google.android.gms.common.internal.zzbp.zzb(api, (Object)"Api must not be null.");
        com.google.android.gms.common.internal.zzbp.zzb((Object)zza2, (Object)"Settings must not be null; use Settings.DEFAULT_SETTINGS instead.");
        this.mContext = context.getApplicationContext();
        this.zzfdg = api;
        this.zzfgr = o;
        this.zzakg = zza2.zzfgy;
        this.zzfgs = zzh.zza(this.zzfdg, this.zzfgr);
        this.zzfgt = new zzbx(this);
        this.zzfgv = zzbp.zzca(this.mContext);
        this.mId = this.zzfgv.zzahq();
        this.zzfgu = zza2.zzfgx;
        this.zzfgv.zza(this);
    }

    @Deprecated
    public GoogleApi(@NonNull Activity activity, Api<O> api, O o, zzcz zzcz2) {
        this(activity, api, o, new zzd().zza(zzcz2).zza(activity.getMainLooper()).zzafn());
    }

    @Deprecated
    public GoogleApi(@NonNull Context context, Api<O> api, O o, zzcz zzcz2) {
        this(context, api, o, new zzd().zza(zzcz2).zzafn());
    }

    private final <A extends Api.zzb, T extends zzm<? extends Result, A>> T zza(int n, @NonNull T t) {
        t.zzagg();
        this.zzfgv.zza(this, n, t);
        return t;
    }

    private final <TResult, A extends Api.zzb> Task<TResult> zza(int n, @NonNull zzdd<A, TResult> zzdd2) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        this.zzfgv.zza(this, n, zzdd2, taskCompletionSource, this.zzfgu);
        return taskCompletionSource.getTask();
    }

    public final <A extends Api.zzb, T extends zzm<? extends Result, A>> T zza(@NonNull T t) {
        return this.zza(0, t);
    }

    public final <TResult, A extends Api.zzb> Task<TResult> zza(zzdd<A, TResult> zzdd2) {
        return this.zza(0, zzdd2);
    }

    public final <A extends Api.zzb, T extends zzm<? extends Result, A>> T zzb(@NonNull T t) {
        return this.zza(1, t);
    }

    public final <TResult, A extends Api.zzb> Task<TResult> zzb(zzdd<A, TResult> zzdd2) {
        return this.zza(1, zzdd2);
    }

    public final <A extends Api.zzb, T extends zzm<? extends Result, A>> T zzc(@NonNull T t) {
        return this.zza(2, t);
    }

    @WorkerThread
    public Api.zze zza(Looper looper, zzbr<O> zzbr2) {
        zzq zzq2 = this.zzafm().zzfz(this.mContext.getPackageName()).zzga(this.mContext.getClass().getName()).zzajz();
        return this.zzfdg.zzafd().zza(this.mContext, looper, zzq2, this.zzfgr, zzbr2, zzbr2);
    }

    public final Api<O> zzafj() {
        return this.zzfdg;
    }

    public final zzh<O> zzafk() {
        return this.zzfgs;
    }

    public final int getInstanceId() {
        return this.mId;
    }

    public final GoogleApiClient zzafl() {
        return this.zzfgt;
    }

    public final Looper getLooper() {
        return this.zzakg;
    }

    public final Context getApplicationContext() {
        return this.mContext;
    }

    private final zzr zzafm() {
        GoogleSignInAccount googleSignInAccount;
        GoogleApi googleApi = this;
        googleApi = this;
        return new zzr().zze((Account)(googleApi.zzfgr instanceof Api.ApiOptions.HasGoogleSignInAccountOptions ? ((Api.ApiOptions.HasGoogleSignInAccountOptions)googleApi.zzfgr).getGoogleSignInAccount().getAccount() : (googleApi.zzfgr instanceof Api.ApiOptions.HasAccountOptions ? ((Api.ApiOptions.HasAccountOptions)googleApi.zzfgr).getAccount() : null))).zze(googleApi.zzfgr instanceof Api.ApiOptions.HasGoogleSignInAccountOptions && (googleSignInAccount = ((Api.ApiOptions.HasGoogleSignInAccountOptions)googleApi.zzfgr).getGoogleSignInAccount()) != null ? googleSignInAccount.getGrantedScopes() : Collections.emptySet());
    }

    public zzcw zza(Context context, Handler handler) {
        return new zzcw(context, handler, this.zzafm().zzajz());
    }

    public static final class zza {
        public static final zza zzfgw = new zzd().zzafn();
        public final zzcz zzfgx;
        public final Looper zzfgy;

        private zza(zzcz zzcz2, Account account, Looper looper) {
            this.zzfgx = zzcz2;
            this.zzfgy = looper;
        }

        /* synthetic */ zza(zzcz zzcz2, Account account, Looper looper, zzc zzc2) {
            this(zzcz2, null, looper);
        }
    }
}

