/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.internal.zzao;
import com.google.android.gms.common.api.internal.zzar;
import com.google.android.gms.common.api.internal.zzbc;
import com.google.android.gms.common.api.internal.zzbd;
import com.google.android.gms.common.api.internal.zzbk;
import com.google.android.gms.common.api.internal.zzbm;
import com.google.android.gms.common.api.internal.zzbn;
import com.google.android.gms.common.api.internal.zzcd;
import com.google.android.gms.common.api.internal.zzce;
import com.google.android.gms.common.api.internal.zzcv;
import com.google.android.gms.common.api.internal.zzm;
import com.google.android.gms.common.api.internal.zzw;
import com.google.android.gms.common.api.internal.zzx;
import com.google.android.gms.common.internal.zzq;
import com.google.android.gms.common.zze;
import com.google.android.gms.internal.zzcps;
import com.google.android.gms.internal.zzcpt;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;

public final class zzbl
implements zzcd,
zzx {
    private final Lock zzfke;
    private final Condition zzfna;
    private final Context mContext;
    private final zze zzfko;
    private final zzbn zzfnb;
    final Map<Api.zzc<?>, Api.zze> zzfmn;
    final Map<Api.zzc<?>, ConnectionResult> zzfnc = new HashMap();
    private zzq zzfkj;
    private Map<Api<?>, Boolean> zzfkm;
    private Api.zza<? extends zzcps, zzcpt> zzfhm;
    private volatile zzbk zzfnd;
    private ConnectionResult zzfne = null;
    int zzfnf;
    final zzbd zzfju;
    final zzce zzfng;

    public zzbl(Context context, zzbd zzbd2, Lock lock, Looper looper, zze zze2, Map<Api.zzc<?>, Api.zze> map, zzq zzq2, Map<Api<?>, Boolean> map2, Api.zza<? extends zzcps, zzcpt> zza2, ArrayList<zzw> arrayList, zzce zzce2) {
        this.mContext = context;
        this.zzfke = lock;
        this.zzfko = zze2;
        this.zzfmn = map;
        this.zzfkj = zzq2;
        this.zzfkm = map2;
        this.zzfhm = zza2;
        this.zzfju = zzbd2;
        this.zzfng = zzce2;
        ArrayList<zzw> arrayList2 = arrayList;
        int n = arrayList2.size();
        for (int i = 0; i < n; ++i) {
            zzw zzw2 = arrayList2.get(i);
            zzw2.zza(this);
        }
        this.zzfnb = new zzbn(this, looper);
        this.zzfna = lock.newCondition();
        this.zzfnd = new zzbc(this);
    }

    @Override
    public final <A extends Api.zzb, R extends Result, T extends zzm<R, A>> T zzd(@NonNull T t) {
        t.zzagg();
        return this.zzfnd.zzd(t);
    }

    @Override
    public final <A extends Api.zzb, T extends zzm<? extends Result, A>> T zze(@NonNull T t) {
        t.zzagg();
        return this.zzfnd.zze(t);
    }

    @Override
    public final void connect() {
        this.zzfnd.connect();
    }

    @Override
    public final ConnectionResult blockingConnect() {
        this.connect();
        while (this.isConnecting()) {
            try {
                this.zzfna.await();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return new ConnectionResult(15, null);
            }
        }
        if (this.isConnected()) {
            return ConnectionResult.zzfff;
        }
        if (this.zzfne != null) {
            return this.zzfne;
        }
        return new ConnectionResult(13, null);
    }

    @Override
    public final ConnectionResult blockingConnect(long l, TimeUnit timeUnit) {
        this.connect();
        long l2 = timeUnit.toNanos(l);
        while (this.isConnecting()) {
            try {
                if (l2 <= 0L) {
                    this.disconnect();
                    return new ConnectionResult(14, null);
                }
                l2 = this.zzfna.awaitNanos(l2);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return new ConnectionResult(15, null);
            }
        }
        if (this.isConnected()) {
            return ConnectionResult.zzfff;
        }
        if (this.zzfne != null) {
            return this.zzfne;
        }
        return new ConnectionResult(13, null);
    }

    @Override
    public final void disconnect() {
        if (this.zzfnd.disconnect()) {
            this.zzfnc.clear();
        }
    }

    @Override
    @Nullable
    public final ConnectionResult getConnectionResult(@NonNull Api<?> api) {
        Api.zzc<?> zzc2 = api.zzafe();
        if (this.zzfmn.containsKey(zzc2)) {
            if (this.zzfmn.get(zzc2).isConnected()) {
                return ConnectionResult.zzfff;
            }
            if (this.zzfnc.containsKey(zzc2)) {
                return this.zzfnc.get(zzc2);
            }
        }
        return null;
    }

    final void zzahl() {
        this.zzfke.lock();
        try {
            this.zzfnd = new zzar(this, this.zzfkj, this.zzfkm, this.zzfko, this.zzfhm, this.zzfke, this.mContext);
            this.zzfnd.begin();
            this.zzfna.signalAll();
            return;
        }
        finally {
            this.zzfke.unlock();
        }
    }

    final void zzahm() {
        this.zzfke.lock();
        try {
            this.zzfju.zzahi();
            this.zzfnd = new zzao(this);
            this.zzfnd.begin();
            this.zzfna.signalAll();
            return;
        }
        finally {
            this.zzfke.unlock();
        }
    }

    final void zzg(ConnectionResult connectionResult) {
        this.zzfke.lock();
        try {
            this.zzfne = connectionResult;
            this.zzfnd = new zzbc(this);
            this.zzfnd.begin();
            this.zzfna.signalAll();
            return;
        }
        finally {
            this.zzfke.unlock();
        }
    }

    @Override
    public final boolean isConnected() {
        return this.zzfnd instanceof zzao;
    }

    @Override
    public final boolean isConnecting() {
        return this.zzfnd instanceof zzar;
    }

    @Override
    public final boolean zza(zzcv zzcv2) {
        return false;
    }

    @Override
    public final void zzafp() {
    }

    @Override
    public final void zzagi() {
        if (this.isConnected()) {
            ((zzao)this.zzfnd).zzagy();
        }
    }

    @Override
    public final void zza(@NonNull ConnectionResult connectionResult, @NonNull Api<?> api, boolean bl) {
        this.zzfke.lock();
        try {
            this.zzfnd.zza(connectionResult, api, bl);
            return;
        }
        finally {
            this.zzfke.unlock();
        }
    }

    @Override
    public final void onConnected(@Nullable Bundle bundle) {
        this.zzfke.lock();
        try {
            this.zzfnd.onConnected(bundle);
            return;
        }
        finally {
            this.zzfke.unlock();
        }
    }

    @Override
    public final void onConnectionSuspended(int n) {
        this.zzfke.lock();
        try {
            this.zzfnd.onConnectionSuspended(n);
            return;
        }
        finally {
            this.zzfke.unlock();
        }
    }

    final void zza(zzbm zzbm2) {
        Message message = this.zzfnb.obtainMessage(1, zzbm2);
        this.zzfnb.sendMessage(message);
    }

    final void zza(RuntimeException runtimeException) {
        Message message = this.zzfnb.obtainMessage(2, runtimeException);
        this.zzfnb.sendMessage(message);
    }

    @Override
    public final void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        String string3 = String.valueOf(string2).concat("  ");
        printWriter.append(string2).append("mState=").println(this.zzfnd);
        for (Api<?> api : this.zzfkm.keySet()) {
            printWriter.append(string2).append(api.getName()).println(":");
            this.zzfmn.get(api.zzafe()).dump(string3, fileDescriptor, printWriter, stringArray);
        }
    }

    static /* synthetic */ Lock zza(zzbl zzbl2) {
        return zzbl2.zzfke;
    }

    static /* synthetic */ zzbk zzb(zzbl zzbl2) {
        return zzbl2.zzfnd;
    }
}

