/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.data;

import android.graphics.Bitmap;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.common.data.zza;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.internal.zzbck;
import com.google.android.gms.internal.zzbcn;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public class BitmapTeleporter
extends zzbck
implements ReflectedParcelable {
    public static final Parcelable.Creator<BitmapTeleporter> CREATOR = new zza();
    private int zzdxs;
    private ParcelFileDescriptor zzcqz;
    private int zzecz;
    private Bitmap zzfqb;
    private boolean zzfqc;
    private File zzfqd;

    BitmapTeleporter(int n, ParcelFileDescriptor parcelFileDescriptor, int n2) {
        this.zzdxs = n;
        this.zzcqz = parcelFileDescriptor;
        this.zzecz = n2;
        this.zzfqb = null;
        this.zzfqc = false;
    }

    public BitmapTeleporter(Bitmap bitmap) {
        this.zzdxs = 1;
        this.zzcqz = null;
        this.zzecz = 0;
        this.zzfqb = bitmap;
        this.zzfqc = true;
    }

    public final Bitmap zzais() {
        if (!this.zzfqc) {
            Bitmap.Config config;
            int n;
            int n2;
            byte[] byArray;
            DataInputStream dataInputStream = new DataInputStream((InputStream)new ParcelFileDescriptor.AutoCloseInputStream(this.zzcqz));
            try {
                byArray = new byte[dataInputStream.readInt()];
                n2 = dataInputStream.readInt();
                n = dataInputStream.readInt();
                config = Bitmap.Config.valueOf((String)dataInputStream.readUTF());
                dataInputStream.read(byArray);
            }
            catch (IOException iOException) {
                throw new IllegalStateException("Could not read from parcel file descriptor", iOException);
            }
            finally {
                BitmapTeleporter.zza(dataInputStream);
            }
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            Bitmap bitmap = Bitmap.createBitmap((int)n2, (int)n, (Bitmap.Config)config);
            bitmap.copyPixelsFromBuffer((Buffer)byteBuffer);
            this.zzfqb = bitmap;
            this.zzfqc = true;
        }
        return this.zzfqb;
    }

    public void writeToParcel(Parcel parcel, int n) {
        if (this.zzcqz == null) {
            Bitmap bitmap = this.zzfqb;
            ByteBuffer byteBuffer = ByteBuffer.allocate(bitmap.getRowBytes() * bitmap.getHeight());
            bitmap.copyPixelsToBuffer((Buffer)byteBuffer);
            byte[] byArray = byteBuffer.array();
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(this.zzait());
            DataOutputStream dataOutputStream = new DataOutputStream(bufferedOutputStream);
            try {
                dataOutputStream.writeInt(byArray.length);
                dataOutputStream.writeInt(bitmap.getWidth());
                dataOutputStream.writeInt(bitmap.getHeight());
                dataOutputStream.writeUTF(bitmap.getConfig().toString());
                dataOutputStream.write(byArray);
            }
            catch (IOException iOException) {
                throw new IllegalStateException("Could not write into unlinked file", iOException);
            }
            finally {
                BitmapTeleporter.zza(dataOutputStream);
            }
        }
        int n2 = n | 1;
        Parcel parcel2 = parcel;
        BitmapTeleporter bitmapTeleporter = this;
        int n3 = zzbcn.zze((Parcel)parcel2);
        zzbcn.zzc((Parcel)parcel2, (int)1, (int)bitmapTeleporter.zzdxs);
        zzbcn.zza((Parcel)parcel2, (int)2, (Parcelable)bitmapTeleporter.zzcqz, (int)n2, (boolean)false);
        zzbcn.zzc((Parcel)parcel2, (int)3, (int)bitmapTeleporter.zzecz);
        zzbcn.zzai((Parcel)parcel2, (int)n3);
        this.zzcqz = null;
    }

    public final void release() {
        if (!this.zzfqc) {
            try {
                this.zzcqz.close();
                return;
            }
            catch (IOException iOException) {
                Log.w((String)"BitmapTeleporter", (String)"Could not close PFD", (Throwable)iOException);
            }
        }
    }

    public final void zzc(File file) {
        if (file == null) {
            throw new NullPointerException("Cannot set null temp directory");
        }
        this.zzfqd = file;
    }

    private final FileOutputStream zzait() {
        FileOutputStream fileOutputStream;
        File file;
        if (this.zzfqd == null) {
            throw new IllegalStateException("setTempDir() must be called before writing this object to a parcel");
        }
        try {
            file = File.createTempFile("teleporter", ".tmp", this.zzfqd);
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Could not create temporary file", iOException);
        }
        try {
            fileOutputStream = new FileOutputStream(file);
            this.zzcqz = ParcelFileDescriptor.open((File)file, (int)0x10000000);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IllegalStateException("Temporary file is somehow already deleted");
        }
        file.delete();
        return fileOutputStream;
    }

    private static void zza(Closeable closeable) {
        try {
            closeable.close();
            return;
        }
        catch (IOException iOException) {
            Log.w((String)"BitmapTeleporter", (String)"Could not close stream", (Throwable)iOException);
            return;
        }
    }
}

