/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.accounts.Account;
import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.FragmentActivity;
import android.support.v4.util.ArrayMap;
import android.view.View;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zzbd;
import com.google.android.gms.common.api.internal.zzch;
import com.google.android.gms.common.api.internal.zzcl;
import com.google.android.gms.common.api.internal.zzcx;
import com.google.android.gms.common.api.internal.zzdi;
import com.google.android.gms.common.api.internal.zzi;
import com.google.android.gms.common.api.internal.zzm;
import com.google.android.gms.common.api.internal.zzw;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.internal.zzr;
import com.google.android.gms.common.internal.zzt;
import com.google.android.gms.internal.zzcvy;
import com.google.android.gms.internal.zzcwb;
import com.google.android.gms.internal.zzcwc;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

public abstract class GoogleApiClient {
    private static final Set<GoogleApiClient> zzfkd = Collections.newSetFromMap(new WeakHashMap());
    public static final int SIGN_IN_MODE_REQUIRED = 1;
    public static final int SIGN_IN_MODE_OPTIONAL = 2;

    public GoogleApiClient() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpAll(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        Set<GoogleApiClient> set = zzfkd;
        synchronized (set) {
            int n = 0;
            String string3 = String.valueOf(string2).concat("  ");
            for (GoogleApiClient googleApiClient : zzfkd) {
                printWriter.append(string2).append("GoogleApiClient#").println(n++);
                googleApiClient.dump(string3, fileDescriptor, printWriter, stringArray);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<GoogleApiClient> zzagf() {
        Set<GoogleApiClient> set = zzfkd;
        synchronized (set) {
            return zzfkd;
        }
    }

    public <A extends Api.zzb, R extends Result, T extends zzm<R, A>> T zzd(@NonNull T t) {
        throw new UnsupportedOperationException();
    }

    public <A extends Api.zzb, T extends zzm<? extends Result, A>> T zze(@NonNull T t) {
        throw new UnsupportedOperationException();
    }

    public <L> zzcl<L> zzs(@NonNull L l) {
        throw new UnsupportedOperationException();
    }

    @NonNull
    public <C extends Api.zze> C zza(@NonNull Api.zzc<C> zzc2) {
        throw new UnsupportedOperationException();
    }

    public boolean zza(@NonNull Api<?> api) {
        throw new UnsupportedOperationException();
    }

    public abstract boolean hasConnectedApi(@NonNull Api<?> var1);

    @NonNull
    public abstract ConnectionResult getConnectionResult(@NonNull Api<?> var1);

    public Context getContext() {
        throw new UnsupportedOperationException();
    }

    public Looper getLooper() {
        throw new UnsupportedOperationException();
    }

    public boolean zza(zzcx zzcx2) {
        throw new UnsupportedOperationException();
    }

    public void zzagg() {
        throw new UnsupportedOperationException();
    }

    public abstract void connect();

    public void connect(int n) {
        throw new UnsupportedOperationException();
    }

    public abstract ConnectionResult blockingConnect();

    public abstract ConnectionResult blockingConnect(long var1, @NonNull TimeUnit var3);

    public abstract void disconnect();

    public abstract void reconnect();

    public abstract PendingResult<Status> clearDefaultAccountAndReconnect();

    public abstract void stopAutoManage(@NonNull FragmentActivity var1);

    public abstract boolean isConnected();

    public abstract boolean isConnecting();

    public abstract void registerConnectionCallbacks(@NonNull ConnectionCallbacks var1);

    public abstract boolean isConnectionCallbacksRegistered(@NonNull ConnectionCallbacks var1);

    public abstract void unregisterConnectionCallbacks(@NonNull ConnectionCallbacks var1);

    public abstract void registerConnectionFailedListener(@NonNull OnConnectionFailedListener var1);

    public abstract boolean isConnectionFailedListenerRegistered(@NonNull OnConnectionFailedListener var1);

    public abstract void unregisterConnectionFailedListener(@NonNull OnConnectionFailedListener var1);

    public abstract void dump(String var1, FileDescriptor var2, PrintWriter var3, String[] var4);

    public void zza(zzdi zzdi2) {
        throw new UnsupportedOperationException();
    }

    public void zzb(zzdi zzdi2) {
        throw new UnsupportedOperationException();
    }

    public static final class Builder {
        private Account zzdzb;
        private final Set<Scope> zzfke = new HashSet<Scope>();
        private final Set<Scope> zzfkf = new HashSet<Scope>();
        private int zzfkg;
        private View zzfkh;
        private String zzdyu;
        private String zzfki;
        private final Map<Api<?>, zzt> zzfkj = new ArrayMap();
        private final Context mContext;
        private final Map<Api<?>, Api.ApiOptions> zzfkk = new ArrayMap();
        private zzch zzfkl;
        private int zzfkm = -1;
        private OnConnectionFailedListener zzfkn;
        private Looper zzakm;
        private GoogleApiAvailability zzfko = GoogleApiAvailability.getInstance();
        private Api.zza<? extends zzcwb, zzcwc> zzfkp = zzcvy.zzdyi;
        private final ArrayList<ConnectionCallbacks> zzfkq = new ArrayList();
        private final ArrayList<OnConnectionFailedListener> zzfkr = new ArrayList();
        private boolean zzfks = false;

        public Builder(@NonNull Context context) {
            this.mContext = context;
            this.zzakm = context.getMainLooper();
            this.zzdyu = context.getPackageName();
            this.zzfki = context.getClass().getName();
        }

        public Builder(@NonNull Context context, @NonNull ConnectionCallbacks connectionCallbacks, @NonNull OnConnectionFailedListener onConnectionFailedListener) {
            this(context);
            zzbq.checkNotNull((Object)connectionCallbacks, (Object)"Must provide a connected listener");
            this.zzfkq.add(connectionCallbacks);
            zzbq.checkNotNull((Object)onConnectionFailedListener, (Object)"Must provide a connection failed listener");
            this.zzfkr.add(onConnectionFailedListener);
        }

        public final Builder setHandler(@NonNull Handler handler) {
            zzbq.checkNotNull((Object)handler, (Object)"Handler must not be null");
            this.zzakm = handler.getLooper();
            return this;
        }

        public final Builder addConnectionCallbacks(@NonNull ConnectionCallbacks connectionCallbacks) {
            zzbq.checkNotNull((Object)connectionCallbacks, (Object)"Listener must not be null");
            this.zzfkq.add(connectionCallbacks);
            return this;
        }

        public final Builder addOnConnectionFailedListener(@NonNull OnConnectionFailedListener onConnectionFailedListener) {
            zzbq.checkNotNull((Object)onConnectionFailedListener, (Object)"Listener must not be null");
            this.zzfkr.add(onConnectionFailedListener);
            return this;
        }

        public final Builder setViewForPopups(@NonNull View view) {
            zzbq.checkNotNull((Object)view, (Object)"View must not be null");
            this.zzfkh = view;
            return this;
        }

        public final Builder addScope(@NonNull Scope scope) {
            zzbq.checkNotNull((Object)scope, (Object)"Scope must not be null");
            this.zzfke.add(scope);
            return this;
        }

        public final Builder addApi(@NonNull Api<? extends Api.ApiOptions.NotRequiredOptions> api) {
            zzbq.checkNotNull(api, (Object)"Api must not be null");
            this.zzfkk.put(api, null);
            List<Scope> list = api.zzafs().zzq(null);
            this.zzfkf.addAll(list);
            this.zzfke.addAll(list);
            return this;
        }

        public final Builder addApiIfAvailable(@NonNull Api<? extends Api.ApiOptions.NotRequiredOptions> api, Scope ... scopeArray) {
            zzbq.checkNotNull(api, (Object)"Api must not be null");
            this.zzfkk.put(api, null);
            this.zza(api, null, scopeArray);
            return this;
        }

        public final <O extends Api.ApiOptions.HasOptions> Builder addApi(@NonNull Api<O> api, @NonNull O o) {
            zzbq.checkNotNull(api, (Object)"Api must not be null");
            zzbq.checkNotNull(o, (Object)"Null options are not permitted for this Api");
            this.zzfkk.put(api, o);
            List<Scope> list = api.zzafs().zzq(o);
            this.zzfkf.addAll(list);
            this.zzfke.addAll(list);
            return this;
        }

        public final <O extends Api.ApiOptions.HasOptions> Builder addApiIfAvailable(@NonNull Api<O> api, @NonNull O o, Scope ... scopeArray) {
            zzbq.checkNotNull(api, (Object)"Api must not be null");
            zzbq.checkNotNull(o, (Object)"Null options are not permitted for this Api");
            this.zzfkk.put(api, o);
            this.zza(api, o, scopeArray);
            return this;
        }

        public final Builder setAccountName(String string2) {
            this.zzdzb = string2 == null ? null : new Account(string2, "com.google");
            return this;
        }

        public final Builder useDefaultAccount() {
            return this.setAccountName("<<default account>>");
        }

        public final Builder setGravityForPopups(int n) {
            this.zzfkg = n;
            return this;
        }

        public final Builder enableAutoManage(@NonNull FragmentActivity fragmentActivity, int n, @Nullable OnConnectionFailedListener onConnectionFailedListener) {
            OnConnectionFailedListener onConnectionFailedListener2 = onConnectionFailedListener;
            zzch zzch2 = new zzch((Activity)fragmentActivity);
            Builder builder = this;
            zzbq.checkArgument((n >= 0 ? 1 : 0) != 0, (Object)"clientId must be non-negative");
            builder.zzfkm = n;
            builder.zzfkn = onConnectionFailedListener2;
            builder.zzfkl = zzch2;
            return builder;
        }

        public final Builder enableAutoManage(@NonNull FragmentActivity fragmentActivity, @Nullable OnConnectionFailedListener onConnectionFailedListener) {
            return this.enableAutoManage(fragmentActivity, 0, onConnectionFailedListener);
        }

        public final zzr zzagi() {
            zzcwc zzcwc2 = zzcwc.zzjzj;
            if (this.zzfkk.containsKey(zzcvy.API)) {
                zzcwc2 = (zzcwc)this.zzfkk.get(zzcvy.API);
            }
            return new zzr(this.zzdzb, this.zzfke, this.zzfkj, this.zzfkg, this.zzfkh, this.zzdyu, this.zzfki, zzcwc2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final GoogleApiClient build() {
            zzbq.checkArgument((!this.zzfkk.isEmpty() ? 1 : 0) != 0, (Object)"must call addApi() to add at least one API");
            Builder builder = this;
            Object object = builder.zzagi();
            Api<?> api = null;
            boolean bl = false;
            Map<Api<?>, zzt> map = ((zzr)object).zzakm();
            ArrayMap arrayMap = new ArrayMap();
            ArrayMap arrayMap2 = new ArrayMap();
            ArrayList<zzw> arrayList = new ArrayList<zzw>();
            for (Api<?> api2 : builder.zzfkk.keySet()) {
                Api.ApiOptions apiOptions = builder.zzfkk.get(api2);
                boolean bl2 = map.get(api2) != null;
                arrayMap.put(api2, bl2);
                zzw zzw2 = new zzw(api2, bl2);
                arrayList.add(zzw2);
                Object object2 = api2.zzaft();
                Api.zza<?, ?> zza2 = object2;
                zzw zzw3 = zzw2;
                zzw zzw4 = zzw2;
                zzr zzr2 = object;
                Looper looper = builder.zzakm;
                Context context = builder.mContext;
                Api.ApiOptions apiOptions2 = apiOptions;
                Object obj = ((Api.zza)object2).zza(context, looper, zzr2, apiOptions2, zzw4, zzw3);
                arrayMap2.put(api2.zzafu(), obj);
                if (zza2.getPriority() == 1) {
                    boolean bl3 = bl = apiOptions != null;
                }
                if (!obj.zzaax()) continue;
                if (api != null) {
                    object2 = api2.getName();
                    String string2 = api.getName();
                    throw new IllegalStateException(new StringBuilder(21 + String.valueOf(object2).length() + String.valueOf(string2).length()).append((String)object2).append(" cannot be used with ").append(string2).toString());
                }
                api = api2;
            }
            if (api != null) {
                if (bl) {
                    String string3 = api.getName();
                    throw new IllegalStateException(new StringBuilder(82 + String.valueOf(string3).length()).append("With using ").append(string3).append(", GamesOptions can only be specified within GoogleSignInOptions.Builder").toString());
                }
                zzbq.zza((builder.zzdzb == null ? 1 : 0) != 0, (String)"Must not set an account in GoogleApiClient.Builder when using %s. Set account in GoogleSignInOptions.Builder instead", (Object[])new Object[]{api.getName()});
                zzbq.zza((boolean)builder.zzfke.equals(builder.zzfkf), (String)"Must not set scopes in GoogleApiClient.Builder when using %s. Set account in GoogleSignInOptions.Builder instead.", (Object[])new Object[]{api.getName()});
            }
            int n = zzbd.zza(arrayMap2.values(), true);
            zzbd zzbd2 = new zzbd(builder.mContext, new ReentrantLock(), builder.zzakm, (zzr)object, builder.zzfko, builder.zzfkp, (Map<Api<?>, Boolean>)arrayMap, (List<ConnectionCallbacks>)builder.zzfkq, (List<OnConnectionFailedListener>)builder.zzfkr, (Map<Api.zzc<?>, Api.zze>)arrayMap2, builder.zzfkm, n, arrayList, false);
            Set set = zzfkd;
            synchronized (set) {
                zzfkd.add(zzbd2);
            }
            if (this.zzfkm >= 0) {
                object = zzbd2;
                builder = this;
                zzi.zza(builder.zzfkl).zza(builder.zzfkm, (GoogleApiClient)object, builder.zzfkn);
            }
            return zzbd2;
        }

        private final <O extends Api.ApiOptions> void zza(Api<O> api, O o, Scope ... scopeArray) {
            HashSet<Scope> hashSet = new HashSet<Scope>(api.zzafs().zzq(o));
            Scope[] scopeArray2 = scopeArray;
            int n = scopeArray.length;
            for (int i = 0; i < n; ++i) {
                Scope scope = scopeArray2[i];
                hashSet.add(scope);
            }
            this.zzfkj.put(api, new zzt(hashSet));
        }
    }

    public static interface OnConnectionFailedListener {
        public void onConnectionFailed(@NonNull ConnectionResult var1);
    }

    public static interface ConnectionCallbacks {
        public static final int CAUSE_SERVICE_DISCONNECTED = 1;
        public static final int CAUSE_NETWORK_LOST = 2;

        public void onConnected(@Nullable Bundle var1);

        public void onConnectionSuspended(int var1);
    }
}

