/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.data;

import android.graphics.Bitmap;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.common.data.zza;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.internal.zzbej;
import com.google.android.gms.internal.zzbem;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public class BitmapTeleporter
extends zzbej
implements ReflectedParcelable {
    public static final Parcelable.Creator<BitmapTeleporter> CREATOR = new zza();
    private int zzdzm;
    private ParcelFileDescriptor zzcoi;
    private int zzefo;
    private Bitmap zzfth;
    private boolean zzfti;
    private File zzftj;

    BitmapTeleporter(int n, ParcelFileDescriptor parcelFileDescriptor, int n2) {
        this.zzdzm = n;
        this.zzcoi = parcelFileDescriptor;
        this.zzefo = n2;
        this.zzfth = null;
        this.zzfti = false;
    }

    public BitmapTeleporter(Bitmap bitmap) {
        this.zzdzm = 1;
        this.zzcoi = null;
        this.zzefo = 0;
        this.zzfth = bitmap;
        this.zzfti = true;
    }

    public final Bitmap zzajl() {
        if (!this.zzfti) {
            Bitmap.Config config;
            int n;
            int n2;
            byte[] byArray;
            DataInputStream dataInputStream = new DataInputStream((InputStream)new ParcelFileDescriptor.AutoCloseInputStream(this.zzcoi));
            try {
                byArray = new byte[dataInputStream.readInt()];
                n2 = dataInputStream.readInt();
                n = dataInputStream.readInt();
                config = Bitmap.Config.valueOf((String)dataInputStream.readUTF());
                dataInputStream.read(byArray);
            }
            catch (IOException iOException) {
                throw new IllegalStateException("Could not read from parcel file descriptor", iOException);
            }
            finally {
                BitmapTeleporter.zza(dataInputStream);
            }
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            Bitmap bitmap = Bitmap.createBitmap((int)n2, (int)n, (Bitmap.Config)config);
            bitmap.copyPixelsFromBuffer((Buffer)byteBuffer);
            this.zzfth = bitmap;
            this.zzfti = true;
        }
        return this.zzfth;
    }

    public void writeToParcel(Parcel parcel, int n) {
        if (this.zzcoi == null) {
            Bitmap bitmap = this.zzfth;
            ByteBuffer byteBuffer = ByteBuffer.allocate(bitmap.getRowBytes() * bitmap.getHeight());
            bitmap.copyPixelsToBuffer((Buffer)byteBuffer);
            byte[] byArray = byteBuffer.array();
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(this.zzajm());
            DataOutputStream dataOutputStream = new DataOutputStream(bufferedOutputStream);
            try {
                dataOutputStream.writeInt(byArray.length);
                dataOutputStream.writeInt(bitmap.getWidth());
                dataOutputStream.writeInt(bitmap.getHeight());
                dataOutputStream.writeUTF(bitmap.getConfig().toString());
                dataOutputStream.write(byArray);
            }
            catch (IOException iOException) {
                throw new IllegalStateException("Could not write into unlinked file", iOException);
            }
            finally {
                BitmapTeleporter.zza(dataOutputStream);
            }
        }
        int n2 = n | 1;
        Parcel parcel2 = parcel;
        BitmapTeleporter bitmapTeleporter = this;
        int n3 = zzbem.zze((Parcel)parcel2);
        zzbem.zzc((Parcel)parcel2, (int)1, (int)bitmapTeleporter.zzdzm);
        zzbem.zza((Parcel)parcel2, (int)2, (Parcelable)bitmapTeleporter.zzcoi, (int)n2, (boolean)false);
        zzbem.zzc((Parcel)parcel2, (int)3, (int)bitmapTeleporter.zzefo);
        zzbem.zzai((Parcel)parcel2, (int)n3);
        this.zzcoi = null;
    }

    public final void release() {
        if (!this.zzfti) {
            try {
                this.zzcoi.close();
                return;
            }
            catch (IOException iOException) {
                Log.w((String)"BitmapTeleporter", (String)"Could not close PFD", (Throwable)iOException);
            }
        }
    }

    public final void setTempDir(File file) {
        if (file == null) {
            throw new NullPointerException("Cannot set null temp directory");
        }
        this.zzftj = file;
    }

    private final FileOutputStream zzajm() {
        FileOutputStream fileOutputStream;
        File file;
        if (this.zzftj == null) {
            throw new IllegalStateException("setTempDir() must be called before writing this object to a parcel");
        }
        try {
            file = File.createTempFile("teleporter", ".tmp", this.zzftj);
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Could not create temporary file", iOException);
        }
        try {
            fileOutputStream = new FileOutputStream(file);
            this.zzcoi = ParcelFileDescriptor.open((File)file, (int)0x10000000);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IllegalStateException("Temporary file is somehow already deleted");
        }
        file.delete();
        return fileOutputStream;
    }

    private static void zza(Closeable closeable) {
        try {
            closeable.close();
            return;
        }
        catch (IOException iOException) {
            Log.w((String)"BitmapTeleporter", (String)"Could not close stream", (Throwable)iOException);
            return;
        }
    }
}

