/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.NotificationCompat;
import android.util.Log;
import android.util.TypedValue;
import android.view.View;
import android.widget.ProgressBar;
import com.google.android.gms.R;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.ErrorDialogFragment;
import com.google.android.gms.common.SupportErrorDialogFragment;
import com.google.android.gms.common.api.GoogleApi;
import com.google.android.gms.common.api.GoogleApiActivity;
import com.google.android.gms.common.api.internal.zzbp;
import com.google.android.gms.common.api.internal.zzca;
import com.google.android.gms.common.api.internal.zzcb;
import com.google.android.gms.common.api.internal.zzci;
import com.google.android.gms.common.api.internal.zzcq;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.common.internal.zzv;
import com.google.android.gms.common.util.zzi;
import com.google.android.gms.common.util.zzq;
import com.google.android.gms.common.zze;
import com.google.android.gms.common.zzo;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import java.util.ArrayList;
import java.util.Arrays;

public class GoogleApiAvailability
extends zze {
    private static final GoogleApiAvailability zzfib = new GoogleApiAvailability();
    public static final int GOOGLE_PLAY_SERVICES_VERSION_CODE = zze.GOOGLE_PLAY_SERVICES_VERSION_CODE;
    public static final String GOOGLE_PLAY_SERVICES_PACKAGE = "com.google.android.gms";

    public static GoogleApiAvailability getInstance() {
        return zzfib;
    }

    GoogleApiAvailability() {
    }

    @MainThread
    public Task<Void> makeGooglePlayServicesAvailable(Activity activity) {
        zzbq.zzfz((String)"makeGooglePlayServicesAvailable must be called from the main thread");
        int n = this.isGooglePlayServicesAvailable((Context)activity);
        if (n == 0) {
            return Tasks.forResult(null);
        }
        zzcq zzcq2 = zzcq.zzp(activity);
        ConnectionResult connectionResult = new ConnectionResult(n, null);
        zzcq2.zzb(connectionResult, 0);
        return zzcq2.getTask();
    }

    public Dialog getErrorDialog(Activity activity, int n, int n2) {
        return this.getErrorDialog(activity, n, n2, null);
    }

    public Dialog getErrorDialog(Activity activity, int n, int n2, DialogInterface.OnCancelListener onCancelListener) {
        Intent intent = zze.zza((Context)activity, (int)n, (String)"d");
        return GoogleApiAvailability.zza((Context)activity, n, zzv.zza(activity, intent, n2), onCancelListener);
    }

    public boolean showErrorDialogFragment(Activity activity, int n, int n2) {
        return this.showErrorDialogFragment(activity, n, n2, null);
    }

    public final boolean zza(Activity activity, @NonNull zzci zzci2, int n, int n2, DialogInterface.OnCancelListener onCancelListener) {
        Intent intent = zze.zza((Context)activity, (int)n, (String)"d");
        Dialog dialog = GoogleApiAvailability.zza((Context)activity, n, zzv.zza(zzci2, intent, 2), onCancelListener);
        if (dialog == null) {
            return false;
        }
        GoogleApiAvailability.zza(activity, dialog, "GooglePlayServicesErrorDialog", onCancelListener);
        return true;
    }

    public boolean showErrorDialogFragment(Activity activity, int n, int n2, DialogInterface.OnCancelListener onCancelListener) {
        Dialog dialog = this.getErrorDialog(activity, n, n2, onCancelListener);
        if (dialog == null) {
            return false;
        }
        GoogleApiAvailability.zza(activity, dialog, "GooglePlayServicesErrorDialog", onCancelListener);
        return true;
    }

    public void showErrorNotification(Context context, int n) {
        Context context2 = context;
        GoogleApiAvailability googleApiAvailability = this;
        PendingIntent pendingIntent = googleApiAvailability.zza(context2, n, 0, "n");
        googleApiAvailability.zza(context2, n, null, pendingIntent);
    }

    public void showErrorNotification(Context context, ConnectionResult connectionResult) {
        PendingIntent pendingIntent = this.getErrorResolutionPendingIntent(context, connectionResult);
        this.zza(context, connectionResult.getErrorCode(), null, pendingIntent);
    }

    public final boolean zza(Context context, ConnectionResult connectionResult, int n) {
        PendingIntent pendingIntent = this.getErrorResolutionPendingIntent(context, connectionResult);
        if (pendingIntent != null) {
            this.zza(context, connectionResult.getErrorCode(), null, GoogleApiActivity.zza(context, pendingIntent, n));
            return true;
        }
        return false;
    }

    public static Dialog zza(Activity activity, DialogInterface.OnCancelListener onCancelListener) {
        ProgressBar progressBar = new ProgressBar((Context)activity, null, 16842874);
        progressBar.setIndeterminate(true);
        progressBar.setVisibility(0);
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)activity);
        builder.setView((View)progressBar);
        builder.setMessage((CharSequence)zzu.zzi((Context)activity, 18));
        builder.setPositiveButton((CharSequence)"", null);
        AlertDialog alertDialog = builder.create();
        GoogleApiAvailability.zza(activity, (Dialog)alertDialog, "GooglePlayServicesUpdatingDialog", onCancelListener);
        return alertDialog;
    }

    @Nullable
    public static zzca zza(Context context, zzcb zzcb2) {
        IntentFilter intentFilter = new IntentFilter("android.intent.action.PACKAGE_ADDED");
        intentFilter.addDataScheme("package");
        zzca zzca2 = new zzca(zzcb2);
        context.registerReceiver((BroadcastReceiver)zzca2, intentFilter);
        zzca2.setContext(context);
        String string2 = GOOGLE_PLAY_SERVICES_PACKAGE;
        if (!zzo.zzv((Context)context, (String)GOOGLE_PLAY_SERVICES_PACKAGE)) {
            zzcb2.zzagu();
            zzca2.unregister();
            return null;
        }
        return zzca2;
    }

    public Task<Void> checkApiAvailability(GoogleApi<?> googleApi, GoogleApi<?> ... googleApiArray) {
        zzbq.checkNotNull(googleApi, (Object)"Requested API must not be null.");
        Object object = googleApiArray;
        int n = googleApiArray.length;
        for (int i = 0; i < n; ++i) {
            zzbq.checkNotNull(object[i], (Object)"Requested API must not be null.");
        }
        object = new ArrayList(googleApiArray.length + 1);
        object.add(googleApi);
        object.addAll(Arrays.asList(googleApiArray));
        return zzbp.zzaie().zza((Iterable<? extends GoogleApi<?>>)object);
    }

    public int isGooglePlayServicesAvailable(Context context) {
        return super.isGooglePlayServicesAvailable(context);
    }

    public final boolean isUserResolvableError(int n) {
        return super.isUserResolvableError(n);
    }

    @Nullable
    public PendingIntent getErrorResolutionPendingIntent(Context context, int n, int n2) {
        return super.getErrorResolutionPendingIntent(context, n, n2);
    }

    @Nullable
    public PendingIntent getErrorResolutionPendingIntent(Context context, ConnectionResult connectionResult) {
        if (connectionResult.hasResolution()) {
            return connectionResult.getResolution();
        }
        return this.getErrorResolutionPendingIntent(context, connectionResult.getErrorCode(), 0);
    }

    public final String getErrorString(int n) {
        return super.getErrorString(n);
    }

    static Dialog zza(Context context, int n, zzv zzv2, DialogInterface.OnCancelListener onCancelListener) {
        String string2;
        String string3;
        if (n == 0) {
            return null;
        }
        AlertDialog.Builder builder = null;
        TypedValue typedValue = new TypedValue();
        context.getTheme().resolveAttribute(16843529, typedValue, true);
        String string4 = context.getResources().getResourceEntryName(typedValue.resourceId);
        if ("Theme.Dialog.Alert".equals(string4)) {
            builder = new AlertDialog.Builder(context, 5);
        }
        if (builder == null) {
            builder = new AlertDialog.Builder(context);
        }
        builder.setMessage((CharSequence)zzu.zzi(context, n));
        if (onCancelListener != null) {
            builder.setOnCancelListener(onCancelListener);
        }
        if ((string3 = zzu.zzk(context, n)) != null) {
            builder.setPositiveButton((CharSequence)string3, (DialogInterface.OnClickListener)zzv2);
        }
        if ((string2 = zzu.zzg(context, n)) != null) {
            builder.setTitle((CharSequence)string2);
        }
        return builder.create();
    }

    static void zza(Activity activity, Dialog dialog, String string2, DialogInterface.OnCancelListener onCancelListener) {
        boolean bl = activity instanceof FragmentActivity;
        if (bl) {
            FragmentManager fragmentManager = ((FragmentActivity)activity).getSupportFragmentManager();
            SupportErrorDialogFragment.newInstance(dialog, onCancelListener).show(fragmentManager, string2);
            return;
        }
        android.app.FragmentManager fragmentManager = activity.getFragmentManager();
        ErrorDialogFragment.newInstance(dialog, onCancelListener).show(fragmentManager, string2);
    }

    @TargetApi(value=20)
    private final void zza(Context context, int n, String string2, PendingIntent pendingIntent) {
        int n2;
        Notification notification;
        if (n == 18) {
            this.zzca(context);
            return;
        }
        if (pendingIntent == null) {
            if (n == 6) {
                Log.w((String)"GoogleApiAvailability", (String)"Missing resolution for ConnectionResult.RESOLUTION_REQUIRED. Call GoogleApiAvailability#showErrorNotification(Context, ConnectionResult) instead.");
            }
            return;
        }
        String string3 = zzu.zzh(context, n);
        String string4 = zzu.zzj(context, n);
        Resources resources = context.getResources();
        if (zzi.zzcq((Context)context)) {
            zzbq.checkState((boolean)zzq.zzama());
            notification = new Notification.Builder(context).setSmallIcon(context.getApplicationInfo().icon).setPriority(2).setAutoCancel(true).setContentTitle((CharSequence)string3).setStyle((Notification.Style)new Notification.BigTextStyle().bigText((CharSequence)string4)).addAction(R.drawable.common_full_open_on_phone, (CharSequence)resources.getString(R.string.common_open_on_phone), pendingIntent).build();
        } else {
            notification = new NotificationCompat.Builder(context).setSmallIcon(17301642).setTicker((CharSequence)resources.getString(R.string.common_google_play_services_notification_ticker)).setWhen(System.currentTimeMillis()).setAutoCancel(true).setContentIntent(pendingIntent).setContentTitle((CharSequence)string3).setContentText((CharSequence)string4).setLocalOnly(true).setStyle((NotificationCompat.Style)new NotificationCompat.BigTextStyle().bigText((CharSequence)string4)).build();
        }
        switch (n) {
            case 1: 
            case 2: 
            case 3: {
                n2 = 10436;
                zzo.zzfit.set(false);
                break;
            }
            default: {
                n2 = 39789;
            }
        }
        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
        notificationManager.notify(n2, notification);
    }

    final void zzca(Context context) {
        new zza(this, context).sendEmptyMessageDelayed(1, 120000L);
    }

    @SuppressLint(value={"HandlerLeak"})
    final class zza
    extends Handler {
        private final Context mApplicationContext;
        private /* synthetic */ GoogleApiAvailability zzfic;

        public zza(GoogleApiAvailability googleApiAvailability, Context context) {
            this.zzfic = googleApiAvailability;
            super(Looper.myLooper() == null ? Looper.getMainLooper() : Looper.myLooper());
            this.mApplicationContext = context.getApplicationContext();
        }

        public final void handleMessage(Message message) {
            switch (message.what) {
                case 1: {
                    int n = this.zzfic.isGooglePlayServicesAvailable(this.mApplicationContext);
                    if (!this.zzfic.isUserResolvableError(n)) break;
                    this.zzfic.showErrorNotification(this.mApplicationContext, n);
                    return;
                }
                default: {
                    int n = message.what;
                    Log.w((String)"GoogleApiAvailability", (String)new StringBuilder(50).append("Don't know how to handle this message: ").append(n).toString());
                }
            }
        }
    }
}

