/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.content.Context;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zzac;
import com.google.android.gms.common.api.internal.zzaf;
import com.google.android.gms.common.api.internal.zzag;
import com.google.android.gms.common.api.internal.zzbd;
import com.google.android.gms.common.api.internal.zzbp;
import com.google.android.gms.common.api.internal.zzcf;
import com.google.android.gms.common.api.internal.zzcx;
import com.google.android.gms.common.api.internal.zzdo;
import com.google.android.gms.common.api.internal.zzh;
import com.google.android.gms.common.api.internal.zzm;
import com.google.android.gms.common.api.internal.zzs;
import com.google.android.gms.common.api.internal.zzw;
import com.google.android.gms.common.internal.zzr;
import com.google.android.gms.common.internal.zzt;
import com.google.android.gms.common.zze;
import com.google.android.gms.internal.zzbfx;
import com.google.android.gms.internal.zzcwb;
import com.google.android.gms.internal.zzcwc;
import com.google.android.gms.tasks.OnCompleteListener;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;

public final class zzad
implements zzcf {
    private final Map<Api.zzc<?>, zzac<?>> zzfne = new HashMap();
    private final Map<Api.zzc<?>, zzac<?>> zzfnf = new HashMap();
    private final Map<Api<?>, Boolean> zzfng;
    private final zzbp zzfjo;
    private final zzbd zzfnh;
    private final Lock zzfmy;
    private final Looper zzakm;
    private final zze zzfni;
    private final Condition zzfnj;
    private final zzr zzfnd;
    private final boolean zzfnk;
    private final boolean zzfnl;
    private final Queue<zzm<?, ?>> zzfnm = new LinkedList();
    private boolean zzfnn;
    private Map<zzh<?>, ConnectionResult> zzfno;
    private Map<zzh<?>, ConnectionResult> zzfnp;
    private zzag zzfnq;
    private ConnectionResult zzfnr;

    public zzad(Context context, Lock lock, Looper looper, zze zze2, Map<Api.zzc<?>, Api.zze> map, zzr zzr2, Map<Api<?>, Boolean> map2, Api.zza<? extends zzcwb, zzcwc> zza2, ArrayList<zzw> arrayList, zzbd zzbd2, boolean bl) {
        this.zzfmy = lock;
        this.zzakm = looper;
        this.zzfnj = lock.newCondition();
        this.zzfni = zze2;
        this.zzfnh = zzbd2;
        this.zzfng = map2;
        this.zzfnd = zzr2;
        this.zzfnk = bl;
        HashMap hashMap = new HashMap();
        for (Api<?> api : map2.keySet()) {
            hashMap.put(api.zzaft(), api);
        }
        HashMap hashMap2 = new HashMap();
        ArrayList<zzw> arrayList2 = arrayList;
        int n = arrayList2.size();
        for (int i = 0; i < n; ++i) {
            zzw zzw2 = arrayList2.get(i);
            zzw zzw3 = zzw2;
            hashMap2.put(zzw3.zzffv, zzw3);
        }
        boolean bl2 = false;
        boolean bl3 = true;
        boolean bl4 = false;
        for (Map.Entry<Api.zzc<?>, Api.zze> entry : map.entrySet()) {
            Api api = (Api)hashMap.get(entry.getKey());
            Api.zze zze3 = entry.getValue();
            if (zze3.zzafu()) {
                bl4 = true;
                if (!this.zzfng.get(api).booleanValue()) {
                    bl2 = true;
                }
            } else {
                bl3 = false;
            }
            zzw zzw4 = (zzw)hashMap2.get(api);
            zzac zzac2 = new zzac(context, api, looper, zze3, zzw4, zzr2, zza2);
            this.zzfne.put(entry.getKey(), zzac2);
            if (!zze3.zzaam()) continue;
            this.zzfnf.put(entry.getKey(), zzac2);
        }
        this.zzfnl = bl4 && !bl3 && !bl2;
        this.zzfjo = zzbp.zzaie();
    }

    @Override
    public final <A extends Api.zzb, R extends Result, T extends zzm<R, A>> T zzd(@NonNull T t) {
        if (this.zzfnk && this.zzg(t)) {
            return t;
        }
        if (!this.isConnected()) {
            this.zzfnm.add(t);
            return t;
        }
        this.zzfnh.zzfpn.zzb(t);
        return this.zzfne.get(t.zzaft()).zza(t);
    }

    @Override
    public final <A extends Api.zzb, T extends zzm<? extends Result, A>> T zze(@NonNull T t) {
        Api.zzc<A> zzc2 = t.zzaft();
        if (this.zzfnk && this.zzg(t)) {
            return t;
        }
        this.zzfnh.zzfpn.zzb(t);
        return this.zzfne.get(zzc2).zzb(t);
    }

    private final <T extends zzm<? extends Result, ? extends Api.zzb>> boolean zzg(@NonNull T t) {
        Api.zzc<? extends Api.zzb> zzc2 = t.zzaft();
        ConnectionResult connectionResult = this.zzb(zzc2);
        if (connectionResult != null && connectionResult.getErrorCode() == 4) {
            t.zzu(new Status(4, null, this.zzfjo.zza(this.zzfne.get(zzc2).zzaga(), System.identityHashCode(this.zzfnh))));
            return true;
        }
        return false;
    }

    @Override
    public final void connect() {
        this.zzfmy.lock();
        try {
            if (this.zzfnn) {
                return;
            }
            this.zzfnn = true;
            this.zzfno = null;
            this.zzfnp = null;
            this.zzfnq = null;
            this.zzfnr = null;
            this.zzfjo.zzagm();
            this.zzfjo.zza(this.zzfne.values()).addOnCompleteListener((Executor)new zzbfx(this.zzakm), (OnCompleteListener)new zzaf(this, null));
            return;
        }
        finally {
            this.zzfmy.unlock();
        }
    }

    @Override
    public final ConnectionResult blockingConnect() {
        this.connect();
        while (this.isConnecting()) {
            try {
                this.zzfnj.await();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return new ConnectionResult(15, null);
            }
        }
        if (this.isConnected()) {
            return ConnectionResult.zzfhy;
        }
        if (this.zzfnr != null) {
            return this.zzfnr;
        }
        return new ConnectionResult(13, null);
    }

    @Override
    public final ConnectionResult blockingConnect(long l, TimeUnit timeUnit) {
        this.connect();
        long l2 = timeUnit.toNanos(l);
        while (this.isConnecting()) {
            try {
                if (l2 <= 0L) {
                    this.disconnect();
                    return new ConnectionResult(14, null);
                }
                l2 = this.zzfnj.awaitNanos(l2);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return new ConnectionResult(15, null);
            }
        }
        if (this.isConnected()) {
            return ConnectionResult.zzfhy;
        }
        if (this.zzfnr != null) {
            return this.zzfnr;
        }
        return new ConnectionResult(13, null);
    }

    @Override
    public final void disconnect() {
        this.zzfmy.lock();
        try {
            this.zzfnn = false;
            this.zzfno = null;
            this.zzfnp = null;
            if (this.zzfnq != null) {
                this.zzfnq.cancel();
                this.zzfnq = null;
            }
            this.zzfnr = null;
            while (!this.zzfnm.isEmpty()) {
                zzm<?, ?> zzm2 = this.zzfnm.remove();
                ((zzs)zzm2).zza((zzdo)null);
                ((PendingResult)zzm2).cancel();
            }
            this.zzfnj.signalAll();
            return;
        }
        finally {
            this.zzfmy.unlock();
        }
    }

    @Override
    @Nullable
    public final ConnectionResult getConnectionResult(@NonNull Api<?> api) {
        return this.zzb(api.zzaft());
    }

    @Nullable
    private final ConnectionResult zzb(@NonNull Api.zzc<?> zzc2) {
        this.zzfmy.lock();
        try {
            zzac<?> zzac2 = this.zzfne.get(zzc2);
            if (this.zzfno != null && zzac2 != null) {
                ConnectionResult connectionResult = this.zzfno.get(zzac2.zzaga());
                return connectionResult;
            }
            return null;
        }
        finally {
            this.zzfmy.unlock();
        }
    }

    @Override
    public final boolean isConnected() {
        this.zzfmy.lock();
        try {
            boolean bl = this.zzfno != null && this.zzfnr == null;
            return bl;
        }
        finally {
            this.zzfmy.unlock();
        }
    }

    @Override
    public final boolean isConnecting() {
        this.zzfmy.lock();
        try {
            boolean bl = this.zzfno == null && this.zzfnn;
            return bl;
        }
        finally {
            this.zzfmy.unlock();
        }
    }

    private final boolean zzahe() {
        this.zzfmy.lock();
        try {
            if (!this.zzfnn || !this.zzfnk) {
                return false;
            }
            for (Api.zzc<?> zzc2 : this.zzfnf.keySet()) {
                ConnectionResult connectionResult = this.zzb(zzc2);
                if (connectionResult != null && connectionResult.isSuccess()) continue;
                return false;
            }
            return true;
        }
        finally {
            this.zzfmy.unlock();
        }
    }

    @Override
    public final boolean zza(zzcx zzcx2) {
        this.zzfmy.lock();
        try {
            if (this.zzfnn && !this.zzahe()) {
                this.zzfjo.zzagm();
                this.zzfnq = new zzag(this, zzcx2);
                this.zzfjo.zza(this.zzfnf.values()).addOnCompleteListener((Executor)new zzbfx(this.zzakm), (OnCompleteListener)this.zzfnq);
                return true;
            }
            return false;
        }
        finally {
            this.zzfmy.unlock();
        }
    }

    @Override
    public final void zzagf() {
        this.zzfmy.lock();
        try {
            this.zzfjo.zzagf();
            if (this.zzfnq != null) {
                this.zzfnq.cancel();
                this.zzfnq = null;
            }
            if (this.zzfnp == null) {
                this.zzfnp = new ArrayMap(this.zzfnf.size());
            }
            ConnectionResult connectionResult = new ConnectionResult(4);
            for (zzac<?> zzac2 : this.zzfnf.values()) {
                this.zzfnp.put(zzac2.zzaga(), connectionResult);
            }
            if (this.zzfno != null) {
                this.zzfno.putAll(this.zzfnp);
            }
            return;
        }
        finally {
            this.zzfmy.unlock();
        }
    }

    @Override
    public final void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
    }

    @Override
    public final void zzagy() {
    }

    private final void zzahf() {
        if (this.zzfnd == null) {
            this.zzfnh.zzfpi = Collections.emptySet();
            return;
        }
        HashSet<Scope> hashSet = new HashSet<Scope>(this.zzfnd.zzakj());
        Map<Api<?>, zzt> map = this.zzfnd.zzakl();
        for (Api<?> api : map.keySet()) {
            ConnectionResult connectionResult = this.getConnectionResult(api);
            if (connectionResult == null || !connectionResult.isSuccess()) continue;
            hashSet.addAll(map.get(api).zzees);
        }
        this.zzfnh.zzfpi = hashSet;
    }

    private final void zzahg() {
        while (!this.zzfnm.isEmpty()) {
            this.zze(this.zzfnm.remove());
        }
        this.zzfnh.zzj(null);
    }

    private final boolean zza(zzac<?> zzac2, ConnectionResult connectionResult) {
        return !connectionResult.isSuccess() && !connectionResult.hasResolution() && this.zzfng.get(zzac2.zzafy()) != false && zzac2.zzahd().zzafu() && this.zzfni.isUserResolvableError(connectionResult.getErrorCode());
    }

    @Nullable
    private final ConnectionResult zzahh() {
        ConnectionResult connectionResult = null;
        int n = 0;
        ConnectionResult connectionResult2 = null;
        int n2 = 0;
        for (zzac<?> zzac2 : this.zzfne.values()) {
            int n3;
            Api api = zzac2.zzafy();
            zzh zzh2 = zzac2.zzaga();
            ConnectionResult connectionResult3 = this.zzfno.get(zzh2);
            if (connectionResult3.isSuccess() || this.zzfng.get(api).booleanValue() && !connectionResult3.hasResolution() && !this.zzfni.isUserResolvableError(connectionResult3.getErrorCode())) continue;
            if (connectionResult3.getErrorCode() == 4 && this.zzfnk) {
                n3 = api.zzafr().getPriority();
                if (connectionResult2 != null && n2 <= n3) continue;
                connectionResult2 = connectionResult3;
                n2 = n3;
                continue;
            }
            n3 = api.zzafr().getPriority();
            if (connectionResult != null && n <= n3) continue;
            connectionResult = connectionResult3;
            n = n3;
        }
        if (connectionResult != null && connectionResult2 != null && n > n2) {
            return connectionResult2;
        }
        return connectionResult;
    }

    static /* synthetic */ Lock zza(zzad zzad2) {
        return zzad2.zzfmy;
    }

    static /* synthetic */ boolean zzb(zzad zzad2) {
        return zzad2.zzfnn;
    }

    static /* synthetic */ Map zza(zzad zzad2, Map map) {
        zzad2.zzfno = map;
        return zzad2.zzfno;
    }

    static /* synthetic */ Map zzc(zzad zzad2) {
        return zzad2.zzfne;
    }

    static /* synthetic */ Map zzd(zzad zzad2) {
        return zzad2.zzfno;
    }

    static /* synthetic */ boolean zze(zzad zzad2) {
        return zzad2.zzfnl;
    }

    static /* synthetic */ boolean zza(zzad zzad2, zzac zzac2, ConnectionResult connectionResult) {
        return zzad2.zza(zzac2, connectionResult);
    }

    static /* synthetic */ ConnectionResult zza(zzad zzad2, ConnectionResult connectionResult) {
        zzad2.zzfnr = connectionResult;
        return zzad2.zzfnr;
    }

    static /* synthetic */ ConnectionResult zzf(zzad zzad2) {
        return zzad2.zzahh();
    }

    static /* synthetic */ Map zzg(zzad zzad2) {
        return zzad2.zzfnp;
    }

    static /* synthetic */ ConnectionResult zzh(zzad zzad2) {
        return zzad2.zzfnr;
    }

    static /* synthetic */ void zzi(zzad zzad2) {
        zzad2.zzahf();
    }

    static /* synthetic */ void zzj(zzad zzad2) {
        zzad2.zzahg();
    }

    static /* synthetic */ boolean zza(zzad zzad2, boolean bl) {
        zzad2.zzfnn = false;
        return false;
    }

    static /* synthetic */ zzbd zzk(zzad zzad2) {
        return zzad2.zzfnh;
    }

    static /* synthetic */ Condition zzl(zzad zzad2) {
        return zzad2.zzfnj;
    }

    static /* synthetic */ Map zzb(zzad zzad2, Map map) {
        zzad2.zzfnp = map;
        return zzad2.zzfnp;
    }

    static /* synthetic */ Map zzm(zzad zzad2) {
        return zzad2.zzfnf;
    }
}

