/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.v4.app.FragmentActivity;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zzad;
import com.google.android.gms.common.api.internal.zzbe;
import com.google.android.gms.common.api.internal.zzbf;
import com.google.android.gms.common.api.internal.zzbg;
import com.google.android.gms.common.api.internal.zzbh;
import com.google.android.gms.common.api.internal.zzbi;
import com.google.android.gms.common.api.internal.zzbj;
import com.google.android.gms.common.api.internal.zzbl;
import com.google.android.gms.common.api.internal.zzca;
import com.google.android.gms.common.api.internal.zzcf;
import com.google.android.gms.common.api.internal.zzcg;
import com.google.android.gms.common.api.internal.zzch;
import com.google.android.gms.common.api.internal.zzcl;
import com.google.android.gms.common.api.internal.zzcp;
import com.google.android.gms.common.api.internal.zzcx;
import com.google.android.gms.common.api.internal.zzdc;
import com.google.android.gms.common.api.internal.zzdi;
import com.google.android.gms.common.api.internal.zzdl;
import com.google.android.gms.common.api.internal.zzdo;
import com.google.android.gms.common.api.internal.zzi;
import com.google.android.gms.common.api.internal.zzm;
import com.google.android.gms.common.api.internal.zzs;
import com.google.android.gms.common.api.internal.zzw;
import com.google.android.gms.common.api.internal.zzy;
import com.google.android.gms.common.internal.zzae;
import com.google.android.gms.common.internal.zzaf;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.internal.zzr;
import com.google.android.gms.common.zze;
import com.google.android.gms.internal.zzbeq;
import com.google.android.gms.internal.zzcwb;
import com.google.android.gms.internal.zzcwc;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;

public final class zzbd
extends GoogleApiClient
implements zzcg {
    private final Lock zzfmy;
    private boolean zzfki;
    private final zzae zzfpa;
    private zzcf zzfpb = null;
    private final int zzfkc;
    private final Context mContext;
    private final Looper zzakm;
    final Queue<zzm<?, ?>> zzfnm = new LinkedList();
    private volatile boolean zzfpc;
    private long zzfpd = 120000L;
    private long zzfpe = 5000L;
    private final zzbi zzfpf;
    private final GoogleApiAvailability zzfke;
    private zzca zzfpg;
    final Map<Api.zzc<?>, Api.zze> zzfph;
    Set<Scope> zzfpi = new HashSet<Scope>();
    private zzr zzfnd;
    private Map<Api<?>, Boolean> zzfng;
    private Api.zza<? extends zzcwb, zzcwc> zzfkf;
    private final zzcp zzfpj = new zzcp();
    private final ArrayList<zzw> zzfpk;
    private Integer zzfpl = null;
    Set<zzdi> zzfpm = null;
    final zzdl zzfpn;
    private final zzaf zzfpo = new zzbe(this);

    public zzbd(Context context, Lock lock, Looper looper, zzr zzr2, GoogleApiAvailability googleApiAvailability, Api.zza<? extends zzcwb, zzcwc> zza2, Map<Api<?>, Boolean> map, List<GoogleApiClient.ConnectionCallbacks> list, List<GoogleApiClient.OnConnectionFailedListener> list2, Map<Api.zzc<?>, Api.zze> map2, int n, int n2, ArrayList<zzw> arrayList, boolean bl) {
        this.mContext = context;
        this.zzfmy = lock;
        this.zzfki = false;
        this.zzfpa = new zzae(looper, this.zzfpo);
        this.zzakm = looper;
        this.zzfpf = new zzbi(this, looper);
        this.zzfke = googleApiAvailability;
        this.zzfkc = n;
        if (this.zzfkc >= 0) {
            this.zzfpl = n2;
        }
        this.zzfng = map;
        this.zzfph = map2;
        this.zzfpk = arrayList;
        this.zzfpn = new zzdl(this.zzfph);
        for (GoogleApiClient.ConnectionCallbacks object : list) {
            this.zzfpa.registerConnectionCallbacks(object);
        }
        for (GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener : list2) {
            this.zzfpa.registerConnectionFailedListener(onConnectionFailedListener);
        }
        this.zzfnd = zzr2;
        this.zzfkf = zza2;
    }

    @Override
    public final <A extends Api.zzb, R extends Result, T extends zzm<R, A>> T zzd(@NonNull T t) {
        zzbq.checkArgument((t.zzaft() != null ? 1 : 0) != 0, (Object)"This task can not be enqueued (it's probably a Batch or malformed)");
        String string2 = t.zzafy() != null ? t.zzafy().getName() : "the API";
        zzbq.checkArgument((boolean)this.zzfph.containsKey(t.zzaft()), (Object)new StringBuilder(65 + String.valueOf(string2).length()).append("GoogleApiClient is not configured to use ").append(string2).append(" required for this call.").toString());
        this.zzfmy.lock();
        try {
            if (this.zzfpb == null) {
                this.zzfnm.add(t);
                string2 = t;
                return (T)string2;
            }
            string2 = this.zzfpb.zzd(t);
            return (T)string2;
        }
        finally {
            this.zzfmy.unlock();
        }
    }

    @Override
    public final <A extends Api.zzb, T extends zzm<? extends Result, A>> T zze(@NonNull T t) {
        zzbq.checkArgument((t.zzaft() != null ? 1 : 0) != 0, (Object)"This task can not be executed (it's probably a Batch or malformed)");
        Object object = t.zzafy() != null ? t.zzafy().getName() : "the API";
        zzbq.checkArgument((boolean)this.zzfph.containsKey(t.zzaft()), (Object)new StringBuilder(65 + String.valueOf(object).length()).append("GoogleApiClient is not configured to use ").append((String)object).append(" required for this call.").toString());
        this.zzfmy.lock();
        try {
            if (this.zzfpb == null) {
                throw new IllegalStateException("GoogleApiClient is not connected yet.");
            }
            if (this.zzfpc) {
                this.zzfnm.add(t);
                while (!this.zzfnm.isEmpty()) {
                    object = this.zzfnm.remove();
                    this.zzfpn.zzb((zzs<? extends Result>)object);
                    ((zzm)object).zzu(Status.zzfkq);
                }
                object = t;
                return (T)object;
            }
            object = this.zzfpb.zze(t);
            return (T)object;
        }
        finally {
            this.zzfmy.unlock();
        }
    }

    @Override
    public final <L> zzcl<L> zzs(@NonNull L l) {
        this.zzfmy.lock();
        try {
            Looper looper = this.zzakm;
            L l2 = l;
            zzcl<L> zzcl2 = this.zzfpj.zza(l2, looper, "NO_TYPE");
            return zzcl2;
        }
        finally {
            this.zzfmy.unlock();
        }
    }

    @Override
    @NonNull
    public final <C extends Api.zze> C zza(@NonNull Api.zzc<C> zzc2) {
        Api.zze zze2 = this.zzfph.get(zzc2);
        zzbq.checkNotNull((Object)zze2, (Object)"Appropriate Api was not requested.");
        return (C)zze2;
    }

    @Override
    public final boolean zza(@NonNull Api<?> api) {
        return this.zzfph.containsKey(api.zzaft());
    }

    @Override
    public final boolean hasConnectedApi(@NonNull Api<?> api) {
        if (!((GoogleApiClient)this).isConnected()) {
            return false;
        }
        Api.zze zze2 = this.zzfph.get(api.zzaft());
        return zze2 != null && zze2.isConnected();
    }

    @Override
    @NonNull
    public final ConnectionResult getConnectionResult(@NonNull Api<?> api) {
        block6: {
            ConnectionResult connectionResult;
            block7: {
                block8: {
                    this.zzfmy.lock();
                    if (!((GoogleApiClient)this).isConnected() && !this.zzfpc) {
                        throw new IllegalStateException("Cannot invoke getConnectionResult unless GoogleApiClient is connected");
                    }
                    if (!this.zzfph.containsKey(api.zzaft())) break block6;
                    connectionResult = this.zzfpb.getConnectionResult(api);
                    if (connectionResult != null) break block7;
                    if (!this.zzfpc) break block8;
                    ConnectionResult connectionResult2 = ConnectionResult.zzfhy;
                    this.zzfmy.unlock();
                    return connectionResult2;
                }
                Log.w((String)"GoogleApiClientImpl", (String)this.zzaia());
                Log.wtf((String)"GoogleApiClientImpl", (String)String.valueOf(api.getName()).concat(" requested in getConnectionResult is not connected but is not present in the failed  connections map"), (Throwable)new Exception());
                ConnectionResult connectionResult3 = new ConnectionResult(8, null);
                return connectionResult3;
            }
            ConnectionResult connectionResult4 = connectionResult;
            this.zzfmy.unlock();
            return connectionResult4;
        }
        try {
            throw new IllegalArgumentException(String.valueOf(api.getName()).concat(" was never registered with GoogleApiClient"));
        }
        finally {
            this.zzfmy.unlock();
        }
    }

    @Override
    public final void connect() {
        this.zzfmy.lock();
        try {
            if (this.zzfkc >= 0) {
                zzbq.zza((this.zzfpl != null ? 1 : 0) != 0, (Object)"Sign-in mode should have been set explicitly by auto-manage.");
            } else if (this.zzfpl == null) {
                this.zzfpl = zzbd.zza(this.zzfph.values(), false);
            } else if (this.zzfpl == 2) {
                throw new IllegalStateException("Cannot call connect() when SignInMode is set to SIGN_IN_MODE_OPTIONAL. Call connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            ((GoogleApiClient)this).connect(this.zzfpl);
            return;
        }
        finally {
            this.zzfmy.unlock();
        }
    }

    @Override
    public final void connect(int n) {
        this.zzfmy.lock();
        try {
            zzbq.checkArgument((n == 3 || n == 1 || n == 2 ? 1 : 0) != 0, (Object)new StringBuilder(33).append("Illegal sign-in mode: ").append(n).toString());
            this.zzbv(n);
            this.zzahw();
            return;
        }
        finally {
            this.zzfmy.unlock();
        }
    }

    @Override
    public final ConnectionResult blockingConnect() {
        zzbq.zza((Looper.myLooper() != Looper.getMainLooper() ? 1 : 0) != 0, (Object)"blockingConnect must not be called on the UI thread");
        this.zzfmy.lock();
        try {
            if (this.zzfkc >= 0) {
                zzbq.zza((this.zzfpl != null ? 1 : 0) != 0, (Object)"Sign-in mode should have been set explicitly by auto-manage.");
            } else if (this.zzfpl == null) {
                this.zzfpl = zzbd.zza(this.zzfph.values(), false);
            } else if (this.zzfpl == 2) {
                throw new IllegalStateException("Cannot call blockingConnect() when sign-in mode is set to SIGN_IN_MODE_OPTIONAL. Call connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            this.zzbv(this.zzfpl);
            this.zzfpa.zzakx();
            ConnectionResult connectionResult = this.zzfpb.blockingConnect();
            return connectionResult;
        }
        finally {
            this.zzfmy.unlock();
        }
    }

    @Override
    public final ConnectionResult blockingConnect(long l, @NonNull TimeUnit timeUnit) {
        zzbq.zza((Looper.myLooper() != Looper.getMainLooper() ? 1 : 0) != 0, (Object)"blockingConnect must not be called on the UI thread");
        zzbq.checkNotNull((Object)((Object)timeUnit), (Object)"TimeUnit must not be null");
        this.zzfmy.lock();
        try {
            if (this.zzfpl == null) {
                this.zzfpl = zzbd.zza(this.zzfph.values(), false);
            } else if (this.zzfpl == 2) {
                throw new IllegalStateException("Cannot call blockingConnect() when sign-in mode is set to SIGN_IN_MODE_OPTIONAL. Call connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            this.zzbv(this.zzfpl);
            this.zzfpa.zzakx();
            ConnectionResult connectionResult = this.zzfpb.blockingConnect(l, timeUnit);
            return connectionResult;
        }
        finally {
            this.zzfmy.unlock();
        }
    }

    @Override
    public final void disconnect() {
        this.zzfmy.lock();
        try {
            this.zzfpn.release();
            if (this.zzfpb != null) {
                this.zzfpb.disconnect();
            }
            this.zzfpj.release();
            for (zzm zzm2 : this.zzfnm) {
                ((zzs)zzm2).zza((zzdo)null);
                ((PendingResult)zzm2).cancel();
            }
            this.zzfnm.clear();
            if (this.zzfpb == null) {
                return;
            }
            this.zzahy();
            this.zzfpa.zzakw();
            return;
        }
        finally {
            this.zzfmy.unlock();
        }
    }

    @Override
    public final void reconnect() {
        ((GoogleApiClient)this).disconnect();
        ((GoogleApiClient)this).connect();
    }

    @Override
    public final PendingResult<Status> clearDefaultAccountAndReconnect() {
        zzbq.zza((boolean)((GoogleApiClient)this).isConnected(), (Object)"GoogleApiClient is not connected yet.");
        zzbq.zza((this.zzfpl != 2 ? 1 : 0) != 0, (Object)"Cannot use clearDefaultAccountAndReconnect with GOOGLE_SIGN_IN_API");
        zzdc zzdc2 = new zzdc(this);
        if (this.zzfph.containsKey(zzbeq.zzdyh)) {
            this.zza(this, zzdc2, false);
        } else {
            AtomicReference<GoogleApiClient> atomicReference = new AtomicReference<GoogleApiClient>();
            zzbf zzbf2 = new zzbf(this, atomicReference, zzdc2);
            zzbg zzbg2 = new zzbg(this, zzdc2);
            GoogleApiClient googleApiClient = new GoogleApiClient.Builder(this.mContext).addApi(zzbeq.API).addConnectionCallbacks(zzbf2).addOnConnectionFailedListener(zzbg2).setHandler(this.zzfpf).build();
            atomicReference.set(googleApiClient);
            googleApiClient.connect();
        }
        return zzdc2;
    }

    private final void zza(GoogleApiClient googleApiClient, zzdc zzdc2, boolean bl) {
        zzbeq.zzfzb.zzd(googleApiClient).setResultCallback(new zzbh(this, zzdc2, bl, googleApiClient));
    }

    @Override
    public final void stopAutoManage(@NonNull FragmentActivity fragmentActivity) {
        zzch zzch2 = new zzch((Activity)fragmentActivity);
        zzbd zzbd2 = this;
        if (zzbd2.zzfkc >= 0) {
            zzi.zza(zzch2).zzbr(zzbd2.zzfkc);
            return;
        }
        throw new IllegalStateException("Called stopAutoManage but automatic lifecycle management is not enabled.");
    }

    @Override
    public final boolean isConnected() {
        return this.zzfpb != null && this.zzfpb.isConnected();
    }

    @Override
    public final boolean isConnecting() {
        return this.zzfpb != null && this.zzfpb.isConnecting();
    }

    private final void zzbv(int n) {
        if (this.zzfpl == null) {
            this.zzfpl = n;
        } else if (this.zzfpl != n) {
            String string2 = zzbd.zzbw(n);
            String string3 = zzbd.zzbw(this.zzfpl);
            throw new IllegalStateException(new StringBuilder(51 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Cannot use sign-in mode: ").append(string2).append(". Mode was already set to ").append(string3).toString());
        }
        if (this.zzfpb != null) {
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        for (Api.zze zze2 : this.zzfph.values()) {
            if (zze2.zzaam()) {
                bl = true;
            }
            if (!zze2.zzaaw()) continue;
            bl2 = true;
        }
        switch (this.zzfpl) {
            case 3: {
                break;
            }
            case 1: {
                if (!bl) {
                    throw new IllegalStateException("SIGN_IN_MODE_REQUIRED cannot be used on a GoogleApiClient that does not contain any authenticated APIs. Use connect() instead.");
                }
                if (!bl2) break;
                throw new IllegalStateException("Cannot use SIGN_IN_MODE_REQUIRED with GOOGLE_SIGN_IN_API. Use connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            case 2: {
                if (!bl) break;
                if (this.zzfki) {
                    this.zzfpb = new zzad(this.mContext, this.zzfmy, this.zzakm, this.zzfke, this.zzfph, this.zzfnd, this.zzfng, this.zzfkf, this.zzfpk, this, true);
                    return;
                }
                this.zzfpb = zzy.zza(this.mContext, this, this.zzfmy, this.zzakm, this.zzfke, this.zzfph, this.zzfnd, this.zzfng, this.zzfkf, this.zzfpk);
                return;
            }
        }
        if (this.zzfki && !bl2) {
            this.zzfpb = new zzad(this.mContext, this.zzfmy, this.zzakm, this.zzfke, this.zzfph, this.zzfnd, this.zzfng, this.zzfkf, this.zzfpk, this, false);
            return;
        }
        this.zzfpb = new zzbl(this.mContext, this, this.zzfmy, this.zzakm, this.zzfke, this.zzfph, this.zzfnd, this.zzfng, this.zzfkf, this.zzfpk, this);
    }

    private final void zzahw() {
        this.zzfpa.zzakx();
        this.zzfpb.connect();
    }

    private final void resume() {
        this.zzfmy.lock();
        try {
            if (this.zzfpc) {
                this.zzahw();
            }
            return;
        }
        finally {
            this.zzfmy.unlock();
        }
    }

    private final void zzahx() {
        this.zzfmy.lock();
        try {
            if (this.zzahy()) {
                this.zzahw();
            }
            return;
        }
        finally {
            this.zzfmy.unlock();
        }
    }

    final boolean zzahy() {
        if (!this.zzfpc) {
            return false;
        }
        this.zzfpc = false;
        this.zzfpf.removeMessages(2);
        this.zzfpf.removeMessages(1);
        if (this.zzfpg != null) {
            this.zzfpg.unregister();
            this.zzfpg = null;
        }
        return true;
    }

    @Override
    public final void registerConnectionCallbacks(@NonNull GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        this.zzfpa.registerConnectionCallbacks(connectionCallbacks);
    }

    @Override
    public final boolean isConnectionCallbacksRegistered(@NonNull GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        return this.zzfpa.isConnectionCallbacksRegistered(connectionCallbacks);
    }

    @Override
    public final void unregisterConnectionCallbacks(@NonNull GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        this.zzfpa.unregisterConnectionCallbacks(connectionCallbacks);
    }

    @Override
    public final void registerConnectionFailedListener(@NonNull GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        this.zzfpa.registerConnectionFailedListener(onConnectionFailedListener);
    }

    @Override
    public final boolean isConnectionFailedListenerRegistered(@NonNull GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        return this.zzfpa.isConnectionFailedListenerRegistered(onConnectionFailedListener);
    }

    @Override
    public final void unregisterConnectionFailedListener(@NonNull GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        this.zzfpa.unregisterConnectionFailedListener(onConnectionFailedListener);
    }

    @Override
    public final void zzj(Bundle bundle) {
        while (!this.zzfnm.isEmpty()) {
            ((GoogleApiClient)this).zze(this.zzfnm.remove());
        }
        this.zzfpa.zzk(bundle);
    }

    @Override
    public final void zzc(ConnectionResult connectionResult) {
        if (!zze.zze((Context)this.mContext, (int)connectionResult.getErrorCode())) {
            this.zzahy();
        }
        if (!this.zzfpc) {
            this.zzfpa.zzk(connectionResult);
            this.zzfpa.zzakw();
        }
    }

    @Override
    public final void zzf(int n, boolean bl) {
        if (n == 1 && !bl) {
            zzbd zzbd2 = this;
            if (!zzbd2.zzfpc) {
                zzbd2.zzfpc = true;
                if (zzbd2.zzfpg == null) {
                    zzbd2.zzfpg = GoogleApiAvailability.zza(zzbd2.mContext.getApplicationContext(), new zzbj(zzbd2));
                }
                zzbd2.zzfpf.sendMessageDelayed(zzbd2.zzfpf.obtainMessage(1), zzbd2.zzfpd);
                zzbd2.zzfpf.sendMessageDelayed(zzbd2.zzfpf.obtainMessage(2), zzbd2.zzfpe);
            }
        }
        this.zzfpn.zzaji();
        this.zzfpa.zzcg(n);
        this.zzfpa.zzakw();
        if (n == 2) {
            this.zzahw();
        }
    }

    @Override
    public final Context getContext() {
        return this.mContext;
    }

    @Override
    public final Looper getLooper() {
        return this.zzakm;
    }

    @Override
    public final boolean zza(zzcx zzcx2) {
        return this.zzfpb != null && this.zzfpb.zza(zzcx2);
    }

    @Override
    public final void zzagf() {
        if (this.zzfpb != null) {
            this.zzfpb.zzagf();
        }
    }

    @Override
    public final void zza(zzdi zzdi2) {
        this.zzfmy.lock();
        try {
            if (this.zzfpm == null) {
                this.zzfpm = new HashSet<zzdi>();
            }
            this.zzfpm.add(zzdi2);
            return;
        }
        finally {
            this.zzfmy.unlock();
        }
    }

    @Override
    public final void zzb(zzdi zzdi2) {
        this.zzfmy.lock();
        try {
            if (this.zzfpm == null) {
                Log.wtf((String)"GoogleApiClientImpl", (String)"Attempted to remove pending transform when no transforms are registered.", (Throwable)new Exception());
            } else if (!this.zzfpm.remove(zzdi2)) {
                Log.wtf((String)"GoogleApiClientImpl", (String)"Failed to remove pending transform - this may lead to memory leaks!", (Throwable)new Exception());
            } else if (!this.zzahz()) {
                this.zzfpb.zzagy();
            }
            return;
        }
        finally {
            this.zzfmy.unlock();
        }
    }

    final boolean zzahz() {
        this.zzfmy.lock();
        try {
            if (this.zzfpm == null) {
                return false;
            }
            boolean bl = !this.zzfpm.isEmpty();
            return bl;
        }
        finally {
            this.zzfmy.unlock();
        }
    }

    final String zzaia() {
        StringWriter stringWriter = new StringWriter();
        ((GoogleApiClient)this).dump("", null, new PrintWriter(stringWriter), null);
        return stringWriter.toString();
    }

    @Override
    public final void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        printWriter.append(string2).append("mContext=").println(this.mContext);
        printWriter.append(string2).append("mResuming=").print(this.zzfpc);
        printWriter.append(" mWorkQueue.size()=").print(this.zzfnm.size());
        PrintWriter printWriter2 = printWriter;
        zzdl zzdl2 = this.zzfpn;
        printWriter2.append(" mUnconsumedApiCalls.size()=").println(zzdl2.zzfso.size());
        if (this.zzfpb != null) {
            this.zzfpb.dump(string2, fileDescriptor, printWriter, stringArray);
        }
    }

    public static int zza(Iterable<Api.zze> iterable, boolean bl) {
        boolean bl2 = false;
        boolean bl3 = false;
        for (Api.zze zze2 : iterable) {
            if (zze2.zzaam()) {
                bl2 = true;
            }
            if (!zze2.zzaaw()) continue;
            bl3 = true;
        }
        if (bl2) {
            if (bl3 && bl) {
                return 2;
            }
            return 1;
        }
        return 3;
    }

    private static String zzbw(int n) {
        switch (n) {
            case 3: {
                return "SIGN_IN_MODE_NONE";
            }
            case 1: {
                return "SIGN_IN_MODE_REQUIRED";
            }
            case 2: {
                return "SIGN_IN_MODE_OPTIONAL";
            }
        }
        return "UNKNOWN";
    }

    static /* synthetic */ void zza(zzbd zzbd2) {
        zzbd2.resume();
    }

    static /* synthetic */ void zzb(zzbd zzbd2) {
        zzbd2.zzahx();
    }

    static /* synthetic */ void zza(zzbd zzbd2, GoogleApiClient googleApiClient, zzdc zzdc2, boolean bl) {
        zzbd2.zza(googleApiClient, zzdc2, true);
    }

    static /* synthetic */ Context zzc(zzbd zzbd2) {
        return zzbd2.mContext;
    }
}

