/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.internal.zzao;
import com.google.android.gms.common.api.internal.zzar;
import com.google.android.gms.common.api.internal.zzbc;
import com.google.android.gms.common.api.internal.zzbd;
import com.google.android.gms.common.api.internal.zzbk;
import com.google.android.gms.common.api.internal.zzbm;
import com.google.android.gms.common.api.internal.zzbn;
import com.google.android.gms.common.api.internal.zzcf;
import com.google.android.gms.common.api.internal.zzcg;
import com.google.android.gms.common.api.internal.zzcx;
import com.google.android.gms.common.api.internal.zzm;
import com.google.android.gms.common.api.internal.zzw;
import com.google.android.gms.common.api.internal.zzx;
import com.google.android.gms.common.internal.zzr;
import com.google.android.gms.common.zze;
import com.google.android.gms.internal.zzcwb;
import com.google.android.gms.internal.zzcwc;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;

public final class zzbl
implements zzcf,
zzx {
    private final Lock zzfmy;
    private final Condition zzfpu;
    private final Context mContext;
    private final zze zzfni;
    private final zzbn zzfpv;
    final Map<Api.zzc<?>, Api.zze> zzfph;
    final Map<Api.zzc<?>, ConnectionResult> zzfpw = new HashMap();
    private zzr zzfnd;
    private Map<Api<?>, Boolean> zzfng;
    private Api.zza<? extends zzcwb, zzcwc> zzfkf;
    private volatile zzbk zzfpx;
    private ConnectionResult zzfpy = null;
    int zzfpz;
    final zzbd zzfmo;
    final zzcg zzfqa;

    public zzbl(Context context, zzbd zzbd2, Lock lock, Looper looper, zze zze2, Map<Api.zzc<?>, Api.zze> map, zzr zzr2, Map<Api<?>, Boolean> map2, Api.zza<? extends zzcwb, zzcwc> zza2, ArrayList<zzw> arrayList, zzcg zzcg2) {
        this.mContext = context;
        this.zzfmy = lock;
        this.zzfni = zze2;
        this.zzfph = map;
        this.zzfnd = zzr2;
        this.zzfng = map2;
        this.zzfkf = zza2;
        this.zzfmo = zzbd2;
        this.zzfqa = zzcg2;
        ArrayList<zzw> arrayList2 = arrayList;
        int n = arrayList2.size();
        for (int i = 0; i < n; ++i) {
            zzw zzw2 = arrayList2.get(i);
            zzw2.zza(this);
        }
        this.zzfpv = new zzbn(this, looper);
        this.zzfpu = lock.newCondition();
        this.zzfpx = new zzbc(this);
    }

    @Override
    public final <A extends Api.zzb, R extends Result, T extends zzm<R, A>> T zzd(@NonNull T t) {
        t.zzagw();
        return this.zzfpx.zzd(t);
    }

    @Override
    public final <A extends Api.zzb, T extends zzm<? extends Result, A>> T zze(@NonNull T t) {
        t.zzagw();
        return this.zzfpx.zze(t);
    }

    @Override
    public final void connect() {
        this.zzfpx.connect();
    }

    @Override
    public final ConnectionResult blockingConnect() {
        this.connect();
        while (this.isConnecting()) {
            try {
                this.zzfpu.await();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return new ConnectionResult(15, null);
            }
        }
        if (this.isConnected()) {
            return ConnectionResult.zzfhy;
        }
        if (this.zzfpy != null) {
            return this.zzfpy;
        }
        return new ConnectionResult(13, null);
    }

    @Override
    public final ConnectionResult blockingConnect(long l, TimeUnit timeUnit) {
        this.connect();
        long l2 = timeUnit.toNanos(l);
        while (this.isConnecting()) {
            try {
                if (l2 <= 0L) {
                    this.disconnect();
                    return new ConnectionResult(14, null);
                }
                l2 = this.zzfpu.awaitNanos(l2);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return new ConnectionResult(15, null);
            }
        }
        if (this.isConnected()) {
            return ConnectionResult.zzfhy;
        }
        if (this.zzfpy != null) {
            return this.zzfpy;
        }
        return new ConnectionResult(13, null);
    }

    @Override
    public final void disconnect() {
        if (this.zzfpx.disconnect()) {
            this.zzfpw.clear();
        }
    }

    @Override
    @Nullable
    public final ConnectionResult getConnectionResult(@NonNull Api<?> api) {
        Api.zzc<?> zzc2 = api.zzaft();
        if (this.zzfph.containsKey(zzc2)) {
            if (this.zzfph.get(zzc2).isConnected()) {
                return ConnectionResult.zzfhy;
            }
            if (this.zzfpw.containsKey(zzc2)) {
                return this.zzfpw.get(zzc2);
            }
        }
        return null;
    }

    final void zzaib() {
        this.zzfmy.lock();
        try {
            this.zzfpx = new zzar(this, this.zzfnd, this.zzfng, this.zzfni, this.zzfkf, this.zzfmy, this.mContext);
            this.zzfpx.begin();
            this.zzfpu.signalAll();
            return;
        }
        finally {
            this.zzfmy.unlock();
        }
    }

    final void zzaic() {
        this.zzfmy.lock();
        try {
            this.zzfmo.zzahy();
            this.zzfpx = new zzao(this);
            this.zzfpx.begin();
            this.zzfpu.signalAll();
            return;
        }
        finally {
            this.zzfmy.unlock();
        }
    }

    final void zzg(ConnectionResult connectionResult) {
        this.zzfmy.lock();
        try {
            this.zzfpy = connectionResult;
            this.zzfpx = new zzbc(this);
            this.zzfpx.begin();
            this.zzfpu.signalAll();
            return;
        }
        finally {
            this.zzfmy.unlock();
        }
    }

    @Override
    public final boolean isConnected() {
        return this.zzfpx instanceof zzao;
    }

    @Override
    public final boolean isConnecting() {
        return this.zzfpx instanceof zzar;
    }

    @Override
    public final boolean zza(zzcx zzcx2) {
        return false;
    }

    @Override
    public final void zzagf() {
    }

    @Override
    public final void zzagy() {
        if (this.isConnected()) {
            ((zzao)this.zzfpx).zzaho();
        }
    }

    @Override
    public final void zza(@NonNull ConnectionResult connectionResult, @NonNull Api<?> api, boolean bl) {
        this.zzfmy.lock();
        try {
            this.zzfpx.zza(connectionResult, api, bl);
            return;
        }
        finally {
            this.zzfmy.unlock();
        }
    }

    @Override
    public final void onConnected(@Nullable Bundle bundle) {
        this.zzfmy.lock();
        try {
            this.zzfpx.onConnected(bundle);
            return;
        }
        finally {
            this.zzfmy.unlock();
        }
    }

    @Override
    public final void onConnectionSuspended(int n) {
        this.zzfmy.lock();
        try {
            this.zzfpx.onConnectionSuspended(n);
            return;
        }
        finally {
            this.zzfmy.unlock();
        }
    }

    final void zza(zzbm zzbm2) {
        Message message = this.zzfpv.obtainMessage(1, zzbm2);
        this.zzfpv.sendMessage(message);
    }

    final void zza(RuntimeException runtimeException) {
        Message message = this.zzfpv.obtainMessage(2, runtimeException);
        this.zzfpv.sendMessage(message);
    }

    @Override
    public final void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        String string3 = String.valueOf(string2).concat("  ");
        printWriter.append(string2).append("mState=").println(this.zzfpx);
        for (Api<?> api : this.zzfng.keySet()) {
            printWriter.append(string2).append(api.getName()).println(":");
            this.zzfph.get(api.zzaft()).dump(string3, fileDescriptor, printWriter, stringArray);
        }
    }

    static /* synthetic */ Lock zza(zzbl zzbl2) {
        return zzbl2.zzfmy;
    }

    static /* synthetic */ zzbk zzb(zzbl zzbl2) {
        return zzbl2.zzfpx;
    }
}

