/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.SystemClock;
import com.google.android.gms.internal.zzbee;
import com.google.android.gms.internal.zzbeg;

public final class zzbec
extends Drawable
implements Drawable.Callback {
    private int zzfuu = 0;
    private long zzdss;
    private int mFrom;
    private int zzfuv;
    private int zzfuw = 255;
    private int zzfux;
    private int mAlpha = 0;
    private boolean zzfup = true;
    private boolean zzfuy;
    private zzbeg zzfuz;
    private Drawable zzfva;
    private Drawable zzfvb;
    private boolean zzfvc;
    private boolean zzfvd;
    private boolean zzfve;
    private int zzfvf;

    public zzbec(Drawable drawable2, Drawable drawable3) {
        this(null);
        if (drawable2 == null) {
            drawable2 = zzbee.zzajt();
        }
        this.zzfva = drawable2;
        drawable2.setCallback((Drawable.Callback)this);
        this.zzfuz.zzfvi |= drawable2.getChangingConfigurations();
        if (drawable3 == null) {
            drawable3 = zzbee.zzajt();
        }
        this.zzfvb = drawable3;
        drawable3.setCallback((Drawable.Callback)this);
        this.zzfuz.zzfvi |= drawable3.getChangingConfigurations();
    }

    zzbec(zzbeg zzbeg2) {
        this.zzfuz = new zzbeg(zzbeg2);
    }

    public final void invalidateDrawable(Drawable drawable2) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.invalidateDrawable((Drawable)this);
        }
    }

    public final void scheduleDrawable(Drawable drawable2, Runnable runnable, long l) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.scheduleDrawable((Drawable)this, runnable, l);
        }
    }

    public final void unscheduleDrawable(Drawable drawable2, Runnable runnable) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.unscheduleDrawable((Drawable)this, runnable);
        }
    }

    public final int getChangingConfigurations() {
        return super.getChangingConfigurations() | this.zzfuz.mChangingConfigurations | this.zzfuz.zzfvi;
    }

    public final void setAlpha(int n) {
        if (this.mAlpha == this.zzfuw) {
            this.mAlpha = n;
        }
        this.zzfuw = n;
        this.invalidateSelf();
    }

    public final void setColorFilter(ColorFilter colorFilter) {
        this.zzfva.setColorFilter(colorFilter);
        this.zzfvb.setColorFilter(colorFilter);
    }

    public final int getIntrinsicWidth() {
        return Math.max(this.zzfva.getIntrinsicWidth(), this.zzfvb.getIntrinsicWidth());
    }

    public final int getIntrinsicHeight() {
        return Math.max(this.zzfva.getIntrinsicHeight(), this.zzfvb.getIntrinsicHeight());
    }

    protected final void onBoundsChange(Rect rect) {
        this.zzfva.setBounds(rect);
        this.zzfvb.setBounds(rect);
    }

    public final Drawable.ConstantState getConstantState() {
        if (this.canConstantState()) {
            this.zzfuz.mChangingConfigurations = this.getChangingConfigurations();
            return this.zzfuz;
        }
        return null;
    }

    public final int getOpacity() {
        if (!this.zzfve) {
            this.zzfvf = Drawable.resolveOpacity((int)this.zzfva.getOpacity(), (int)this.zzfvb.getOpacity());
            this.zzfve = true;
        }
        return this.zzfvf;
    }

    private final boolean canConstantState() {
        if (!this.zzfvc) {
            this.zzfvd = this.zzfva.getConstantState() != null && this.zzfvb.getConstantState() != null;
            this.zzfvc = true;
        }
        return this.zzfvd;
    }

    public final Drawable mutate() {
        if (!this.zzfuy && super.mutate() == this) {
            if (!this.canConstantState()) {
                throw new IllegalStateException("One or more children of this LayerDrawable does not have constant state; this drawable cannot be mutated.");
            }
            this.zzfva.mutate();
            this.zzfvb.mutate();
            this.zzfuy = true;
        }
        return this;
    }

    public final Drawable zzajs() {
        return this.zzfvb;
    }

    public final void startTransition(int n) {
        this.mFrom = 0;
        this.zzfuv = this.zzfuw;
        this.mAlpha = 0;
        this.zzfux = 250;
        this.zzfuu = 1;
        this.invalidateSelf();
    }

    public final void draw(Canvas canvas) {
        boolean bl = true;
        switch (this.zzfuu) {
            case 1: {
                this.zzdss = SystemClock.uptimeMillis();
                bl = false;
                this.zzfuu = 2;
                break;
            }
            case 2: {
                float f;
                if (this.zzdss < 0L) break;
                float f2 = (float)(SystemClock.uptimeMillis() - this.zzdss) / (float)this.zzfux;
                bl = f >= 1.0f;
                if (bl) {
                    this.zzfuu = 0;
                }
                f2 = Math.min(f2, 1.0f);
                this.mAlpha = (int)(0.0f + (float)this.zzfuv * f2);
            }
        }
        int n = this.mAlpha;
        boolean bl2 = this.zzfup;
        Drawable drawable2 = this.zzfva;
        Drawable drawable3 = this.zzfvb;
        if (bl) {
            if (!bl2 || n == 0) {
                drawable2.draw(canvas);
            }
            if (n == this.zzfuw) {
                drawable3.setAlpha(this.zzfuw);
                drawable3.draw(canvas);
            }
            return;
        }
        if (bl2) {
            drawable2.setAlpha(this.zzfuw - n);
        }
        drawable2.draw(canvas);
        if (bl2) {
            drawable2.setAlpha(this.zzfuw);
        }
        if (n > 0) {
            drawable3.setAlpha(n);
            drawable3.draw(canvas);
            drawable3.setAlpha(this.zzfuw);
        }
        this.invalidateSelf();
    }
}

