/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.util.Log;
import android.util.Pair;
import com.google.android.gms.common.annotation.KeepName;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.ResultTransform;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.TransformedResult;
import com.google.android.gms.common.api.internal.zzdg;
import com.google.android.gms.common.api.internal.zzdm;
import com.google.android.gms.common.api.internal.zzs;
import com.google.android.gms.common.internal.zzaq;
import com.google.android.gms.common.internal.zzbq;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

@KeepName
public abstract class BasePendingResult<R extends Result>
extends PendingResult<R> {
    static final ThreadLocal<Boolean> zzfot = new zzs();
    private final Object zzfou = new Object();
    private zza<R> zzfov;
    private WeakReference<GoogleApiClient> zzfow;
    private final CountDownLatch zzapd = new CountDownLatch(1);
    private final ArrayList<PendingResult.zza> zzfox = new ArrayList();
    private ResultCallback<? super R> zzfoy;
    private final AtomicReference<zzdm> zzfoz = new AtomicReference();
    private R zzfne;
    private Status mStatus;
    @KeepName
    private zzb mResultGuardian;
    private volatile boolean zzfpa;
    private boolean zzan;
    private boolean zzfpb;
    private zzaq zzfpc;
    private volatile zzdg<R> zzfpd;
    private boolean zzfpe = false;

    @Deprecated
    BasePendingResult() {
        this.zzfov = new zza(Looper.getMainLooper());
        this.zzfow = new WeakReference<Object>(null);
    }

    protected BasePendingResult(GoogleApiClient googleApiClient) {
        Looper looper = googleApiClient != null ? googleApiClient.getLooper() : Looper.getMainLooper();
        this.zzfov = new zza(looper);
        this.zzfow = new WeakReference<GoogleApiClient>(googleApiClient);
    }

    @Deprecated
    protected BasePendingResult(Looper looper) {
        this.zzfov = new zza(looper);
        this.zzfow = new WeakReference<Object>(null);
    }

    public final boolean isReady() {
        return this.zzapd.getCount() == 0L;
    }

    @Override
    public final R await() {
        zzbq.zzgn((String)"await must not be called on the UI thread");
        zzbq.zza((!this.zzfpa ? 1 : 0) != 0, (Object)"Result has already been consumed");
        zzbq.zza((this.zzfpd == null ? 1 : 0) != 0, (Object)"Cannot await if then() has been called.");
        try {
            this.zzapd.await();
        }
        catch (InterruptedException interruptedException) {
            this.zzv(Status.zzfnj);
        }
        zzbq.zza((boolean)this.isReady(), (Object)"Result is not ready.");
        return this.get();
    }

    @Override
    public final R await(long l, TimeUnit timeUnit) {
        if (l > 0L) {
            zzbq.zzgn((String)"await must not be called on the UI thread when time is greater than zero.");
        }
        zzbq.zza((!this.zzfpa ? 1 : 0) != 0, (Object)"Result has already been consumed.");
        zzbq.zza((this.zzfpd == null ? 1 : 0) != 0, (Object)"Cannot await if then() has been called.");
        try {
            if (!this.zzapd.await(l, timeUnit)) {
                this.zzv(Status.zzfnl);
            }
        }
        catch (InterruptedException interruptedException) {
            this.zzv(Status.zzfnj);
        }
        zzbq.zza((boolean)this.isReady(), (Object)"Result is not ready.");
        return this.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setResultCallback(ResultCallback<? super R> resultCallback) {
        Object object = this.zzfou;
        synchronized (object) {
            if (resultCallback == null) {
                this.zzfoy = null;
                return;
            }
            zzbq.zza((!this.zzfpa ? 1 : 0) != 0, (Object)"Result has already been consumed.");
            zzbq.zza((this.zzfpd == null ? 1 : 0) != 0, (Object)"Cannot set callbacks if then() has been called.");
            if (((PendingResult)this).isCanceled()) {
                return;
            }
            if (this.isReady()) {
                this.zzfov.zza(resultCallback, (R)this.get());
            } else {
                this.zzfoy = resultCallback;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setResultCallback(ResultCallback<? super R> resultCallback, long l, TimeUnit timeUnit) {
        Object object = this.zzfou;
        synchronized (object) {
            if (resultCallback == null) {
                this.zzfoy = null;
                return;
            }
            zzbq.zza((!this.zzfpa ? 1 : 0) != 0, (Object)"Result has already been consumed.");
            zzbq.zza((this.zzfpd == null ? 1 : 0) != 0, (Object)"Cannot set callbacks if then() has been called.");
            if (((PendingResult)this).isCanceled()) {
                return;
            }
            if (this.isReady()) {
                this.zzfov.zza(resultCallback, (R)this.get());
            } else {
                this.zzfoy = resultCallback;
                long l2 = timeUnit.toMillis(l);
                BasePendingResult basePendingResult = this;
                zza<R> zza2 = this.zzfov;
                zza2.sendMessageDelayed(zza2.obtainMessage(2, basePendingResult), l2);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zza(PendingResult.zza zza2) {
        zzbq.checkArgument((zza2 != null ? 1 : 0) != 0, (Object)"Callback cannot be null.");
        Object object = this.zzfou;
        synchronized (object) {
            if (this.isReady()) {
                zza2.zzr(this.mStatus);
            } else {
                this.zzfox.add(zza2);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        Object object = this.zzfou;
        synchronized (object) {
            if (this.zzan || this.zzfpa) {
                return;
            }
            if (this.zzfpc != null) {
                try {
                    this.zzfpc.cancel();
                }
                catch (RemoteException remoteException) {}
            }
            BasePendingResult.zzd(this.zzfne);
            this.zzan = true;
            this.zzc(this.zzb(Status.zzfnm));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zzahh() {
        Object object = this.zzfou;
        synchronized (object) {
            if ((GoogleApiClient)this.zzfow.get() == null || !this.zzfpe) {
                ((PendingResult)this).cancel();
            }
            return ((PendingResult)this).isCanceled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCanceled() {
        Object object = this.zzfou;
        synchronized (object) {
            return this.zzan;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <S extends Result> TransformedResult<S> then(ResultTransform<? super R, ? extends S> resultTransform) {
        zzbq.zza((!this.zzfpa ? 1 : 0) != 0, (Object)"Result has already been consumed.");
        Object object = this.zzfou;
        synchronized (object) {
            zzbq.zza((this.zzfpd == null ? 1 : 0) != 0, (Object)"Cannot call then() twice.");
            zzbq.zza((this.zzfoy == null ? 1 : 0) != 0, (Object)"Cannot call then() if callbacks are set.");
            zzbq.zza((!this.zzan ? 1 : 0) != 0, (Object)"Cannot call then() if result was canceled.");
            this.zzfpe = true;
            this.zzfpd = new zzdg(this.zzfow);
            TransformedResult<? extends S> transformedResult = ((TransformedResult)this.zzfpd).then(resultTransform);
            if (this.isReady()) {
                this.zzfov.zza(this.zzfpd, this.get());
            } else {
                this.zzfoy = this.zzfpd;
            }
            return transformedResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setResult(R r) {
        Object object = this.zzfou;
        synchronized (object) {
            if (!this.zzfpb && !this.zzan) {
                if (this.isReady()) {
                    // empty if block
                }
            } else {
                BasePendingResult.zzd(r);
                return;
            }
            zzbq.zza((!this.isReady() ? 1 : 0) != 0, (Object)"Results have already been set");
            zzbq.zza((!this.zzfpa ? 1 : 0) != 0, (Object)"Result has already been consumed");
            this.zzc(r);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzv(Status status) {
        Object object = this.zzfou;
        synchronized (object) {
            if (!this.isReady()) {
                this.setResult(this.zzb(status));
                this.zzfpb = true;
            }
            return;
        }
    }

    @NonNull
    protected abstract R zzb(Status var1);

    public final void zza(zzdm zzdm2) {
        this.zzfoz.set(zzdm2);
    }

    @Override
    public final Integer zzagv() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void zza(zzaq zzaq2) {
        Object object = this.zzfou;
        synchronized (object) {
            this.zzfpc = zzaq2;
            return;
        }
    }

    public final void zzahi() {
        this.zzfpe = this.zzfpe || zzfot.get() != false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final R get() {
        R r;
        Object object = this.zzfou;
        synchronized (object) {
            zzbq.zza((!this.zzfpa ? 1 : 0) != 0, (Object)"Result has already been consumed.");
            zzbq.zza((boolean)this.isReady(), (Object)"Result is not ready.");
            r = this.zzfne;
            this.zzfne = null;
            this.zzfoy = null;
            this.zzfpa = true;
        }
        BasePendingResult basePendingResult = this;
        zzdm zzdm2 = basePendingResult.zzfoz.getAndSet(null);
        if (zzdm2 != null) {
            zzdm2.zzc(basePendingResult);
        }
        return r;
    }

    private final void zzc(R r) {
        this.zzfne = r;
        this.zzfpc = null;
        this.zzapd.countDown();
        this.mStatus = this.zzfne.getStatus();
        if (this.zzan) {
            this.zzfoy = null;
        } else if (this.zzfoy == null) {
            if (this.zzfne instanceof Releasable) {
                this.mResultGuardian = new zzb(this, null);
            }
        } else {
            this.zzfov.removeMessages(2);
            this.zzfov.zza(this.zzfoy, (R)this.get());
        }
        ArrayList<PendingResult.zza> arrayList = this.zzfox;
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            PendingResult.zza zza2 = arrayList.get(i);
            zza2.zzr(this.mStatus);
        }
        this.zzfox.clear();
    }

    public static void zzd(Result result) {
        if (result instanceof Releasable) {
            try {
                ((Releasable)result).release();
                return;
            }
            catch (RuntimeException runtimeException) {
                String string2 = String.valueOf(result);
                Log.w((String)"BasePendingResult", (String)new StringBuilder(18 + String.valueOf(string2).length()).append("Unable to release ").append(string2).toString(), (Throwable)runtimeException);
            }
        }
    }

    final class zzb {
        private /* synthetic */ BasePendingResult zzfpf;

        private zzb(BasePendingResult basePendingResult) {
            this.zzfpf = basePendingResult;
        }

        protected final void finalize() throws Throwable {
            BasePendingResult.zzd(this.zzfpf.zzfne);
            super.finalize();
        }

        /* synthetic */ zzb(BasePendingResult basePendingResult, zzs zzs2) {
            this(basePendingResult);
        }
    }

    public static final class zza<R extends Result>
    extends Handler {
        public zza() {
            this(Looper.getMainLooper());
        }

        public zza(Looper looper) {
            super(looper);
        }

        public final void zza(ResultCallback<? super R> resultCallback, R r) {
            this.sendMessage(this.obtainMessage(1, new Pair(resultCallback, r)));
        }

        public final void handleMessage(Message message) {
            switch (message.what) {
                case 1: {
                    Pair pair = (Pair)message.obj;
                    Result result = (Result)pair.second;
                    ResultCallback resultCallback = (ResultCallback)pair.first;
                    try {
                        resultCallback.onResult(result);
                        return;
                    }
                    catch (RuntimeException runtimeException) {
                        BasePendingResult.zzd(result);
                        throw runtimeException;
                    }
                }
                case 2: {
                    ((BasePendingResult)message.obj).zzv(Status.zzfnl);
                    return;
                }
            }
            int n = message.what;
            Log.wtf((String)"BasePendingResult", (String)new StringBuilder(45).append("Don't know how to handle message: ").append(n).toString(), (Throwable)new Exception());
        }
    }
}

