/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.content.Context;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.BasePendingResult;
import com.google.android.gms.common.api.internal.zzac;
import com.google.android.gms.common.api.internal.zzad;
import com.google.android.gms.common.api.internal.zzba;
import com.google.android.gms.common.api.internal.zzbm;
import com.google.android.gms.common.api.internal.zzcc;
import com.google.android.gms.common.api.internal.zzcu;
import com.google.android.gms.common.api.internal.zzdm;
import com.google.android.gms.common.api.internal.zzh;
import com.google.android.gms.common.api.internal.zzm;
import com.google.android.gms.common.api.internal.zzt;
import com.google.android.gms.common.api.internal.zzz;
import com.google.android.gms.common.internal.zzr;
import com.google.android.gms.common.zzf;
import com.google.android.gms.internal.zzbha;
import com.google.android.gms.internal.zzcxd;
import com.google.android.gms.internal.zzcxe;
import com.google.android.gms.tasks.OnCompleteListener;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;

public final class zzaa
implements zzcc {
    private final Map<Api.zzc<?>, zzz<?>> zzfpy = new HashMap();
    private final Map<Api.zzc<?>, zzz<?>> zzfpz = new HashMap();
    private final Map<Api<?>, Boolean> zzfqa;
    private final zzbm zzfmi;
    private final zzba zzfqb;
    private final Lock zzfps;
    private final Looper zzall;
    private final zzf zzfqc;
    private final Condition zzfqd;
    private final zzr zzfpx;
    private final boolean zzfqe;
    private final boolean zzfqf;
    private final Queue<zzm<?, ?>> zzfqg = new LinkedList();
    private boolean zzfqh;
    private Map<zzh<?>, ConnectionResult> zzfqi;
    private Map<zzh<?>, ConnectionResult> zzfqj;
    private zzad zzfqk;
    private ConnectionResult zzfql;

    public zzaa(Context context, Lock lock, Looper looper, zzf zzf2, Map<Api.zzc<?>, Api.zze> map, zzr zzr2, Map<Api<?>, Boolean> map2, Api.zza<? extends zzcxd, zzcxe> zza2, ArrayList<zzt> arrayList, zzba zzba2, boolean bl) {
        this.zzfps = lock;
        this.zzall = looper;
        this.zzfqd = lock.newCondition();
        this.zzfqc = zzf2;
        this.zzfqb = zzba2;
        this.zzfqa = map2;
        this.zzfpx = zzr2;
        this.zzfqe = bl;
        HashMap hashMap = new HashMap();
        for (Api<?> api : map2.keySet()) {
            hashMap.put(api.zzagf(), api);
        }
        HashMap hashMap2 = new HashMap();
        ArrayList<zzt> arrayList2 = arrayList;
        int n = arrayList2.size();
        for (int i = 0; i < n; ++i) {
            zzt zzt2 = arrayList2.get(i);
            zzt zzt3 = zzt2;
            hashMap2.put(zzt3.zzfin, zzt3);
        }
        boolean bl2 = false;
        boolean bl3 = true;
        boolean bl4 = false;
        for (Map.Entry<Api.zzc<?>, Api.zze> entry : map.entrySet()) {
            Api api = (Api)hashMap.get(entry.getKey());
            Api.zze zze2 = entry.getValue();
            if (zze2.zzagg()) {
                bl4 = true;
                if (!this.zzfqa.get(api).booleanValue()) {
                    bl2 = true;
                }
            } else {
                bl3 = false;
            }
            zzt zzt4 = (zzt)hashMap2.get(api);
            zzz zzz2 = new zzz(context, api, looper, zze2, zzt4, zzr2, zza2);
            this.zzfpy.put(entry.getKey(), zzz2);
            if (!zze2.zzaay()) continue;
            this.zzfpz.put(entry.getKey(), zzz2);
        }
        this.zzfqf = bl4 && !bl3 && !bl2;
        this.zzfmi = zzbm.zzaiq();
    }

    @Override
    public final <A extends Api.zzb, R extends Result, T extends zzm<R, A>> T zzd(@NonNull T t) {
        if (this.zzfqe && this.zzg(t)) {
            return t;
        }
        if (!this.isConnected()) {
            this.zzfqg.add(t);
            return t;
        }
        this.zzfqb.zzfsh.zzb(t);
        return this.zzfpy.get(t.zzagf()).zza(t);
    }

    @Override
    public final <A extends Api.zzb, T extends zzm<? extends Result, A>> T zze(@NonNull T t) {
        Api.zzc<A> zzc2 = t.zzagf();
        if (this.zzfqe && this.zzg(t)) {
            return t;
        }
        this.zzfqb.zzfsh.zzb(t);
        return this.zzfpy.get(zzc2).zzb(t);
    }

    private final <T extends zzm<? extends Result, ? extends Api.zzb>> boolean zzg(@NonNull T t) {
        Api.zzc<? extends Api.zzb> zzc2 = t.zzagf();
        ConnectionResult connectionResult = this.zzb(zzc2);
        if (connectionResult != null && connectionResult.getErrorCode() == 4) {
            t.zzu(new Status(4, null, this.zzfmi.zza(this.zzfpy.get(zzc2).zzagn(), System.identityHashCode(this.zzfqb))));
            return true;
        }
        return false;
    }

    @Override
    public final void connect() {
        this.zzfps.lock();
        try {
            if (this.zzfqh) {
                return;
            }
            this.zzfqh = true;
            this.zzfqi = null;
            this.zzfqj = null;
            this.zzfqk = null;
            this.zzfql = null;
            this.zzfmi.zzagz();
            this.zzfmi.zza(this.zzfpy.values()).addOnCompleteListener((Executor)new zzbha(this.zzall), (OnCompleteListener)new zzac(this, null));
            return;
        }
        finally {
            this.zzfps.unlock();
        }
    }

    @Override
    public final ConnectionResult blockingConnect() {
        this.connect();
        while (this.isConnecting()) {
            try {
                this.zzfqd.await();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return new ConnectionResult(15, null);
            }
        }
        if (this.isConnected()) {
            return ConnectionResult.zzfkr;
        }
        if (this.zzfql != null) {
            return this.zzfql;
        }
        return new ConnectionResult(13, null);
    }

    @Override
    public final ConnectionResult blockingConnect(long l, TimeUnit timeUnit) {
        this.connect();
        long l2 = timeUnit.toNanos(l);
        while (this.isConnecting()) {
            try {
                if (l2 <= 0L) {
                    this.disconnect();
                    return new ConnectionResult(14, null);
                }
                l2 = this.zzfqd.awaitNanos(l2);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return new ConnectionResult(15, null);
            }
        }
        if (this.isConnected()) {
            return ConnectionResult.zzfkr;
        }
        if (this.zzfql != null) {
            return this.zzfql;
        }
        return new ConnectionResult(13, null);
    }

    @Override
    public final void disconnect() {
        this.zzfps.lock();
        try {
            this.zzfqh = false;
            this.zzfqi = null;
            this.zzfqj = null;
            if (this.zzfqk != null) {
                this.zzfqk.cancel();
                this.zzfqk = null;
            }
            this.zzfql = null;
            while (!this.zzfqg.isEmpty()) {
                zzm<?, ?> zzm2 = this.zzfqg.remove();
                ((BasePendingResult)zzm2).zza((zzdm)null);
                ((PendingResult)zzm2).cancel();
            }
            this.zzfqd.signalAll();
            return;
        }
        finally {
            this.zzfps.unlock();
        }
    }

    @Override
    @Nullable
    public final ConnectionResult getConnectionResult(@NonNull Api<?> api) {
        return this.zzb(api.zzagf());
    }

    @Nullable
    private final ConnectionResult zzb(@NonNull Api.zzc<?> zzc2) {
        this.zzfps.lock();
        try {
            zzz<?> zzz2 = this.zzfpy.get(zzc2);
            if (this.zzfqi != null && zzz2 != null) {
                ConnectionResult connectionResult = this.zzfqi.get(zzz2.zzagn());
                return connectionResult;
            }
            return null;
        }
        finally {
            this.zzfps.unlock();
        }
    }

    @Override
    public final boolean isConnected() {
        this.zzfps.lock();
        try {
            boolean bl = this.zzfqi != null && this.zzfql == null;
            return bl;
        }
        finally {
            this.zzfps.unlock();
        }
    }

    @Override
    public final boolean isConnecting() {
        this.zzfps.lock();
        try {
            boolean bl = this.zzfqi == null && this.zzfqh;
            return bl;
        }
        finally {
            this.zzfps.unlock();
        }
    }

    private final boolean zzahq() {
        this.zzfps.lock();
        try {
            if (!this.zzfqh || !this.zzfqe) {
                return false;
            }
            for (Api.zzc<?> zzc2 : this.zzfpz.keySet()) {
                ConnectionResult connectionResult = this.zzb(zzc2);
                if (connectionResult != null && connectionResult.isSuccess()) continue;
                return false;
            }
            return true;
        }
        finally {
            this.zzfps.unlock();
        }
    }

    @Override
    public final boolean zza(zzcu zzcu2) {
        this.zzfps.lock();
        try {
            if (this.zzfqh && !this.zzahq()) {
                this.zzfmi.zzagz();
                this.zzfqk = new zzad(this, zzcu2);
                this.zzfmi.zza(this.zzfpz.values()).addOnCompleteListener((Executor)new zzbha(this.zzall), (OnCompleteListener)this.zzfqk);
                return true;
            }
            return false;
        }
        finally {
            this.zzfps.unlock();
        }
    }

    @Override
    public final void zzags() {
        this.zzfps.lock();
        try {
            this.zzfmi.zzags();
            if (this.zzfqk != null) {
                this.zzfqk.cancel();
                this.zzfqk = null;
            }
            if (this.zzfqj == null) {
                this.zzfqj = new ArrayMap(this.zzfpz.size());
            }
            ConnectionResult connectionResult = new ConnectionResult(4);
            for (zzz<?> zzz2 : this.zzfpz.values()) {
                this.zzfqj.put(zzz2.zzagn(), connectionResult);
            }
            if (this.zzfqi != null) {
                this.zzfqi.putAll(this.zzfqj);
            }
            return;
        }
        finally {
            this.zzfps.unlock();
        }
    }

    @Override
    public final void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
    }

    @Override
    public final void zzahk() {
    }

    private final void zzahr() {
        if (this.zzfpx == null) {
            this.zzfqb.zzfsc = Collections.emptySet();
            return;
        }
        HashSet<Scope> hashSet = new HashSet<Scope>(this.zzfpx.zzakv());
        Map<Api<?>, com.google.android.gms.common.internal.zzt> map = this.zzfpx.zzakx();
        for (Api<?> api : map.keySet()) {
            ConnectionResult connectionResult = this.getConnectionResult(api);
            if (connectionResult == null || !connectionResult.isSuccess()) continue;
            hashSet.addAll(map.get(api).zzehs);
        }
        this.zzfqb.zzfsc = hashSet;
    }

    private final void zzahs() {
        while (!this.zzfqg.isEmpty()) {
            this.zze(this.zzfqg.remove());
        }
        this.zzfqb.zzj(null);
    }

    private final boolean zza(zzz<?> zzz2, ConnectionResult connectionResult) {
        return !connectionResult.isSuccess() && !connectionResult.hasResolution() && this.zzfqa.get(zzz2.zzagl()) != false && zzz2.zzahp().zzagg() && this.zzfqc.isUserResolvableError(connectionResult.getErrorCode());
    }

    @Nullable
    private final ConnectionResult zzaht() {
        ConnectionResult connectionResult = null;
        int n = 0;
        ConnectionResult connectionResult2 = null;
        int n2 = 0;
        for (zzz<?> zzz2 : this.zzfpy.values()) {
            int n3;
            Api api = zzz2.zzagl();
            zzh zzh2 = zzz2.zzagn();
            ConnectionResult connectionResult3 = this.zzfqi.get(zzh2);
            if (connectionResult3.isSuccess() || this.zzfqa.get(api).booleanValue() && !connectionResult3.hasResolution() && !this.zzfqc.isUserResolvableError(connectionResult3.getErrorCode())) continue;
            if (connectionResult3.getErrorCode() == 4 && this.zzfqe) {
                n3 = api.zzagd().getPriority();
                if (connectionResult2 != null && n2 <= n3) continue;
                connectionResult2 = connectionResult3;
                n2 = n3;
                continue;
            }
            n3 = api.zzagd().getPriority();
            if (connectionResult != null && n <= n3) continue;
            connectionResult = connectionResult3;
            n = n3;
        }
        if (connectionResult != null && connectionResult2 != null && n > n2) {
            return connectionResult2;
        }
        return connectionResult;
    }

    static /* synthetic */ Lock zza(zzaa zzaa2) {
        return zzaa2.zzfps;
    }

    static /* synthetic */ boolean zzb(zzaa zzaa2) {
        return zzaa2.zzfqh;
    }

    static /* synthetic */ Map zza(zzaa zzaa2, Map map) {
        zzaa2.zzfqi = map;
        return zzaa2.zzfqi;
    }

    static /* synthetic */ Map zzc(zzaa zzaa2) {
        return zzaa2.zzfpy;
    }

    static /* synthetic */ Map zzd(zzaa zzaa2) {
        return zzaa2.zzfqi;
    }

    static /* synthetic */ boolean zze(zzaa zzaa2) {
        return zzaa2.zzfqf;
    }

    static /* synthetic */ boolean zza(zzaa zzaa2, zzz zzz2, ConnectionResult connectionResult) {
        return zzaa2.zza(zzz2, connectionResult);
    }

    static /* synthetic */ ConnectionResult zza(zzaa zzaa2, ConnectionResult connectionResult) {
        zzaa2.zzfql = connectionResult;
        return zzaa2.zzfql;
    }

    static /* synthetic */ ConnectionResult zzf(zzaa zzaa2) {
        return zzaa2.zzaht();
    }

    static /* synthetic */ Map zzg(zzaa zzaa2) {
        return zzaa2.zzfqj;
    }

    static /* synthetic */ ConnectionResult zzh(zzaa zzaa2) {
        return zzaa2.zzfql;
    }

    static /* synthetic */ void zzi(zzaa zzaa2) {
        zzaa2.zzahr();
    }

    static /* synthetic */ void zzj(zzaa zzaa2) {
        zzaa2.zzahs();
    }

    static /* synthetic */ boolean zza(zzaa zzaa2, boolean bl) {
        zzaa2.zzfqh = false;
        return false;
    }

    static /* synthetic */ zzba zzk(zzaa zzaa2) {
        return zzaa2.zzfqb;
    }

    static /* synthetic */ Condition zzl(zzaa zzaa2) {
        return zzaa2.zzfqd;
    }

    static /* synthetic */ Map zzb(zzaa zzaa2, Map map) {
        zzaa2.zzfqj = map;
        return zzaa2.zzfqj;
    }

    static /* synthetic */ Map zzm(zzaa zzaa2) {
        return zzaa2.zzfpz;
    }
}

