/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zzba;
import com.google.android.gms.common.api.internal.zzbi;
import com.google.android.gms.common.api.internal.zzcc;
import com.google.android.gms.common.api.internal.zzcu;
import com.google.android.gms.common.api.internal.zzm;
import com.google.android.gms.common.api.internal.zzt;
import com.google.android.gms.common.api.internal.zzw;
import com.google.android.gms.common.api.internal.zzx;
import com.google.android.gms.common.api.internal.zzy;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.internal.zzr;
import com.google.android.gms.common.zzf;
import com.google.android.gms.internal.zzcxd;
import com.google.android.gms.internal.zzcxe;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;

final class zzv
implements zzcc {
    private final Context mContext;
    private final zzba zzfpi;
    private final Looper zzall;
    private final zzbi zzfpj;
    private final zzbi zzfpk;
    private final Map<Api.zzc<?>, zzbi> zzfpl;
    private final Set<zzcu> zzfpm = Collections.newSetFromMap(new WeakHashMap());
    private final Api.zze zzfpn;
    private Bundle zzfpo;
    private ConnectionResult zzfpp = null;
    private ConnectionResult zzfpq = null;
    private boolean zzfpr = false;
    private final Lock zzfps;
    private int zzfpt = 0;

    public static zzv zza(Context context, zzba zzba2, Lock lock, Looper looper, zzf zzf2, Map<Api.zzc<?>, Api.zze> map, zzr zzr2, Map<Api<?>, Boolean> map2, Api.zza<? extends zzcxd, zzcxe> zza2, ArrayList<zzt> arrayList) {
        Object object;
        Api.zze zze2 = null;
        ArrayMap arrayMap2 = new ArrayMap();
        ArrayMap arrayMap3 = new ArrayMap();
        for (Map.Entry<Api.zzc<?>, Api.zze> arrayMap4 : map.entrySet()) {
            object = arrayMap4.getValue();
            if (object.zzabj()) {
                zze2 = object;
            }
            if (object.zzaay()) {
                arrayMap2.put(arrayMap4.getKey(), object);
                continue;
            }
            arrayMap3.put(arrayMap4.getKey(), object);
        }
        zzbq.zza((!arrayMap2.isEmpty() ? 1 : 0) != 0, (Object)"CompositeGoogleApiClient should not be used without any APIs that require sign-in.");
        ArrayMap arrayMap5 = new ArrayMap();
        ArrayMap arrayMap = new ArrayMap();
        for (Api api : map2.keySet()) {
            Api.zzc<?> zzc2 = api.zzagf();
            if (arrayMap2.containsKey(zzc2)) {
                arrayMap5.put(api, map2.get(api));
                continue;
            }
            if (arrayMap3.containsKey(zzc2)) {
                arrayMap.put(api, map2.get(api));
                continue;
            }
            throw new IllegalStateException("Each API in the isOptionalMap must have a corresponding client in the clients map.");
        }
        object = new ArrayList<zzt>();
        ArrayList<zzt> arrayList2 = new ArrayList<zzt>();
        ArrayList<zzt> arrayList3 = arrayList;
        int n = arrayList3.size();
        for (int i = 0; i < n; ++i) {
            zzt zzt2 = arrayList3.get(i);
            zzt zzt3 = zzt2;
            if (arrayMap5.containsKey(zzt3.zzfin)) {
                ((ArrayList)object).add(zzt3);
                continue;
            }
            if (arrayMap.containsKey(zzt3.zzfin)) {
                arrayList2.add(zzt3);
                continue;
            }
            throw new IllegalStateException("Each ClientCallbacks must have a corresponding API in the isOptionalMap");
        }
        return new zzv(context, zzba2, lock, looper, zzf2, (Map<Api.zzc<?>, Api.zze>)arrayMap2, (Map<Api.zzc<?>, Api.zze>)arrayMap3, zzr2, zza2, zze2, (ArrayList<zzt>)object, arrayList2, (Map<Api<?>, Boolean>)arrayMap5, (Map<Api<?>, Boolean>)arrayMap);
    }

    private zzv(Context context, zzba zzba2, Lock lock, Looper looper, zzf zzf2, Map<Api.zzc<?>, Api.zze> map, Map<Api.zzc<?>, Api.zze> map2, zzr zzr2, Api.zza<? extends zzcxd, zzcxe> zza2, Api.zze zze2, ArrayList<zzt> arrayList, ArrayList<zzt> arrayList2, Map<Api<?>, Boolean> map3, Map<Api<?>, Boolean> map4) {
        this.mContext = context;
        this.zzfpi = zzba2;
        this.zzfps = lock;
        this.zzall = looper;
        this.zzfpn = zze2;
        this.zzfpj = new zzbi(context, this.zzfpi, lock, looper, zzf2, map2, null, map4, null, arrayList2, new zzx(this, null));
        this.zzfpk = new zzbi(context, this.zzfpi, lock, looper, zzf2, map, zzr2, map3, zza2, arrayList, new zzy(this, null));
        ArrayMap arrayMap = new ArrayMap();
        for (Api.zzc<?> zzc2 : map2.keySet()) {
            arrayMap.put(zzc2, (Object)this.zzfpj);
        }
        for (Api.zzc<?> zzc2 : map.keySet()) {
            arrayMap.put(zzc2, (Object)this.zzfpk);
        }
        this.zzfpl = Collections.unmodifiableMap(arrayMap);
    }

    @Override
    public final <A extends Api.zzb, R extends Result, T extends zzm<R, A>> T zzd(@NonNull T t) {
        if (this.zzf(t)) {
            if (this.zzahn()) {
                t.zzu(new Status(4, null, this.zzaho()));
                return t;
            }
            return this.zzfpk.zzd(t);
        }
        return this.zzfpj.zzd(t);
    }

    @Override
    public final <A extends Api.zzb, T extends zzm<? extends Result, A>> T zze(@NonNull T t) {
        if (this.zzf(t)) {
            if (this.zzahn()) {
                t.zzu(new Status(4, null, this.zzaho()));
                return t;
            }
            return this.zzfpk.zze(t);
        }
        return this.zzfpj.zze(t);
    }

    @Override
    @Nullable
    public final ConnectionResult getConnectionResult(@NonNull Api<?> api) {
        if (this.zzfpl.get(api.zzagf()).equals(this.zzfpk)) {
            if (this.zzahn()) {
                return new ConnectionResult(4, this.zzaho());
            }
            return this.zzfpk.getConnectionResult(api);
        }
        return this.zzfpj.getConnectionResult(api);
    }

    @Override
    public final void connect() {
        this.zzfpt = 2;
        this.zzfpr = false;
        zzv zzv2 = this;
        this.zzfpq = null;
        zzv2.zzfpp = null;
        zzv2.zzfpj.connect();
        zzv2.zzfpk.connect();
    }

    @Override
    public final ConnectionResult blockingConnect() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final ConnectionResult blockingConnect(long l, @NonNull TimeUnit timeUnit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void disconnect() {
        this.zzfpq = null;
        this.zzfpp = null;
        this.zzfpt = 0;
        this.zzfpj.disconnect();
        this.zzfpk.disconnect();
        this.zzahm();
    }

    @Override
    public final boolean isConnected() {
        this.zzfps.lock();
        try {
            boolean bl = this.zzfpj.isConnected() && (this.zzfpk.isConnected() || this.zzahn() || this.zzfpt == 1);
            return bl;
        }
        finally {
            this.zzfps.unlock();
        }
    }

    @Override
    public final boolean isConnecting() {
        this.zzfps.lock();
        try {
            boolean bl = this.zzfpt == 2;
            return bl;
        }
        finally {
            this.zzfps.unlock();
        }
    }

    @Override
    public final boolean zza(zzcu zzcu2) {
        this.zzfps.lock();
        try {
            if ((this.isConnecting() || this.isConnected()) && !this.zzfpk.isConnected()) {
                this.zzfpm.add(zzcu2);
                if (this.zzfpt == 0) {
                    this.zzfpt = 1;
                }
                this.zzfpq = null;
                this.zzfpk.connect();
                return true;
            }
        }
        finally {
            this.zzfps.unlock();
        }
        return false;
    }

    @Override
    public final void zzahk() {
        this.zzfpj.zzahk();
        this.zzfpk.zzahk();
    }

    @Override
    public final void zzags() {
        this.zzfps.lock();
        try {
            boolean bl = this.isConnecting();
            this.zzfpk.disconnect();
            this.zzfpq = new ConnectionResult(4);
            if (bl) {
                new Handler(this.zzall).post((Runnable)new zzw(this));
            } else {
                this.zzahm();
            }
            return;
        }
        finally {
            this.zzfps.unlock();
        }
    }

    private final void zzahl() {
        if (zzv.zzb(this.zzfpp)) {
            if (zzv.zzb(this.zzfpq) || this.zzahn()) {
                zzv zzv2 = this;
                switch (zzv2.zzfpt) {
                    case 2: {
                        zzv2.zzfpi.zzj(zzv2.zzfpo);
                    }
                    case 1: {
                        zzv2.zzahm();
                        break;
                    }
                    default: {
                        Log.wtf((String)"CompositeGAC", (String)"Attempted to call success callbacks in CONNECTION_MODE_NONE. Callbacks should be disabled via GmsClientSupervisor", (Throwable)((Object)new AssertionError()));
                    }
                }
                zzv2.zzfpt = 0;
                return;
            }
            if (this.zzfpq != null) {
                if (this.zzfpt == 1) {
                    this.zzahm();
                    return;
                }
                this.zza(this.zzfpq);
                this.zzfpj.disconnect();
                return;
            }
        } else {
            if (this.zzfpp != null && zzv.zzb(this.zzfpq)) {
                this.zzfpk.disconnect();
                this.zza(this.zzfpp);
                return;
            }
            if (this.zzfpp != null && this.zzfpq != null) {
                ConnectionResult connectionResult = this.zzfpp;
                if (this.zzfpk.zzfst < this.zzfpj.zzfst) {
                    connectionResult = this.zzfpq;
                }
                this.zza(connectionResult);
            }
        }
    }

    private final void zza(ConnectionResult connectionResult) {
        switch (this.zzfpt) {
            case 2: {
                this.zzfpi.zzc(connectionResult);
            }
            case 1: {
                this.zzahm();
                break;
            }
            default: {
                Log.wtf((String)"CompositeGAC", (String)"Attempted to call failure callbacks in CONNECTION_MODE_NONE. Callbacks should be disabled via GmsClientSupervisor", (Throwable)new Exception());
            }
        }
        this.zzfpt = 0;
    }

    private final void zzahm() {
        Iterator<zzcu> iterator = this.zzfpm.iterator();
        while (iterator.hasNext()) {
            iterator.next().zzabi();
        }
        this.zzfpm.clear();
    }

    private final void zze(int n, boolean bl) {
        this.zzfpi.zzf(n, bl);
        this.zzfpq = null;
        this.zzfpp = null;
    }

    private final boolean zzahn() {
        return this.zzfpq != null && this.zzfpq.getErrorCode() == 4;
    }

    private final boolean zzf(zzm<? extends Result, ? extends Api.zzb> zzm2) {
        Api.zzc<? extends Api.zzb> zzc2 = zzm2.zzagf();
        zzbq.checkArgument((boolean)this.zzfpl.containsKey(zzc2), (Object)"GoogleApiClient is not configured to use the API required for this call.");
        return this.zzfpl.get(zzc2).equals(this.zzfpk);
    }

    @Nullable
    private final PendingIntent zzaho() {
        if (this.zzfpn == null) {
            return null;
        }
        return PendingIntent.getActivity((Context)this.mContext, (int)System.identityHashCode(this.zzfpi), (Intent)this.zzfpn.getSignInIntent(), (int)0x8000000);
    }

    private final void zzi(Bundle bundle) {
        if (this.zzfpo == null) {
            this.zzfpo = bundle;
            return;
        }
        if (bundle != null) {
            this.zzfpo.putAll(bundle);
        }
    }

    private static boolean zzb(ConnectionResult connectionResult) {
        return connectionResult != null && connectionResult.isSuccess();
    }

    @Override
    public final void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        printWriter.append(string2).append("authClient").println(":");
        this.zzfpk.dump(String.valueOf(string2).concat("  "), fileDescriptor, printWriter, stringArray);
        printWriter.append(string2).append("anonClient").println(":");
        this.zzfpj.dump(String.valueOf(string2).concat("  "), fileDescriptor, printWriter, stringArray);
    }

    static /* synthetic */ Lock zza(zzv zzv2) {
        return zzv2.zzfps;
    }

    static /* synthetic */ void zzb(zzv zzv2) {
        zzv2.zzahl();
    }

    static /* synthetic */ void zza(zzv zzv2, Bundle bundle) {
        zzv2.zzi(bundle);
    }

    static /* synthetic */ ConnectionResult zza(zzv zzv2, ConnectionResult connectionResult) {
        zzv2.zzfpp = connectionResult;
        return zzv2.zzfpp;
    }

    static /* synthetic */ boolean zzc(zzv zzv2) {
        return zzv2.zzfpr;
    }

    static /* synthetic */ ConnectionResult zzd(zzv zzv2) {
        return zzv2.zzfpq;
    }

    static /* synthetic */ boolean zza(zzv zzv2, boolean bl) {
        zzv2.zzfpr = bl;
        return zzv2.zzfpr;
    }

    static /* synthetic */ void zza(zzv zzv2, int n, boolean bl) {
        zzv2.zze(n, bl);
    }

    static /* synthetic */ zzbi zze(zzv zzv2) {
        return zzv2.zzfpk;
    }

    static /* synthetic */ ConnectionResult zzb(zzv zzv2, ConnectionResult connectionResult) {
        zzv2.zzfpq = connectionResult;
        return zzv2.zzfpq;
    }

    static /* synthetic */ zzbi zzf(zzv zzv2) {
        return zzv2.zzfpj;
    }
}

