/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.accounts.Account;
import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.internal.zzah;
import com.google.android.gms.common.api.internal.zzbm;
import com.google.android.gms.common.api.internal.zzbo;
import com.google.android.gms.common.api.internal.zzbw;
import com.google.android.gms.common.api.internal.zzci;
import com.google.android.gms.common.api.internal.zzck;
import com.google.android.gms.common.api.internal.zzcm;
import com.google.android.gms.common.api.internal.zzcq;
import com.google.android.gms.common.api.internal.zzcv;
import com.google.android.gms.common.api.internal.zzda;
import com.google.android.gms.common.api.internal.zzde;
import com.google.android.gms.common.api.internal.zzdo;
import com.google.android.gms.common.api.internal.zzg;
import com.google.android.gms.common.api.internal.zzh;
import com.google.android.gms.common.api.internal.zzm;
import com.google.android.gms.common.api.zzc;
import com.google.android.gms.common.api.zzd;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.internal.zzr;
import com.google.android.gms.common.internal.zzs;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import java.util.Collections;

public class GoogleApi<O extends Api.ApiOptions> {
    private final Context zzb;
    private final Api<O> zzc;
    private final O zzd;
    private final zzh<O> zze;
    private final Looper zzf;
    private final int zzg;
    private final GoogleApiClient zzh;
    private final zzda zzi;
    @Hide
    protected final zzbm zza;

    @Hide
    protected GoogleApi(@NonNull Context context, Api<O> api, Looper looper) {
        zzbq.zza((Object)context, (Object)"Null context is not permitted.");
        zzbq.zza(api, (Object)"Api must not be null.");
        zzbq.zza((Object)looper, (Object)"Looper must not be null.");
        this.zzb = context.getApplicationContext();
        this.zzc = api;
        this.zzd = null;
        this.zzf = looper;
        this.zze = com.google.android.gms.common.api.internal.zzh.zza(api);
        this.zzh = new zzbw(this);
        this.zza = zzbm.zza(this.zzb);
        this.zzg = this.zza.zzc();
        this.zzi = new zzg();
    }

    @Deprecated
    @Hide
    public GoogleApi(@NonNull Context context, Api<O> api, O o, Looper looper, zzda zzda2) {
        this(context, api, null, new zzd().zza(looper).zza(zzda2).zza());
    }

    @Hide
    @MainThread
    public GoogleApi(@NonNull Activity activity, Api<O> api, O o, zza zza2) {
        zzbq.zza((Object)activity, (Object)"Null activity is not permitted.");
        zzbq.zza(api, (Object)"Api must not be null.");
        zzbq.zza((Object)zza2, (Object)"Settings must not be null; use Settings.DEFAULT_SETTINGS instead.");
        this.zzb = activity.getApplicationContext();
        this.zzc = api;
        this.zzd = o;
        this.zzf = zza2.zzc;
        this.zze = com.google.android.gms.common.api.internal.zzh.zza(this.zzc, this.zzd);
        this.zzh = new zzbw(this);
        this.zza = zzbm.zza(this.zzb);
        this.zzg = this.zza.zzc();
        this.zzi = zza2.zzb;
        zzah.zza(activity, this.zza, this.zze);
        this.zza.zza(this);
    }

    @Hide
    public GoogleApi(@NonNull Context context, Api<O> api, O o, zza zza2) {
        zzbq.zza((Object)context, (Object)"Null context is not permitted.");
        zzbq.zza(api, (Object)"Api must not be null.");
        zzbq.zza((Object)zza2, (Object)"Settings must not be null; use Settings.DEFAULT_SETTINGS instead.");
        this.zzb = context.getApplicationContext();
        this.zzc = api;
        this.zzd = o;
        this.zzf = zza2.zzc;
        this.zze = com.google.android.gms.common.api.internal.zzh.zza(this.zzc, this.zzd);
        this.zzh = new zzbw(this);
        this.zza = zzbm.zza(this.zzb);
        this.zzg = this.zza.zzc();
        this.zzi = zza2.zzb;
        this.zza.zza(this);
    }

    @Deprecated
    @Hide
    public GoogleApi(@NonNull Activity activity, Api<O> api, O o, zzda zzda2) {
        this(activity, api, o, new zzd().zza(zzda2).zza(activity.getMainLooper()).zza());
    }

    @Deprecated
    @Hide
    public GoogleApi(@NonNull Context context, Api<O> api, O o, zzda zzda2) {
        this(context, api, o, new zzd().zza(zzda2).zza());
    }

    private final <A extends Api.zzb, T extends zzm<? extends Result, A>> T zza(int n, @NonNull T t) {
        t.zzg();
        this.zza.zza(this, n, t);
        return t;
    }

    private final <TResult, A extends Api.zzb> Task<TResult> zza(int n, @NonNull zzde<A, TResult> zzde2) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        this.zza.zza(this, n, zzde2, taskCompletionSource, this.zzi);
        return taskCompletionSource.getTask();
    }

    @Hide
    public final <A extends Api.zzb, T extends zzm<? extends Result, A>> T zza(@NonNull T t) {
        return this.zza(0, t);
    }

    @Hide
    public final <TResult, A extends Api.zzb> Task<TResult> zza(zzde<A, TResult> zzde2) {
        return this.zza(false, (zzdo)((Object)zzde2));
    }

    @Hide
    public final <A extends Api.zzb, T extends zzm<? extends Result, A>> T zzb(@NonNull T t) {
        return this.zza(1, t);
    }

    @Hide
    public final <TResult, A extends Api.zzb> Task<TResult> zzb(zzde<A, TResult> zzde2) {
        return this.zza(true, (zzdo)((Object)zzde2));
    }

    @Hide
    public final <A extends Api.zzb, T extends zzm<? extends Result, A>> T zzc(@NonNull T t) {
        return this.zza(2, t);
    }

    @Hide
    public final <A extends Api.zzb, T extends zzcq<A, ?>, U extends zzdo<A, ?>> Task<Void> zza(@NonNull T t, U u) {
        zzbq.zza(t);
        zzbq.zza(u);
        zzbq.zza(t.zza(), (Object)"Listener has already been released.");
        zzbq.zza(u.zza(), (Object)"Listener has already been released.");
        zzbq.zzb((boolean)t.zza().equals(u.zza()), (Object)"Listener registration and unregistration methods must be constructed with the same ListenerHolder.");
        return this.zza.zza(this, t, u);
    }

    @Hide
    public final Task<Boolean> zza(@NonNull zzck<?> zzck2) {
        zzbq.zza(zzck2, (Object)"Listener key cannot be null.");
        return this.zza.zza(this, zzck2);
    }

    @Hide
    public final <L> zzci<L> zza(@NonNull L l, String string2) {
        return zzcm.zzb(l, this.zzf, string2);
    }

    @Hide
    @WorkerThread
    public Api.zze zza(Looper looper, zzbo<O> zzbo2) {
        zzr zzr2 = this.zzh().zza(this.zzb.getPackageName()).zzb(this.zzb.getClass().getName()).zza();
        return this.zzc.zzb().zza(this.zzb, looper, zzr2, this.zzd, zzbo2, zzbo2);
    }

    @Hide
    public final Api<O> zza() {
        return this.zzc;
    }

    @Hide
    public final O zzb() {
        return this.zzd;
    }

    @Hide
    public final zzh<O> zzc() {
        return this.zze;
    }

    @Hide
    public final int zzd() {
        return this.zzg;
    }

    @Hide
    public final GoogleApiClient zze() {
        return this.zzh;
    }

    @Hide
    public final Looper zzf() {
        return this.zzf;
    }

    @Hide
    public final Context zzg() {
        return this.zzb;
    }

    @Hide
    private final zzs zzh() {
        GoogleSignInAccount googleSignInAccount;
        GoogleApi googleApi = this;
        Account account = googleApi.zzd instanceof Api.ApiOptions.HasGoogleSignInAccountOptions && (googleSignInAccount = ((Api.ApiOptions.HasGoogleSignInAccountOptions)googleApi.zzd).getGoogleSignInAccount()) != null ? googleSignInAccount.getAccount() : (googleApi.zzd instanceof Api.ApiOptions.HasAccountOptions ? ((Api.ApiOptions.HasAccountOptions)googleApi.zzd).getAccount() : null);
        googleApi = this;
        return new zzs().zza(account).zza(googleApi.zzd instanceof Api.ApiOptions.HasGoogleSignInAccountOptions && (googleSignInAccount = ((Api.ApiOptions.HasGoogleSignInAccountOptions)googleApi.zzd).getGoogleSignInAccount()) != null ? googleSignInAccount.zzd() : Collections.emptySet());
    }

    @Hide
    public zzcv zza(Context context, Handler handler) {
        return new zzcv(context, handler, this.zzh().zza());
    }

    @Hide
    public static final class zza {
        public static final zza zza = new zzd().zza();
        public final zzda zzb;
        public final Looper zzc;

        private zza(zzda zzda2, Account account, Looper looper) {
            this.zzb = zzda2;
            this.zzc = looper;
        }

        /* synthetic */ zza(zzda zzda2, Account account, Looper looper, zzc zzc2) {
            this(zzda2, null, looper);
        }
    }
}

