/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.accounts.Account;
import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.FragmentActivity;
import android.support.v4.util.ArrayMap;
import android.view.View;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zzba;
import com.google.android.gms.common.api.internal.zzce;
import com.google.android.gms.common.api.internal.zzci;
import com.google.android.gms.common.api.internal.zzcu;
import com.google.android.gms.common.api.internal.zzdh;
import com.google.android.gms.common.api.internal.zzi;
import com.google.android.gms.common.api.internal.zzm;
import com.google.android.gms.common.api.internal.zzt;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.internal.zzr;
import com.google.android.gms.internal.zzcyg;
import com.google.android.gms.internal.zzcyj;
import com.google.android.gms.internal.zzcyk;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

public abstract class GoogleApiClient {
    private static final Set<GoogleApiClient> zza = Collections.newSetFromMap(new WeakHashMap());
    public static final int SIGN_IN_MODE_REQUIRED = 1;
    public static final int SIGN_IN_MODE_OPTIONAL = 2;

    public GoogleApiClient() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpAll(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        Set<GoogleApiClient> set = zza;
        synchronized (set) {
            int n = 0;
            String string3 = String.valueOf(string2).concat("  ");
            for (GoogleApiClient googleApiClient : zza) {
                printWriter.append(string2).append("GoogleApiClient#").println(n++);
                googleApiClient.dump(string3, fileDescriptor, printWriter, stringArray);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Hide
    public static Set<GoogleApiClient> zza() {
        Set<GoogleApiClient> set = zza;
        synchronized (set) {
            return zza;
        }
    }

    @Hide
    public <A extends Api.zzb, R extends Result, T extends zzm<R, A>> T zza(@NonNull T t) {
        throw new UnsupportedOperationException();
    }

    @Hide
    public <A extends Api.zzb, T extends zzm<? extends Result, A>> T zzb(@NonNull T t) {
        throw new UnsupportedOperationException();
    }

    @Hide
    public <L> zzci<L> zza(@NonNull L l) {
        throw new UnsupportedOperationException();
    }

    @Hide
    @NonNull
    public <C extends Api.zze> C zza(@NonNull Api.zzc<C> zzc2) {
        throw new UnsupportedOperationException();
    }

    @Hide
    public boolean zza(@NonNull Api<?> api) {
        throw new UnsupportedOperationException();
    }

    public abstract boolean hasConnectedApi(@NonNull Api<?> var1);

    @NonNull
    public abstract ConnectionResult getConnectionResult(@NonNull Api<?> var1);

    @Hide
    public Context zzb() {
        throw new UnsupportedOperationException();
    }

    @Hide
    public Looper zzc() {
        throw new UnsupportedOperationException();
    }

    @Hide
    public boolean zza(zzcu zzcu2) {
        throw new UnsupportedOperationException();
    }

    @Hide
    public void zzd() {
        throw new UnsupportedOperationException();
    }

    public abstract void connect();

    public void connect(int n) {
        throw new UnsupportedOperationException();
    }

    public abstract ConnectionResult blockingConnect();

    public abstract ConnectionResult blockingConnect(long var1, @NonNull TimeUnit var3);

    public abstract void disconnect();

    public abstract void reconnect();

    public abstract PendingResult<Status> clearDefaultAccountAndReconnect();

    public abstract void stopAutoManage(@NonNull FragmentActivity var1);

    public abstract boolean isConnected();

    public abstract boolean isConnecting();

    public abstract void registerConnectionCallbacks(@NonNull ConnectionCallbacks var1);

    public abstract boolean isConnectionCallbacksRegistered(@NonNull ConnectionCallbacks var1);

    public abstract void unregisterConnectionCallbacks(@NonNull ConnectionCallbacks var1);

    public abstract void registerConnectionFailedListener(@NonNull OnConnectionFailedListener var1);

    public abstract boolean isConnectionFailedListenerRegistered(@NonNull OnConnectionFailedListener var1);

    public abstract void unregisterConnectionFailedListener(@NonNull OnConnectionFailedListener var1);

    public abstract void dump(String var1, FileDescriptor var2, PrintWriter var3, String[] var4);

    @Hide
    public void zza(zzdh zzdh2) {
        throw new UnsupportedOperationException();
    }

    @Hide
    public void zzb(zzdh zzdh2) {
        throw new UnsupportedOperationException();
    }

    public static final class Builder {
        private Account zza;
        private final Set<Scope> zzb = new HashSet<Scope>();
        private final Set<Scope> zzc = new HashSet<Scope>();
        private int zzd;
        private View zze;
        private String zzf;
        private String zzg;
        private final Map<Api<?>, com.google.android.gms.common.internal.zzt> zzh = new ArrayMap();
        private final Context zzi;
        private final Map<Api<?>, Api.ApiOptions> zzj = new ArrayMap();
        private zzce zzk;
        private int zzl = -1;
        private OnConnectionFailedListener zzm;
        private Looper zzn;
        private GoogleApiAvailability zzo = GoogleApiAvailability.getInstance();
        private Api.zza<? extends zzcyj, zzcyk> zzp = zzcyg.zza;
        private final ArrayList<ConnectionCallbacks> zzq = new ArrayList();
        private final ArrayList<OnConnectionFailedListener> zzr = new ArrayList();
        private boolean zzs = false;

        public Builder(@NonNull Context context) {
            this.zzi = context;
            this.zzn = context.getMainLooper();
            this.zzf = context.getPackageName();
            this.zzg = context.getClass().getName();
        }

        public Builder(@NonNull Context context, @NonNull ConnectionCallbacks connectionCallbacks, @NonNull OnConnectionFailedListener onConnectionFailedListener) {
            this(context);
            zzbq.zza((Object)connectionCallbacks, (Object)"Must provide a connected listener");
            this.zzq.add(connectionCallbacks);
            zzbq.zza((Object)onConnectionFailedListener, (Object)"Must provide a connection failed listener");
            this.zzr.add(onConnectionFailedListener);
        }

        public final Builder setHandler(@NonNull Handler handler) {
            zzbq.zza((Object)handler, (Object)"Handler must not be null");
            this.zzn = handler.getLooper();
            return this;
        }

        public final Builder addConnectionCallbacks(@NonNull ConnectionCallbacks connectionCallbacks) {
            zzbq.zza((Object)connectionCallbacks, (Object)"Listener must not be null");
            this.zzq.add(connectionCallbacks);
            return this;
        }

        public final Builder addOnConnectionFailedListener(@NonNull OnConnectionFailedListener onConnectionFailedListener) {
            zzbq.zza((Object)onConnectionFailedListener, (Object)"Listener must not be null");
            this.zzr.add(onConnectionFailedListener);
            return this;
        }

        public final Builder setViewForPopups(@NonNull View view) {
            zzbq.zza((Object)view, (Object)"View must not be null");
            this.zze = view;
            return this;
        }

        public final Builder addScope(@NonNull Scope scope) {
            zzbq.zza((Object)scope, (Object)"Scope must not be null");
            this.zzb.add(scope);
            return this;
        }

        public final Builder addApi(@NonNull Api<? extends Api.ApiOptions.NotRequiredOptions> api) {
            zzbq.zza(api, (Object)"Api must not be null");
            this.zzj.put(api, null);
            List<Scope> list = api.zza().zza(null);
            this.zzc.addAll(list);
            this.zzb.addAll(list);
            return this;
        }

        public final Builder addApiIfAvailable(@NonNull Api<? extends Api.ApiOptions.NotRequiredOptions> api, Scope ... scopeArray) {
            zzbq.zza(api, (Object)"Api must not be null");
            this.zzj.put(api, null);
            this.zza(api, null, scopeArray);
            return this;
        }

        public final <O extends Api.ApiOptions.HasOptions> Builder addApi(@NonNull Api<O> api, @NonNull O o) {
            zzbq.zza(api, (Object)"Api must not be null");
            zzbq.zza(o, (Object)"Null options are not permitted for this Api");
            this.zzj.put(api, o);
            List<Scope> list = api.zza().zza(o);
            this.zzc.addAll(list);
            this.zzb.addAll(list);
            return this;
        }

        public final <O extends Api.ApiOptions.HasOptions> Builder addApiIfAvailable(@NonNull Api<O> api, @NonNull O o, Scope ... scopeArray) {
            zzbq.zza(api, (Object)"Api must not be null");
            zzbq.zza(o, (Object)"Null options are not permitted for this Api");
            this.zzj.put(api, o);
            this.zza(api, o, scopeArray);
            return this;
        }

        public final Builder setAccountName(String string2) {
            this.zza = string2 == null ? null : new Account(string2, "com.google");
            return this;
        }

        public final Builder useDefaultAccount() {
            return this.setAccountName("<<default account>>");
        }

        public final Builder setGravityForPopups(int n) {
            this.zzd = n;
            return this;
        }

        public final Builder enableAutoManage(@NonNull FragmentActivity fragmentActivity, int n, @Nullable OnConnectionFailedListener onConnectionFailedListener) {
            OnConnectionFailedListener onConnectionFailedListener2 = onConnectionFailedListener;
            zzce zzce2 = new zzce((Activity)fragmentActivity);
            Builder builder = this;
            zzbq.zzb((n >= 0 ? 1 : 0) != 0, (Object)"clientId must be non-negative");
            builder.zzl = n;
            builder.zzm = onConnectionFailedListener2;
            builder.zzk = zzce2;
            return builder;
        }

        public final Builder enableAutoManage(@NonNull FragmentActivity fragmentActivity, @Nullable OnConnectionFailedListener onConnectionFailedListener) {
            return this.enableAutoManage(fragmentActivity, 0, onConnectionFailedListener);
        }

        @Hide
        public final zzr zza() {
            zzcyk zzcyk2 = zzcyk.zza;
            if (this.zzj.containsKey(zzcyg.zzb)) {
                zzcyk2 = (zzcyk)this.zzj.get(zzcyg.zzb);
            }
            return new zzr(this.zza, this.zzb, this.zzh, this.zzd, this.zze, this.zzf, this.zzg, zzcyk2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final GoogleApiClient build() {
            zzbq.zzb((!this.zzj.isEmpty() ? 1 : 0) != 0, (Object)"must call addApi() to add at least one API");
            Builder builder = this;
            Object object = builder.zza();
            Api<?> api = null;
            boolean bl = false;
            Map<Api<?>, com.google.android.gms.common.internal.zzt> map = ((zzr)object).zzg();
            ArrayMap arrayMap = new ArrayMap();
            ArrayMap arrayMap2 = new ArrayMap();
            ArrayList<zzt> arrayList = new ArrayList<zzt>();
            for (Api<?> api2 : builder.zzj.keySet()) {
                Api.ApiOptions apiOptions = builder.zzj.get(api2);
                boolean bl2 = map.get(api2) != null;
                arrayMap.put(api2, bl2);
                zzt zzt2 = new zzt(api2, bl2);
                arrayList.add(zzt2);
                Object object2 = api2.zzb();
                Api.zza<?, ?> zza2 = object2;
                zzt zzt3 = zzt2;
                zzt zzt4 = zzt2;
                zzr zzr2 = object;
                Looper looper = builder.zzn;
                Context context = builder.zzi;
                Api.ApiOptions apiOptions2 = apiOptions;
                Object obj = ((Api.zza)object2).zza(context, looper, zzr2, apiOptions2, zzt4, zzt3);
                arrayMap2.put(api2.zzc(), obj);
                if (zza2.zza() == 1) {
                    boolean bl3 = bl = apiOptions != null;
                }
                if (!obj.zze()) continue;
                if (api != null) {
                    object2 = api2.zzd();
                    String string2 = api.zzd();
                    throw new IllegalStateException(new StringBuilder(21 + String.valueOf(object2).length() + String.valueOf(string2).length()).append((String)object2).append(" cannot be used with ").append(string2).toString());
                }
                api = api2;
            }
            if (api != null) {
                if (bl) {
                    String string3 = api.zzd();
                    throw new IllegalStateException(new StringBuilder(82 + String.valueOf(string3).length()).append("With using ").append(string3).append(", GamesOptions can only be specified within GoogleSignInOptions.Builder").toString());
                }
                zzbq.zza((builder.zza == null ? 1 : 0) != 0, (String)"Must not set an account in GoogleApiClient.Builder when using %s. Set account in GoogleSignInOptions.Builder instead", (Object[])new Object[]{api.zzd()});
                zzbq.zza((boolean)builder.zzb.equals(builder.zzc), (String)"Must not set scopes in GoogleApiClient.Builder when using %s. Set account in GoogleSignInOptions.Builder instead.", (Object[])new Object[]{api.zzd()});
            }
            int n = zzba.zza(arrayMap2.values(), true);
            zzba zzba2 = new zzba(builder.zzi, new ReentrantLock(), builder.zzn, (zzr)object, builder.zzo, builder.zzp, (Map<Api<?>, Boolean>)arrayMap, (List<ConnectionCallbacks>)builder.zzq, (List<OnConnectionFailedListener>)builder.zzr, (Map<Api.zzc<?>, Api.zze>)arrayMap2, builder.zzl, n, arrayList, false);
            Set set = zza;
            synchronized (set) {
                zza.add(zzba2);
            }
            if (this.zzl >= 0) {
                object = zzba2;
                builder = this;
                com.google.android.gms.common.api.internal.zzi.zza(builder.zzk).zza(builder.zzl, (GoogleApiClient)object, builder.zzm);
            }
            return zzba2;
        }

        private final <O extends Api.ApiOptions> void zza(Api<O> api, O o, Scope ... scopeArray) {
            HashSet<Scope> hashSet = new HashSet<Scope>(api.zza().zza(o));
            Scope[] scopeArray2 = scopeArray;
            int n = scopeArray.length;
            for (int i = 0; i < n; ++i) {
                Scope scope = scopeArray2[i];
                hashSet.add(scope);
            }
            this.zzh.put(api, new com.google.android.gms.common.internal.zzt(hashSet));
        }
    }

    public static interface OnConnectionFailedListener {
        public void onConnectionFailed(@NonNull ConnectionResult var1);
    }

    public static interface ConnectionCallbacks {
        public static final int CAUSE_SERVICE_DISCONNECTED = 1;
        public static final int CAUSE_NETWORK_LOST = 2;

        public void onConnected(@Nullable Bundle var1);

        public void onConnectionSuspended(int var1);
    }
}

