/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.BasePendingResult;
import com.google.android.gms.common.api.internal.zzac;
import com.google.android.gms.common.api.internal.zzad;
import com.google.android.gms.common.api.internal.zzba;
import com.google.android.gms.common.api.internal.zzbm;
import com.google.android.gms.common.api.internal.zzcc;
import com.google.android.gms.common.api.internal.zzcu;
import com.google.android.gms.common.api.internal.zzdn;
import com.google.android.gms.common.api.internal.zzh;
import com.google.android.gms.common.api.internal.zzm;
import com.google.android.gms.common.api.internal.zzt;
import com.google.android.gms.common.api.internal.zzz;
import com.google.android.gms.common.internal.zzr;
import com.google.android.gms.common.zzf;
import com.google.android.gms.internal.zzbic;
import com.google.android.gms.internal.zzcyj;
import com.google.android.gms.internal.zzcyk;
import com.google.android.gms.tasks.OnCompleteListener;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;

public final class zzaa
implements zzcc {
    private final Map<Api.zzc<?>, zzz<?>> zza = new HashMap();
    private final Map<Api.zzc<?>, zzz<?>> zzb = new HashMap();
    private final Map<Api<?>, Boolean> zzc;
    private final zzbm zzd;
    private final zzba zze;
    private final Lock zzf;
    private final Looper zzg;
    private final zzf zzh;
    private final Condition zzi;
    private final zzr zzj;
    private final boolean zzk;
    private final boolean zzl;
    private final Queue<zzm<?, ?>> zzm = new LinkedList();
    private boolean zzn;
    private Map<zzh<?>, ConnectionResult> zzo;
    private Map<zzh<?>, ConnectionResult> zzp;
    private zzad zzq;
    private ConnectionResult zzr;

    public zzaa(Context context, Lock lock, Looper looper, zzf zzf2, Map<Api.zzc<?>, Api.zze> map, zzr zzr2, Map<Api<?>, Boolean> map2, Api.zza<? extends zzcyj, zzcyk> zza2, ArrayList<zzt> arrayList, zzba zzba2, boolean bl) {
        this.zzf = lock;
        this.zzg = looper;
        this.zzi = lock.newCondition();
        this.zzh = zzf2;
        this.zze = zzba2;
        this.zzc = map2;
        this.zzj = zzr2;
        this.zzk = bl;
        HashMap hashMap = new HashMap();
        for (Api<?> api : map2.keySet()) {
            hashMap.put(api.zzc(), api);
        }
        HashMap hashMap2 = new HashMap();
        ArrayList<zzt> arrayList2 = arrayList;
        int n = arrayList2.size();
        for (int i = 0; i < n; ++i) {
            zzt zzt2 = arrayList2.get(i);
            zzt zzt3 = zzt2;
            hashMap2.put(zzt3.zza, zzt3);
        }
        boolean bl2 = false;
        boolean bl3 = true;
        boolean bl4 = false;
        for (Map.Entry<Api.zzc<?>, Api.zze> entry : map.entrySet()) {
            Api api = (Api)hashMap.get(entry.getKey());
            Api.zze zze2 = entry.getValue();
            if (zze2.zzu()) {
                bl4 = true;
                if (!this.zzc.get(api).booleanValue()) {
                    bl2 = true;
                }
            } else {
                bl3 = false;
            }
            zzt zzt4 = (zzt)hashMap2.get(api);
            zzz zzz2 = new zzz(context, api, looper, zze2, zzt4, zzr2, zza2);
            this.zza.put(entry.getKey(), zzz2);
            if (!zze2.l_()) continue;
            this.zzb.put(entry.getKey(), zzz2);
        }
        this.zzl = bl4 && !bl3 && !bl2;
        this.zzd = zzbm.zza();
    }

    @Override
    public final <A extends Api.zzb, R extends Result, T extends zzm<R, A>> T zza(@NonNull T t) {
        if (this.zzk && this.zzc(t)) {
            return t;
        }
        if (!this.zzd()) {
            this.zzm.add(t);
            return t;
        }
        this.zze.zze.zza(t);
        return this.zza.get(t.zzc()).zza(t);
    }

    @Override
    public final <A extends Api.zzb, T extends zzm<? extends Result, A>> T zzb(@NonNull T t) {
        Api.zzc<A> zzc2 = t.zzc();
        if (this.zzk && this.zzc(t)) {
            return t;
        }
        this.zze.zze.zza(t);
        return this.zza.get(zzc2).zzb(t);
    }

    private final <T extends zzm<? extends Result, ? extends Api.zzb>> boolean zzc(@NonNull T t) {
        Api.zzc<? extends Api.zzb> zzc2 = t.zzc();
        ConnectionResult connectionResult = this.zza(zzc2);
        if (connectionResult != null && connectionResult.getErrorCode() == 4) {
            t.zzc(new Status(4, null, this.zzd.zza(this.zza.get(zzc2).zzc(), System.identityHashCode(this.zze))));
            return true;
        }
        return false;
    }

    @Override
    public final void zza() {
        this.zzf.lock();
        try {
            if (this.zzn) {
                return;
            }
            this.zzn = true;
            this.zzo = null;
            this.zzp = null;
            this.zzq = null;
            this.zzr = null;
            this.zzd.zzd();
            this.zzd.zza(this.zza.values()).addOnCompleteListener((Executor)new zzbic(this.zzg), (OnCompleteListener)new zzac(this, null));
            return;
        }
        finally {
            this.zzf.unlock();
        }
    }

    @Override
    public final ConnectionResult zzb() {
        this.zza();
        while (this.zze()) {
            try {
                this.zzi.await();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return new ConnectionResult(15, null);
            }
        }
        if (this.zzd()) {
            return ConnectionResult.zza;
        }
        if (this.zzr != null) {
            return this.zzr;
        }
        return new ConnectionResult(13, null);
    }

    @Override
    public final ConnectionResult zza(long l, TimeUnit timeUnit) {
        this.zza();
        long l2 = timeUnit.toNanos(l);
        while (this.zze()) {
            try {
                if (l2 <= 0L) {
                    this.zzc();
                    return new ConnectionResult(14, null);
                }
                l2 = this.zzi.awaitNanos(l2);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return new ConnectionResult(15, null);
            }
        }
        if (this.zzd()) {
            return ConnectionResult.zza;
        }
        if (this.zzr != null) {
            return this.zzr;
        }
        return new ConnectionResult(13, null);
    }

    @Override
    public final void zzc() {
        this.zzf.lock();
        try {
            this.zzn = false;
            this.zzo = null;
            this.zzp = null;
            if (this.zzq != null) {
                this.zzq.zza();
                this.zzq = null;
            }
            this.zzr = null;
            while (!this.zzm.isEmpty()) {
                zzm<?, ?> zzm2 = this.zzm.remove();
                ((BasePendingResult)zzm2).zza((zzdn)null);
                ((PendingResult)zzm2).cancel();
            }
            this.zzi.signalAll();
            return;
        }
        finally {
            this.zzf.unlock();
        }
    }

    @Override
    @Nullable
    public final ConnectionResult zza(@NonNull Api<?> api) {
        return this.zza(api.zzc());
    }

    @Nullable
    private final ConnectionResult zza(@NonNull Api.zzc<?> zzc2) {
        this.zzf.lock();
        try {
            zzz<?> zzz2 = this.zza.get(zzc2);
            if (this.zzo != null && zzz2 != null) {
                ConnectionResult connectionResult = this.zzo.get(zzz2.zzc());
                return connectionResult;
            }
            return null;
        }
        finally {
            this.zzf.unlock();
        }
    }

    @Override
    public final boolean zzd() {
        this.zzf.lock();
        try {
            boolean bl = this.zzo != null && this.zzr == null;
            return bl;
        }
        finally {
            this.zzf.unlock();
        }
    }

    @Override
    public final boolean zze() {
        this.zzf.lock();
        try {
            boolean bl = this.zzo == null && this.zzn;
            return bl;
        }
        finally {
            this.zzf.unlock();
        }
    }

    private final boolean zzh() {
        this.zzf.lock();
        try {
            if (!this.zzn || !this.zzk) {
                return false;
            }
            for (Api.zzc<?> zzc2 : this.zzb.keySet()) {
                ConnectionResult connectionResult = this.zza(zzc2);
                if (connectionResult != null && connectionResult.isSuccess()) continue;
                return false;
            }
            return true;
        }
        finally {
            this.zzf.unlock();
        }
    }

    @Override
    public final boolean zza(zzcu zzcu2) {
        this.zzf.lock();
        try {
            if (this.zzn && !this.zzh()) {
                this.zzd.zzd();
                this.zzq = new zzad(this, zzcu2);
                this.zzd.zza(this.zzb.values()).addOnCompleteListener((Executor)new zzbic(this.zzg), (OnCompleteListener)this.zzq);
                return true;
            }
            return false;
        }
        finally {
            this.zzf.unlock();
        }
    }

    @Override
    public final void zzg() {
        this.zzf.lock();
        try {
            this.zzd.zze();
            if (this.zzq != null) {
                this.zzq.zza();
                this.zzq = null;
            }
            if (this.zzp == null) {
                this.zzp = new ArrayMap(this.zzb.size());
            }
            ConnectionResult connectionResult = new ConnectionResult(4);
            for (zzz<?> zzz2 : this.zzb.values()) {
                this.zzp.put(zzz2.zzc(), connectionResult);
            }
            if (this.zzo != null) {
                this.zzo.putAll(this.zzp);
            }
            return;
        }
        finally {
            this.zzf.unlock();
        }
    }

    @Override
    public final void zza(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
    }

    @Override
    public final void zzf() {
    }

    private final void zzi() {
        if (this.zzj == null) {
            this.zze.zzc = Collections.emptySet();
            return;
        }
        HashSet<Scope> hashSet = new HashSet<Scope>(this.zzj.zze());
        Map<Api<?>, com.google.android.gms.common.internal.zzt> map = this.zzj.zzg();
        for (Api<?> api : map.keySet()) {
            ConnectionResult connectionResult = this.zza(api);
            if (connectionResult == null || !connectionResult.isSuccess()) continue;
            hashSet.addAll(map.get(api).zza);
        }
        this.zze.zzc = hashSet;
    }

    private final void zzj() {
        while (!this.zzm.isEmpty()) {
            this.zzb(this.zzm.remove());
        }
        this.zze.zza((Bundle)null);
    }

    private final boolean zza(zzz<?> zzz2, ConnectionResult connectionResult) {
        return !connectionResult.isSuccess() && !connectionResult.hasResolution() && this.zzc.get(zzz2.zza()) != false && zzz2.zzh().zzu() && this.zzh.isUserResolvableError(connectionResult.getErrorCode());
    }

    @Nullable
    private final ConnectionResult zzk() {
        ConnectionResult connectionResult = null;
        int n = 0;
        ConnectionResult connectionResult2 = null;
        int n2 = 0;
        for (zzz<?> zzz2 : this.zza.values()) {
            int n3;
            Api api = zzz2.zza();
            zzh zzh2 = zzz2.zzc();
            ConnectionResult connectionResult3 = this.zzo.get(zzh2);
            if (connectionResult3.isSuccess() || this.zzc.get(api).booleanValue() && !connectionResult3.hasResolution() && !this.zzh.isUserResolvableError(connectionResult3.getErrorCode())) continue;
            if (connectionResult3.getErrorCode() == 4 && this.zzk) {
                n3 = api.zza().zza();
                if (connectionResult2 != null && n2 <= n3) continue;
                connectionResult2 = connectionResult3;
                n2 = n3;
                continue;
            }
            n3 = api.zza().zza();
            if (connectionResult != null && n <= n3) continue;
            connectionResult = connectionResult3;
            n = n3;
        }
        if (connectionResult != null && connectionResult2 != null && n > n2) {
            return connectionResult2;
        }
        return connectionResult;
    }

    static /* synthetic */ Lock zza(zzaa zzaa2) {
        return zzaa2.zzf;
    }

    static /* synthetic */ boolean zzb(zzaa zzaa2) {
        return zzaa2.zzn;
    }

    static /* synthetic */ Map zza(zzaa zzaa2, Map map) {
        zzaa2.zzo = map;
        return zzaa2.zzo;
    }

    static /* synthetic */ Map zzc(zzaa zzaa2) {
        return zzaa2.zza;
    }

    static /* synthetic */ Map zzd(zzaa zzaa2) {
        return zzaa2.zzo;
    }

    static /* synthetic */ boolean zze(zzaa zzaa2) {
        return zzaa2.zzl;
    }

    static /* synthetic */ boolean zza(zzaa zzaa2, zzz zzz2, ConnectionResult connectionResult) {
        return zzaa2.zza(zzz2, connectionResult);
    }

    static /* synthetic */ ConnectionResult zza(zzaa zzaa2, ConnectionResult connectionResult) {
        zzaa2.zzr = connectionResult;
        return zzaa2.zzr;
    }

    static /* synthetic */ ConnectionResult zzf(zzaa zzaa2) {
        return zzaa2.zzk();
    }

    static /* synthetic */ Map zzg(zzaa zzaa2) {
        return zzaa2.zzp;
    }

    static /* synthetic */ ConnectionResult zzh(zzaa zzaa2) {
        return zzaa2.zzr;
    }

    static /* synthetic */ void zzi(zzaa zzaa2) {
        zzaa2.zzi();
    }

    static /* synthetic */ void zzj(zzaa zzaa2) {
        zzaa2.zzj();
    }

    static /* synthetic */ boolean zza(zzaa zzaa2, boolean bl) {
        zzaa2.zzn = false;
        return false;
    }

    static /* synthetic */ zzba zzk(zzaa zzaa2) {
        return zzaa2.zze;
    }

    static /* synthetic */ Condition zzl(zzaa zzaa2) {
        return zzaa2.zzi;
    }

    static /* synthetic */ Map zzb(zzaa zzaa2, Map map) {
        zzaa2.zzp = map;
        return zzaa2.zzp;
    }

    static /* synthetic */ Map zzm(zzaa zzaa2) {
        return zzaa2.zzb;
    }
}

