/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.internal.zzal;
import com.google.android.gms.common.api.internal.zzao;
import com.google.android.gms.common.api.internal.zzaz;
import com.google.android.gms.common.api.internal.zzba;
import com.google.android.gms.common.api.internal.zzbh;
import com.google.android.gms.common.api.internal.zzbj;
import com.google.android.gms.common.api.internal.zzbk;
import com.google.android.gms.common.api.internal.zzcc;
import com.google.android.gms.common.api.internal.zzcd;
import com.google.android.gms.common.api.internal.zzcu;
import com.google.android.gms.common.api.internal.zzm;
import com.google.android.gms.common.api.internal.zzt;
import com.google.android.gms.common.api.internal.zzu;
import com.google.android.gms.common.internal.zzr;
import com.google.android.gms.common.zzf;
import com.google.android.gms.internal.zzcyj;
import com.google.android.gms.internal.zzcyk;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;

public final class zzbi
implements zzcc,
zzu {
    private final Lock zzf;
    private final Condition zzg;
    private final Context zzh;
    private final zzf zzi;
    private final zzbk zzj;
    final Map<Api.zzc<?>, Api.zze> zza;
    final Map<Api.zzc<?>, ConnectionResult> zzb = new HashMap();
    private zzr zzk;
    private Map<Api<?>, Boolean> zzl;
    private Api.zza<? extends zzcyj, zzcyk> zzm;
    private volatile zzbh zzn;
    private ConnectionResult zzo = null;
    int zzc;
    final zzba zzd;
    final zzcd zze;

    public zzbi(Context context, zzba zzba2, Lock lock, Looper looper, zzf zzf2, Map<Api.zzc<?>, Api.zze> map, zzr zzr2, Map<Api<?>, Boolean> map2, Api.zza<? extends zzcyj, zzcyk> zza2, ArrayList<zzt> arrayList, zzcd zzcd2) {
        this.zzh = context;
        this.zzf = lock;
        this.zzi = zzf2;
        this.zza = map;
        this.zzk = zzr2;
        this.zzl = map2;
        this.zzm = zza2;
        this.zzd = zzba2;
        this.zze = zzcd2;
        ArrayList<zzt> arrayList2 = arrayList;
        int n = arrayList2.size();
        for (int i = 0; i < n; ++i) {
            zzt zzt2 = arrayList2.get(i);
            zzt2.zza(this);
        }
        this.zzj = new zzbk(this, looper);
        this.zzg = lock.newCondition();
        this.zzn = new zzaz(this);
    }

    @Override
    public final <A extends Api.zzb, R extends Result, T extends zzm<R, A>> T zza(@NonNull T t) {
        t.zzg();
        return this.zzn.zza(t);
    }

    @Override
    public final <A extends Api.zzb, T extends zzm<? extends Result, A>> T zzb(@NonNull T t) {
        t.zzg();
        return this.zzn.zzb(t);
    }

    @Override
    public final void zza() {
        this.zzn.zzc();
    }

    @Override
    public final ConnectionResult zzb() {
        this.zza();
        while (this.zze()) {
            try {
                this.zzg.await();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return new ConnectionResult(15, null);
            }
        }
        if (this.zzd()) {
            return ConnectionResult.zza;
        }
        if (this.zzo != null) {
            return this.zzo;
        }
        return new ConnectionResult(13, null);
    }

    @Override
    public final ConnectionResult zza(long l, TimeUnit timeUnit) {
        this.zza();
        long l2 = timeUnit.toNanos(l);
        while (this.zze()) {
            try {
                if (l2 <= 0L) {
                    this.zzc();
                    return new ConnectionResult(14, null);
                }
                l2 = this.zzg.awaitNanos(l2);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return new ConnectionResult(15, null);
            }
        }
        if (this.zzd()) {
            return ConnectionResult.zza;
        }
        if (this.zzo != null) {
            return this.zzo;
        }
        return new ConnectionResult(13, null);
    }

    @Override
    public final void zzc() {
        if (this.zzn.zzb()) {
            this.zzb.clear();
        }
    }

    @Override
    @Nullable
    public final ConnectionResult zza(@NonNull Api<?> api) {
        Api.zzc<?> zzc2 = api.zzc();
        if (this.zza.containsKey(zzc2)) {
            if (this.zza.get(zzc2).zzs()) {
                return ConnectionResult.zza;
            }
            if (this.zzb.containsKey(zzc2)) {
                return this.zzb.get(zzc2);
            }
        }
        return null;
    }

    final void zzh() {
        this.zzf.lock();
        try {
            this.zzn = new zzao(this, this.zzk, this.zzl, this.zzi, this.zzm, this.zzf, this.zzh);
            this.zzn.zza();
            this.zzg.signalAll();
            return;
        }
        finally {
            this.zzf.unlock();
        }
    }

    final void zzi() {
        this.zzf.lock();
        try {
            this.zzd.zzf();
            this.zzn = new zzal(this);
            this.zzn.zza();
            this.zzg.signalAll();
            return;
        }
        finally {
            this.zzf.unlock();
        }
    }

    final void zza(ConnectionResult connectionResult) {
        this.zzf.lock();
        try {
            this.zzo = connectionResult;
            this.zzn = new zzaz(this);
            this.zzn.zza();
            this.zzg.signalAll();
            return;
        }
        finally {
            this.zzf.unlock();
        }
    }

    @Override
    public final boolean zzd() {
        return this.zzn instanceof zzal;
    }

    @Override
    public final boolean zze() {
        return this.zzn instanceof zzao;
    }

    @Override
    public final boolean zza(zzcu zzcu2) {
        return false;
    }

    @Override
    public final void zzg() {
    }

    @Override
    public final void zzf() {
        if (this.zzd()) {
            ((zzal)this.zzn).zzd();
        }
    }

    @Override
    public final void zza(@NonNull ConnectionResult connectionResult, @NonNull Api<?> api, boolean bl) {
        this.zzf.lock();
        try {
            this.zzn.zza(connectionResult, api, bl);
            return;
        }
        finally {
            this.zzf.unlock();
        }
    }

    @Override
    public final void onConnected(@Nullable Bundle bundle) {
        this.zzf.lock();
        try {
            this.zzn.zza(bundle);
            return;
        }
        finally {
            this.zzf.unlock();
        }
    }

    @Override
    public final void onConnectionSuspended(int n) {
        this.zzf.lock();
        try {
            this.zzn.zza(n);
            return;
        }
        finally {
            this.zzf.unlock();
        }
    }

    final void zza(zzbj zzbj2) {
        Message message = this.zzj.obtainMessage(1, zzbj2);
        this.zzj.sendMessage(message);
    }

    final void zza(RuntimeException runtimeException) {
        Message message = this.zzj.obtainMessage(2, runtimeException);
        this.zzj.sendMessage(message);
    }

    @Override
    public final void zza(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        String string3 = String.valueOf(string2).concat("  ");
        printWriter.append(string2).append("mState=").println(this.zzn);
        for (Api<?> api : this.zzl.keySet()) {
            printWriter.append(string2).append(api.zzd()).println(":");
            this.zza.get(api.zzc()).zza(string3, fileDescriptor, printWriter, stringArray);
        }
    }

    static /* synthetic */ Lock zza(zzbi zzbi2) {
        return zzbi2.zzf;
    }

    static /* synthetic */ zzbh zzb(zzbi zzbi2) {
        return zzbi2.zzn;
    }
}

