/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.images;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.ResultReceiver;
import android.os.SystemClock;
import android.support.v4.util.LruCache;
import android.util.Log;
import android.widget.ImageView;
import com.google.android.gms.common.annotation.KeepName;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.internal.zzbgk;
import java.io.FileDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public final class ImageManager {
    private static final Object zza = new Object();
    private static HashSet<Uri> zzb = new HashSet();
    private static ImageManager zzc;
    private final Context zzd;
    private final Handler zze;
    private final ExecutorService zzf;
    private final zza zzg;
    private final zzbgk zzh;
    private final Map<com.google.android.gms.common.images.zza, ImageReceiver> zzi;
    private final Map<Uri, ImageReceiver> zzj;
    private final Map<Uri, Long> zzk;

    public static ImageManager create(Context context) {
        Context context2 = context;
        if (zzc == null) {
            zzc = new ImageManager(context2, false);
        }
        return zzc;
    }

    private ImageManager(Context context, boolean bl) {
        this.zzd = context.getApplicationContext();
        this.zze = new Handler(Looper.getMainLooper());
        this.zzf = Executors.newFixedThreadPool(4);
        this.zzg = null;
        this.zzh = new zzbgk();
        this.zzi = new HashMap<com.google.android.gms.common.images.zza, ImageReceiver>();
        this.zzj = new HashMap<Uri, ImageReceiver>();
        this.zzk = new HashMap<Uri, Long>();
    }

    public final void loadImage(ImageView imageView, Uri uri) {
        com.google.android.gms.common.images.zzc zzc2 = new com.google.android.gms.common.images.zzc(imageView, uri);
        this.zza(zzc2);
    }

    public final void loadImage(ImageView imageView, int n) {
        com.google.android.gms.common.images.zzc zzc2 = new com.google.android.gms.common.images.zzc(imageView, n);
        this.zza(zzc2);
    }

    public final void loadImage(ImageView imageView, Uri uri, int n) {
        com.google.android.gms.common.images.zzc zzc2 = new com.google.android.gms.common.images.zzc(imageView, uri);
        new com.google.android.gms.common.images.zzc(imageView, uri).zzb = n;
        this.zza(zzc2);
    }

    public final void loadImage(OnImageLoadedListener onImageLoadedListener, Uri uri) {
        com.google.android.gms.common.images.zzd zzd2 = new com.google.android.gms.common.images.zzd(onImageLoadedListener, uri);
        this.zza(zzd2);
    }

    public final void loadImage(OnImageLoadedListener onImageLoadedListener, Uri uri, int n) {
        com.google.android.gms.common.images.zzd zzd2 = new com.google.android.gms.common.images.zzd(onImageLoadedListener, uri);
        new com.google.android.gms.common.images.zzd(onImageLoadedListener, uri).zzb = n;
        this.zza(zzd2);
    }

    @Hide
    private final void zza(com.google.android.gms.common.images.zza zza2) {
        com.google.android.gms.common.internal.zzc.zza((String)"ImageManager.loadImage() must be called in the main thread");
        new zzc(this, zza2).run();
    }

    private final Bitmap zza(com.google.android.gms.common.images.zzb zzb2) {
        if (this.zzg == null) {
            return null;
        }
        return (Bitmap)this.zzg.get(zzb2);
    }

    static final class zza
    extends LruCache<com.google.android.gms.common.images.zzb, Bitmap> {
        protected final /* synthetic */ int sizeOf(Object object, Object object2) {
            Bitmap bitmap = (Bitmap)object2;
            return bitmap.getHeight() * bitmap.getRowBytes();
        }

        protected final /* synthetic */ void entryRemoved(boolean bl, Object object, Object object2, Object object3) {
            Bitmap bitmap = (Bitmap)object3;
            Bitmap bitmap2 = (Bitmap)object2;
            com.google.android.gms.common.images.zzb zzb2 = (com.google.android.gms.common.images.zzb)object;
            super.entryRemoved(bl, (Object)zzb2, (Object)bitmap2, (Object)bitmap);
        }
    }

    final class zzd
    implements Runnable {
        private final Uri zza;
        private final Bitmap zzb;
        private final CountDownLatch zzc;
        private boolean zzd;
        private /* synthetic */ ImageManager zze;

        public zzd(ImageManager imageManager, Uri uri, Bitmap bitmap, boolean bl, CountDownLatch countDownLatch) {
            this.zze = imageManager;
            this.zza = uri;
            this.zzb = bitmap;
            this.zzd = bl;
            this.zzc = countDownLatch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            ImageReceiver imageReceiver;
            boolean bl;
            com.google.android.gms.common.internal.zzc.zza((String)"OnBitmapLoadedRunnable must be executed in the main thread");
            boolean bl2 = bl = this.zzb != null;
            if (this.zze.zzg != null) {
                if (this.zzd) {
                    this.zze.zzg.evictAll();
                    System.gc();
                    this.zzd = false;
                    this.zze.zze.post((Runnable)this);
                    return;
                }
                if (bl) {
                    this.zze.zzg.put(new com.google.android.gms.common.images.zzb(this.zza), this.zzb);
                }
            }
            if ((imageReceiver = (ImageReceiver)((Object)this.zze.zzj.remove(this.zza))) != null) {
                boolean bl3 = bl;
                ImageReceiver imageReceiver2 = imageReceiver;
                zzd zzd2 = this;
                ArrayList arrayList = imageReceiver2.zzb;
                int n = arrayList.size();
                for (int i = 0; i < n; ++i) {
                    com.google.android.gms.common.images.zza zza2 = (com.google.android.gms.common.images.zza)arrayList.get(i);
                    if (bl3) {
                        zza2.zza(zzd2.zze.zzd, zzd2.zzb, false);
                    } else {
                        zzd2.zze.zzk.put(zzd2.zza, SystemClock.elapsedRealtime());
                        zza2.zza(zzd2.zze.zzd, zzd2.zze.zzh, false);
                    }
                    if (zza2 instanceof com.google.android.gms.common.images.zzd) continue;
                    zzd2.zze.zzi.remove(zza2);
                }
            }
            this.zzc.countDown();
            Object object = zza;
            synchronized (object) {
                zzb.remove(this.zza);
                return;
            }
        }
    }

    final class zzb
    implements Runnable {
        private final Uri zza;
        private final ParcelFileDescriptor zzb;
        private /* synthetic */ ImageManager zzc;

        public zzb(ImageManager imageManager, Uri uri, ParcelFileDescriptor parcelFileDescriptor) {
            this.zzc = imageManager;
            this.zza = uri;
            this.zzb = parcelFileDescriptor;
        }

        @Override
        public final void run() {
            String string2 = "LoadBitmapFromDiskRunnable can't be executed in the main thread";
            if (Looper.getMainLooper().getThread() == Thread.currentThread()) {
                String string3 = String.valueOf(Thread.currentThread());
                String string4 = String.valueOf(Looper.getMainLooper().getThread());
                Log.e((String)"Asserts", (String)new StringBuilder(56 + String.valueOf(string3).length() + String.valueOf(string4).length()).append("checkNotMainThread: current thread ").append(string3).append(" IS the main thread ").append(string4).append("!").toString());
                throw new IllegalStateException(string2);
            }
            boolean bl = false;
            Bitmap bitmap = null;
            if (this.zzb != null) {
                try {
                    bitmap = BitmapFactory.decodeFileDescriptor((FileDescriptor)this.zzb.getFileDescriptor());
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    String string5 = String.valueOf(this.zza);
                    Log.e((String)"ImageManager", (String)new StringBuilder(34 + String.valueOf(string5).length()).append("OOM while loading bitmap for uri: ").append(string5).toString(), (Throwable)outOfMemoryError);
                    bl = true;
                }
                try {
                    this.zzb.close();
                }
                catch (IOException iOException) {
                    Log.e((String)"ImageManager", (String)"closed failed", (Throwable)iOException);
                }
            }
            CountDownLatch countDownLatch = new CountDownLatch(1);
            this.zzc.zze.post((Runnable)new zzd(this.zzc, this.zza, bitmap, bl, countDownLatch));
            try {
                countDownLatch.await();
                return;
            }
            catch (InterruptedException interruptedException) {
                String string6 = String.valueOf(this.zza);
                Log.w((String)"ImageManager", (String)new StringBuilder(32 + String.valueOf(string6).length()).append("Latch interrupted while posting ").append(string6).toString());
                return;
            }
        }
    }

    @KeepName
    final class ImageReceiver
    extends ResultReceiver {
        private final Uri zza;
        private final ArrayList<com.google.android.gms.common.images.zza> zzb;
        private /* synthetic */ ImageManager zzc;

        ImageReceiver(ImageManager imageManager, Uri uri) {
            this.zzc = imageManager;
            super(new Handler(Looper.getMainLooper()));
            this.zza = uri;
            this.zzb = new ArrayList();
        }

        public final void zza(com.google.android.gms.common.images.zza zza2) {
            com.google.android.gms.common.internal.zzc.zza((String)"ImageReceiver.addImageRequest() must be called in the main thread");
            this.zzb.add(zza2);
        }

        public final void zzb(com.google.android.gms.common.images.zza zza2) {
            com.google.android.gms.common.internal.zzc.zza((String)"ImageReceiver.removeImageRequest() must be called in the main thread");
            this.zzb.remove(zza2);
        }

        public final void zza() {
            Intent intent = new Intent("com.google.android.gms.common.images.LOAD_IMAGE");
            intent.putExtra("com.google.android.gms.extras.uri", (Parcelable)this.zza);
            intent.putExtra("com.google.android.gms.extras.resultReceiver", (Parcelable)this);
            intent.putExtra("com.google.android.gms.extras.priority", 3);
            this.zzc.zzd.sendBroadcast(intent);
        }

        public final void onReceiveResult(int n, Bundle bundle) {
            ParcelFileDescriptor parcelFileDescriptor = (ParcelFileDescriptor)bundle.getParcelable("com.google.android.gms.extra.fileDescriptor");
            this.zzc.zzf.execute(new zzb(this.zzc, this.zza, parcelFileDescriptor));
        }
    }

    final class zzc
    implements Runnable {
        private final com.google.android.gms.common.images.zza zza;
        private /* synthetic */ ImageManager zzb;

        public zzc(ImageManager imageManager, com.google.android.gms.common.images.zza zza2) {
            this.zzb = imageManager;
            this.zza = zza2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            com.google.android.gms.common.internal.zzc.zza((String)"LoadImageRunnable must be executed on the main thread");
            ImageReceiver imageReceiver = (ImageReceiver)((Object)this.zzb.zzi.get(this.zza));
            if (imageReceiver != null) {
                this.zzb.zzi.remove(this.zza);
                imageReceiver.zzb(this.zza);
            }
            com.google.android.gms.common.images.zzb zzb2 = this.zza.zza;
            if (zzb2.zza == null) {
                this.zza.zza(this.zzb.zzd, this.zzb.zzh, true);
                return;
            }
            Bitmap bitmap = this.zzb.zza(zzb2);
            if (bitmap != null) {
                this.zza.zza(this.zzb.zzd, bitmap, true);
                return;
            }
            Long l = (Long)this.zzb.zzk.get(zzb2.zza);
            if (l != null) {
                if (SystemClock.elapsedRealtime() - l < 3600000L) {
                    this.zza.zza(this.zzb.zzd, this.zzb.zzh, true);
                    return;
                }
                this.zzb.zzk.remove(zzb2.zza);
            }
            this.zza.zza(this.zzb.zzd, this.zzb.zzh);
            imageReceiver = (ImageReceiver)((Object)this.zzb.zzj.get(zzb2.zza));
            if (imageReceiver == null) {
                imageReceiver = new ImageReceiver(this.zzb, zzb2.zza);
                this.zzb.zzj.put(zzb2.zza, imageReceiver);
            }
            imageReceiver.zza(this.zza);
            if (!(this.zza instanceof com.google.android.gms.common.images.zzd)) {
                this.zzb.zzi.put(this.zza, imageReceiver);
            }
            Object object = zza;
            synchronized (object) {
                if (!zzb.contains(zzb2.zza)) {
                    zzb.add(zzb2.zza);
                    imageReceiver.zza();
                }
                return;
            }
        }
    }

    public static interface OnImageLoadedListener {
        public void onImageLoaded(Uri var1, Drawable var2, boolean var3);
    }
}

