/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.images;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.images.zze;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import java.util.Arrays;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

public final class WebImage
extends zzbgl {
    public static final Parcelable.Creator<WebImage> CREATOR = new zze();
    private int zza;
    private final Uri zzb;
    private final int zzc;
    private final int zzd;

    WebImage(int n, Uri uri, int n2, int n3) {
        this.zza = n;
        this.zzb = uri;
        this.zzc = n2;
        this.zzd = n3;
    }

    public WebImage(Uri uri, int n, int n2) throws IllegalArgumentException {
        this(1, uri, n, n2);
        if (uri == null) {
            throw new IllegalArgumentException("url cannot be null");
        }
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException("width and height must not be negative");
        }
    }

    public WebImage(Uri uri) throws IllegalArgumentException {
        this(uri, 0, 0);
    }

    @Hide
    public WebImage(JSONObject jSONObject) throws IllegalArgumentException {
        this(WebImage.zza(jSONObject), jSONObject.optInt("width", 0), jSONObject.optInt("height", 0));
    }

    private static Uri zza(JSONObject jSONObject) {
        Uri uri = null;
        if (jSONObject.has("url")) {
            try {
                uri = Uri.parse((String)jSONObject.getString("url"));
            }
            catch (JSONException jSONException) {}
        }
        return uri;
    }

    public final Uri getUrl() {
        return this.zzb;
    }

    public final int getWidth() {
        return this.zzc;
    }

    public final int getHeight() {
        return this.zzd;
    }

    public final String toString() {
        return String.format(Locale.US, "Image %dx%d %s", this.zzc, this.zzd, this.zzb.toString());
    }

    @Hide
    public final JSONObject zza() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("url", (Object)this.zzb.toString());
            jSONObject.put("width", this.zzc);
            jSONObject.put("height", this.zzd);
        }
        catch (JSONException jSONException) {}
        return jSONObject;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof WebImage)) {
            return false;
        }
        WebImage webImage = (WebImage)((Object)object);
        return zzbg.zza((Object)this.zzb, (Object)webImage.zzb) && this.zzc == webImage.zzc && this.zzd == webImage.zzd;
    }

    public final int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzb, this.zzc, this.zzd});
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        WebImage webImage = this;
        int n2 = zzbgo.zza((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)1, (int)webImage.zza);
        zzbgo.zza((Parcel)parcel2, (int)2, (Parcelable)webImage.getUrl(), (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)3, (int)webImage.getWidth());
        zzbgo.zza((Parcel)parcel2, (int)4, (int)webImage.getHeight());
        zzbgo.zza((Parcel)parcel2, (int)n2);
    }
}

