/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.SystemClock;
import com.google.android.gms.internal.zzbgg;
import com.google.android.gms.internal.zzbgi;

public final class zzbge
extends Drawable
implements Drawable.Callback {
    private int zza = 0;
    private long zzb;
    private int zzc;
    private int zzd;
    private int zze = 255;
    private int zzf;
    private int zzg = 0;
    private boolean zzh = true;
    private boolean zzi;
    private zzbgi zzj;
    private Drawable zzk;
    private Drawable zzl;
    private boolean zzm;
    private boolean zzn;
    private boolean zzo;
    private int zzp;

    public zzbge(Drawable drawable2, Drawable drawable3) {
        this(null);
        if (drawable2 == null) {
            drawable2 = zzbgg.zza();
        }
        this.zzk = drawable2;
        drawable2.setCallback((Drawable.Callback)this);
        this.zzj.zzb |= drawable2.getChangingConfigurations();
        if (drawable3 == null) {
            drawable3 = zzbgg.zza();
        }
        this.zzl = drawable3;
        drawable3.setCallback((Drawable.Callback)this);
        this.zzj.zzb |= drawable3.getChangingConfigurations();
    }

    zzbge(zzbgi zzbgi2) {
        this.zzj = new zzbgi(zzbgi2);
    }

    public final void invalidateDrawable(Drawable drawable2) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.invalidateDrawable((Drawable)this);
        }
    }

    public final void scheduleDrawable(Drawable drawable2, Runnable runnable, long l) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.scheduleDrawable((Drawable)this, runnable, l);
        }
    }

    public final void unscheduleDrawable(Drawable drawable2, Runnable runnable) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.unscheduleDrawable((Drawable)this, runnable);
        }
    }

    public final int getChangingConfigurations() {
        return super.getChangingConfigurations() | this.zzj.zza | this.zzj.zzb;
    }

    public final void setAlpha(int n) {
        if (this.zzg == this.zze) {
            this.zzg = n;
        }
        this.zze = n;
        this.invalidateSelf();
    }

    public final void setColorFilter(ColorFilter colorFilter) {
        this.zzk.setColorFilter(colorFilter);
        this.zzl.setColorFilter(colorFilter);
    }

    public final int getIntrinsicWidth() {
        return Math.max(this.zzk.getIntrinsicWidth(), this.zzl.getIntrinsicWidth());
    }

    public final int getIntrinsicHeight() {
        return Math.max(this.zzk.getIntrinsicHeight(), this.zzl.getIntrinsicHeight());
    }

    protected final void onBoundsChange(Rect rect) {
        this.zzk.setBounds(rect);
        this.zzl.setBounds(rect);
    }

    public final Drawable.ConstantState getConstantState() {
        if (this.zzb()) {
            this.zzj.zza = this.getChangingConfigurations();
            return this.zzj;
        }
        return null;
    }

    public final int getOpacity() {
        if (!this.zzo) {
            this.zzp = Drawable.resolveOpacity((int)this.zzk.getOpacity(), (int)this.zzl.getOpacity());
            this.zzo = true;
        }
        return this.zzp;
    }

    private final boolean zzb() {
        if (!this.zzm) {
            this.zzn = this.zzk.getConstantState() != null && this.zzl.getConstantState() != null;
            this.zzm = true;
        }
        return this.zzn;
    }

    public final Drawable mutate() {
        if (!this.zzi && super.mutate() == this) {
            if (!this.zzb()) {
                throw new IllegalStateException("One or more children of this LayerDrawable does not have constant state; this drawable cannot be mutated.");
            }
            this.zzk.mutate();
            this.zzl.mutate();
            this.zzi = true;
        }
        return this;
    }

    public final Drawable zza() {
        return this.zzl;
    }

    public final void zza(int n) {
        this.zzc = 0;
        this.zzd = this.zze;
        this.zzg = 0;
        this.zzf = 250;
        this.zza = 1;
        this.invalidateSelf();
    }

    public final void draw(Canvas canvas) {
        boolean bl = true;
        switch (this.zza) {
            case 1: {
                this.zzb = SystemClock.uptimeMillis();
                bl = false;
                this.zza = 2;
                break;
            }
            case 2: {
                float f;
                if (this.zzb < 0L) break;
                float f2 = (float)(SystemClock.uptimeMillis() - this.zzb) / (float)this.zzf;
                bl = f >= 1.0f;
                if (bl) {
                    this.zza = 0;
                }
                f2 = Math.min(f2, 1.0f);
                this.zzg = (int)(0.0f + (float)this.zzd * f2);
            }
        }
        int n = this.zzg;
        boolean bl2 = this.zzh;
        Drawable drawable2 = this.zzk;
        Drawable drawable3 = this.zzl;
        if (bl) {
            if (!bl2 || n == 0) {
                drawable2.draw(canvas);
            }
            if (n == this.zze) {
                drawable3.setAlpha(this.zze);
                drawable3.draw(canvas);
            }
            return;
        }
        if (bl2) {
            drawable2.setAlpha(this.zze - n);
        }
        drawable2.draw(canvas);
        if (bl2) {
            drawable2.setAlpha(this.zze);
        }
        if (n > 0) {
            drawable3.setAlpha(n);
            drawable3.draw(canvas);
            drawable3.setAlpha(this.zze);
        }
        this.invalidateSelf();
    }
}

