/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.accounts.Account;
import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.internal.zzah;
import com.google.android.gms.common.api.internal.zzbm;
import com.google.android.gms.common.api.internal.zzbo;
import com.google.android.gms.common.api.internal.zzbw;
import com.google.android.gms.common.api.internal.zzci;
import com.google.android.gms.common.api.internal.zzck;
import com.google.android.gms.common.api.internal.zzcm;
import com.google.android.gms.common.api.internal.zzcq;
import com.google.android.gms.common.api.internal.zzcv;
import com.google.android.gms.common.api.internal.zzda;
import com.google.android.gms.common.api.internal.zzde;
import com.google.android.gms.common.api.internal.zzdo;
import com.google.android.gms.common.api.internal.zzg;
import com.google.android.gms.common.api.internal.zzh;
import com.google.android.gms.common.api.internal.zzm;
import com.google.android.gms.common.api.zzc;
import com.google.android.gms.common.api.zzd;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.internal.zzr;
import com.google.android.gms.common.internal.zzs;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import java.util.Collections;

public class GoogleApi<O extends Api.ApiOptions> {
    private final Context mContext;
    private final Api<O> zzfop;
    private final O zzfsm;
    private final zzh<O> zzfsn;
    private final Looper zzalj;
    private final int mId;
    private final GoogleApiClient zzfso;
    private final zzda zzfsp;
    @Hide
    protected final zzbm zzfsq;

    @Hide
    protected GoogleApi(@NonNull Context context, Api<O> api, Looper looper) {
        zzbq.checkNotNull((Object)context, (Object)"Null context is not permitted.");
        zzbq.checkNotNull(api, (Object)"Api must not be null.");
        zzbq.checkNotNull((Object)looper, (Object)"Looper must not be null.");
        this.mContext = context.getApplicationContext();
        this.zzfop = api;
        this.zzfsm = null;
        this.zzalj = looper;
        this.zzfsn = zzh.zzb(api);
        this.zzfso = new zzbw(this);
        this.zzfsq = zzbm.zzck(this.mContext);
        this.mId = this.zzfsq.zzaka();
        this.zzfsp = new zzg();
    }

    @Deprecated
    @Hide
    public GoogleApi(@NonNull Context context, Api<O> api, O o, Looper looper, zzda zzda2) {
        this(context, api, null, new zzd().zza(looper).zza(zzda2).zzahy());
    }

    @Hide
    @MainThread
    public GoogleApi(@NonNull Activity activity, Api<O> api, O o, zza zza2) {
        zzbq.checkNotNull((Object)activity, (Object)"Null activity is not permitted.");
        zzbq.checkNotNull(api, (Object)"Api must not be null.");
        zzbq.checkNotNull((Object)zza2, (Object)"Settings must not be null; use Settings.DEFAULT_SETTINGS instead.");
        this.mContext = activity.getApplicationContext();
        this.zzfop = api;
        this.zzfsm = o;
        this.zzalj = zza2.zzfst;
        this.zzfsn = zzh.zza(this.zzfop, this.zzfsm);
        this.zzfso = new zzbw(this);
        this.zzfsq = zzbm.zzck(this.mContext);
        this.mId = this.zzfsq.zzaka();
        this.zzfsp = zza2.zzfss;
        zzah.zza(activity, this.zzfsq, this.zzfsn);
        this.zzfsq.zza(this);
    }

    @Hide
    public GoogleApi(@NonNull Context context, Api<O> api, O o, zza zza2) {
        zzbq.checkNotNull((Object)context, (Object)"Null context is not permitted.");
        zzbq.checkNotNull(api, (Object)"Api must not be null.");
        zzbq.checkNotNull((Object)zza2, (Object)"Settings must not be null; use Settings.DEFAULT_SETTINGS instead.");
        this.mContext = context.getApplicationContext();
        this.zzfop = api;
        this.zzfsm = o;
        this.zzalj = zza2.zzfst;
        this.zzfsn = zzh.zza(this.zzfop, this.zzfsm);
        this.zzfso = new zzbw(this);
        this.zzfsq = zzbm.zzck(this.mContext);
        this.mId = this.zzfsq.zzaka();
        this.zzfsp = zza2.zzfss;
        this.zzfsq.zza(this);
    }

    @Deprecated
    @Hide
    public GoogleApi(@NonNull Activity activity, Api<O> api, O o, zzda zzda2) {
        this(activity, api, o, new zzd().zza(zzda2).zza(activity.getMainLooper()).zzahy());
    }

    @Deprecated
    @Hide
    public GoogleApi(@NonNull Context context, Api<O> api, O o, zzda zzda2) {
        this(context, api, o, new zzd().zza(zzda2).zzahy());
    }

    private final <A extends Api.zzb, T extends zzm<? extends Result, A>> T zza(int n, @NonNull T t) {
        t.zzaiq();
        this.zzfsq.zza(this, n, t);
        return t;
    }

    private final <TResult, A extends Api.zzb> Task<TResult> zza(int n, @NonNull zzde<A, TResult> zzde2) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        this.zzfsq.zza(this, n, zzde2, taskCompletionSource, this.zzfsp);
        return taskCompletionSource.getTask();
    }

    @Hide
    public final <A extends Api.zzb, T extends zzm<? extends Result, A>> T zza(@NonNull T t) {
        return this.zza(0, t);
    }

    @Hide
    public final <TResult, A extends Api.zzb> Task<TResult> zza(zzde<A, TResult> zzde2) {
        return this.zza(false, (zzdo)((Object)zzde2));
    }

    @Hide
    public final <A extends Api.zzb, T extends zzm<? extends Result, A>> T zzb(@NonNull T t) {
        return this.zza(1, t);
    }

    @Hide
    public final <TResult, A extends Api.zzb> Task<TResult> zzb(zzde<A, TResult> zzde2) {
        return this.zza(true, (zzdo)((Object)zzde2));
    }

    @Hide
    public final <A extends Api.zzb, T extends zzm<? extends Result, A>> T zzc(@NonNull T t) {
        return this.zza(2, t);
    }

    @Hide
    public final <A extends Api.zzb, T extends zzcq<A, ?>, U extends zzdo<A, ?>> Task<Void> zza(@NonNull T t, U u) {
        zzbq.checkNotNull(t);
        zzbq.checkNotNull(u);
        zzbq.checkNotNull(t.zzakx(), (Object)"Listener has already been released.");
        zzbq.checkNotNull(u.zzakx(), (Object)"Listener has already been released.");
        zzbq.checkArgument((boolean)t.zzakx().equals(u.zzakx()), (Object)"Listener registration and unregistration methods must be constructed with the same ListenerHolder.");
        return this.zzfsq.zza(this, t, u);
    }

    @Hide
    public final Task<Boolean> zza(@NonNull zzck<?> zzck2) {
        zzbq.checkNotNull(zzck2, (Object)"Listener key cannot be null.");
        return this.zzfsq.zza(this, zzck2);
    }

    @Hide
    public final <L> zzci<L> zza(@NonNull L l, String string2) {
        return zzcm.zzb(l, this.zzalj, string2);
    }

    @Hide
    @WorkerThread
    public Api.zze zza(Looper looper, zzbo<O> zzbo2) {
        zzr zzr2 = this.zzahx().zzgo(this.mContext.getPackageName()).zzgp(this.mContext.getClass().getName()).zzamn();
        return this.zzfop.zzahl().zza(this.mContext, looper, zzr2, this.zzfsm, zzbo2, zzbo2);
    }

    @Hide
    public final Api<O> zzaht() {
        return this.zzfop;
    }

    @Hide
    public final O zzahu() {
        return this.zzfsm;
    }

    @Hide
    public final zzh<O> zzahv() {
        return this.zzfsn;
    }

    @Hide
    public final int getInstanceId() {
        return this.mId;
    }

    @Hide
    public final GoogleApiClient zzahw() {
        return this.zzfso;
    }

    @Hide
    public final Looper getLooper() {
        return this.zzalj;
    }

    @Hide
    public final Context getApplicationContext() {
        return this.mContext;
    }

    @Hide
    private final zzs zzahx() {
        GoogleSignInAccount googleSignInAccount;
        GoogleApi googleApi = this;
        Account account = googleApi.zzfsm instanceof Api.ApiOptions.HasGoogleSignInAccountOptions && (googleSignInAccount = ((Api.ApiOptions.HasGoogleSignInAccountOptions)googleApi.zzfsm).getGoogleSignInAccount()) != null ? googleSignInAccount.getAccount() : (googleApi.zzfsm instanceof Api.ApiOptions.HasAccountOptions ? ((Api.ApiOptions.HasAccountOptions)googleApi.zzfsm).getAccount() : null);
        googleApi = this;
        return new zzs().zze(account).zze(googleApi.zzfsm instanceof Api.ApiOptions.HasGoogleSignInAccountOptions && (googleSignInAccount = ((Api.ApiOptions.HasGoogleSignInAccountOptions)googleApi.zzfsm).getGoogleSignInAccount()) != null ? googleSignInAccount.zzacf() : Collections.emptySet());
    }

    @Hide
    public zzcv zza(Context context, Handler handler) {
        return new zzcv(context, handler, this.zzahx().zzamn());
    }

    @Hide
    public static final class zza {
        public static final zza zzfsr = new zzd().zzahy();
        public final zzda zzfss;
        public final Looper zzfst;

        private zza(zzda zzda2, Account account, Looper looper) {
            this.zzfss = zzda2;
            this.zzfst = looper;
        }

        /* synthetic */ zza(zzda zzda2, Account account, Looper looper, zzc zzc2) {
            this(zzda2, null, looper);
        }
    }
}

