/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.util.Log;
import android.util.Pair;
import com.google.android.gms.common.annotation.KeepName;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.ResultTransform;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.TransformedResult;
import com.google.android.gms.common.api.internal.zzdh;
import com.google.android.gms.common.api.internal.zzdn;
import com.google.android.gms.common.api.internal.zzs;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzaq;
import com.google.android.gms.common.internal.zzbq;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

@Hide
@KeepName
public abstract class BasePendingResult<R extends Result>
extends PendingResult<R> {
    static final ThreadLocal<Boolean> zzfvb = new zzs();
    private final Object zzfvc = new Object();
    @Hide
    private zza<R> zzfvd;
    private WeakReference<GoogleApiClient> zzfve;
    private final CountDownLatch zzapc = new CountDownLatch(1);
    private final ArrayList<PendingResult.zza> zzfvf = new ArrayList();
    private ResultCallback<? super R> zzfvg;
    private final AtomicReference<zzdn> zzfvh = new AtomicReference();
    private R zzftm;
    private Status mStatus;
    @KeepName
    private zzb mResultGuardian;
    private volatile boolean zzfvi;
    private boolean zzam;
    private boolean zzfvj;
    private zzaq zzfvk;
    private volatile zzdh<R> zzfvl;
    private boolean zzfvm = false;

    @Deprecated
    BasePendingResult() {
        this.zzfvd = new zza(Looper.getMainLooper());
        this.zzfve = new WeakReference<Object>(null);
    }

    protected BasePendingResult(GoogleApiClient googleApiClient) {
        Looper looper = googleApiClient != null ? googleApiClient.getLooper() : Looper.getMainLooper();
        this.zzfvd = new zza(looper);
        this.zzfve = new WeakReference<GoogleApiClient>(googleApiClient);
    }

    @Deprecated
    protected BasePendingResult(Looper looper) {
        this.zzfvd = new zza(looper);
        this.zzfve = new WeakReference<Object>(null);
    }

    @Hide
    public final boolean isReady() {
        return this.zzapc.getCount() == 0L;
    }

    @Override
    public final R await() {
        zzbq.zzgw((String)"await must not be called on the UI thread");
        zzbq.zza((!this.zzfvi ? 1 : 0) != 0, (Object)"Result has already been consumed");
        zzbq.zza((this.zzfvl == null ? 1 : 0) != 0, (Object)"Cannot await if then() has been called.");
        try {
            this.zzapc.await();
        }
        catch (InterruptedException interruptedException) {
            this.zzv(Status.zzftr);
        }
        zzbq.zza((boolean)this.isReady(), (Object)"Result is not ready.");
        return this.get();
    }

    @Override
    public final R await(long l, TimeUnit timeUnit) {
        if (l > 0L) {
            zzbq.zzgw((String)"await must not be called on the UI thread when time is greater than zero.");
        }
        zzbq.zza((!this.zzfvi ? 1 : 0) != 0, (Object)"Result has already been consumed.");
        zzbq.zza((this.zzfvl == null ? 1 : 0) != 0, (Object)"Cannot await if then() has been called.");
        try {
            if (!this.zzapc.await(l, timeUnit)) {
                this.zzv(Status.zzftt);
            }
        }
        catch (InterruptedException interruptedException) {
            this.zzv(Status.zzftr);
        }
        zzbq.zza((boolean)this.isReady(), (Object)"Result is not ready.");
        return this.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setResultCallback(ResultCallback<? super R> resultCallback) {
        Object object = this.zzfvc;
        synchronized (object) {
            if (resultCallback == null) {
                this.zzfvg = null;
                return;
            }
            zzbq.zza((!this.zzfvi ? 1 : 0) != 0, (Object)"Result has already been consumed.");
            zzbq.zza((this.zzfvl == null ? 1 : 0) != 0, (Object)"Cannot set callbacks if then() has been called.");
            if (((PendingResult)this).isCanceled()) {
                return;
            }
            if (this.isReady()) {
                this.zzfvd.zza(resultCallback, (R)this.get());
            } else {
                this.zzfvg = resultCallback;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setResultCallback(ResultCallback<? super R> resultCallback, long l, TimeUnit timeUnit) {
        Object object = this.zzfvc;
        synchronized (object) {
            if (resultCallback == null) {
                this.zzfvg = null;
                return;
            }
            zzbq.zza((!this.zzfvi ? 1 : 0) != 0, (Object)"Result has already been consumed.");
            zzbq.zza((this.zzfvl == null ? 1 : 0) != 0, (Object)"Cannot set callbacks if then() has been called.");
            if (((PendingResult)this).isCanceled()) {
                return;
            }
            if (this.isReady()) {
                this.zzfvd.zza(resultCallback, (R)this.get());
            } else {
                this.zzfvg = resultCallback;
                long l2 = timeUnit.toMillis(l);
                BasePendingResult basePendingResult = this;
                zza<R> zza2 = this.zzfvd;
                zza2.sendMessageDelayed(zza2.obtainMessage(2, basePendingResult), l2);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Hide
    public final void zza(PendingResult.zza zza2) {
        zzbq.checkArgument((zza2 != null ? 1 : 0) != 0, (Object)"Callback cannot be null.");
        Object object = this.zzfvc;
        synchronized (object) {
            if (this.isReady()) {
                zza2.zzr(this.mStatus);
            } else {
                this.zzfvf.add(zza2);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        Object object = this.zzfvc;
        synchronized (object) {
            if (this.zzam || this.zzfvi) {
                return;
            }
            if (this.zzfvk != null) {
                try {
                    this.zzfvk.cancel();
                }
                catch (RemoteException remoteException) {}
            }
            BasePendingResult.zzd(this.zzftm);
            this.zzam = true;
            this.zzc(this.zzb(Status.zzftu));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Hide
    public final boolean zzaip() {
        Object object = this.zzfvc;
        synchronized (object) {
            if ((GoogleApiClient)this.zzfve.get() == null || !this.zzfvm) {
                ((PendingResult)this).cancel();
            }
            return ((PendingResult)this).isCanceled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCanceled() {
        Object object = this.zzfvc;
        synchronized (object) {
            return this.zzam;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Hide
    public <S extends Result> TransformedResult<S> then(ResultTransform<? super R, ? extends S> resultTransform) {
        zzbq.zza((!this.zzfvi ? 1 : 0) != 0, (Object)"Result has already been consumed.");
        Object object = this.zzfvc;
        synchronized (object) {
            zzbq.zza((this.zzfvl == null ? 1 : 0) != 0, (Object)"Cannot call then() twice.");
            zzbq.zza((this.zzfvg == null ? 1 : 0) != 0, (Object)"Cannot call then() if callbacks are set.");
            zzbq.zza((!this.zzam ? 1 : 0) != 0, (Object)"Cannot call then() if result was canceled.");
            this.zzfvm = true;
            this.zzfvl = new zzdh(this.zzfve);
            TransformedResult<? extends S> transformedResult = ((TransformedResult)this.zzfvl).then(resultTransform);
            if (this.isReady()) {
                this.zzfvd.zza(this.zzfvl, this.get());
            } else {
                this.zzfvg = this.zzfvl;
            }
            return transformedResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Hide
    public final void setResult(R r) {
        Object object = this.zzfvc;
        synchronized (object) {
            if (!this.zzfvj && !this.zzam) {
                if (this.isReady()) {
                    // empty if block
                }
            } else {
                BasePendingResult.zzd(r);
                return;
            }
            zzbq.zza((!this.isReady() ? 1 : 0) != 0, (Object)"Results have already been set");
            zzbq.zza((!this.zzfvi ? 1 : 0) != 0, (Object)"Result has already been consumed");
            this.zzc(r);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Hide
    public final void zzv(Status status) {
        Object object = this.zzfvc;
        synchronized (object) {
            if (!this.isReady()) {
                this.setResult(this.zzb(status));
                this.zzfvj = true;
            }
            return;
        }
    }

    @Hide
    @NonNull
    protected abstract R zzb(Status var1);

    @Hide
    public final void zza(zzdn zzdn2) {
        this.zzfvh.set(zzdn2);
    }

    @Override
    @Hide
    public final Integer zzaid() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Hide
    protected final void zza(zzaq zzaq2) {
        Object object = this.zzfvc;
        synchronized (object) {
            this.zzfvk = zzaq2;
            return;
        }
    }

    @Hide
    public final void zzaiq() {
        this.zzfvm = this.zzfvm || zzfvb.get() != false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final R get() {
        R r;
        Object object = this.zzfvc;
        synchronized (object) {
            zzbq.zza((!this.zzfvi ? 1 : 0) != 0, (Object)"Result has already been consumed.");
            zzbq.zza((boolean)this.isReady(), (Object)"Result is not ready.");
            r = this.zzftm;
            this.zzftm = null;
            this.zzfvg = null;
            this.zzfvi = true;
        }
        BasePendingResult basePendingResult = this;
        zzdn zzdn2 = basePendingResult.zzfvh.getAndSet(null);
        if (zzdn2 != null) {
            zzdn2.zzc(basePendingResult);
        }
        return r;
    }

    private final void zzc(R r) {
        this.zzftm = r;
        this.zzfvk = null;
        this.zzapc.countDown();
        this.mStatus = this.zzftm.getStatus();
        if (this.zzam) {
            this.zzfvg = null;
        } else if (this.zzfvg == null) {
            if (this.zzftm instanceof Releasable) {
                this.mResultGuardian = new zzb(this, null);
            }
        } else {
            this.zzfvd.removeMessages(2);
            this.zzfvd.zza(this.zzfvg, (R)this.get());
        }
        ArrayList<PendingResult.zza> arrayList = this.zzfvf;
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            PendingResult.zza zza2 = arrayList.get(i);
            zza2.zzr(this.mStatus);
        }
        this.zzfvf.clear();
    }

    @Hide
    public static void zzd(Result result) {
        if (result instanceof Releasable) {
            try {
                ((Releasable)result).release();
                return;
            }
            catch (RuntimeException runtimeException) {
                String string2 = String.valueOf(result);
                Log.w((String)"BasePendingResult", (String)new StringBuilder(18 + String.valueOf(string2).length()).append("Unable to release ").append(string2).toString(), (Throwable)runtimeException);
            }
        }
    }

    final class zzb {
        private /* synthetic */ BasePendingResult zzfvn;

        private zzb(BasePendingResult basePendingResult) {
            this.zzfvn = basePendingResult;
        }

        protected final void finalize() throws Throwable {
            BasePendingResult.zzd(this.zzfvn.zzftm);
            super.finalize();
        }

        /* synthetic */ zzb(BasePendingResult basePendingResult, zzs zzs2) {
            this(basePendingResult);
        }
    }

    @Hide
    public static final class zza<R extends Result>
    extends Handler {
        public zza() {
            this(Looper.getMainLooper());
        }

        public zza(Looper looper) {
            super(looper);
        }

        public final void zza(ResultCallback<? super R> resultCallback, R r) {
            this.sendMessage(this.obtainMessage(1, new Pair(resultCallback, r)));
        }

        public final void handleMessage(Message message) {
            switch (message.what) {
                case 1: {
                    Pair pair = (Pair)message.obj;
                    Result result = (Result)pair.second;
                    ResultCallback resultCallback = (ResultCallback)pair.first;
                    try {
                        resultCallback.onResult(result);
                        return;
                    }
                    catch (RuntimeException runtimeException) {
                        BasePendingResult.zzd(result);
                        throw runtimeException;
                    }
                }
                case 2: {
                    ((BasePendingResult)message.obj).zzv(Status.zzftt);
                    return;
                }
            }
            int n = message.what;
            Log.wtf((String)"BasePendingResult", (String)new StringBuilder(45).append("Don't know how to handle message: ").append(n).toString(), (Throwable)new Exception());
        }
    }
}

