/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.v4.app.FragmentActivity;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.BasePendingResult;
import com.google.android.gms.common.api.internal.zzaa;
import com.google.android.gms.common.api.internal.zzbb;
import com.google.android.gms.common.api.internal.zzbc;
import com.google.android.gms.common.api.internal.zzbd;
import com.google.android.gms.common.api.internal.zzbe;
import com.google.android.gms.common.api.internal.zzbf;
import com.google.android.gms.common.api.internal.zzbg;
import com.google.android.gms.common.api.internal.zzbi;
import com.google.android.gms.common.api.internal.zzbx;
import com.google.android.gms.common.api.internal.zzcc;
import com.google.android.gms.common.api.internal.zzcd;
import com.google.android.gms.common.api.internal.zzce;
import com.google.android.gms.common.api.internal.zzci;
import com.google.android.gms.common.api.internal.zzcm;
import com.google.android.gms.common.api.internal.zzcu;
import com.google.android.gms.common.api.internal.zzdb;
import com.google.android.gms.common.api.internal.zzdh;
import com.google.android.gms.common.api.internal.zzdk;
import com.google.android.gms.common.api.internal.zzdn;
import com.google.android.gms.common.api.internal.zzi;
import com.google.android.gms.common.api.internal.zzm;
import com.google.android.gms.common.api.internal.zzt;
import com.google.android.gms.common.api.internal.zzv;
import com.google.android.gms.common.internal.zzae;
import com.google.android.gms.common.internal.zzaf;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.internal.zzr;
import com.google.android.gms.common.zzf;
import com.google.android.gms.internal.zzbgs;
import com.google.android.gms.internal.zzcyj;
import com.google.android.gms.internal.zzcyk;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;

public final class zzba
extends GoogleApiClient
implements zzcd {
    private final Lock zzfwa;
    private boolean zzftk;
    private final zzae zzfyc;
    private zzcc zzfyd = null;
    private final int zzfte;
    private final Context mContext;
    private final Looper zzalj;
    final Queue<zzm<?, ?>> zzfwo = new LinkedList();
    private volatile boolean zzfye;
    private long zzfyf = 120000L;
    private long zzfyg = 5000L;
    private final zzbf zzfyh;
    private final GoogleApiAvailability zzftg;
    private zzbx zzfyi;
    final Map<Api.zzc<?>, Api.zze> zzfyj;
    Set<Scope> zzfyk = new HashSet<Scope>();
    private zzr zzfwf;
    private Map<Api<?>, Boolean> zzfwi;
    private Api.zza<? extends zzcyj, zzcyk> zzfth;
    private final zzcm zzfyl = new zzcm();
    private final ArrayList<zzt> zzfym;
    private Integer zzfyn = null;
    Set<zzdh> zzfyo = null;
    final zzdk zzfyp;
    private final zzaf zzfyq = new zzbb(this);

    public zzba(Context context, Lock lock, Looper looper, zzr zzr2, GoogleApiAvailability googleApiAvailability, Api.zza<? extends zzcyj, zzcyk> zza2, Map<Api<?>, Boolean> map, List<GoogleApiClient.ConnectionCallbacks> list, List<GoogleApiClient.OnConnectionFailedListener> list2, Map<Api.zzc<?>, Api.zze> map2, int n, int n2, ArrayList<zzt> arrayList, boolean bl) {
        this.mContext = context;
        this.zzfwa = lock;
        this.zzftk = false;
        this.zzfyc = new zzae(looper, this.zzfyq);
        this.zzalj = looper;
        this.zzfyh = new zzbf(this, looper);
        this.zzftg = googleApiAvailability;
        this.zzfte = n;
        if (this.zzfte >= 0) {
            this.zzfyn = n2;
        }
        this.zzfwi = map;
        this.zzfyj = map2;
        this.zzfym = arrayList;
        this.zzfyp = new zzdk(this.zzfyj);
        for (GoogleApiClient.ConnectionCallbacks object : list) {
            this.zzfyc.registerConnectionCallbacks(object);
        }
        for (GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener : list2) {
            this.zzfyc.registerConnectionFailedListener(onConnectionFailedListener);
        }
        this.zzfwf = zzr2;
        this.zzfth = zza2;
    }

    @Override
    public final <A extends Api.zzb, R extends Result, T extends zzm<R, A>> T zzd(@NonNull T t) {
        zzbq.checkArgument((t.zzahm() != null ? 1 : 0) != 0, (Object)"This task can not be enqueued (it's probably a Batch or malformed)");
        String string2 = t.zzaht() != null ? t.zzaht().getName() : "the API";
        zzbq.checkArgument((boolean)this.zzfyj.containsKey(t.zzahm()), (Object)new StringBuilder(65 + String.valueOf(string2).length()).append("GoogleApiClient is not configured to use ").append(string2).append(" required for this call.").toString());
        this.zzfwa.lock();
        try {
            if (this.zzfyd == null) {
                this.zzfwo.add(t);
                string2 = t;
                return (T)string2;
            }
            string2 = this.zzfyd.zzd(t);
            return (T)string2;
        }
        finally {
            this.zzfwa.unlock();
        }
    }

    @Override
    public final <A extends Api.zzb, T extends zzm<? extends Result, A>> T zze(@NonNull T t) {
        zzbq.checkArgument((t.zzahm() != null ? 1 : 0) != 0, (Object)"This task can not be executed (it's probably a Batch or malformed)");
        Object object = t.zzaht() != null ? t.zzaht().getName() : "the API";
        zzbq.checkArgument((boolean)this.zzfyj.containsKey(t.zzahm()), (Object)new StringBuilder(65 + String.valueOf(object).length()).append("GoogleApiClient is not configured to use ").append((String)object).append(" required for this call.").toString());
        this.zzfwa.lock();
        try {
            if (this.zzfyd == null) {
                throw new IllegalStateException("GoogleApiClient is not connected yet.");
            }
            if (this.zzfye) {
                this.zzfwo.add(t);
                while (!this.zzfwo.isEmpty()) {
                    object = this.zzfwo.remove();
                    this.zzfyp.zzb((BasePendingResult<? extends Result>)object);
                    ((zzm)object).zzu(Status.zzfts);
                }
                object = t;
                return (T)object;
            }
            object = this.zzfyd.zze(t);
            return (T)object;
        }
        finally {
            this.zzfwa.unlock();
        }
    }

    @Override
    public final <L> zzci<L> zzt(@NonNull L l) {
        this.zzfwa.lock();
        try {
            Looper looper = this.zzalj;
            L l2 = l;
            zzci<L> zzci2 = this.zzfyl.zza(l2, looper, "NO_TYPE");
            return zzci2;
        }
        finally {
            this.zzfwa.unlock();
        }
    }

    @Override
    @NonNull
    public final <C extends Api.zze> C zza(@NonNull Api.zzc<C> zzc2) {
        Api.zze zze2 = this.zzfyj.get(zzc2);
        zzbq.checkNotNull((Object)zze2, (Object)"Appropriate Api was not requested.");
        return (C)zze2;
    }

    @Override
    public final boolean zza(@NonNull Api<?> api) {
        return this.zzfyj.containsKey(api.zzahm());
    }

    @Override
    public final boolean hasConnectedApi(@NonNull Api<?> api) {
        if (!((GoogleApiClient)this).isConnected()) {
            return false;
        }
        Api.zze zze2 = this.zzfyj.get(api.zzahm());
        return zze2 != null && zze2.isConnected();
    }

    @Override
    @NonNull
    public final ConnectionResult getConnectionResult(@NonNull Api<?> api) {
        block6: {
            ConnectionResult connectionResult;
            block7: {
                block8: {
                    this.zzfwa.lock();
                    if (!((GoogleApiClient)this).isConnected() && !this.zzfye) {
                        throw new IllegalStateException("Cannot invoke getConnectionResult unless GoogleApiClient is connected");
                    }
                    if (!this.zzfyj.containsKey(api.zzahm())) break block6;
                    connectionResult = this.zzfyd.getConnectionResult(api);
                    if (connectionResult != null) break block7;
                    if (!this.zzfye) break block8;
                    ConnectionResult connectionResult2 = ConnectionResult.zzfqt;
                    this.zzfwa.unlock();
                    return connectionResult2;
                }
                Log.w((String)"GoogleApiClientImpl", (String)this.zzaju());
                Log.wtf((String)"GoogleApiClientImpl", (String)String.valueOf(api.getName()).concat(" requested in getConnectionResult is not connected but is not present in the failed  connections map"), (Throwable)new Exception());
                ConnectionResult connectionResult3 = new ConnectionResult(8, null);
                return connectionResult3;
            }
            ConnectionResult connectionResult4 = connectionResult;
            this.zzfwa.unlock();
            return connectionResult4;
        }
        try {
            throw new IllegalArgumentException(String.valueOf(api.getName()).concat(" was never registered with GoogleApiClient"));
        }
        finally {
            this.zzfwa.unlock();
        }
    }

    @Override
    public final void connect() {
        this.zzfwa.lock();
        try {
            if (this.zzfte >= 0) {
                zzbq.zza((this.zzfyn != null ? 1 : 0) != 0, (Object)"Sign-in mode should have been set explicitly by auto-manage.");
            } else if (this.zzfyn == null) {
                this.zzfyn = zzba.zza(this.zzfyj.values(), false);
            } else if (this.zzfyn == 2) {
                throw new IllegalStateException("Cannot call connect() when SignInMode is set to SIGN_IN_MODE_OPTIONAL. Call connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            ((GoogleApiClient)this).connect(this.zzfyn);
            return;
        }
        finally {
            this.zzfwa.unlock();
        }
    }

    @Override
    public final void connect(int n) {
        this.zzfwa.lock();
        try {
            zzbq.checkArgument((n == 3 || n == 1 || n == 2 ? 1 : 0) != 0, (Object)new StringBuilder(33).append("Illegal sign-in mode: ").append(n).toString());
            this.zzbu(n);
            this.zzajq();
            return;
        }
        finally {
            this.zzfwa.unlock();
        }
    }

    @Override
    public final ConnectionResult blockingConnect() {
        zzbq.zza((Looper.myLooper() != Looper.getMainLooper() ? 1 : 0) != 0, (Object)"blockingConnect must not be called on the UI thread");
        this.zzfwa.lock();
        try {
            if (this.zzfte >= 0) {
                zzbq.zza((this.zzfyn != null ? 1 : 0) != 0, (Object)"Sign-in mode should have been set explicitly by auto-manage.");
            } else if (this.zzfyn == null) {
                this.zzfyn = zzba.zza(this.zzfyj.values(), false);
            } else if (this.zzfyn == 2) {
                throw new IllegalStateException("Cannot call blockingConnect() when sign-in mode is set to SIGN_IN_MODE_OPTIONAL. Call connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            this.zzbu(this.zzfyn);
            this.zzfyc.zzamt();
            ConnectionResult connectionResult = this.zzfyd.blockingConnect();
            return connectionResult;
        }
        finally {
            this.zzfwa.unlock();
        }
    }

    @Override
    public final ConnectionResult blockingConnect(long l, @NonNull TimeUnit timeUnit) {
        zzbq.zza((Looper.myLooper() != Looper.getMainLooper() ? 1 : 0) != 0, (Object)"blockingConnect must not be called on the UI thread");
        zzbq.checkNotNull((Object)((Object)timeUnit), (Object)"TimeUnit must not be null");
        this.zzfwa.lock();
        try {
            if (this.zzfyn == null) {
                this.zzfyn = zzba.zza(this.zzfyj.values(), false);
            } else if (this.zzfyn == 2) {
                throw new IllegalStateException("Cannot call blockingConnect() when sign-in mode is set to SIGN_IN_MODE_OPTIONAL. Call connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            this.zzbu(this.zzfyn);
            this.zzfyc.zzamt();
            ConnectionResult connectionResult = this.zzfyd.blockingConnect(l, timeUnit);
            return connectionResult;
        }
        finally {
            this.zzfwa.unlock();
        }
    }

    @Override
    public final void disconnect() {
        this.zzfwa.lock();
        try {
            this.zzfyp.release();
            if (this.zzfyd != null) {
                this.zzfyd.disconnect();
            }
            this.zzfyl.release();
            for (zzm zzm2 : this.zzfwo) {
                ((BasePendingResult)zzm2).zza((zzdn)null);
                ((PendingResult)zzm2).cancel();
            }
            this.zzfwo.clear();
            if (this.zzfyd == null) {
                return;
            }
            this.zzajs();
            this.zzfyc.zzams();
            return;
        }
        finally {
            this.zzfwa.unlock();
        }
    }

    @Override
    public final void reconnect() {
        ((GoogleApiClient)this).disconnect();
        ((GoogleApiClient)this).connect();
    }

    @Override
    public final PendingResult<Status> clearDefaultAccountAndReconnect() {
        zzbq.zza((boolean)((GoogleApiClient)this).isConnected(), (Object)"GoogleApiClient is not connected yet.");
        zzbq.zza((this.zzfyn != 2 ? 1 : 0) != 0, (Object)"Cannot use clearDefaultAccountAndReconnect with GOOGLE_SIGN_IN_API");
        zzdb zzdb2 = new zzdb(this);
        if (this.zzfyj.containsKey(zzbgs.zzegu)) {
            this.zza(this, zzdb2, false);
        } else {
            AtomicReference<GoogleApiClient> atomicReference = new AtomicReference<GoogleApiClient>();
            zzbc zzbc2 = new zzbc(this, atomicReference, zzdb2);
            zzbd zzbd2 = new zzbd(this, zzdb2);
            GoogleApiClient googleApiClient = new GoogleApiClient.Builder(this.mContext).addApi(zzbgs.API).addConnectionCallbacks(zzbc2).addOnConnectionFailedListener(zzbd2).setHandler(this.zzfyh).build();
            atomicReference.set(googleApiClient);
            googleApiClient.connect();
        }
        return zzdb2;
    }

    private final void zza(GoogleApiClient googleApiClient, zzdb zzdb2, boolean bl) {
        zzbgs.zzgif.zzd(googleApiClient).setResultCallback(new zzbe(this, zzdb2, bl, googleApiClient));
    }

    @Override
    public final void stopAutoManage(@NonNull FragmentActivity fragmentActivity) {
        zzce zzce2 = new zzce((Activity)fragmentActivity);
        zzba zzba2 = this;
        if (zzba2.zzfte >= 0) {
            zzi.zza(zzce2).zzbq(zzba2.zzfte);
            return;
        }
        throw new IllegalStateException("Called stopAutoManage but automatic lifecycle management is not enabled.");
    }

    @Override
    public final boolean isConnected() {
        return this.zzfyd != null && this.zzfyd.isConnected();
    }

    @Override
    public final boolean isConnecting() {
        return this.zzfyd != null && this.zzfyd.isConnecting();
    }

    private final void zzbu(int n) {
        if (this.zzfyn == null) {
            this.zzfyn = n;
        } else if (this.zzfyn != n) {
            String string2 = zzba.zzbv(n);
            String string3 = zzba.zzbv(this.zzfyn);
            throw new IllegalStateException(new StringBuilder(51 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Cannot use sign-in mode: ").append(string2).append(". Mode was already set to ").append(string3).toString());
        }
        if (this.zzfyd != null) {
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        for (Api.zze zze2 : this.zzfyj.values()) {
            if (zze2.zzacc()) {
                bl = true;
            }
            if (!zze2.zzacn()) continue;
            bl2 = true;
        }
        switch (this.zzfyn) {
            case 3: {
                break;
            }
            case 1: {
                if (!bl) {
                    throw new IllegalStateException("SIGN_IN_MODE_REQUIRED cannot be used on a GoogleApiClient that does not contain any authenticated APIs. Use connect() instead.");
                }
                if (!bl2) break;
                throw new IllegalStateException("Cannot use SIGN_IN_MODE_REQUIRED with GOOGLE_SIGN_IN_API. Use connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            case 2: {
                if (!bl) break;
                if (this.zzftk) {
                    this.zzfyd = new zzaa(this.mContext, this.zzfwa, this.zzalj, this.zzftg, this.zzfyj, this.zzfwf, this.zzfwi, this.zzfth, this.zzfym, this, true);
                    return;
                }
                this.zzfyd = zzv.zza(this.mContext, this, this.zzfwa, this.zzalj, this.zzftg, this.zzfyj, this.zzfwf, this.zzfwi, this.zzfth, this.zzfym);
                return;
            }
        }
        if (this.zzftk && !bl2) {
            this.zzfyd = new zzaa(this.mContext, this.zzfwa, this.zzalj, this.zzftg, this.zzfyj, this.zzfwf, this.zzfwi, this.zzfth, this.zzfym, this, false);
            return;
        }
        this.zzfyd = new zzbi(this.mContext, this, this.zzfwa, this.zzalj, this.zzftg, this.zzfyj, this.zzfwf, this.zzfwi, this.zzfth, this.zzfym, this);
    }

    private final void zzajq() {
        this.zzfyc.zzamt();
        this.zzfyd.connect();
    }

    private final void resume() {
        this.zzfwa.lock();
        try {
            if (this.zzfye) {
                this.zzajq();
            }
            return;
        }
        finally {
            this.zzfwa.unlock();
        }
    }

    private final void zzajr() {
        this.zzfwa.lock();
        try {
            if (this.zzajs()) {
                this.zzajq();
            }
            return;
        }
        finally {
            this.zzfwa.unlock();
        }
    }

    final boolean zzajs() {
        if (!this.zzfye) {
            return false;
        }
        this.zzfye = false;
        this.zzfyh.removeMessages(2);
        this.zzfyh.removeMessages(1);
        if (this.zzfyi != null) {
            this.zzfyi.unregister();
            this.zzfyi = null;
        }
        return true;
    }

    @Override
    public final void registerConnectionCallbacks(@NonNull GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        this.zzfyc.registerConnectionCallbacks(connectionCallbacks);
    }

    @Override
    public final boolean isConnectionCallbacksRegistered(@NonNull GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        return this.zzfyc.isConnectionCallbacksRegistered(connectionCallbacks);
    }

    @Override
    public final void unregisterConnectionCallbacks(@NonNull GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        this.zzfyc.unregisterConnectionCallbacks(connectionCallbacks);
    }

    @Override
    public final void registerConnectionFailedListener(@NonNull GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        this.zzfyc.registerConnectionFailedListener(onConnectionFailedListener);
    }

    @Override
    public final boolean isConnectionFailedListenerRegistered(@NonNull GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        return this.zzfyc.isConnectionFailedListenerRegistered(onConnectionFailedListener);
    }

    @Override
    public final void unregisterConnectionFailedListener(@NonNull GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        this.zzfyc.unregisterConnectionFailedListener(onConnectionFailedListener);
    }

    @Override
    public final void zzk(Bundle bundle) {
        while (!this.zzfwo.isEmpty()) {
            ((GoogleApiClient)this).zze(this.zzfwo.remove());
        }
        this.zzfyc.zzl(bundle);
    }

    @Override
    public final void zzc(ConnectionResult connectionResult) {
        if (!zzf.zzd((Context)this.mContext, (int)connectionResult.getErrorCode())) {
            this.zzajs();
        }
        if (!this.zzfye) {
            this.zzfyc.zzk(connectionResult);
            this.zzfyc.zzams();
        }
    }

    @Override
    public final void zzf(int n, boolean bl) {
        if (n == 1 && !bl) {
            zzba zzba2 = this;
            if (!zzba2.zzfye) {
                zzba2.zzfye = true;
                if (zzba2.zzfyi == null) {
                    zzba2.zzfyi = GoogleApiAvailability.zza(zzba2.mContext.getApplicationContext(), new zzbg(zzba2));
                }
                zzba2.zzfyh.sendMessageDelayed(zzba2.zzfyh.obtainMessage(1), zzba2.zzfyf);
                zzba2.zzfyh.sendMessageDelayed(zzba2.zzfyh.obtainMessage(2), zzba2.zzfyg);
            }
        }
        this.zzfyp.zzald();
        this.zzfyc.zzcf(n);
        this.zzfyc.zzams();
        if (n == 2) {
            this.zzajq();
        }
    }

    @Override
    public final Context getContext() {
        return this.mContext;
    }

    @Override
    public final Looper getLooper() {
        return this.zzalj;
    }

    @Override
    public final boolean zza(zzcu zzcu2) {
        return this.zzfyd != null && this.zzfyd.zza(zzcu2);
    }

    @Override
    public final void zzaia() {
        if (this.zzfyd != null) {
            this.zzfyd.zzaia();
        }
    }

    @Override
    public final void zza(zzdh zzdh2) {
        this.zzfwa.lock();
        try {
            if (this.zzfyo == null) {
                this.zzfyo = new HashSet<zzdh>();
            }
            this.zzfyo.add(zzdh2);
            return;
        }
        finally {
            this.zzfwa.unlock();
        }
    }

    @Override
    public final void zzb(zzdh zzdh2) {
        this.zzfwa.lock();
        try {
            if (this.zzfyo == null) {
                Log.wtf((String)"GoogleApiClientImpl", (String)"Attempted to remove pending transform when no transforms are registered.", (Throwable)new Exception());
            } else if (!this.zzfyo.remove(zzdh2)) {
                Log.wtf((String)"GoogleApiClientImpl", (String)"Failed to remove pending transform - this may lead to memory leaks!", (Throwable)new Exception());
            } else if (!this.zzajt()) {
                this.zzfyd.zzais();
            }
            return;
        }
        finally {
            this.zzfwa.unlock();
        }
    }

    final boolean zzajt() {
        this.zzfwa.lock();
        try {
            if (this.zzfyo == null) {
                return false;
            }
            boolean bl = !this.zzfyo.isEmpty();
            return bl;
        }
        finally {
            this.zzfwa.unlock();
        }
    }

    final String zzaju() {
        StringWriter stringWriter = new StringWriter();
        ((GoogleApiClient)this).dump("", null, new PrintWriter(stringWriter), null);
        return stringWriter.toString();
    }

    @Override
    public final void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        printWriter.append(string2).append("mContext=").println(this.mContext);
        printWriter.append(string2).append("mResuming=").print(this.zzfye);
        printWriter.append(" mWorkQueue.size()=").print(this.zzfwo.size());
        PrintWriter printWriter2 = printWriter;
        zzdk zzdk2 = this.zzfyp;
        printWriter2.append(" mUnconsumedApiCalls.size()=").println(zzdk2.zzgbs.size());
        if (this.zzfyd != null) {
            this.zzfyd.dump(string2, fileDescriptor, printWriter, stringArray);
        }
    }

    public static int zza(Iterable<Api.zze> iterable, boolean bl) {
        boolean bl2 = false;
        boolean bl3 = false;
        for (Api.zze zze2 : iterable) {
            if (zze2.zzacc()) {
                bl2 = true;
            }
            if (!zze2.zzacn()) continue;
            bl3 = true;
        }
        if (bl2) {
            if (bl3 && bl) {
                return 2;
            }
            return 1;
        }
        return 3;
    }

    private static String zzbv(int n) {
        switch (n) {
            case 3: {
                return "SIGN_IN_MODE_NONE";
            }
            case 1: {
                return "SIGN_IN_MODE_REQUIRED";
            }
            case 2: {
                return "SIGN_IN_MODE_OPTIONAL";
            }
        }
        return "UNKNOWN";
    }

    static /* synthetic */ void zza(zzba zzba2) {
        zzba2.resume();
    }

    static /* synthetic */ void zzb(zzba zzba2) {
        zzba2.zzajr();
    }

    static /* synthetic */ void zza(zzba zzba2, GoogleApiClient googleApiClient, zzdb zzdb2, boolean bl) {
        zzba2.zza(googleApiClient, zzdb2, true);
    }

    static /* synthetic */ Context zzc(zzba zzba2) {
        return zzba2.mContext;
    }
}

