/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.internal.zzal;
import com.google.android.gms.common.api.internal.zzao;
import com.google.android.gms.common.api.internal.zzaz;
import com.google.android.gms.common.api.internal.zzba;
import com.google.android.gms.common.api.internal.zzbh;
import com.google.android.gms.common.api.internal.zzbj;
import com.google.android.gms.common.api.internal.zzbk;
import com.google.android.gms.common.api.internal.zzcc;
import com.google.android.gms.common.api.internal.zzcd;
import com.google.android.gms.common.api.internal.zzcu;
import com.google.android.gms.common.api.internal.zzm;
import com.google.android.gms.common.api.internal.zzt;
import com.google.android.gms.common.api.internal.zzu;
import com.google.android.gms.common.internal.zzr;
import com.google.android.gms.common.zzf;
import com.google.android.gms.internal.zzcyj;
import com.google.android.gms.internal.zzcyk;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;

public final class zzbi
implements zzcc,
zzu {
    private final Lock zzfwa;
    private final Condition zzfyw;
    private final Context mContext;
    private final zzf zzfwk;
    private final zzbk zzfyx;
    final Map<Api.zzc<?>, Api.zze> zzfyj;
    final Map<Api.zzc<?>, ConnectionResult> zzfyy = new HashMap();
    private zzr zzfwf;
    private Map<Api<?>, Boolean> zzfwi;
    private Api.zza<? extends zzcyj, zzcyk> zzfth;
    private volatile zzbh zzfyz;
    private ConnectionResult zzfza = null;
    int zzfzb;
    final zzba zzfvq;
    final zzcd zzfzc;

    public zzbi(Context context, zzba zzba2, Lock lock, Looper looper, zzf zzf2, Map<Api.zzc<?>, Api.zze> map, zzr zzr2, Map<Api<?>, Boolean> map2, Api.zza<? extends zzcyj, zzcyk> zza2, ArrayList<zzt> arrayList, zzcd zzcd2) {
        this.mContext = context;
        this.zzfwa = lock;
        this.zzfwk = zzf2;
        this.zzfyj = map;
        this.zzfwf = zzr2;
        this.zzfwi = map2;
        this.zzfth = zza2;
        this.zzfvq = zzba2;
        this.zzfzc = zzcd2;
        ArrayList<zzt> arrayList2 = arrayList;
        int n = arrayList2.size();
        for (int i = 0; i < n; ++i) {
            zzt zzt2 = arrayList2.get(i);
            zzt2.zza(this);
        }
        this.zzfyx = new zzbk(this, looper);
        this.zzfyw = lock.newCondition();
        this.zzfyz = new zzaz(this);
    }

    @Override
    public final <A extends Api.zzb, R extends Result, T extends zzm<R, A>> T zzd(@NonNull T t) {
        t.zzaiq();
        return this.zzfyz.zzd(t);
    }

    @Override
    public final <A extends Api.zzb, T extends zzm<? extends Result, A>> T zze(@NonNull T t) {
        t.zzaiq();
        return this.zzfyz.zze(t);
    }

    @Override
    public final void connect() {
        this.zzfyz.connect();
    }

    @Override
    public final ConnectionResult blockingConnect() {
        this.connect();
        while (this.isConnecting()) {
            try {
                this.zzfyw.await();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return new ConnectionResult(15, null);
            }
        }
        if (this.isConnected()) {
            return ConnectionResult.zzfqt;
        }
        if (this.zzfza != null) {
            return this.zzfza;
        }
        return new ConnectionResult(13, null);
    }

    @Override
    public final ConnectionResult blockingConnect(long l, TimeUnit timeUnit) {
        this.connect();
        long l2 = timeUnit.toNanos(l);
        while (this.isConnecting()) {
            try {
                if (l2 <= 0L) {
                    this.disconnect();
                    return new ConnectionResult(14, null);
                }
                l2 = this.zzfyw.awaitNanos(l2);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return new ConnectionResult(15, null);
            }
        }
        if (this.isConnected()) {
            return ConnectionResult.zzfqt;
        }
        if (this.zzfza != null) {
            return this.zzfza;
        }
        return new ConnectionResult(13, null);
    }

    @Override
    public final void disconnect() {
        if (this.zzfyz.disconnect()) {
            this.zzfyy.clear();
        }
    }

    @Override
    @Nullable
    public final ConnectionResult getConnectionResult(@NonNull Api<?> api) {
        Api.zzc<?> zzc2 = api.zzahm();
        if (this.zzfyj.containsKey(zzc2)) {
            if (this.zzfyj.get(zzc2).isConnected()) {
                return ConnectionResult.zzfqt;
            }
            if (this.zzfyy.containsKey(zzc2)) {
                return this.zzfyy.get(zzc2);
            }
        }
        return null;
    }

    final void zzajv() {
        this.zzfwa.lock();
        try {
            this.zzfyz = new zzao(this, this.zzfwf, this.zzfwi, this.zzfwk, this.zzfth, this.zzfwa, this.mContext);
            this.zzfyz.begin();
            this.zzfyw.signalAll();
            return;
        }
        finally {
            this.zzfwa.unlock();
        }
    }

    final void zzajw() {
        this.zzfwa.lock();
        try {
            this.zzfvq.zzajs();
            this.zzfyz = new zzal(this);
            this.zzfyz.begin();
            this.zzfyw.signalAll();
            return;
        }
        finally {
            this.zzfwa.unlock();
        }
    }

    final void zzg(ConnectionResult connectionResult) {
        this.zzfwa.lock();
        try {
            this.zzfza = connectionResult;
            this.zzfyz = new zzaz(this);
            this.zzfyz.begin();
            this.zzfyw.signalAll();
            return;
        }
        finally {
            this.zzfwa.unlock();
        }
    }

    @Override
    public final boolean isConnected() {
        return this.zzfyz instanceof zzal;
    }

    @Override
    public final boolean isConnecting() {
        return this.zzfyz instanceof zzao;
    }

    @Override
    public final boolean zza(zzcu zzcu2) {
        return false;
    }

    @Override
    public final void zzaia() {
    }

    @Override
    public final void zzais() {
        if (this.isConnected()) {
            ((zzal)this.zzfyz).zzaji();
        }
    }

    @Override
    public final void zza(@NonNull ConnectionResult connectionResult, @NonNull Api<?> api, boolean bl) {
        this.zzfwa.lock();
        try {
            this.zzfyz.zza(connectionResult, api, bl);
            return;
        }
        finally {
            this.zzfwa.unlock();
        }
    }

    @Override
    public final void onConnected(@Nullable Bundle bundle) {
        this.zzfwa.lock();
        try {
            this.zzfyz.onConnected(bundle);
            return;
        }
        finally {
            this.zzfwa.unlock();
        }
    }

    @Override
    public final void onConnectionSuspended(int n) {
        this.zzfwa.lock();
        try {
            this.zzfyz.onConnectionSuspended(n);
            return;
        }
        finally {
            this.zzfwa.unlock();
        }
    }

    final void zza(zzbj zzbj2) {
        Message message = this.zzfyx.obtainMessage(1, zzbj2);
        this.zzfyx.sendMessage(message);
    }

    final void zzb(RuntimeException runtimeException) {
        Message message = this.zzfyx.obtainMessage(2, runtimeException);
        this.zzfyx.sendMessage(message);
    }

    @Override
    public final void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        String string3 = String.valueOf(string2).concat("  ");
        printWriter.append(string2).append("mState=").println(this.zzfyz);
        for (Api<?> api : this.zzfwi.keySet()) {
            printWriter.append(string2).append(api.getName()).println(":");
            this.zzfyj.get(api.zzahm()).dump(string3, fileDescriptor, printWriter, stringArray);
        }
    }

    static /* synthetic */ Lock zza(zzbi zzbi2) {
        return zzbi2.zzfwa;
    }

    static /* synthetic */ zzbh zzb(zzbi zzbi2) {
        return zzbi2.zzfyz;
    }
}

