/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.app.Application;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArraySet;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApi;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zzah;
import com.google.android.gms.common.api.internal.zzbn;
import com.google.android.gms.common.api.internal.zzbo;
import com.google.android.gms.common.api.internal.zzc;
import com.google.android.gms.common.api.internal.zzck;
import com.google.android.gms.common.api.internal.zzcp;
import com.google.android.gms.common.api.internal.zzcq;
import com.google.android.gms.common.api.internal.zzcr;
import com.google.android.gms.common.api.internal.zzd;
import com.google.android.gms.common.api.internal.zzda;
import com.google.android.gms.common.api.internal.zzde;
import com.google.android.gms.common.api.internal.zzdo;
import com.google.android.gms.common.api.internal.zze;
import com.google.android.gms.common.api.internal.zzf;
import com.google.android.gms.common.api.internal.zzh;
import com.google.android.gms.common.api.internal.zzj;
import com.google.android.gms.common.api.internal.zzk;
import com.google.android.gms.common.api.internal.zzl;
import com.google.android.gms.common.api.internal.zzm;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzcyj;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

@Hide
public final class zzbm
implements Handler.Callback {
    public static final Status zzfzg = new Status(4, "Sign-out occurred while this API call was in progress.");
    private static final Status zzfzh = new Status(4, "The user must be signed in to make this API call.");
    private long zzfyg = 5000L;
    private long zzfyf = 120000L;
    private long zzfzi = 10000L;
    private static final Object sLock = new Object();
    private static zzbm zzfzj;
    private final Context mContext;
    private final GoogleApiAvailability zzftg;
    private int zzfzk = -1;
    private final AtomicInteger zzfzl = new AtomicInteger(1);
    private final AtomicInteger zzfzm = new AtomicInteger(0);
    private final Map<zzh<?>, zzbo<?>> zzfwg = new ConcurrentHashMap(5, 0.75f, 1);
    private zzah zzfzn = null;
    private final Set<zzh<?>> zzfzo = new ArraySet();
    private final Set<zzh<?>> zzfzp = new ArraySet();
    private final Handler mHandler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzbm zzck(Context context) {
        Object object = sLock;
        synchronized (object) {
            if (zzfzj == null) {
                HandlerThread handlerThread = new HandlerThread("GoogleApiHandler", 9);
                handlerThread.start();
                Looper looper = handlerThread.getLooper();
                zzfzj = new zzbm(context.getApplicationContext(), looper, GoogleApiAvailability.getInstance());
            }
            return zzfzj;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzbm zzajy() {
        Object object = sLock;
        synchronized (object) {
            zzbq.checkNotNull((Object)zzfzj, (Object)"Must guarantee manager is non-null before using getInstance");
            return zzfzj;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zzajz() {
        Object object = sLock;
        synchronized (object) {
            if (zzfzj != null) {
                zzbm zzbm2 = zzfzj;
                zzbm2.zzfzm.incrementAndGet();
                zzbm2.mHandler.sendMessageAtFrontOfQueue(zzbm2.mHandler.obtainMessage(10));
            }
            return;
        }
    }

    private zzbm(Context context, Looper looper, GoogleApiAvailability googleApiAvailability) {
        this.mContext = context;
        this.mHandler = new Handler(looper, (Handler.Callback)this);
        this.zzftg = googleApiAvailability;
        this.mHandler.sendMessage(this.mHandler.obtainMessage(6));
    }

    public final int zzaka() {
        return this.zzfzl.getAndIncrement();
    }

    public final void zza(GoogleApi<?> googleApi) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(7, googleApi));
    }

    @WorkerThread
    private final void zzb(GoogleApi<?> googleApi) {
        zzh<?> zzh2 = googleApi.zzahv();
        zzbo<Object> zzbo2 = this.zzfwg.get(zzh2);
        if (zzbo2 == null) {
            zzbo2 = new zzbo(this, googleApi);
            this.zzfwg.put(zzh2, zzbo2);
        }
        if (zzbo2.zzacc()) {
            this.zzfzp.add(zzh2);
        }
        zzbo2.connect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(@NonNull zzah zzah2) {
        Object object = sLock;
        synchronized (object) {
            if (this.zzfzn != zzah2) {
                this.zzfzn = zzah2;
                this.zzfzo.clear();
                this.zzfzo.addAll((Collection<zzh<?>>)zzah2.zzajf());
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void zzb(@NonNull zzah zzah2) {
        Object object = sLock;
        synchronized (object) {
            if (this.zzfzn == zzah2) {
                this.zzfzn = null;
                this.zzfzo.clear();
            }
            return;
        }
    }

    public final Task<Map<zzh<?>, String>> zza(Iterable<? extends GoogleApi<?>> iterable) {
        zzj zzj2 = new zzj(iterable);
        for (GoogleApi<?> googleApi : iterable) {
            zzbo<?> zzbo2 = this.zzfwg.get(googleApi.zzahv());
            if (zzbo2 == null || !zzbo2.isConnected()) {
                this.mHandler.sendMessage(this.mHandler.obtainMessage(2, (Object)zzj2));
                return zzj2.getTask();
            }
            zzj2.zza(googleApi.zzahv(), ConnectionResult.zzfqt, zzbo2.zzaix().zzahp());
        }
        return zzj2.getTask();
    }

    public final void zzaih() {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(3));
    }

    final void zzaia() {
        this.zzfzm.incrementAndGet();
        this.mHandler.sendMessage(this.mHandler.obtainMessage(10));
    }

    @WorkerThread
    private final void zzakb() {
        for (zzh<?> zzh2 : this.zzfzp) {
            this.zzfwg.remove(zzh2).signOut();
        }
        this.zzfzp.clear();
    }

    public final <O extends Api.ApiOptions> void zza(GoogleApi<O> googleApi, int n, zzm<? extends Result, Api.zzb> zzm2) {
        zzc<zzm<? extends Result, Api.zzb>> zzc2 = new zzc<zzm<? extends Result, Api.zzb>>(n, zzm2);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(4, (Object)new zzcp(zzc2, this.zzfzm.get(), googleApi)));
    }

    public final <O extends Api.ApiOptions, TResult> void zza(GoogleApi<O> googleApi, int n, zzde<Api.zzb, TResult> zzde2, TaskCompletionSource<TResult> taskCompletionSource, zzda zzda2) {
        zze<TResult> zze2 = new zze<TResult>(n, zzde2, taskCompletionSource, zzda2);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(4, (Object)new zzcp(zze2, this.zzfzm.get(), googleApi)));
    }

    public final <O extends Api.ApiOptions> Task<Void> zza(@NonNull GoogleApi<O> googleApi, @NonNull zzcq<Api.zzb, ?> zzcq2, @NonNull zzdo<Api.zzb, ?> zzdo2) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        zzd zzd2 = new zzd(new zzcr(zzcq2, zzdo2), (TaskCompletionSource<Void>)taskCompletionSource);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(8, (Object)new zzcp(zzd2, this.zzfzm.get(), googleApi)));
        return taskCompletionSource.getTask();
    }

    public final <O extends Api.ApiOptions> Task<Boolean> zza(@NonNull GoogleApi<O> googleApi, @NonNull zzck<?> zzck2) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        zzf zzf2 = new zzf(zzck2, (TaskCompletionSource<Boolean>)taskCompletionSource);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(13, (Object)new zzcp(zzf2, this.zzfzm.get(), googleApi)));
        return taskCompletionSource.getTask();
    }

    @WorkerThread
    public final boolean handleMessage(Message message) {
        block0 : switch (message.what) {
            case 1: {
                boolean bl = (Boolean)message.obj;
                zzbm zzbm2 = this;
                this.zzfzi = bl ? 10000L : 300000L;
                zzbm2.mHandler.removeMessages(12);
                for (zzh<?> zzh2 : zzbm2.zzfwg.keySet()) {
                    zzbm2.mHandler.sendMessageDelayed(zzbm2.mHandler.obtainMessage(12, zzh2), zzbm2.zzfzi);
                }
                break;
            }
            case 2: {
                zzj zzj2 = (zzj)message.obj;
                zzbm zzbm3 = this;
                for (zzh<?> zzh3 : zzj2.zzaii()) {
                    zzbo<?> zzbo2 = zzbm3.zzfwg.get(zzh3);
                    if (zzbo2 == null) {
                        ConnectionResult connectionResult = new ConnectionResult(13);
                        zzj2.zza(zzh3, connectionResult, null);
                        break block0;
                    }
                    if (zzbo2.isConnected()) {
                        zzj2.zza(zzh3, ConnectionResult.zzfqt, zzbo2.zzaix().zzahp());
                        continue;
                    }
                    if (zzbo2.zzakj() != null) {
                        zzj2.zza(zzh3, zzbo2.zzakj(), null);
                        continue;
                    }
                    zzbo2.zza(zzj2);
                }
                break;
            }
            case 3: {
                for (zzbo<?> zzbo3 : this.zzfwg.values()) {
                    zzbo3.zzaki();
                    zzbo3.connect();
                }
                break;
            }
            case 4: 
            case 8: 
            case 13: {
                zzcp zzcp2 = (zzcp)message.obj;
                zzbm zzbm4 = this;
                zzbo<?> zzbo4 = zzbm4.zzfwg.get(zzcp2.zzgba.zzahv());
                if (zzbo4 == null) {
                    zzbm4.zzb(zzcp2.zzgba);
                    zzbo4 = zzbm4.zzfwg.get(zzcp2.zzgba.zzahv());
                }
                if (zzbo4.zzacc() && zzbm4.zzfzm.get() != zzcp2.zzgaz) {
                    zzcp2.zzgay.zzs(zzfzg);
                    zzbo4.signOut();
                    break;
                }
                zzbo4.zza(zzcp2.zzgay);
                break;
            }
            case 5: {
                ConnectionResult connectionResult = (ConnectionResult)message.obj;
                int n = message.arg1;
                zzbm zzbm5 = this;
                zzbo<?> zzbo5 = null;
                for (zzbo<?> zzbo6 : zzbm5.zzfwg.values()) {
                    if (zzbo6.getInstanceId() != n) continue;
                    zzbo5 = zzbo6;
                    break;
                }
                if (zzbo5 != null) {
                    zzbo<?> zzbo6;
                    String string2 = zzbm5.zzftg.getErrorString(connectionResult.getErrorCode());
                    zzbo6 = connectionResult.getErrorMessage();
                    zzbo5.zzw(new Status(17, new StringBuilder(69 + String.valueOf(string2).length() + String.valueOf(zzbo6).length()).append("Error resolution was canceled by the user, original error message: ").append(string2).append(": ").append((String)((Object)zzbo6)).toString()));
                    break;
                }
                Log.wtf((String)"GoogleApiManager", (String)new StringBuilder(76).append("Could not find API instance ").append(n).append(" while trying to fail enqueued calls.").toString(), (Throwable)new Exception());
                break;
            }
            case 6: {
                zzbm zzbm6 = this;
                if (!(zzbm6.mContext.getApplicationContext() instanceof Application)) break;
                zzk.zza((Application)((Application)zzbm6.mContext.getApplicationContext()));
                zzk.zzaij().zza((zzl)new zzbn(zzbm6));
                if (zzk.zzaij().zzbi(true)) break;
                zzbm6.zzfzi = 300000L;
                break;
            }
            case 7: {
                this.zzb((GoogleApi)message.obj);
                break;
            }
            case 9: {
                if (!this.zzfwg.containsKey(message.obj)) break;
                this.zzfwg.get(message.obj).resume();
                break;
            }
            case 10: {
                this.zzakb();
                break;
            }
            case 11: {
                if (!this.zzfwg.containsKey(message.obj)) break;
                this.zzfwg.get(message.obj).zzajr();
                break;
            }
            case 12: {
                if (!this.zzfwg.containsKey(message.obj)) break;
                this.zzfwg.get(message.obj).zzakm();
                break;
            }
            default: {
                int n = message.what;
                Log.w((String)"GoogleApiManager", (String)new StringBuilder(31).append("Unknown message id: ").append(n).toString());
                return false;
            }
        }
        return true;
    }

    final PendingIntent zza(zzh<?> zzh2, int n) {
        zzbo<?> zzbo2 = this.zzfwg.get(zzh2);
        if (zzbo2 == null) {
            return null;
        }
        zzcyj zzcyj2 = zzbo2.zzakn();
        if (zzcyj2 == null) {
            return null;
        }
        return PendingIntent.getActivity((Context)this.mContext, (int)n, (Intent)zzcyj2.getSignInIntent(), (int)0x8000000);
    }

    final boolean zzc(ConnectionResult connectionResult, int n) {
        return this.zzftg.zza(this.mContext, connectionResult, n);
    }

    public final void zza(ConnectionResult connectionResult, int n) {
        if (!this.zzc(connectionResult, n)) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(5, n, 0, (Object)connectionResult));
        }
    }

    static /* synthetic */ Handler zza(zzbm zzbm2) {
        return zzbm2.mHandler;
    }

    static /* synthetic */ int zzb(zzbm zzbm2) {
        return zzbm2.zzfzk;
    }

    static /* synthetic */ int zza(zzbm zzbm2, int n) {
        zzbm2.zzfzk = n;
        return zzbm2.zzfzk;
    }

    static /* synthetic */ Context zzc(zzbm zzbm2) {
        return zzbm2.mContext;
    }

    static /* synthetic */ long zzd(zzbm zzbm2) {
        return zzbm2.zzfyg;
    }

    static /* synthetic */ long zze(zzbm zzbm2) {
        return zzbm2.zzfyf;
    }

    static /* synthetic */ Status zzakc() {
        return zzfzh;
    }

    static /* synthetic */ Object zzakd() {
        return sLock;
    }

    static /* synthetic */ zzah zzf(zzbm zzbm2) {
        return zzbm2.zzfzn;
    }

    static /* synthetic */ Set zzg(zzbm zzbm2) {
        return zzbm2.zzfzo;
    }

    static /* synthetic */ GoogleApiAvailability zzh(zzbm zzbm2) {
        return zzbm2.zzftg;
    }

    static /* synthetic */ long zzi(zzbm zzbm2) {
        return zzbm2.zzfzi;
    }

    static /* synthetic */ Map zzj(zzbm zzbm2) {
        return zzbm2.zzfwg;
    }
}

