/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApi;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zza;
import com.google.android.gms.common.api.internal.zzae;
import com.google.android.gms.common.api.internal.zzbm;
import com.google.android.gms.common.api.internal.zzbp;
import com.google.android.gms.common.api.internal.zzbq;
import com.google.android.gms.common.api.internal.zzbr;
import com.google.android.gms.common.api.internal.zzbs;
import com.google.android.gms.common.api.internal.zzbu;
import com.google.android.gms.common.api.internal.zzck;
import com.google.android.gms.common.api.internal.zzcr;
import com.google.android.gms.common.api.internal.zzcv;
import com.google.android.gms.common.api.internal.zzf;
import com.google.android.gms.common.api.internal.zzh;
import com.google.android.gms.common.api.internal.zzj;
import com.google.android.gms.common.api.internal.zzu;
import com.google.android.gms.common.internal.zzbz;
import com.google.android.gms.internal.zzcyj;
import com.google.android.gms.tasks.TaskCompletionSource;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;

public final class zzbo<O extends Api.ApiOptions>
implements GoogleApiClient.ConnectionCallbacks,
GoogleApiClient.OnConnectionFailedListener,
zzu {
    private final Queue<zza> zzfzr = new LinkedList<zza>();
    private final Api.zze zzfwd;
    private final Api.zzb zzfzs;
    private final zzh<O> zzfsn;
    private final zzae zzfzt;
    private final Set<zzj> zzfzu = new HashSet<zzj>();
    private final Map<zzck<?>, zzcr> zzfzv = new HashMap();
    private final int zzfzw;
    private final zzcv zzfzx;
    private boolean zzfye;
    private int zzfzy = -1;
    private ConnectionResult zzfzz = null;
    final /* synthetic */ zzbm zzfzq;

    private final void zzake() {
        this.zzfzy = -1;
        zzbm.zza(this.zzfzq, -1);
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    @WorkerThread
    public zzbo(zzbm zzbm2, GoogleApi googleApi) {
        this.zzfzq = zzbm2;
        this.zzfwd = googleApi.zza(zzbm.zza(zzbm2).getLooper(), this);
        this.zzfzs = this.zzfwd instanceof zzbz ? zzbz.zzanb() : this.zzfwd;
        this.zzfsn = googleApi.zzahv();
        this.zzfzt = new zzae();
        this.zzfzw = googleApi.getInstanceId();
        if (this.zzfwd.zzacc()) {
            this.zzfzx = googleApi.zza(zzbm.zzc(zzbm2), zzbm.zza(zzbm2));
            return;
        }
        this.zzfzx = null;
    }

    @Override
    public final void onConnected(@Nullable Bundle bundle) {
        if (Looper.myLooper() == zzbm.zza(this.zzfzq).getLooper()) {
            this.zzakf();
            return;
        }
        zzbm.zza(this.zzfzq).post((Runnable)new zzbp(this));
    }

    @WorkerThread
    private final void zzakf() {
        this.zzaki();
        this.zzi(ConnectionResult.zzfqt);
        this.zzakk();
        for (zzcr zzcr2 : this.zzfzv.values()) {
            try {
                zzcr2.zzfty.zzb(this.zzfzs, (TaskCompletionSource<Void>)new TaskCompletionSource());
            }
            catch (DeadObjectException deadObjectException) {
                this.onConnectionSuspended(1);
                this.zzfwd.disconnect();
                break;
            }
            catch (RemoteException remoteException) {
            }
        }
        zzbo zzbo2 = this;
        while (zzbo2.zzfwd.isConnected() && !zzbo2.zzfzr.isEmpty()) {
            zza zza2 = zzbo2.zzfzr.remove();
            zzbo2.zzb(zza2);
        }
        this.zzakl();
    }

    @Override
    public final void onConnectionSuspended(int n) {
        if (Looper.myLooper() == zzbm.zza(this.zzfzq).getLooper()) {
            this.zzakg();
            return;
        }
        zzbm.zza(this.zzfzq).post((Runnable)new zzbq(this));
    }

    @WorkerThread
    private final void zzakg() {
        this.zzaki();
        this.zzfye = true;
        this.zzfzt.zzaje();
        zzbm.zza(this.zzfzq).sendMessageDelayed(Message.obtain((Handler)zzbm.zza(this.zzfzq), (int)9, this.zzfsn), zzbm.zzd(this.zzfzq));
        zzbm.zza(this.zzfzq).sendMessageDelayed(Message.obtain((Handler)zzbm.zza(this.zzfzq), (int)11, this.zzfsn), zzbm.zze(this.zzfzq));
        this.zzake();
    }

    @WorkerThread
    public final void zzh(@NonNull ConnectionResult connectionResult) {
        com.google.android.gms.common.internal.zzbq.zza((Handler)zzbm.zza(this.zzfzq));
        this.zzfwd.disconnect();
        this.onConnectionFailed(connectionResult);
    }

    @Override
    public final void zza(ConnectionResult connectionResult, Api<?> api, boolean bl) {
        if (Looper.myLooper() == zzbm.zza(this.zzfzq).getLooper()) {
            this.onConnectionFailed(connectionResult);
            return;
        }
        zzbm.zza(this.zzfzq).post((Runnable)new zzbr(this, connectionResult));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WorkerThread
    public final void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
        com.google.android.gms.common.internal.zzbq.zza((Handler)zzbm.zza(this.zzfzq));
        if (this.zzfzx != null) {
            this.zzfzx.zzakz();
        }
        this.zzaki();
        this.zzake();
        this.zzi(connectionResult);
        if (connectionResult.getErrorCode() == 4) {
            this.zzw(zzbm.zzakc());
            return;
        }
        if (this.zzfzr.isEmpty()) {
            this.zzfzz = connectionResult;
            return;
        }
        Object object = zzbm.zzakd();
        synchronized (object) {
            if (zzbm.zzf(this.zzfzq) != null && zzbm.zzg(this.zzfzq).contains(this.zzfsn)) {
                zzbm.zzf(this.zzfzq).zzb(connectionResult, this.zzfzw);
                return;
            }
        }
        if (!this.zzfzq.zzc(connectionResult, this.zzfzw)) {
            if (connectionResult.getErrorCode() == 18) {
                this.zzfye = true;
            }
            if (this.zzfye) {
                zzbm.zza(this.zzfzq).sendMessageDelayed(Message.obtain((Handler)zzbm.zza(this.zzfzq), (int)9, this.zzfsn), zzbm.zzd(this.zzfzq));
                return;
            }
            object = this.zzfsn.zzaig();
            this.zzw(new Status(17, new StringBuilder(38 + String.valueOf(object).length()).append("API: ").append((String)object).append(" is not available on this device.").toString()));
        }
    }

    @WorkerThread
    public final void zza(zza zza2) {
        com.google.android.gms.common.internal.zzbq.zza((Handler)zzbm.zza(this.zzfzq));
        if (this.zzfwd.isConnected()) {
            this.zzb(zza2);
            this.zzakl();
            return;
        }
        this.zzfzr.add(zza2);
        if (this.zzfzz != null && this.zzfzz.hasResolution()) {
            this.onConnectionFailed(this.zzfzz);
            return;
        }
        this.connect();
    }

    @WorkerThread
    public final void signOut() {
        com.google.android.gms.common.internal.zzbq.zza((Handler)zzbm.zza(this.zzfzq));
        this.zzw(zzbm.zzfzg);
        this.zzfzt.zzajd();
        for (zzck zzck2 : this.zzfzv.keySet().toArray(new zzck[this.zzfzv.size()])) {
            this.zza(new zzf(zzck2, (TaskCompletionSource<Boolean>)new TaskCompletionSource()));
        }
        this.zzi(new ConnectionResult(4));
        if (this.zzfwd.isConnected()) {
            this.zzfwd.zza(new zzbs(this));
        }
    }

    public final Api.zze zzaix() {
        return this.zzfwd;
    }

    public final Map<zzck<?>, zzcr> zzakh() {
        return this.zzfzv;
    }

    @WorkerThread
    public final void zzaki() {
        com.google.android.gms.common.internal.zzbq.zza((Handler)zzbm.zza(this.zzfzq));
        this.zzfzz = null;
    }

    @WorkerThread
    public final ConnectionResult zzakj() {
        com.google.android.gms.common.internal.zzbq.zza((Handler)zzbm.zza(this.zzfzq));
        return this.zzfzz;
    }

    @WorkerThread
    private final void zzb(zza zza2) {
        zza2.zza(this.zzfzt, this.zzacc());
        try {
            zza2.zza(this);
            return;
        }
        catch (DeadObjectException deadObjectException) {
            this.onConnectionSuspended(1);
            this.zzfwd.disconnect();
            return;
        }
    }

    @WorkerThread
    public final void zzw(Status status) {
        com.google.android.gms.common.internal.zzbq.zza((Handler)zzbm.zza(this.zzfzq));
        Iterator iterator = this.zzfzr.iterator();
        while (iterator.hasNext()) {
            ((zza)iterator.next()).zzs(status);
        }
        this.zzfzr.clear();
    }

    @WorkerThread
    public final void resume() {
        com.google.android.gms.common.internal.zzbq.zza((Handler)zzbm.zza(this.zzfzq));
        if (this.zzfye) {
            this.connect();
        }
    }

    @WorkerThread
    private final void zzakk() {
        if (this.zzfye) {
            zzbm.zza(this.zzfzq).removeMessages(11, this.zzfsn);
            zzbm.zza(this.zzfzq).removeMessages(9, this.zzfsn);
            this.zzfye = false;
        }
    }

    @WorkerThread
    public final void zzajr() {
        com.google.android.gms.common.internal.zzbq.zza((Handler)zzbm.zza(this.zzfzq));
        if (this.zzfye) {
            this.zzakk();
            Status status = zzbm.zzh(this.zzfzq).isGooglePlayServicesAvailable(zzbm.zzc(this.zzfzq)) == 18 ? new Status(8, "Connection timed out while waiting for Google Play services update to complete.") : new Status(8, "API failed to connect while resuming due to an unknown error.");
            this.zzw(status);
            this.zzfwd.disconnect();
        }
    }

    private final void zzakl() {
        zzbm.zza(this.zzfzq).removeMessages(12, this.zzfsn);
        zzbm.zza(this.zzfzq).sendMessageDelayed(zzbm.zza(this.zzfzq).obtainMessage(12, this.zzfsn), zzbm.zzi(this.zzfzq));
    }

    @WorkerThread
    public final void zzakm() {
        com.google.android.gms.common.internal.zzbq.zza((Handler)zzbm.zza(this.zzfzq));
        if (this.zzfwd.isConnected() && this.zzfzv.size() == 0) {
            if (this.zzfzt.zzajc()) {
                this.zzakl();
                return;
            }
            this.zzfwd.disconnect();
        }
    }

    @WorkerThread
    public final void connect() {
        com.google.android.gms.common.internal.zzbq.zza((Handler)zzbm.zza(this.zzfzq));
        if (this.zzfwd.isConnected() || this.zzfwd.isConnecting()) {
            return;
        }
        if (this.zzfwd.zzahn()) {
            zzbo zzbo2 = this;
            zzbo2.zzfwd.zzahq();
            if (zzbm.zzb(zzbo2.zzfzq) != 0) {
                int n;
                zzbm.zzh(this.zzfzq);
                int n2 = n = GoogleApiAvailability.zzc((Context)zzbm.zzc(this.zzfzq), (int)this.zzfwd.zzahq());
                zzbo2 = this;
                zzbo2.zzfwd.zzahq();
                zzbm.zza(zzbo2.zzfzq, n2);
                if (n != 0) {
                    ConnectionResult connectionResult = new ConnectionResult(n, null);
                    this.onConnectionFailed(connectionResult);
                    return;
                }
            }
        }
        zzbu zzbu2 = new zzbu(this.zzfzq, this.zzfwd, this.zzfsn);
        if (this.zzfwd.zzacc()) {
            this.zzfzx.zza(zzbu2);
        }
        this.zzfwd.zza(zzbu2);
    }

    @WorkerThread
    public final void zza(zzj zzj2) {
        com.google.android.gms.common.internal.zzbq.zza((Handler)zzbm.zza(this.zzfzq));
        this.zzfzu.add(zzj2);
    }

    @WorkerThread
    private final void zzi(ConnectionResult connectionResult) {
        for (zzj zzj2 : this.zzfzu) {
            String string2 = null;
            if (connectionResult == ConnectionResult.zzfqt) {
                string2 = this.zzfwd.zzahp();
            }
            zzj2.zza(this.zzfsn, connectionResult, string2);
        }
        this.zzfzu.clear();
    }

    final boolean isConnected() {
        return this.zzfwd.isConnected();
    }

    public final boolean zzacc() {
        return this.zzfwd.zzacc();
    }

    public final int getInstanceId() {
        return this.zzfzw;
    }

    final zzcyj zzakn() {
        if (this.zzfzx == null) {
            return null;
        }
        return this.zzfzx.zzakn();
    }

    static /* synthetic */ void zzc(zzbo zzbo2) {
        zzbo2.zzakf();
    }

    static /* synthetic */ void zzd(zzbo zzbo2) {
        zzbo2.zzakg();
    }

    static /* synthetic */ Api.zze zze(zzbo zzbo2) {
        return zzbo2.zzfwd;
    }
}

