/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.images;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.images.zze;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import java.util.Arrays;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

public final class WebImage
extends zzbgl {
    public static final Parcelable.Creator<WebImage> CREATOR = new zze();
    private int zzehz;
    private final Uri zzfgr;
    private final int zzalt;
    private final int zzalu;

    WebImage(int n, Uri uri, int n2, int n3) {
        this.zzehz = n;
        this.zzfgr = uri;
        this.zzalt = n2;
        this.zzalu = n3;
    }

    public WebImage(Uri uri, int n, int n2) throws IllegalArgumentException {
        this(1, uri, n, n2);
        if (uri == null) {
            throw new IllegalArgumentException("url cannot be null");
        }
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException("width and height must not be negative");
        }
    }

    public WebImage(Uri uri) throws IllegalArgumentException {
        this(uri, 0, 0);
    }

    @Hide
    public WebImage(JSONObject jSONObject) throws IllegalArgumentException {
        this(WebImage.zzx(jSONObject), jSONObject.optInt("width", 0), jSONObject.optInt("height", 0));
    }

    private static Uri zzx(JSONObject jSONObject) {
        Uri uri = null;
        if (jSONObject.has("url")) {
            try {
                uri = Uri.parse((String)jSONObject.getString("url"));
            }
            catch (JSONException jSONException) {}
        }
        return uri;
    }

    public final Uri getUrl() {
        return this.zzfgr;
    }

    public final int getWidth() {
        return this.zzalt;
    }

    public final int getHeight() {
        return this.zzalu;
    }

    public final String toString() {
        return String.format(Locale.US, "Image %dx%d %s", this.zzalt, this.zzalu, this.zzfgr.toString());
    }

    @Hide
    public final JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("url", (Object)this.zzfgr.toString());
            jSONObject.put("width", this.zzalt);
            jSONObject.put("height", this.zzalu);
        }
        catch (JSONException jSONException) {}
        return jSONObject;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof WebImage)) {
            return false;
        }
        WebImage webImage = (WebImage)((Object)object);
        return zzbg.equal((Object)this.zzfgr, (Object)webImage.zzfgr) && this.zzalt == webImage.zzalt && this.zzalu == webImage.zzalu;
    }

    public final int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzfgr, this.zzalt, this.zzalu});
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        WebImage webImage = this;
        int n2 = zzbgo.zze((Parcel)parcel2);
        zzbgo.zzc((Parcel)parcel2, (int)1, (int)webImage.zzehz);
        zzbgo.zza((Parcel)parcel2, (int)2, (Parcelable)webImage.getUrl(), (int)n, (boolean)false);
        zzbgo.zzc((Parcel)parcel2, (int)3, (int)webImage.getWidth());
        zzbgo.zzc((Parcel)parcel2, (int)4, (int)webImage.getHeight());
        zzbgo.zzai((Parcel)parcel2, (int)n2);
    }
}

