/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.SystemClock;
import com.google.android.gms.internal.zzbgg;
import com.google.android.gms.internal.zzbgi;

public final class zzbge
extends Drawable
implements Drawable.Callback {
    private int zzgdy = 0;
    private long zzebf;
    private int mFrom;
    private int zzgdz;
    private int zzgea = 255;
    private int zzgeb;
    private int mAlpha = 0;
    private boolean zzgdt = true;
    private boolean zzgec;
    private zzbgi zzged;
    private Drawable zzgee;
    private Drawable zzgef;
    private boolean zzgeg;
    private boolean zzgeh;
    private boolean zzgei;
    private int zzgej;

    public zzbge(Drawable drawable2, Drawable drawable3) {
        this(null);
        if (drawable2 == null) {
            drawable2 = zzbgg.zzalo();
        }
        this.zzgee = drawable2;
        drawable2.setCallback((Drawable.Callback)this);
        this.zzged.zzgem |= drawable2.getChangingConfigurations();
        if (drawable3 == null) {
            drawable3 = zzbgg.zzalo();
        }
        this.zzgef = drawable3;
        drawable3.setCallback((Drawable.Callback)this);
        this.zzged.zzgem |= drawable3.getChangingConfigurations();
    }

    zzbge(zzbgi zzbgi2) {
        this.zzged = new zzbgi(zzbgi2);
    }

    public final void invalidateDrawable(Drawable drawable2) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.invalidateDrawable((Drawable)this);
        }
    }

    public final void scheduleDrawable(Drawable drawable2, Runnable runnable, long l) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.scheduleDrawable((Drawable)this, runnable, l);
        }
    }

    public final void unscheduleDrawable(Drawable drawable2, Runnable runnable) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.unscheduleDrawable((Drawable)this, runnable);
        }
    }

    public final int getChangingConfigurations() {
        return super.getChangingConfigurations() | this.zzged.mChangingConfigurations | this.zzged.zzgem;
    }

    public final void setAlpha(int n) {
        if (this.mAlpha == this.zzgea) {
            this.mAlpha = n;
        }
        this.zzgea = n;
        this.invalidateSelf();
    }

    public final void setColorFilter(ColorFilter colorFilter) {
        this.zzgee.setColorFilter(colorFilter);
        this.zzgef.setColorFilter(colorFilter);
    }

    public final int getIntrinsicWidth() {
        return Math.max(this.zzgee.getIntrinsicWidth(), this.zzgef.getIntrinsicWidth());
    }

    public final int getIntrinsicHeight() {
        return Math.max(this.zzgee.getIntrinsicHeight(), this.zzgef.getIntrinsicHeight());
    }

    protected final void onBoundsChange(Rect rect) {
        this.zzgee.setBounds(rect);
        this.zzgef.setBounds(rect);
    }

    public final Drawable.ConstantState getConstantState() {
        if (this.canConstantState()) {
            this.zzged.mChangingConfigurations = this.getChangingConfigurations();
            return this.zzged;
        }
        return null;
    }

    public final int getOpacity() {
        if (!this.zzgei) {
            this.zzgej = Drawable.resolveOpacity((int)this.zzgee.getOpacity(), (int)this.zzgef.getOpacity());
            this.zzgei = true;
        }
        return this.zzgej;
    }

    private final boolean canConstantState() {
        if (!this.zzgeg) {
            this.zzgeh = this.zzgee.getConstantState() != null && this.zzgef.getConstantState() != null;
            this.zzgeg = true;
        }
        return this.zzgeh;
    }

    public final Drawable mutate() {
        if (!this.zzgec && super.mutate() == this) {
            if (!this.canConstantState()) {
                throw new IllegalStateException("One or more children of this LayerDrawable does not have constant state; this drawable cannot be mutated.");
            }
            this.zzgee.mutate();
            this.zzgef.mutate();
            this.zzgec = true;
        }
        return this;
    }

    public final Drawable zzaln() {
        return this.zzgef;
    }

    public final void startTransition(int n) {
        this.mFrom = 0;
        this.zzgdz = this.zzgea;
        this.mAlpha = 0;
        this.zzgeb = 250;
        this.zzgdy = 1;
        this.invalidateSelf();
    }

    public final void draw(Canvas canvas) {
        boolean bl = true;
        switch (this.zzgdy) {
            case 1: {
                this.zzebf = SystemClock.uptimeMillis();
                bl = false;
                this.zzgdy = 2;
                break;
            }
            case 2: {
                float f;
                if (this.zzebf < 0L) break;
                float f2 = (float)(SystemClock.uptimeMillis() - this.zzebf) / (float)this.zzgeb;
                bl = f >= 1.0f;
                if (bl) {
                    this.zzgdy = 0;
                }
                f2 = Math.min(f2, 1.0f);
                this.mAlpha = (int)(0.0f + (float)this.zzgdz * f2);
            }
        }
        int n = this.mAlpha;
        boolean bl2 = this.zzgdt;
        Drawable drawable2 = this.zzgee;
        Drawable drawable3 = this.zzgef;
        if (bl) {
            if (!bl2 || n == 0) {
                drawable2.draw(canvas);
            }
            if (n == this.zzgea) {
                drawable3.setAlpha(this.zzgea);
                drawable3.draw(canvas);
            }
            return;
        }
        if (bl2) {
            drawable2.setAlpha(this.zzgea - n);
        }
        drawable2.draw(canvas);
        if (bl2) {
            drawable2.setAlpha(this.zzgea);
        }
        if (n > 0) {
            drawable3.setAlpha(n);
            drawable3.draw(canvas);
            drawable3.setAlpha(this.zzgea);
        }
        this.invalidateSelf();
    }
}

