/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.os.DeadObjectException;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.android.gms.common.Feature;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.GoogleApiManager;
import com.google.android.gms.common.api.internal.StatusExceptionMapper;
import com.google.android.gms.common.api.internal.TaskApiCall;
import com.google.android.gms.common.api.internal.zzaa;
import com.google.android.gms.common.api.internal.zzb;
import com.google.android.gms.tasks.TaskCompletionSource;

public final class zzf<ResultT>
extends zzb {
    private final TaskApiCall<Api.AnyClient, ResultT> zzdy;
    private final TaskCompletionSource<ResultT> zzdu;
    private final StatusExceptionMapper zzdz;

    public zzf(int n, TaskApiCall<Api.AnyClient, ResultT> taskApiCall, TaskCompletionSource<ResultT> taskCompletionSource, StatusExceptionMapper statusExceptionMapper) {
        super(n);
        this.zzdu = taskCompletionSource;
        this.zzdy = taskApiCall;
        this.zzdz = statusExceptionMapper;
    }

    @Override
    public final void zza(GoogleApiManager.zza<?> zza2) throws DeadObjectException {
        try {
            this.zzdy.doExecute(zza2.zzae(), this.zzdu);
            return;
        }
        catch (DeadObjectException deadObjectException) {
            throw deadObjectException;
        }
        catch (RemoteException remoteException) {
            ((zzb)this).zza(zzb.zzb(remoteException));
            return;
        }
        catch (RuntimeException runtimeException) {
            ((zzb)this).zza(runtimeException);
            return;
        }
    }

    @Override
    public final void zza(@NonNull Status status) {
        this.zzdu.trySetException(this.zzdz.getException(status));
    }

    @Override
    public final void zza(@NonNull RuntimeException runtimeException) {
        this.zzdu.trySetException((Exception)runtimeException);
    }

    @Override
    public final void zza(@NonNull zzaa zzaa2, boolean bl) {
        zzaa2.zza(this.zzdu, bl);
    }

    @Nullable
    public final Feature[] getRequiredFeatures() {
        return this.zzdy.zzca();
    }

    public final boolean shouldAutoResolveMissingFeatures() {
        return this.zzdy.shouldAutoResolveMissingFeatures();
    }
}

