/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.BaseImplementation;
import com.google.android.gms.common.api.internal.GoogleApiManager;
import com.google.android.gms.common.api.internal.SignInConnectionListener;
import com.google.android.gms.common.api.internal.zzav;
import com.google.android.gms.common.api.internal.zzbp;
import com.google.android.gms.common.api.internal.zzh;
import com.google.android.gms.common.api.internal.zzp;
import com.google.android.gms.common.api.internal.zzv;
import com.google.android.gms.common.api.internal.zzy;
import com.google.android.gms.common.api.internal.zzz;
import com.google.android.gms.common.internal.ClientSettings;
import com.google.android.gms.common.util.concurrent.HandlerExecutor;
import com.google.android.gms.signin.SignInClient;
import com.google.android.gms.signin.SignInOptions;
import com.google.android.gms.tasks.OnCompleteListener;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import javax.annotation.concurrent.GuardedBy;

public final class zzw
implements zzbp {
    private final Map<Api.AnyClientKey<?>, zzv<?>> zzgg = new HashMap();
    private final Map<Api.AnyClientKey<?>, zzv<?>> zzgh = new HashMap();
    private final Map<Api<?>, Boolean> zzgi;
    private final GoogleApiManager zzcq;
    private final zzav zzgj;
    private final Lock zzga;
    private final Looper zzcn;
    private final GoogleApiAvailabilityLight zzgk;
    private final Condition zzgl;
    private final ClientSettings zzgf;
    private final boolean zzgm;
    private final boolean zzgn;
    private final Queue<BaseImplementation.ApiMethodImpl<?, ?>> zzgo = new LinkedList();
    @GuardedBy(value="mLock")
    private boolean zzgp;
    @GuardedBy(value="mLock")
    private Map<zzh<?>, ConnectionResult> zzgq;
    @GuardedBy(value="mLock")
    private Map<zzh<?>, ConnectionResult> zzgr;
    @GuardedBy(value="mLock")
    private zzz zzgs;
    @GuardedBy(value="mLock")
    private ConnectionResult zzgt;

    public zzw(Context context, Lock lock, Looper looper, GoogleApiAvailabilityLight googleApiAvailabilityLight, Map<Api.AnyClientKey<?>, Api.Client> map, ClientSettings clientSettings, Map<Api<?>, Boolean> map2, Api.AbstractClientBuilder<? extends SignInClient, SignInOptions> abstractClientBuilder, ArrayList<zzp> arrayList, zzav zzav2, boolean bl) {
        this.zzga = lock;
        this.zzcn = looper;
        this.zzgl = lock.newCondition();
        this.zzgk = googleApiAvailabilityLight;
        this.zzgj = zzav2;
        this.zzgi = map2;
        this.zzgf = clientSettings;
        this.zzgm = bl;
        HashMap hashMap = new HashMap();
        for (Api<?> api : map2.keySet()) {
            hashMap.put(api.getClientKey(), api);
        }
        HashMap hashMap2 = new HashMap();
        ArrayList<zzp> arrayList2 = arrayList;
        int n = arrayList2.size();
        for (int i = 0; i < n; ++i) {
            zzp zzp2 = arrayList2.get(i);
            zzp zzp3 = zzp2;
            hashMap2.put(zzp3.mApi, zzp3);
        }
        boolean bl2 = false;
        boolean bl3 = true;
        boolean bl4 = false;
        for (Map.Entry<Api.AnyClientKey<?>, Api.Client> entry : map.entrySet()) {
            Api api = (Api)hashMap.get(entry.getKey());
            Api.Client client = entry.getValue();
            if (client.requiresGooglePlayServices()) {
                bl4 = true;
                if (!this.zzgi.get(api).booleanValue()) {
                    bl2 = true;
                }
            } else {
                bl3 = false;
            }
            zzp zzp4 = (zzp)hashMap2.get(api);
            zzv zzv2 = new zzv(context, api, looper, client, zzp4, clientSettings, abstractClientBuilder);
            this.zzgg.put(entry.getKey(), zzv2);
            if (!client.requiresSignIn()) continue;
            this.zzgh.put(entry.getKey(), zzv2);
        }
        this.zzgn = bl4 && !bl3 && !bl2;
        this.zzcq = GoogleApiManager.zzbf();
    }

    @Override
    public final <A extends Api.AnyClient, R extends Result, T extends BaseImplementation.ApiMethodImpl<R, A>> T enqueue(@NonNull T t) {
        if (this.zzgm && this.zzb(t)) {
            return t;
        }
        if (!this.isConnected()) {
            this.zzgo.add(t);
            return t;
        }
        this.zzgj.zzir.zzb(t);
        return this.zzgg.get(t.getClientKey()).doRead(t);
    }

    @Override
    public final <A extends Api.AnyClient, T extends BaseImplementation.ApiMethodImpl<? extends Result, A>> T execute(@NonNull T t) {
        Api.AnyClientKey<A> anyClientKey = t.getClientKey();
        if (this.zzgm && this.zzb(t)) {
            return t;
        }
        this.zzgj.zzir.zzb(t);
        return this.zzgg.get(anyClientKey).doWrite(t);
    }

    private final <T extends BaseImplementation.ApiMethodImpl<? extends Result, ? extends Api.AnyClient>> boolean zzb(@NonNull T t) {
        Api.AnyClientKey<? extends Api.AnyClient> anyClientKey = t.getClientKey();
        ConnectionResult connectionResult = this.zza(anyClientKey);
        if (connectionResult != null && connectionResult.getErrorCode() == 4) {
            t.setFailedResult(new Status(4, null, this.zzcq.zza(this.zzgg.get(anyClientKey).zzm(), System.identityHashCode(this.zzgj))));
            return true;
        }
        return false;
    }

    @Override
    public final void connect() {
        this.zzga.lock();
        try {
            if (this.zzgp) {
                return;
            }
            this.zzgp = true;
            this.zzgq = null;
            this.zzgr = null;
            this.zzgs = null;
            this.zzgt = null;
            this.zzcq.zzr();
            this.zzcq.zza(this.zzgg.values()).addOnCompleteListener((Executor)new HandlerExecutor(this.zzcn), (OnCompleteListener)new zzy(this, null));
            return;
        }
        finally {
            this.zzga.unlock();
        }
    }

    @Override
    @GuardedBy(value="mLock")
    public final ConnectionResult blockingConnect() {
        this.connect();
        while (this.isConnecting()) {
            try {
                this.zzgl.await();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return new ConnectionResult(15, null);
            }
        }
        if (this.isConnected()) {
            return ConnectionResult.RESULT_SUCCESS;
        }
        if (this.zzgt != null) {
            return this.zzgt;
        }
        return new ConnectionResult(13, null);
    }

    @Override
    @GuardedBy(value="mLock")
    public final ConnectionResult blockingConnect(long l, TimeUnit timeUnit) {
        this.connect();
        long l2 = timeUnit.toNanos(l);
        while (this.isConnecting()) {
            try {
                if (l2 <= 0L) {
                    this.disconnect();
                    return new ConnectionResult(14, null);
                }
                l2 = this.zzgl.awaitNanos(l2);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return new ConnectionResult(15, null);
            }
        }
        if (this.isConnected()) {
            return ConnectionResult.RESULT_SUCCESS;
        }
        if (this.zzgt != null) {
            return this.zzgt;
        }
        return new ConnectionResult(13, null);
    }

    @Override
    public final void disconnect() {
        this.zzga.lock();
        try {
            this.zzgp = false;
            this.zzgq = null;
            this.zzgr = null;
            if (this.zzgs != null) {
                this.zzgs.cancel();
                this.zzgs = null;
            }
            this.zzgt = null;
            while (!this.zzgo.isEmpty()) {
                BaseImplementation.ApiMethodImpl<?, ?> apiMethodImpl = this.zzgo.remove();
                apiMethodImpl.zza(null);
                ((PendingResult)apiMethodImpl).cancel();
            }
            this.zzgl.signalAll();
            return;
        }
        finally {
            this.zzga.unlock();
        }
    }

    @Override
    @Nullable
    public final ConnectionResult getConnectionResult(@NonNull Api<?> api) {
        return this.zza(api.getClientKey());
    }

    @Nullable
    private final ConnectionResult zza(@NonNull Api.AnyClientKey<?> anyClientKey) {
        this.zzga.lock();
        try {
            zzv<?> zzv2 = this.zzgg.get(anyClientKey);
            if (this.zzgq != null && zzv2 != null) {
                ConnectionResult connectionResult = this.zzgq.get(zzv2.zzm());
                return connectionResult;
            }
            return null;
        }
        finally {
            this.zzga.unlock();
        }
    }

    @Override
    public final boolean isConnected() {
        this.zzga.lock();
        try {
            boolean bl = this.zzgq != null && this.zzgt == null;
            return bl;
        }
        finally {
            this.zzga.unlock();
        }
    }

    @Override
    public final boolean isConnecting() {
        this.zzga.lock();
        try {
            boolean bl = this.zzgq == null && this.zzgp;
            return bl;
        }
        finally {
            this.zzga.unlock();
        }
    }

    private final boolean zzaf() {
        this.zzga.lock();
        try {
            if (!this.zzgp || !this.zzgm) {
                return false;
            }
            for (Api.AnyClientKey<?> anyClientKey : this.zzgh.keySet()) {
                ConnectionResult connectionResult = this.zza(anyClientKey);
                if (connectionResult != null && connectionResult.isSuccess()) continue;
                return false;
            }
            return true;
        }
        finally {
            this.zzga.unlock();
        }
    }

    @Override
    public final boolean maybeSignIn(SignInConnectionListener signInConnectionListener) {
        this.zzga.lock();
        try {
            if (this.zzgp && !this.zzaf()) {
                this.zzcq.zzr();
                this.zzgs = new zzz(this, signInConnectionListener);
                this.zzcq.zza(this.zzgh.values()).addOnCompleteListener((Executor)new HandlerExecutor(this.zzcn), (OnCompleteListener)this.zzgs);
                return true;
            }
            return false;
        }
        finally {
            this.zzga.unlock();
        }
    }

    @Override
    public final void maybeSignOut() {
        this.zzga.lock();
        try {
            this.zzcq.maybeSignOut();
            if (this.zzgs != null) {
                this.zzgs.cancel();
                this.zzgs = null;
            }
            if (this.zzgr == null) {
                this.zzgr = new ArrayMap(this.zzgh.size());
            }
            ConnectionResult connectionResult = new ConnectionResult(4);
            for (zzv<?> zzv2 : this.zzgh.values()) {
                this.zzgr.put(zzv2.zzm(), connectionResult);
            }
            if (this.zzgq != null) {
                this.zzgq.putAll(this.zzgr);
            }
            return;
        }
        finally {
            this.zzga.unlock();
        }
    }

    @Override
    public final void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
    }

    @Override
    public final void zzz() {
    }

    @GuardedBy(value="mLock")
    private final void zzag() {
        if (this.zzgf == null) {
            this.zzgj.zzim = Collections.emptySet();
            return;
        }
        HashSet<Scope> hashSet = new HashSet<Scope>(this.zzgf.getRequiredScopes());
        Map<Api<?>, ClientSettings.OptionalApiSettings> map = this.zzgf.getOptionalApiSettings();
        for (Api<?> api : map.keySet()) {
            ConnectionResult connectionResult = this.getConnectionResult(api);
            if (connectionResult == null || !connectionResult.isSuccess()) continue;
            hashSet.addAll(map.get(api).mScopes);
        }
        this.zzgj.zzim = hashSet;
    }

    @GuardedBy(value="mLock")
    private final void zzah() {
        while (!this.zzgo.isEmpty()) {
            this.execute(this.zzgo.remove());
        }
        this.zzgj.zzb((Bundle)null);
    }

    private final boolean zza(zzv<?> zzv2, ConnectionResult connectionResult) {
        return !connectionResult.isSuccess() && !connectionResult.hasResolution() && this.zzgi.get(zzv2.getApi()) != false && zzv2.zzae().requiresGooglePlayServices() && this.zzgk.isUserResolvableError(connectionResult.getErrorCode());
    }

    @GuardedBy(value="mLock")
    @Nullable
    private final ConnectionResult zzai() {
        ConnectionResult connectionResult = null;
        int n = 0;
        ConnectionResult connectionResult2 = null;
        int n2 = 0;
        for (zzv<?> zzv2 : this.zzgg.values()) {
            int n3;
            Api api = zzv2.getApi();
            zzh zzh2 = zzv2.zzm();
            ConnectionResult connectionResult3 = this.zzgq.get(zzh2);
            if (connectionResult3.isSuccess() || this.zzgi.get(api).booleanValue() && !connectionResult3.hasResolution() && !this.zzgk.isUserResolvableError(connectionResult3.getErrorCode())) continue;
            if (connectionResult3.getErrorCode() == 4 && this.zzgm) {
                n3 = api.zzj().getPriority();
                if (connectionResult2 != null && n2 <= n3) continue;
                connectionResult2 = connectionResult3;
                n2 = n3;
                continue;
            }
            n3 = api.zzj().getPriority();
            if (connectionResult != null && n <= n3) continue;
            connectionResult = connectionResult3;
            n = n3;
        }
        if (connectionResult != null && connectionResult2 != null && n > n2) {
            return connectionResult2;
        }
        return connectionResult;
    }

    static /* synthetic */ Lock zza(zzw zzw2) {
        return zzw2.zzga;
    }

    static /* synthetic */ boolean zzb(zzw zzw2) {
        return zzw2.zzgp;
    }

    static /* synthetic */ Map zza(zzw zzw2, Map map) {
        zzw2.zzgq = map;
        return zzw2.zzgq;
    }

    static /* synthetic */ Map zzc(zzw zzw2) {
        return zzw2.zzgg;
    }

    static /* synthetic */ Map zzd(zzw zzw2) {
        return zzw2.zzgq;
    }

    static /* synthetic */ boolean zze(zzw zzw2) {
        return zzw2.zzgn;
    }

    static /* synthetic */ boolean zza(zzw zzw2, zzv zzv2, ConnectionResult connectionResult) {
        return zzw2.zza(zzv2, connectionResult);
    }

    static /* synthetic */ ConnectionResult zza(zzw zzw2, ConnectionResult connectionResult) {
        zzw2.zzgt = connectionResult;
        return zzw2.zzgt;
    }

    static /* synthetic */ ConnectionResult zzf(zzw zzw2) {
        return zzw2.zzai();
    }

    static /* synthetic */ Map zzg(zzw zzw2) {
        return zzw2.zzgr;
    }

    static /* synthetic */ ConnectionResult zzh(zzw zzw2) {
        return zzw2.zzgt;
    }

    static /* synthetic */ void zzi(zzw zzw2) {
        zzw2.zzag();
    }

    static /* synthetic */ void zzj(zzw zzw2) {
        zzw2.zzah();
    }

    static /* synthetic */ boolean zza(zzw zzw2, boolean bl) {
        zzw2.zzgp = false;
        return false;
    }

    static /* synthetic */ zzav zzk(zzw zzw2) {
        return zzw2.zzgj;
    }

    static /* synthetic */ Condition zzl(zzw zzw2) {
        return zzw2.zzgl;
    }

    static /* synthetic */ Map zzb(zzw zzw2, Map map) {
        zzw2.zzgr = map;
        return zzw2.zzgr;
    }

    static /* synthetic */ Map zzm(zzw zzw2) {
        return zzw2.zzgh;
    }
}

