/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.data;

import android.os.Bundle;
import com.google.android.gms.common.data.AbstractDataBuffer;
import com.google.android.gms.common.data.DataBufferObserver;
import com.google.android.gms.common.data.DataBufferObserverSet;
import com.google.android.gms.common.data.ObjectExclusionFilterable;
import com.google.android.gms.common.internal.Asserts;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;

public final class ObjectDataBuffer<T>
extends AbstractDataBuffer<T>
implements DataBufferObserver.Observable,
ObjectExclusionFilterable<T> {
    private final ArrayList<T> zzog;
    private final HashSet<Integer> zzoe = new HashSet();
    private final ArrayList<Integer> zzob = new ArrayList();
    private DataBufferObserverSet zzof;

    public ObjectDataBuffer() {
        super(null);
        this.zzog = new ArrayList();
        this.zzof = new DataBufferObserverSet();
        this.zzcl();
    }

    public ObjectDataBuffer(T ... TArray) {
        super(null);
        this.zzog = new ArrayList<T>(Arrays.asList(TArray));
        this.zzof = new DataBufferObserverSet();
        this.zzcl();
    }

    public ObjectDataBuffer(ArrayList<T> arrayList) {
        super(null);
        this.zzog = arrayList;
        this.zzof = new DataBufferObserverSet();
        this.zzcl();
    }

    @Override
    public final void addObserver(DataBufferObserver dataBufferObserver) {
        this.zzof.addObserver(dataBufferObserver);
    }

    @Override
    public final void removeObserver(DataBufferObserver dataBufferObserver) {
        this.zzof.removeObserver(dataBufferObserver);
    }

    public final void add(T t) {
        int n = this.zzog.size();
        this.zzog.add(t);
        this.zzcl();
        if (this.zzof.hasObservers()) {
            Asserts.checkState((!this.zzoe.contains(n) ? 1 : 0) != 0);
            int n2 = this.zzob.size();
            Asserts.checkState((n2 > 0 ? 1 : 0) != 0);
            Asserts.checkState((this.zzob.get(n2 - 1) == n ? 1 : 0) != 0);
            this.zzof.onDataRangeInserted(n2 - 1, 1);
        }
    }

    public final void insertRaw(int n, T t) {
        this.zzog.add(n, t);
        int n2 = n;
        HashSet<Integer> hashSet = new HashSet<Integer>(this.zzoe.size());
        Iterator<Integer> iterator = this.zzoe.iterator();
        while (iterator.hasNext()) {
            Integer n3 = iterator.next();
            if (n3 < n) {
                --n2;
                continue;
            }
            hashSet.add(n3 + 1);
            iterator.remove();
        }
        for (Integer n3 : hashSet) {
            this.zzoe.add(n3);
        }
        this.zzcl();
        if (this.zzof.hasObservers()) {
            this.zzof.onDataRangeInserted(n2, 1);
        }
    }

    public final boolean setRaw(int n, T t) {
        this.zzog.set(n, t);
        boolean bl = !this.zzoe.contains(n);
        if (bl && this.zzof.hasObservers()) {
            int n2 = this.zzob.size();
            for (int i = 0; i < n2; ++i) {
                if (this.zzob.get(i) != n) continue;
                this.zzof.onDataRangeChanged(i, 1);
                break;
            }
        }
        return bl;
    }

    @Override
    public final int getCount() {
        return this.zzog.size() - this.zzoe.size();
    }

    @Override
    public final T get(int n) {
        return this.zzog.get(this.getRawPosition(n));
    }

    public final int getRawCount() {
        return this.zzog.size();
    }

    public final T getRaw(int n) {
        return this.zzog.get(n);
    }

    public final int getRawPosition(int n) {
        if (n < 0 || n >= ((AbstractDataBuffer)this).getCount()) {
            throw new IllegalArgumentException(new StringBuilder(53).append("Position ").append(n).append(" is out of bounds for this buffer").toString());
        }
        return this.zzob.get(n);
    }

    public final int getPositionFromRawPosition(int n) {
        int n2 = -1;
        for (int i = 0; i <= n; ++i) {
            if (this.zzoe.contains(i)) continue;
            ++n2;
        }
        return n2;
    }

    public final boolean isRawPositionFiltered(int n) {
        return this.zzoe.contains(n);
    }

    @Override
    public final void release() {
        this.zzof.clear();
    }

    @Override
    public final Bundle getMetadata() {
        return null;
    }

    public final void removeRaw(int n) {
        this.zzog.remove(n);
        boolean bl = this.zzoe.remove(n);
        int n2 = n;
        HashSet<Integer> hashSet = new HashSet<Integer>(this.zzoe.size());
        Iterator<Integer> iterator = this.zzoe.iterator();
        while (iterator.hasNext()) {
            Integer n3 = iterator.next();
            if (n3 < n) {
                --n2;
                continue;
            }
            iterator.remove();
            hashSet.add(n3 - 1);
        }
        for (Integer n3 : hashSet) {
            this.zzoe.add(n3);
        }
        this.zzcl();
        if (!bl && this.zzof.hasObservers()) {
            this.zzof.onDataRangeRemoved(n2, 1);
        }
    }

    @Override
    public final void filterOut(T t) {
        int n = -1;
        boolean bl = false;
        int n2 = -1;
        int n3 = -1;
        int n4 = this.zzog.size();
        for (int i = 0; i < n4; ++i) {
            if (this.zzoe.contains(i)) continue;
            ++n;
            if (t.equals(this.zzog.get(i))) {
                this.zzoe.add(i);
                bl = true;
                if (!this.zzof.hasObservers()) continue;
                if (n2 < 0) {
                    n2 = n;
                    n3 = 1;
                    continue;
                }
                ++n3;
                continue;
            }
            if (n2 < 0) continue;
            this.zzcl();
            bl = false;
            this.zzof.onDataRangeRemoved(n2, n3);
            n -= n3;
            n2 = -1;
            n3 = -1;
        }
        if (bl) {
            this.zzcl();
        }
        if (n2 >= 0) {
            this.zzof.onDataRangeRemoved(n2, n3);
        }
    }

    public final void filterOutRaw(int n) {
        boolean bl = this.zzoe.add(n);
        int n2 = -1;
        if (this.zzof.hasObservers() && bl) {
            int n3 = this.zzob.size();
            for (int i = 0; i < n3; ++i) {
                if (this.zzob.get(i) != n) continue;
                n2 = i;
                break;
            }
        }
        this.zzcl();
        if (n2 >= 0) {
            this.zzof.onDataRangeRemoved(n2, 1);
        }
    }

    public final void unfilter(T t) {
        int n = 0;
        boolean bl = false;
        int n2 = -1;
        int n3 = -1;
        int n4 = this.zzog.size();
        for (int i = 0; i < n4; ++i) {
            if (!this.zzoe.contains(i)) {
                ++n;
                if (n2 < 0) continue;
                this.zzcl();
                bl = false;
                this.zzof.onDataRangeInserted(n2, n3);
                n += n3;
                n2 = -1;
                n3 = -1;
                continue;
            }
            if (t.equals(this.zzog.get(i))) {
                this.zzoe.remove(i);
                bl = true;
                if (!this.zzof.hasObservers()) continue;
                if (n2 < 0) {
                    n2 = n;
                    n3 = 1;
                    continue;
                }
                ++n3;
                continue;
            }
            if (!this.zzof.hasObservers() || n2 < 0) continue;
            this.zzcl();
            bl = false;
            this.zzof.onDataRangeInserted(n2, n3);
            n += n3;
            n2 = -1;
            n3 = -1;
        }
        if (bl) {
            this.zzcl();
        }
        if (n2 >= 0) {
            this.zzof.onDataRangeInserted(n2, n3);
        }
    }

    public final void unfilterRaw(int n) {
        boolean bl = this.zzoe.remove(n);
        this.zzcl();
        if (!this.zzof.hasObservers() || !bl) {
            return;
        }
        int n2 = -1;
        int n3 = this.zzob.size();
        for (int i = 0; i < n3; ++i) {
            if (this.zzob.get(i) != n) continue;
            n2 = i;
            break;
        }
        if (n2 >= 0) {
            this.zzof.onDataRangeInserted(n2, 1);
        }
    }

    public final void notifyChanged(T t) {
        if (!this.zzof.hasObservers()) {
            return;
        }
        int n = this.zzob.size();
        for (int i = 0; i < n; ++i) {
            if (!t.equals(this.zzog.get(this.zzob.get(i)))) continue;
            this.zzof.onDataRangeChanged(i, 1);
        }
    }

    private final void zzcl() {
        this.zzob.clear();
        int n = this.zzog.size();
        for (int i = 0; i < n; ++i) {
            if (this.zzoe.contains(i)) continue;
            this.zzob.add(i);
        }
    }
}

