/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.images;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.widget.ImageView;
import android.widget.TextView;
import com.google.android.gms.common.images.ImageManager;
import com.google.android.gms.common.images.internal.CrossFadingDrawable;
import com.google.android.gms.common.images.internal.ImageUtils;
import com.google.android.gms.common.images.internal.LoadingImageView;
import com.google.android.gms.common.images.internal.PostProcessedResourceCache;
import com.google.android.gms.common.internal.Asserts;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.util.PlatformVersion;
import java.lang.ref.WeakReference;

public abstract class ImageRequest {
    final zza zzpk;
    protected int mLoadingPlaceholderResId = 0;
    protected int mNoDataPlaceholderResId = 0;
    protected boolean mUseNewDrawable = false;
    protected ImageManager.OnImageLoadedListener mOnImageLoadedListener;
    private boolean zzpl = true;
    private boolean zzpm = false;
    private boolean zzpn = true;
    protected int mPostProcessingFlags;

    public ImageRequest(Uri uri, int n) {
        this.zzpk = new zza(uri);
        this.mNoDataPlaceholderResId = n;
    }

    public void setLoadingPlaceholder(int n) {
        this.mLoadingPlaceholderResId = n;
    }

    public void setOnImageLoadedListener(ImageManager.OnImageLoadedListener onImageLoadedListener) {
        this.mOnImageLoadedListener = onImageLoadedListener;
    }

    public void setNoDataPlaceholder(int n) {
        this.mNoDataPlaceholderResId = n;
    }

    public void setCrossFadeEnabled(boolean bl) {
        this.zzpl = bl;
    }

    public void setCrossFadeAlwaysEnabled(boolean bl) {
        this.zzpm = bl;
        if (bl) {
            this.setCrossFadeEnabled(true);
        }
    }

    public void setLoadingPlaceholderEnabled(boolean bl) {
        this.zzpn = bl;
    }

    public void setPostProcessingFlags(int n) {
        this.mPostProcessingFlags = n;
    }

    public void setUseNewDrawable(boolean bl) {
        this.mUseNewDrawable = bl;
    }

    final void zza(Context context, Bitmap bitmap, boolean bl) {
        Asserts.checkNotNull((Object)bitmap);
        if ((this.mPostProcessingFlags & 1) != 0) {
            bitmap = ImageUtils.frameBitmapInCircle(bitmap);
        }
        BitmapDrawable bitmapDrawable = new BitmapDrawable(context.getResources(), bitmap);
        if (this.mOnImageLoadedListener != null) {
            this.mOnImageLoadedListener.onImageLoaded(this.zzpk.uri, (Drawable)bitmapDrawable, true);
        }
        this.loadImage((Drawable)bitmapDrawable, bl, false, true);
    }

    final void zza(Context context, PostProcessedResourceCache postProcessedResourceCache) {
        if (this.zzpn) {
            Drawable drawable2 = null;
            if (this.mLoadingPlaceholderResId != 0) {
                drawable2 = this.zza(context, postProcessedResourceCache, this.mLoadingPlaceholderResId);
            }
            this.loadImage(drawable2, false, true, false);
        }
    }

    final void zza(Context context, PostProcessedResourceCache postProcessedResourceCache, boolean bl) {
        Drawable drawable2 = null;
        if (this.mNoDataPlaceholderResId != 0) {
            drawable2 = this.zza(context, postProcessedResourceCache, this.mNoDataPlaceholderResId);
        }
        if (this.mOnImageLoadedListener != null) {
            this.mOnImageLoadedListener.onImageLoaded(this.zzpk.uri, drawable2, false);
        }
        this.loadImage(drawable2, bl, false, false);
    }

    private final Drawable zza(Context context, PostProcessedResourceCache postProcessedResourceCache, int n) {
        Resources resources = context.getResources();
        if (this.mPostProcessingFlags > 0) {
            PostProcessedResourceCache.PostProcessedResource postProcessedResource = new PostProcessedResourceCache.PostProcessedResource(n, this.mPostProcessingFlags);
            Drawable drawable2 = (Drawable)postProcessedResourceCache.get(postProcessedResource);
            if (drawable2 == null) {
                drawable2 = resources.getDrawable(n);
                if ((this.mPostProcessingFlags & 1) != 0) {
                    drawable2 = this.frameDrawableInCircle(resources, drawable2);
                }
                postProcessedResourceCache.put(postProcessedResource, drawable2);
            }
            return drawable2;
        }
        return resources.getDrawable(n);
    }

    protected Drawable frameDrawableInCircle(Resources resources, Drawable drawable2) {
        return ImageUtils.frameDrawableInCircle(resources, drawable2);
    }

    protected abstract void loadImage(Drawable var1, boolean var2, boolean var3, boolean var4);

    protected boolean shouldCrossFade(boolean bl, boolean bl2) {
        return this.zzpl && !bl2 && (!bl || this.zzpm);
    }

    protected CrossFadingDrawable createTransitionDrawable(Drawable drawable2, Drawable drawable3) {
        Drawable drawable4 = null;
        if (drawable2 != null) {
            drawable4 = drawable2 instanceof CrossFadingDrawable ? ((CrossFadingDrawable)drawable2).getEndDrawable() : drawable2;
        }
        return new CrossFadingDrawable(drawable4, drawable3);
    }

    static final class zza {
        public final Uri uri;

        public zza(Uri uri) {
            this.uri = uri;
        }

        public final int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.uri});
        }

        public final boolean equals(Object object) {
            if (!(object instanceof zza)) {
                return false;
            }
            if (this == object) {
                return true;
            }
            return Objects.equal((Object)((zza)object).uri, (Object)this.uri);
        }
    }

    public static final class TextViewImageRequest
    extends ImageRequest {
        public static final int POSITION_START = 0;
        public static final int POSITION_TOP = 1;
        public static final int POSITION_END = 2;
        public static final int POSITION_BOTTOM = 3;
        private WeakReference<TextView> zzpq;
        private int zzpr = -1;

        public TextViewImageRequest(TextView textView, int n, Uri uri) {
            super(uri, 0);
            Asserts.checkNotNull((Object)textView);
            Asserts.checkState((n != 0 && n != 1 && n != 2 && n != 3 ? 1 : 0) != 0, (Object)new StringBuilder(29).append("Invalid position: ").append(n).toString());
            this.zzpq = new WeakReference<TextView>(textView);
            this.zzpr = n;
        }

        public TextViewImageRequest(TextView textView, int n, int n2) {
            super(null, n2);
            Asserts.checkNotNull((Object)textView);
            Asserts.checkState((n != 0 && n != 1 && n != 2 && n != 3 ? 1 : 0) != 0, (Object)new StringBuilder(29).append("Invalid position: ").append(n).toString());
            this.zzpq = new WeakReference<TextView>(textView);
            this.zzpr = n;
        }

        public final int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.zzpr});
        }

        public final boolean equals(Object object) {
            if (!(object instanceof TextViewImageRequest)) {
                return false;
            }
            if (this == object) {
                return true;
            }
            TextViewImageRequest textViewImageRequest = (TextViewImageRequest)object;
            TextView textView = (TextView)this.zzpq.get();
            TextView textView2 = (TextView)textViewImageRequest.zzpq.get();
            return textView2 != null && textView != null && Objects.equal((Object)textView2, (Object)textView) && Objects.equal((Object)textViewImageRequest.zzpr, (Object)this.zzpr);
        }

        @Override
        protected final void loadImage(Drawable drawable2, boolean bl, boolean bl2, boolean bl3) {
            TextView textView = (TextView)this.zzpq.get();
            if (textView != null) {
                Drawable drawable3;
                Drawable drawable4 = drawable2;
                int n = this.zzpr;
                TextView textView2 = textView;
                TextViewImageRequest textViewImageRequest = this;
                boolean bl4 = textViewImageRequest.shouldCrossFade(bl, bl2);
                Drawable drawable5 = drawable4;
                Drawable[] drawableArray = PlatformVersion.isAtLeastJellyBeanMR1() ? textView2.getCompoundDrawablesRelative() : textView2.getCompoundDrawables();
                Drawable drawable6 = drawableArray[n];
                if (bl4) {
                    drawable5 = textViewImageRequest.createTransitionDrawable(drawable6, drawable4);
                }
                Drawable drawable7 = n == 0 ? drawable5 : drawableArray[0];
                Drawable drawable8 = n == 1 ? drawable5 : drawableArray[1];
                Drawable drawable9 = n == 2 ? drawable5 : drawableArray[2];
                Drawable drawable10 = drawable3 = n == 3 ? drawable5 : drawableArray[3];
                if (PlatformVersion.isAtLeastJellyBeanMR1()) {
                    textView2.setCompoundDrawablesRelativeWithIntrinsicBounds(drawable7, drawable8, drawable9, drawable3);
                } else {
                    textView2.setCompoundDrawablesWithIntrinsicBounds(drawable7, drawable8, drawable9, drawable3);
                }
                if (bl4) {
                    ((CrossFadingDrawable)drawable5).startTransition(250);
                }
            }
        }
    }

    public static final class ListenerImageRequest
    extends ImageRequest {
        private WeakReference<ImageManager.OnImageLoadedListener> zzpp;

        public ListenerImageRequest(ImageManager.OnImageLoadedListener onImageLoadedListener, Uri uri) {
            super(uri, 0);
            Asserts.checkNotNull((Object)onImageLoadedListener);
            this.zzpp = new WeakReference<ImageManager.OnImageLoadedListener>(onImageLoadedListener);
        }

        public final int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.zzpk});
        }

        public final boolean equals(Object object) {
            if (!(object instanceof ListenerImageRequest)) {
                return false;
            }
            if (this == object) {
                return true;
            }
            ListenerImageRequest listenerImageRequest = (ListenerImageRequest)object;
            ImageManager.OnImageLoadedListener onImageLoadedListener = (ImageManager.OnImageLoadedListener)this.zzpp.get();
            ImageManager.OnImageLoadedListener onImageLoadedListener2 = (ImageManager.OnImageLoadedListener)listenerImageRequest.zzpp.get();
            return onImageLoadedListener2 != null && onImageLoadedListener != null && Objects.equal((Object)onImageLoadedListener2, (Object)onImageLoadedListener) && Objects.equal((Object)listenerImageRequest.zzpk, (Object)this.zzpk);
        }

        @Override
        protected final void loadImage(Drawable drawable2, boolean bl, boolean bl2, boolean bl3) {
            ImageManager.OnImageLoadedListener onImageLoadedListener;
            if (!bl2 && (onImageLoadedListener = (ImageManager.OnImageLoadedListener)this.zzpp.get()) != null) {
                onImageLoadedListener.onImageLoaded(this.zzpk.uri, drawable2, bl3);
            }
        }
    }

    public static final class ImageViewImageRequest
    extends ImageRequest {
        private WeakReference<ImageView> zzpo;

        public ImageViewImageRequest(ImageView imageView, Uri uri) {
            super(uri, 0);
            Asserts.checkNotNull((Object)imageView);
            this.zzpo = new WeakReference<ImageView>(imageView);
        }

        public ImageViewImageRequest(ImageView imageView, int n) {
            super(null, n);
            Asserts.checkNotNull((Object)imageView);
            this.zzpo = new WeakReference<ImageView>(imageView);
        }

        public final int hashCode() {
            return 0;
        }

        public final boolean equals(Object object) {
            if (!(object instanceof ImageViewImageRequest)) {
                return false;
            }
            if (this == object) {
                return true;
            }
            ImageViewImageRequest imageViewImageRequest = (ImageViewImageRequest)object;
            ImageView imageView = (ImageView)this.zzpo.get();
            ImageView imageView2 = (ImageView)imageViewImageRequest.zzpo.get();
            return imageView2 != null && imageView != null && Objects.equal((Object)imageView2, (Object)imageView);
        }

        @Override
        protected final void loadImage(Drawable drawable2, boolean bl, boolean bl2, boolean bl3) {
            block7: {
                boolean bl4;
                ImageViewImageRequest imageViewImageRequest;
                ImageView imageView;
                Drawable drawable3;
                block8: {
                    ImageView imageView2 = (ImageView)this.zzpo.get();
                    if (imageView2 == null) break block7;
                    drawable3 = drawable2;
                    imageView = imageView2;
                    imageViewImageRequest = this;
                    bl4 = !bl2 && !bl3;
                    if (!bl4 || !(imageView instanceof LoadingImageView)) break block8;
                    int n = ((LoadingImageView)imageView).getLoadedNoDataPlaceholderResId();
                    if (imageViewImageRequest.mNoDataPlaceholderResId != 0 && n == imageViewImageRequest.mNoDataPlaceholderResId) break block7;
                }
                boolean bl5 = imageViewImageRequest.shouldCrossFade(bl, bl2);
                if (imageViewImageRequest.mUseNewDrawable && drawable3 != null) {
                    drawable3 = drawable3.getConstantState().newDrawable();
                }
                Drawable drawable4 = drawable3;
                if (bl5) {
                    drawable4 = imageViewImageRequest.createTransitionDrawable(imageView.getDrawable(), drawable3);
                }
                imageView.setImageDrawable(drawable4);
                if (imageView instanceof LoadingImageView) {
                    LoadingImageView loadingImageView = (LoadingImageView)imageView;
                    Uri uri = bl3 ? imageViewImageRequest.zzpk.uri : null;
                    loadingImageView.setLoadedUri(uri);
                    int n = bl4 ? imageViewImageRequest.mNoDataPlaceholderResId : 0;
                    loadingImageView.setLoadedNoDataPlaceholderResId(n);
                }
                if (bl5) {
                    ((CrossFadingDrawable)drawable4).startTransition(250);
                }
            }
        }
    }

    public static final class PostProcessingFlags {
        public static final int CIRCLE_CROP = 1;

        public PostProcessingFlags() {
        }
    }
}

