/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.BaseImplementation;
import com.google.android.gms.common.api.internal.SignInConnectionListener;
import com.google.android.gms.common.api.internal.zaaw;
import com.google.android.gms.common.api.internal.zabe;
import com.google.android.gms.common.api.internal.zabs;
import com.google.android.gms.common.api.internal.zaq;
import com.google.android.gms.common.api.internal.zat;
import com.google.android.gms.common.api.internal.zau;
import com.google.android.gms.common.api.internal.zav;
import com.google.android.gms.common.internal.ClientSettings;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.base.zal;
import com.google.android.gms.signin.SignInOptions;
import com.google.android.gms.signin.zad;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import javax.annotation.concurrent.GuardedBy;

final class zas
implements zabs {
    private final Context mContext;
    private final zaaw zaed;
    private final Looper zabj;
    private final zabe zaee;
    private final zabe zaef;
    private final Map<Api.AnyClientKey<?>, zabe> zaeg;
    private final Set<SignInConnectionListener> zaeh = Collections.newSetFromMap(new WeakHashMap());
    private final Api.Client zaei;
    private Bundle zaej;
    private ConnectionResult zaek = null;
    private ConnectionResult zael = null;
    private boolean zaem = false;
    private final Lock zaen;
    @GuardedBy(value="mLock")
    private int zaeo = 0;

    public static zas zaa(Context context, zaaw zaaw2, Lock lock, Looper looper, GoogleApiAvailabilityLight googleApiAvailabilityLight, Map<Api.AnyClientKey<?>, Api.Client> map, ClientSettings clientSettings, Map<Api<?>, Boolean> map2, Api.AbstractClientBuilder<? extends zad, SignInOptions> abstractClientBuilder, ArrayList<zaq> arrayList) {
        Object object;
        Api.Client client = null;
        ArrayMap arrayMap2 = new ArrayMap();
        ArrayMap arrayMap3 = new ArrayMap();
        for (Map.Entry<Api.AnyClientKey<?>, Api.Client> arrayMap4 : map.entrySet()) {
            object = arrayMap4.getValue();
            if (object.providesSignIn()) {
                client = object;
            }
            if (object.requiresSignIn()) {
                arrayMap2.put(arrayMap4.getKey(), object);
                continue;
            }
            arrayMap3.put(arrayMap4.getKey(), object);
        }
        Preconditions.checkState((!arrayMap2.isEmpty() ? 1 : 0) != 0, (Object)"CompositeGoogleApiClient should not be used without any APIs that require sign-in.");
        ArrayMap arrayMap5 = new ArrayMap();
        ArrayMap arrayMap = new ArrayMap();
        for (Api api : map2.keySet()) {
            Api.AnyClientKey<?> anyClientKey = api.getClientKey();
            if (arrayMap2.containsKey(anyClientKey)) {
                arrayMap5.put(api, map2.get(api));
                continue;
            }
            if (arrayMap3.containsKey(anyClientKey)) {
                arrayMap.put(api, map2.get(api));
                continue;
            }
            throw new IllegalStateException("Each API in the isOptionalMap must have a corresponding client in the clients map.");
        }
        object = new ArrayList<zaq>();
        ArrayList<zaq> arrayList2 = new ArrayList<zaq>();
        ArrayList<zaq> arrayList3 = arrayList;
        int n = arrayList3.size();
        for (int i = 0; i < n; ++i) {
            zaq zaq2 = arrayList3.get(i);
            zaq zaq3 = zaq2;
            if (arrayMap5.containsKey(zaq3.mApi)) {
                ((ArrayList)object).add(zaq3);
                continue;
            }
            if (arrayMap.containsKey(zaq3.mApi)) {
                arrayList2.add(zaq3);
                continue;
            }
            throw new IllegalStateException("Each ClientCallbacks must have a corresponding API in the isOptionalMap");
        }
        return new zas(context, zaaw2, lock, looper, googleApiAvailabilityLight, (Map<Api.AnyClientKey<?>, Api.Client>)arrayMap2, (Map<Api.AnyClientKey<?>, Api.Client>)arrayMap3, clientSettings, abstractClientBuilder, client, (ArrayList<zaq>)object, arrayList2, (Map<Api<?>, Boolean>)arrayMap5, (Map<Api<?>, Boolean>)arrayMap);
    }

    private zas(Context context, zaaw zaaw2, Lock lock, Looper looper, GoogleApiAvailabilityLight googleApiAvailabilityLight, Map<Api.AnyClientKey<?>, Api.Client> map, Map<Api.AnyClientKey<?>, Api.Client> map2, ClientSettings clientSettings, Api.AbstractClientBuilder<? extends zad, SignInOptions> abstractClientBuilder, Api.Client client, ArrayList<zaq> arrayList, ArrayList<zaq> arrayList2, Map<Api<?>, Boolean> map3, Map<Api<?>, Boolean> map4) {
        this.mContext = context;
        this.zaed = zaaw2;
        this.zaen = lock;
        this.zabj = looper;
        this.zaei = client;
        this.zaee = new zabe(context, this.zaed, lock, looper, googleApiAvailabilityLight, map2, null, map4, null, arrayList2, new zau(this, null));
        this.zaef = new zabe(context, this.zaed, lock, looper, googleApiAvailabilityLight, map, clientSettings, map3, abstractClientBuilder, arrayList, new zav(this, null));
        ArrayMap arrayMap = new ArrayMap();
        for (Api.AnyClientKey<?> anyClientKey : map2.keySet()) {
            arrayMap.put(anyClientKey, (Object)this.zaee);
        }
        for (Api.AnyClientKey<?> anyClientKey : map.keySet()) {
            arrayMap.put(anyClientKey, (Object)this.zaef);
        }
        this.zaeg = Collections.unmodifiableMap(arrayMap);
    }

    @Override
    @GuardedBy(value="mLock")
    public final <A extends Api.AnyClient, R extends Result, T extends BaseImplementation.ApiMethodImpl<R, A>> T enqueue(@NonNull T t) {
        if (this.zaa(t)) {
            if (this.zaz()) {
                t.setFailedResult(new Status(4, null, this.zaaa()));
                return t;
            }
            return this.zaef.enqueue(t);
        }
        return this.zaee.enqueue(t);
    }

    @Override
    @GuardedBy(value="mLock")
    public final <A extends Api.AnyClient, T extends BaseImplementation.ApiMethodImpl<? extends Result, A>> T execute(@NonNull T t) {
        if (this.zaa(t)) {
            if (this.zaz()) {
                t.setFailedResult(new Status(4, null, this.zaaa()));
                return t;
            }
            return this.zaef.execute(t);
        }
        return this.zaee.execute(t);
    }

    @Override
    @GuardedBy(value="mLock")
    @Nullable
    public final ConnectionResult getConnectionResult(@NonNull Api<?> api) {
        if (this.zaeg.get(api.getClientKey()).equals(this.zaef)) {
            if (this.zaz()) {
                return new ConnectionResult(4, this.zaaa());
            }
            return this.zaef.getConnectionResult(api);
        }
        return this.zaee.getConnectionResult(api);
    }

    @Override
    @GuardedBy(value="mLock")
    public final void connect() {
        this.zaeo = 2;
        this.zaem = false;
        zas zas2 = this;
        this.zael = null;
        zas2.zaek = null;
        zas2.zaee.connect();
        zas2.zaef.connect();
    }

    @Override
    @GuardedBy(value="mLock")
    public final ConnectionResult blockingConnect() {
        throw new UnsupportedOperationException();
    }

    @Override
    @GuardedBy(value="mLock")
    public final ConnectionResult blockingConnect(long l, @NonNull TimeUnit timeUnit) {
        throw new UnsupportedOperationException();
    }

    @Override
    @GuardedBy(value="mLock")
    public final void disconnect() {
        this.zael = null;
        this.zaek = null;
        this.zaeo = 0;
        this.zaee.disconnect();
        this.zaef.disconnect();
        this.zay();
    }

    @Override
    public final boolean isConnected() {
        this.zaen.lock();
        try {
            boolean bl = this.zaee.isConnected() && (this.zaef.isConnected() || this.zaz() || this.zaeo == 1);
            return bl;
        }
        finally {
            this.zaen.unlock();
        }
    }

    @Override
    public final boolean isConnecting() {
        this.zaen.lock();
        try {
            boolean bl = this.zaeo == 2;
            return bl;
        }
        finally {
            this.zaen.unlock();
        }
    }

    @Override
    public final boolean maybeSignIn(SignInConnectionListener signInConnectionListener) {
        this.zaen.lock();
        try {
            if ((this.isConnecting() || this.isConnected()) && !this.zaef.isConnected()) {
                this.zaeh.add(signInConnectionListener);
                if (this.zaeo == 0) {
                    this.zaeo = 1;
                }
                this.zael = null;
                this.zaef.connect();
                return true;
            }
        }
        finally {
            this.zaen.unlock();
        }
        return false;
    }

    @Override
    @GuardedBy(value="mLock")
    public final void zaw() {
        this.zaee.zaw();
        this.zaef.zaw();
    }

    @Override
    public final void maybeSignOut() {
        this.zaen.lock();
        try {
            boolean bl = this.isConnecting();
            this.zaef.disconnect();
            this.zael = new ConnectionResult(4);
            if (bl) {
                new zal(this.zabj).post(new zat(this));
            } else {
                this.zay();
            }
            return;
        }
        finally {
            this.zaen.unlock();
        }
    }

    @GuardedBy(value="mLock")
    private final void zax() {
        if (zas.zab(this.zaek)) {
            if (zas.zab(this.zael) || this.zaz()) {
                zas zas2 = this;
                switch (zas2.zaeo) {
                    case 2: {
                        zas2.zaed.zab(zas2.zaej);
                    }
                    case 1: {
                        zas2.zay();
                        break;
                    }
                    default: {
                        Log.wtf((String)"CompositeGAC", (String)"Attempted to call success callbacks in CONNECTION_MODE_NONE. Callbacks should be disabled via GmsClientSupervisor", (Throwable)((Object)new AssertionError()));
                    }
                }
                zas2.zaeo = 0;
                return;
            }
            if (this.zael != null) {
                if (this.zaeo == 1) {
                    this.zay();
                    return;
                }
                this.zaa(this.zael);
                this.zaee.disconnect();
                return;
            }
        } else {
            if (this.zaek != null && zas.zab(this.zael)) {
                this.zaef.disconnect();
                this.zaa(this.zaek);
                return;
            }
            if (this.zaek != null && this.zael != null) {
                ConnectionResult connectionResult = this.zaek;
                if (this.zaef.zahr < this.zaee.zahr) {
                    connectionResult = this.zael;
                }
                this.zaa(connectionResult);
            }
        }
    }

    @GuardedBy(value="mLock")
    private final void zaa(ConnectionResult connectionResult) {
        switch (this.zaeo) {
            case 2: {
                this.zaed.zac(connectionResult);
            }
            case 1: {
                this.zay();
                break;
            }
            default: {
                Log.wtf((String)"CompositeGAC", (String)"Attempted to call failure callbacks in CONNECTION_MODE_NONE. Callbacks should be disabled via GmsClientSupervisor", (Throwable)new Exception());
            }
        }
        this.zaeo = 0;
    }

    @GuardedBy(value="mLock")
    private final void zay() {
        Iterator<SignInConnectionListener> iterator = this.zaeh.iterator();
        while (iterator.hasNext()) {
            iterator.next().onComplete();
        }
        this.zaeh.clear();
    }

    @GuardedBy(value="mLock")
    private final void zaa(int n, boolean bl) {
        this.zaed.zab(n, bl);
        this.zael = null;
        this.zaek = null;
    }

    @GuardedBy(value="mLock")
    private final boolean zaz() {
        return this.zael != null && this.zael.getErrorCode() == 4;
    }

    private final boolean zaa(BaseImplementation.ApiMethodImpl<? extends Result, ? extends Api.AnyClient> apiMethodImpl) {
        Api.AnyClientKey<? extends Api.AnyClient> anyClientKey = apiMethodImpl.getClientKey();
        Preconditions.checkArgument((boolean)this.zaeg.containsKey(anyClientKey), (Object)"GoogleApiClient is not configured to use the API required for this call.");
        return this.zaeg.get(anyClientKey).equals(this.zaef);
    }

    @Nullable
    private final PendingIntent zaaa() {
        if (this.zaei == null) {
            return null;
        }
        return PendingIntent.getActivity((Context)this.mContext, (int)System.identityHashCode(this.zaed), (Intent)this.zaei.getSignInIntent(), (int)0x8000000);
    }

    private final void zaa(Bundle bundle) {
        if (this.zaej == null) {
            this.zaej = bundle;
            return;
        }
        if (bundle != null) {
            this.zaej.putAll(bundle);
        }
    }

    private static boolean zab(ConnectionResult connectionResult) {
        return connectionResult != null && connectionResult.isSuccess();
    }

    @Override
    public final void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        printWriter.append(string2).append("authClient").println(":");
        this.zaef.dump(String.valueOf(string2).concat("  "), fileDescriptor, printWriter, stringArray);
        printWriter.append(string2).append("anonClient").println(":");
        this.zaee.dump(String.valueOf(string2).concat("  "), fileDescriptor, printWriter, stringArray);
    }

    static /* synthetic */ Lock zaa(zas zas2) {
        return zas2.zaen;
    }

    static /* synthetic */ void zab(zas zas2) {
        zas2.zax();
    }

    static /* synthetic */ void zaa(zas zas2, Bundle bundle) {
        zas2.zaa(bundle);
    }

    static /* synthetic */ ConnectionResult zaa(zas zas2, ConnectionResult connectionResult) {
        zas2.zaek = connectionResult;
        return zas2.zaek;
    }

    static /* synthetic */ boolean zac(zas zas2) {
        return zas2.zaem;
    }

    static /* synthetic */ ConnectionResult zad(zas zas2) {
        return zas2.zael;
    }

    static /* synthetic */ boolean zaa(zas zas2, boolean bl) {
        zas2.zaem = bl;
        return zas2.zaem;
    }

    static /* synthetic */ void zaa(zas zas2, int n, boolean bl) {
        zas2.zaa(n, bl);
    }

    static /* synthetic */ zabe zae(zas zas2) {
        return zas2.zaef;
    }

    static /* synthetic */ ConnectionResult zab(zas zas2, ConnectionResult connectionResult) {
        zas2.zael = connectionResult;
        return zas2.zael;
    }

    static /* synthetic */ zabe zaf(zas zas2) {
        return zas2.zaee;
    }
}

