/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.signin;

import android.accounts.Account;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.auth.api.signin.GoogleSignInOptionsExtension;
import com.google.android.gms.auth.api.signin.internal.GoogleSignInOptionsExtensionParcelable;
import com.google.android.gms.auth.api.signin.internal.HashAccumulator;
import com.google.android.gms.auth.api.signin.zac;
import com.google.android.gms.auth.api.signin.zad;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.util.VisibleForTesting;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@SafeParcelable.Class(creator="GoogleSignInOptionsCreator")
public class GoogleSignInOptions
extends AbstractSafeParcelable
implements Api.ApiOptions.Optional,
ReflectedParcelable {
    @VisibleForTesting
    public static final Scope zar = new Scope("profile");
    @VisibleForTesting
    public static final Scope zas = new Scope("email");
    @VisibleForTesting
    public static final Scope zat = new Scope("openid");
    @VisibleForTesting
    public static final Scope zau = new Scope("https://www.googleapis.com/auth/games_lite");
    @VisibleForTesting
    public static final Scope zav = new Scope("https://www.googleapis.com/auth/games");
    public static final GoogleSignInOptions DEFAULT_SIGN_IN = new Builder().requestId().requestProfile().build();
    public static final GoogleSignInOptions DEFAULT_GAMES_SIGN_IN = new Builder().requestScopes(zau, new Scope[0]).build();
    public static final Parcelable.Creator<GoogleSignInOptions> CREATOR = new zad();
    @SafeParcelable.VersionField(id=1)
    private final int versionCode;
    @SafeParcelable.Field(id=2, getter="getScopes")
    private final ArrayList<Scope> zaw;
    @SafeParcelable.Field(id=3, getter="getAccount")
    private Account zax;
    @SafeParcelable.Field(id=4, getter="isIdTokenRequested")
    private boolean zay;
    @SafeParcelable.Field(id=5, getter="isServerAuthCodeRequested")
    private final boolean zaz;
    @SafeParcelable.Field(id=6, getter="isForceCodeForRefreshToken")
    private final boolean zaaa;
    @SafeParcelable.Field(id=7, getter="getServerClientId")
    private String zaab;
    @SafeParcelable.Field(id=8, getter="getHostedDomain")
    private String zaac;
    @SafeParcelable.Field(id=9, getter="getExtensions")
    private ArrayList<GoogleSignInOptionsExtensionParcelable> zaad;
    private Map<Integer, GoogleSignInOptionsExtensionParcelable> zaae;
    private static Comparator<Scope> zaaf = new zac();

    @Nullable
    public static GoogleSignInOptions zab(@Nullable String string) throws JSONException {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        JSONObject jSONObject = new JSONObject(string);
        HashSet<Scope> hashSet = new HashSet<Scope>();
        JSONArray jSONArray = jSONObject.getJSONArray("scopes");
        int n = jSONArray.length();
        for (int i = 0; i < n; ++i) {
            hashSet.add(new Scope(jSONArray.getString(i)));
        }
        Account account = null;
        String string2 = jSONObject.optString("accountName", null);
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            account = new Account(string2, "com.google");
        }
        return new GoogleSignInOptions(3, new ArrayList<Scope>(hashSet), account, jSONObject.getBoolean("idTokenRequested"), jSONObject.getBoolean("serverAuthRequested"), jSONObject.getBoolean("forceCodeForRefreshToken"), jSONObject.optString("serverClientId", null), jSONObject.optString("hostedDomain", null), new HashMap<Integer, GoogleSignInOptionsExtensionParcelable>());
    }

    @SafeParcelable.Constructor
    GoogleSignInOptions(@SafeParcelable.Param(id=1) int n, @SafeParcelable.Param(id=2) ArrayList<Scope> arrayList, @SafeParcelable.Param(id=3) Account account, @SafeParcelable.Param(id=4) boolean bl, @SafeParcelable.Param(id=5) boolean bl2, @SafeParcelable.Param(id=6) boolean bl3, @SafeParcelable.Param(id=7) String string, @SafeParcelable.Param(id=8) String string2, @SafeParcelable.Param(id=9) ArrayList<GoogleSignInOptionsExtensionParcelable> arrayList2) {
        this(n, arrayList, account, bl, bl2, bl3, string, string2, GoogleSignInOptions.zaa(arrayList2));
    }

    private GoogleSignInOptions(int n, ArrayList<Scope> arrayList, Account account, boolean bl, boolean bl2, boolean bl3, String string, String string2, Map<Integer, GoogleSignInOptionsExtensionParcelable> map) {
        this.versionCode = n;
        this.zaw = arrayList;
        this.zax = account;
        this.zay = bl;
        this.zaz = bl2;
        this.zaaa = bl3;
        this.zaab = string;
        this.zaac = string2;
        this.zaad = new ArrayList<GoogleSignInOptionsExtensionParcelable>(map.values());
        this.zaae = map;
    }

    @KeepForSdk
    public ArrayList<Scope> getScopes() {
        return new ArrayList<Scope>(this.zaw);
    }

    public Scope[] getScopeArray() {
        return this.zaw.toArray(new Scope[this.zaw.size()]);
    }

    @KeepForSdk
    public Account getAccount() {
        return this.zax;
    }

    @KeepForSdk
    public boolean isIdTokenRequested() {
        return this.zay;
    }

    @KeepForSdk
    public boolean isServerAuthCodeRequested() {
        return this.zaz;
    }

    @KeepForSdk
    public boolean isForceCodeForRefreshToken() {
        return this.zaaa;
    }

    @KeepForSdk
    public String getServerClientId() {
        return this.zaab;
    }

    @KeepForSdk
    public ArrayList<GoogleSignInOptionsExtensionParcelable> getExtensions() {
        return this.zaad;
    }

    private static Map<Integer, GoogleSignInOptionsExtensionParcelable> zaa(@Nullable List<GoogleSignInOptionsExtensionParcelable> list) {
        HashMap<Integer, GoogleSignInOptionsExtensionParcelable> hashMap = new HashMap<Integer, GoogleSignInOptionsExtensionParcelable>();
        if (list == null) {
            return hashMap;
        }
        for (GoogleSignInOptionsExtensionParcelable googleSignInOptionsExtensionParcelable : list) {
            hashMap.put(googleSignInOptionsExtensionParcelable.getType(), googleSignInOptionsExtensionParcelable);
        }
        return hashMap;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        GoogleSignInOptions googleSignInOptions = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)1, (int)googleSignInOptions.versionCode);
        SafeParcelWriter.writeTypedList((Parcel)parcel2, (int)2, googleSignInOptions.getScopes(), (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)3, (Parcelable)googleSignInOptions.getAccount(), (int)n, (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)4, (boolean)googleSignInOptions.isIdTokenRequested());
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)5, (boolean)googleSignInOptions.isServerAuthCodeRequested());
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)6, (boolean)googleSignInOptions.isForceCodeForRefreshToken());
        SafeParcelWriter.writeString((Parcel)parcel2, (int)7, (String)googleSignInOptions.getServerClientId(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)8, (String)googleSignInOptions.zaac, (boolean)false);
        SafeParcelWriter.writeTypedList((Parcel)parcel2, (int)9, googleSignInOptions.getExtensions(), (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        try {
            GoogleSignInOptions googleSignInOptions = (GoogleSignInOptions)object;
            if (this.zaad.size() > 0 || googleSignInOptions.zaad.size() > 0) {
                return false;
            }
            if (this.zaw.size() != googleSignInOptions.getScopes().size() || !this.zaw.containsAll(googleSignInOptions.getScopes())) {
                return false;
            }
            return (this.zax == null ? googleSignInOptions.getAccount() == null : this.zax.equals((Object)googleSignInOptions.getAccount())) && (TextUtils.isEmpty((CharSequence)this.zaab) ? TextUtils.isEmpty((CharSequence)googleSignInOptions.getServerClientId()) : this.zaab.equals(googleSignInOptions.getServerClientId())) && this.zaaa == googleSignInOptions.isForceCodeForRefreshToken() && this.zay == googleSignInOptions.isIdTokenRequested() && this.zaz == googleSignInOptions.isServerAuthCodeRequested();
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int hashCode() {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Scope> arrayList2 = this.zaw;
        int n = arrayList2.size();
        for (int i = 0; i < n; ++i) {
            Scope scope = arrayList2.get(i);
            Scope scope2 = scope;
            arrayList.add(scope2.getScopeUri());
        }
        Collections.sort(arrayList);
        return new HashAccumulator().addObject(arrayList).addObject(this.zax).addObject(this.zaab).zaa(this.zaaa).zaa(this.zay).zaa(this.zaz).hash();
    }

    public final String zae() {
        return this.zad().toString();
    }

    private final JSONObject zad() {
        JSONObject jSONObject = new JSONObject();
        try {
            JSONArray jSONArray = new JSONArray();
            Collections.sort(this.zaw, zaaf);
            ArrayList<Scope> arrayList = this.zaw;
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                Scope scope = arrayList.get(i);
                Scope scope2 = scope;
                jSONArray.put((Object)scope2.getScopeUri());
            }
            jSONObject.put("scopes", (Object)jSONArray);
            if (this.zax != null) {
                jSONObject.put("accountName", (Object)this.zax.name);
            }
            jSONObject.put("idTokenRequested", this.zay);
            jSONObject.put("forceCodeForRefreshToken", this.zaaa);
            jSONObject.put("serverAuthRequested", this.zaz);
            if (!TextUtils.isEmpty((CharSequence)this.zaab)) {
                jSONObject.put("serverClientId", (Object)this.zaab);
            }
            if (!TextUtils.isEmpty((CharSequence)this.zaac)) {
                jSONObject.put("hostedDomain", (Object)this.zaac);
            }
            return jSONObject;
        }
        catch (JSONException jSONException) {
            throw new RuntimeException(jSONException);
        }
    }

    /* synthetic */ GoogleSignInOptions(int n, ArrayList arrayList, Account account, boolean bl, boolean bl2, boolean bl3, String string, String string2, Map map, zac zac2) {
        this(3, (ArrayList<Scope>)arrayList, account, bl, bl2, bl3, string, string2, map);
    }

    public static final class Builder {
        private Set<Scope> mScopes = new HashSet<Scope>();
        private boolean zaz;
        private boolean zaaa;
        private boolean zay;
        private String zaab;
        private Account zax;
        private String zaac;
        private Map<Integer, GoogleSignInOptionsExtensionParcelable> zaag = new HashMap<Integer, GoogleSignInOptionsExtensionParcelable>();

        public Builder() {
        }

        public Builder(@NonNull GoogleSignInOptions googleSignInOptions) {
            Preconditions.checkNotNull((Object)googleSignInOptions);
            this.mScopes = new HashSet<Scope>(googleSignInOptions.zaw);
            this.zaz = googleSignInOptions.zaz;
            this.zaaa = googleSignInOptions.zaaa;
            this.zay = googleSignInOptions.zay;
            this.zaab = googleSignInOptions.zaab;
            this.zax = googleSignInOptions.zax;
            this.zaac = googleSignInOptions.zaac;
            this.zaag = GoogleSignInOptions.zaa(googleSignInOptions.zaad);
        }

        public final Builder requestId() {
            this.mScopes.add(zat);
            return this;
        }

        public final Builder requestEmail() {
            this.mScopes.add(zas);
            return this;
        }

        public final Builder requestProfile() {
            this.mScopes.add(zar);
            return this;
        }

        public final Builder requestScopes(Scope scope, Scope ... scopeArray) {
            this.mScopes.add(scope);
            this.mScopes.addAll(Arrays.asList(scopeArray));
            return this;
        }

        public final Builder requestIdToken(String string) {
            this.zay = true;
            this.zaab = this.zac(string);
            return this;
        }

        public final Builder requestServerAuthCode(String string) {
            return this.requestServerAuthCode(string, false);
        }

        public final Builder requestServerAuthCode(String string, boolean bl) {
            this.zaz = true;
            this.zaab = this.zac(string);
            this.zaaa = bl;
            return this;
        }

        public final Builder setAccountName(String string) {
            this.zax = new Account(Preconditions.checkNotEmpty((String)string), "com.google");
            return this;
        }

        public final Builder setHostedDomain(String string) {
            this.zaac = Preconditions.checkNotEmpty((String)string);
            return this;
        }

        public final Builder addExtension(GoogleSignInOptionsExtension googleSignInOptionsExtension) {
            if (this.zaag.containsKey(googleSignInOptionsExtension.getExtensionType())) {
                throw new IllegalStateException("Only one extension per type may be added");
            }
            if (googleSignInOptionsExtension.getImpliedScopes() != null) {
                this.mScopes.addAll(googleSignInOptionsExtension.getImpliedScopes());
            }
            this.zaag.put(googleSignInOptionsExtension.getExtensionType(), new GoogleSignInOptionsExtensionParcelable(googleSignInOptionsExtension));
            return this;
        }

        public final GoogleSignInOptions build() {
            if (this.mScopes.contains(zav) && this.mScopes.contains(zau)) {
                this.mScopes.remove(zau);
            }
            if (this.zay && (this.zax == null || !this.mScopes.isEmpty())) {
                this.requestId();
            }
            return new GoogleSignInOptions(3, new ArrayList<Scope>(this.mScopes), this.zax, this.zay, this.zaz, this.zaaa, this.zaab, this.zaac, this.zaag, null);
        }

        private final String zac(String string) {
            Preconditions.checkNotEmpty((String)string);
            Preconditions.checkArgument((this.zaab == null || this.zaab.equals(string) ? 1 : 0) != 0, (Object)"two different server client ids provided");
            return string;
        }
    }
}

