/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.os.Looper;
import android.os.Message;
import android.support.annotation.NonNull;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.base.zap;

@KeepForSdk
public final class ListenerHolder<L> {
    private final zaa zajj;
    private volatile L zajk;
    private final ListenerKey<L> zajl;

    @KeepForSdk
    ListenerHolder(@NonNull Looper looper, @NonNull L l, @NonNull String string2) {
        this.zajj = new zaa(looper);
        this.zajk = Preconditions.checkNotNull(l, (Object)"Listener must not be null");
        this.zajl = new ListenerKey<L>(l, Preconditions.checkNotEmpty((String)string2));
    }

    @KeepForSdk
    public final void notifyListener(Notifier<? super L> notifier) {
        Preconditions.checkNotNull(notifier, (Object)"Notifier must not be null");
        Message message = this.zajj.obtainMessage(1, notifier);
        this.zajj.sendMessage(message);
    }

    @KeepForSdk
    public final boolean hasListener() {
        return this.zajk != null;
    }

    @KeepForSdk
    public final void clear() {
        this.zajk = null;
    }

    @NonNull
    @KeepForSdk
    public final ListenerKey<L> getListenerKey() {
        return this.zajl;
    }

    @KeepForSdk
    final void notifyListenerInternal(Notifier<? super L> notifier) {
        L l = this.zajk;
        if (l == null) {
            notifier.onNotifyListenerFailed();
            return;
        }
        try {
            notifier.notifyListener(l);
            return;
        }
        catch (RuntimeException runtimeException) {
            notifier.onNotifyListenerFailed();
            throw runtimeException;
        }
    }

    @KeepForSdk
    public static final class ListenerKey<L> {
        private final L zajk;
        private final String zajn;

        @KeepForSdk
        ListenerKey(L l, String string2) {
            this.zajk = l;
            this.zajn = string2;
        }

        public final boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof ListenerKey)) {
                return false;
            }
            ListenerKey listenerKey = (ListenerKey)object;
            return this.zajk == listenerKey.zajk && this.zajn.equals(listenerKey.zajn);
        }

        public final int hashCode() {
            int n = System.identityHashCode(this.zajk);
            return n * 31 + this.zajn.hashCode();
        }
    }

    private final class zaa
    extends zap {
        public zaa(Looper looper) {
            super(looper);
        }

        public final void handleMessage(Message message) {
            Preconditions.checkArgument((message.what == 1 ? 1 : 0) != 0);
            ListenerHolder.this.notifyListenerInternal((Notifier)message.obj);
        }
    }

    @KeepForSdk
    public static interface Notifier<L> {
        @KeepForSdk
        public void notifyListener(L var1);

        @KeepForSdk
        public void onNotifyListenerFailed();
    }
}

