/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.os.Looper;
import android.support.annotation.NonNull;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.internal.ListenerHolder;
import com.google.android.gms.common.internal.Preconditions;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.WeakHashMap;

@KeepForSdk
public class ListenerHolders {
    private final Set<ListenerHolder<?>> zajo = Collections.newSetFromMap(new WeakHashMap());

    public final <L> ListenerHolder<L> zaa(@NonNull L l, @NonNull Looper looper, @NonNull String string2) {
        ListenerHolder<L> listenerHolder = ListenerHolders.createListenerHolder(l, looper, string2);
        this.zajo.add(listenerHolder);
        return listenerHolder;
    }

    public final void release() {
        Iterator<ListenerHolder<?>> iterator = this.zajo.iterator();
        while (iterator.hasNext()) {
            iterator.next().clear();
        }
        this.zajo.clear();
    }

    @KeepForSdk
    public static <L> ListenerHolder<L> createListenerHolder(@NonNull L l, @NonNull Looper looper, @NonNull String string2) {
        Preconditions.checkNotNull(l, (Object)"Listener must not be null");
        Preconditions.checkNotNull((Object)looper, (Object)"Looper must not be null");
        Preconditions.checkNotNull((Object)string2, (Object)"Listener type must not be null");
        return new ListenerHolder<L>(looper, l, string2);
    }

    @KeepForSdk
    public static <L> ListenerHolder.ListenerKey<L> createListenerKey(@NonNull L l, @NonNull String string2) {
        Preconditions.checkNotNull(l, (Object)"Listener must not be null");
        Preconditions.checkNotNull((Object)string2, (Object)"Listener type must not be null");
        Preconditions.checkNotEmpty((String)string2, (Object)"Listener type must not be empty");
        return new ListenerHolder.ListenerKey<L>(l, string2);
    }
}

