/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.os.Looper;
import android.support.annotation.NonNull;
import android.util.Log;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.ResultCallbacks;
import com.google.android.gms.common.api.ResultTransform;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.TransformedResult;
import com.google.android.gms.common.api.internal.zacc;
import com.google.android.gms.common.api.internal.zacn;
import com.google.android.gms.common.api.internal.zaco;
import com.google.android.gms.common.internal.Preconditions;
import java.lang.ref.WeakReference;
import javax.annotation.concurrent.GuardedBy;

public final class zacm<R extends Result>
extends TransformedResult<R>
implements ResultCallback<R> {
    private ResultTransform<? super R, ? extends Result> zako = null;
    private zacm<? extends Result> zakp = null;
    private volatile ResultCallbacks<? super R> zakq = null;
    private PendingResult<R> zakr = null;
    private final Object zado = new Object();
    private Status zaks = null;
    private final WeakReference<GoogleApiClient> zadq;
    private final zaco zakt;
    private boolean zaku = false;

    public zacm(WeakReference<GoogleApiClient> weakReference) {
        Preconditions.checkNotNull(weakReference, (Object)"GoogleApiClient reference must not be null");
        this.zadq = weakReference;
        GoogleApiClient googleApiClient = (GoogleApiClient)this.zadq.get();
        this.zakt = new zaco(this, googleApiClient != null ? googleApiClient.getLooper() : Looper.getMainLooper());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public final <S extends Result> TransformedResult<S> then(@NonNull ResultTransform<? super R, ? extends S> resultTransform) {
        Object object = this.zado;
        synchronized (object) {
            Preconditions.checkState((this.zako == null ? 1 : 0) != 0, (Object)"Cannot call then() twice.");
            Preconditions.checkState((this.zakq == null ? 1 : 0) != 0, (Object)"Cannot call then() and andFinally() on the same TransformedResult.");
            this.zako = resultTransform;
            zacm<R> zacm2 = new zacm<R>(this.zadq);
            this.zakp = zacm2;
            this.zabu();
            return zacm2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void andFinally(@NonNull ResultCallbacks<? super R> resultCallbacks) {
        Object object = this.zado;
        synchronized (object) {
            Preconditions.checkState((this.zakq == null ? 1 : 0) != 0, (Object)"Cannot call andFinally() twice.");
            Preconditions.checkState((this.zako == null ? 1 : 0) != 0, (Object)"Cannot call then() and andFinally() on the same TransformedResult.");
            this.zakq = resultCallbacks;
            this.zabu();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onResult(R r) {
        Object object = this.zado;
        synchronized (object) {
            if (r.getStatus().isSuccess()) {
                if (this.zako != null) {
                    zacc.zabb().submit(new zacn(this, (Result)r));
                } else if (this.zabw()) {
                    this.zakq.onSuccess(r);
                }
            } else {
                this.zad(r.getStatus());
                zacm.zab(r);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zaa(PendingResult<?> pendingResult) {
        Object object = this.zado;
        synchronized (object) {
            this.zakr = pendingResult;
            this.zabu();
            return;
        }
    }

    @GuardedBy(value="mSyncToken")
    private final void zabu() {
        if (this.zako == null && this.zakq == null) {
            return;
        }
        GoogleApiClient googleApiClient = (GoogleApiClient)this.zadq.get();
        if (!this.zaku && this.zako != null && googleApiClient != null) {
            googleApiClient.zaa(this);
            this.zaku = true;
        }
        if (this.zaks != null) {
            this.zae(this.zaks);
            return;
        }
        if (this.zakr != null) {
            this.zakr.setResultCallback(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zad(Status status) {
        Object object = this.zado;
        synchronized (object) {
            this.zaks = status;
            this.zae(this.zaks);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zae(Status status) {
        Object object = this.zado;
        synchronized (object) {
            if (this.zako != null) {
                Status status2 = this.zako.onFailure(status);
                Preconditions.checkNotNull((Object)status2, (Object)"onFailure must not return null");
                super.zad(status2);
            } else if (this.zabw()) {
                this.zakq.onFailure(status);
            }
            return;
        }
    }

    final void zabv() {
        this.zakq = null;
    }

    @GuardedBy(value="mSyncToken")
    private final boolean zabw() {
        GoogleApiClient googleApiClient = (GoogleApiClient)this.zadq.get();
        return this.zakq != null && googleApiClient != null;
    }

    private static void zab(Result result) {
        if (result instanceof Releasable) {
            try {
                ((Releasable)result).release();
                return;
            }
            catch (RuntimeException runtimeException) {
                String string2 = String.valueOf(result);
                Log.w((String)"TransformedResultImpl", (String)new StringBuilder(18 + String.valueOf(string2).length()).append("Unable to release ").append(string2).toString(), (Throwable)runtimeException);
            }
        }
    }

    static /* synthetic */ ResultTransform zac(zacm zacm2) {
        return zacm2.zako;
    }

    static /* synthetic */ zaco zad(zacm zacm2) {
        return zacm2.zakt;
    }

    static /* synthetic */ void zaa(zacm zacm2, Result result) {
        zacm.zab(result);
    }

    static /* synthetic */ WeakReference zae(zacm zacm2) {
        return zacm2.zadq;
    }

    static /* synthetic */ Object zaf(zacm zacm2) {
        return zacm2.zado;
    }

    static /* synthetic */ zacm zag(zacm zacm2) {
        return zacm2.zakp;
    }

    static /* synthetic */ void zaa(zacm zacm2, Status status) {
        zacm2.zad(status);
    }
}

