/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import android.util.Pair;
import androidx.annotation.NonNull;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.annotation.KeepName;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.ResultTransform;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.TransformedResult;
import com.google.android.gms.common.api.internal.zack;
import com.google.android.gms.common.api.internal.zacq;
import com.google.android.gms.common.api.internal.zao;
import com.google.android.gms.common.internal.ICancelToken;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.base.zar;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

@KeepName
@KeepForSdk
public abstract class BasePendingResult<R extends Result>
extends PendingResult<R> {
    static final ThreadLocal<Boolean> zado = new zao();
    private final Object zadp = new Object();
    private final CallbackHandler<R> zadq;
    private final WeakReference<GoogleApiClient> zadr;
    private final CountDownLatch zads = new CountDownLatch(1);
    private final ArrayList<PendingResult.StatusListener> zadt = new ArrayList();
    private ResultCallback<? super R> zadu;
    private final AtomicReference<zacq> zadv = new AtomicReference();
    private R zacl;
    private Status mStatus;
    @KeepName
    private zaa mResultGuardian;
    private volatile boolean zadw;
    private boolean zadx;
    private boolean zady;
    private ICancelToken zadz;
    private volatile zack<R> zaea;
    private boolean zaeb = false;

    @Deprecated
    BasePendingResult() {
        this.zadq = new CallbackHandler(Looper.getMainLooper());
        this.zadr = new WeakReference<Object>(null);
    }

    @KeepForSdk
    protected BasePendingResult(GoogleApiClient googleApiClient) {
        Looper looper = googleApiClient != null ? googleApiClient.getLooper() : Looper.getMainLooper();
        this.zadq = new CallbackHandler(looper);
        this.zadr = new WeakReference<GoogleApiClient>(googleApiClient);
    }

    @Deprecated
    @KeepForSdk
    protected BasePendingResult(Looper looper) {
        this.zadq = new CallbackHandler(looper);
        this.zadr = new WeakReference<Object>(null);
    }

    @VisibleForTesting
    @KeepForSdk
    protected BasePendingResult(@NonNull CallbackHandler<R> callbackHandler) {
        this.zadq = (CallbackHandler)((Object)Preconditions.checkNotNull(callbackHandler, (Object)"CallbackHandler must not be null"));
        this.zadr = new WeakReference<Object>(null);
    }

    @KeepForSdk
    public final boolean isReady() {
        return this.zads.getCount() == 0L;
    }

    @Override
    public final R await() {
        Preconditions.checkNotMainThread((String)"await must not be called on the UI thread");
        Preconditions.checkState((!this.zadw ? 1 : 0) != 0, (Object)"Result has already been consumed");
        Preconditions.checkState((this.zaea == null ? 1 : 0) != 0, (Object)"Cannot await if then() has been called.");
        try {
            this.zads.await();
        }
        catch (InterruptedException interruptedException) {
            this.zab(Status.RESULT_INTERRUPTED);
        }
        Preconditions.checkState((boolean)this.isReady(), (Object)"Result is not ready.");
        return this.get();
    }

    @Override
    public final R await(long l, TimeUnit timeUnit) {
        if (l > 0L) {
            Preconditions.checkNotMainThread((String)"await must not be called on the UI thread when time is greater than zero.");
        }
        Preconditions.checkState((!this.zadw ? 1 : 0) != 0, (Object)"Result has already been consumed.");
        Preconditions.checkState((this.zaea == null ? 1 : 0) != 0, (Object)"Cannot await if then() has been called.");
        try {
            if (!this.zads.await(l, timeUnit)) {
                this.zab(Status.RESULT_TIMEOUT);
            }
        }
        catch (InterruptedException interruptedException) {
            this.zab(Status.RESULT_INTERRUPTED);
        }
        Preconditions.checkState((boolean)this.isReady(), (Object)"Result is not ready.");
        return this.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @KeepForSdk
    public final void setResultCallback(ResultCallback<? super R> resultCallback) {
        Object object = this.zadp;
        synchronized (object) {
            if (resultCallback == null) {
                this.zadu = null;
                return;
            }
            Preconditions.checkState((!this.zadw ? 1 : 0) != 0, (Object)"Result has already been consumed.");
            Preconditions.checkState((this.zaea == null ? 1 : 0) != 0, (Object)"Cannot set callbacks if then() has been called.");
            if (((PendingResult)this).isCanceled()) {
                return;
            }
            if (this.isReady()) {
                this.zadq.zaa(resultCallback, (R)this.get());
            } else {
                this.zadu = resultCallback;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @KeepForSdk
    public final void setResultCallback(ResultCallback<? super R> resultCallback, long l, TimeUnit timeUnit) {
        Object object = this.zadp;
        synchronized (object) {
            if (resultCallback == null) {
                this.zadu = null;
                return;
            }
            Preconditions.checkState((!this.zadw ? 1 : 0) != 0, (Object)"Result has already been consumed.");
            Preconditions.checkState((this.zaea == null ? 1 : 0) != 0, (Object)"Cannot set callbacks if then() has been called.");
            if (((PendingResult)this).isCanceled()) {
                return;
            }
            if (this.isReady()) {
                this.zadq.zaa(resultCallback, (R)this.get());
            } else {
                this.zadu = resultCallback;
                long l2 = timeUnit.toMillis(l);
                BasePendingResult basePendingResult = this;
                CallbackHandler<R> callbackHandler = this.zadq;
                callbackHandler.sendMessageDelayed(callbackHandler.obtainMessage(2, basePendingResult), l2);
            }
            return;
        }
    }

    private static <R extends Result> ResultCallback<R> zaa(ResultCallback<R> resultCallback) {
        return resultCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addStatusListener(PendingResult.StatusListener statusListener) {
        Preconditions.checkArgument((statusListener != null ? 1 : 0) != 0, (Object)"Callback cannot be null.");
        Object object = this.zadp;
        synchronized (object) {
            if (this.isReady()) {
                statusListener.onComplete(this.mStatus);
            } else {
                this.zadt.add(statusListener);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @KeepForSdk
    public void cancel() {
        Object object = this.zadp;
        synchronized (object) {
            if (this.zadx || this.zadw) {
                return;
            }
            if (this.zadz != null) {
                try {
                    this.zadz.cancel();
                }
                catch (RemoteException remoteException) {}
            }
            BasePendingResult.zab(this.zacl);
            this.zadx = true;
            this.zaa(this.createFailedResult(Status.RESULT_CANCELED));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zaq() {
        Object object = this.zadp;
        synchronized (object) {
            if ((GoogleApiClient)this.zadr.get() == null || !this.zaeb) {
                ((PendingResult)this).cancel();
            }
            return ((PendingResult)this).isCanceled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCanceled() {
        Object object = this.zadp;
        synchronized (object) {
            return this.zadx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <S extends Result> TransformedResult<S> then(ResultTransform<? super R, ? extends S> resultTransform) {
        Preconditions.checkState((!this.zadw ? 1 : 0) != 0, (Object)"Result has already been consumed.");
        Object object = this.zadp;
        synchronized (object) {
            Preconditions.checkState((this.zaea == null ? 1 : 0) != 0, (Object)"Cannot call then() twice.");
            Preconditions.checkState((this.zadu == null ? 1 : 0) != 0, (Object)"Cannot call then() if callbacks are set.");
            Preconditions.checkState((!this.zadx ? 1 : 0) != 0, (Object)"Cannot call then() if result was canceled.");
            this.zaeb = true;
            this.zaea = new zack(this.zadr);
            TransformedResult<? extends S> transformedResult = ((TransformedResult)this.zaea).then(resultTransform);
            if (this.isReady()) {
                this.zadq.zaa(this.zaea, this.get());
            } else {
                this.zadu = this.zaea;
            }
            return transformedResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    public final void setResult(R r) {
        Object object = this.zadp;
        synchronized (object) {
            if (!this.zady && !this.zadx) {
                if (this.isReady()) {
                    // empty if block
                }
            } else {
                BasePendingResult.zab(r);
                return;
            }
            Preconditions.checkState((!this.isReady() ? 1 : 0) != 0, (Object)"Results have already been set");
            Preconditions.checkState((!this.zadw ? 1 : 0) != 0, (Object)"Result has already been consumed");
            this.zaa(r);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zab(Status status) {
        Object object = this.zadp;
        synchronized (object) {
            if (!this.isReady()) {
                this.setResult(this.createFailedResult(status));
                this.zady = true;
            }
            return;
        }
    }

    @NonNull
    @KeepForSdk
    protected abstract R createFailedResult(Status var1);

    public final void zaa(zacq zacq2) {
        this.zadv.set(zacq2);
    }

    @Override
    public final Integer zal() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    protected final void setCancelToken(ICancelToken iCancelToken) {
        Object object = this.zadp;
        synchronized (object) {
            this.zadz = iCancelToken;
            return;
        }
    }

    public final void zar() {
        this.zaeb = this.zaeb || zado.get() != false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final R get() {
        R r;
        Object object = this.zadp;
        synchronized (object) {
            Preconditions.checkState((!this.zadw ? 1 : 0) != 0, (Object)"Result has already been consumed.");
            Preconditions.checkState((boolean)this.isReady(), (Object)"Result is not ready.");
            r = this.zacl;
            this.zacl = null;
            this.zadu = null;
            this.zadw = true;
        }
        BasePendingResult basePendingResult = this;
        zacq zacq2 = basePendingResult.zadv.getAndSet(null);
        if (zacq2 != null) {
            zacq2.zab(basePendingResult);
        }
        return r;
    }

    private final void zaa(R r) {
        this.zacl = r;
        this.zadz = null;
        this.zads.countDown();
        this.mStatus = this.zacl.getStatus();
        if (this.zadx) {
            this.zadu = null;
        } else if (this.zadu == null) {
            if (this.zacl instanceof Releasable) {
                this.mResultGuardian = new zaa(null);
            }
        } else {
            this.zadq.removeMessages(2);
            this.zadq.zaa(this.zadu, (R)this.get());
        }
        ArrayList<PendingResult.StatusListener> arrayList = this.zadt;
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            PendingResult.StatusListener statusListener = arrayList.get(i);
            statusListener.onComplete(this.mStatus);
        }
        this.zadt.clear();
    }

    public static void zab(Result result) {
        if (result instanceof Releasable) {
            try {
                ((Releasable)result).release();
                return;
            }
            catch (RuntimeException runtimeException) {
                String string2 = String.valueOf(result);
                Log.w((String)"BasePendingResult", (String)new StringBuilder(18 + String.valueOf(string2).length()).append("Unable to release ").append(string2).toString(), (Throwable)runtimeException);
            }
        }
    }

    private final class zaa {
        private zaa() {
        }

        protected final void finalize() throws Throwable {
            BasePendingResult.zab(BasePendingResult.this.zacl);
            super.finalize();
        }

        /* synthetic */ zaa(zao zao2) {
            this();
        }
    }

    @VisibleForTesting
    public static class CallbackHandler<R extends Result>
    extends zar {
        public CallbackHandler() {
            this(Looper.getMainLooper());
        }

        public CallbackHandler(Looper looper) {
            super(looper);
        }

        public final void zaa(ResultCallback<? super R> resultCallback, R r) {
            resultCallback = BasePendingResult.zaa(resultCallback);
            this.sendMessage(this.obtainMessage(1, new Pair((Object)resultCallback, r)));
        }

        public void handleMessage(Message message) {
            switch (message.what) {
                case 1: {
                    Pair pair = (Pair)message.obj;
                    Result result = (Result)pair.second;
                    ResultCallback resultCallback = (ResultCallback)pair.first;
                    try {
                        resultCallback.onResult(result);
                        return;
                    }
                    catch (RuntimeException runtimeException) {
                        BasePendingResult.zab(result);
                        throw runtimeException;
                    }
                }
                case 2: {
                    ((BasePendingResult)message.obj).zab(Status.RESULT_TIMEOUT);
                    return;
                }
            }
            int n = message.what;
            Log.wtf((String)"BasePendingResult", (String)new StringBuilder(45).append("Don't know how to handle message: ").append(n).toString(), (Throwable)new Exception());
        }
    }
}

