/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.images;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.images.zae;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

@SafeParcelable.Class(creator="WebImageCreator")
public final class WebImage
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<WebImage> CREATOR = new zae();
    @SafeParcelable.VersionField(id=1)
    private final int zali;
    @SafeParcelable.Field(id=2, getter="getUrl")
    private final Uri zani;
    @SafeParcelable.Field(id=3, getter="getWidth")
    private final int zanj;
    @SafeParcelable.Field(id=4, getter="getHeight")
    private final int zank;

    @SafeParcelable.Constructor
    WebImage(@SafeParcelable.Param(id=1) int n, @SafeParcelable.Param(id=2) Uri uri, @SafeParcelable.Param(id=3) int n2, @SafeParcelable.Param(id=4) int n3) {
        this.zali = n;
        this.zani = uri;
        this.zanj = n2;
        this.zank = n3;
    }

    public WebImage(Uri uri, int n, int n2) throws IllegalArgumentException {
        this(1, uri, n, n2);
        if (uri == null) {
            throw new IllegalArgumentException("url cannot be null");
        }
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException("width and height must not be negative");
        }
    }

    public WebImage(Uri uri) throws IllegalArgumentException {
        this(uri, 0, 0);
    }

    @KeepForSdk
    public WebImage(JSONObject jSONObject) throws IllegalArgumentException {
        this(WebImage.zaa(jSONObject), jSONObject.optInt("width", 0), jSONObject.optInt("height", 0));
    }

    private static Uri zaa(JSONObject jSONObject) {
        Uri uri = null;
        if (jSONObject.has("url")) {
            try {
                uri = Uri.parse((String)jSONObject.getString("url"));
            }
            catch (JSONException jSONException) {}
        }
        return uri;
    }

    public final Uri getUrl() {
        return this.zani;
    }

    public final int getWidth() {
        return this.zanj;
    }

    public final int getHeight() {
        return this.zank;
    }

    public final String toString() {
        return String.format(Locale.US, "Image %dx%d %s", this.zanj, this.zank, this.zani.toString());
    }

    @KeepForSdk
    public final JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("url", (Object)this.zani.toString());
            jSONObject.put("width", this.zanj);
            jSONObject.put("height", this.zank);
        }
        catch (JSONException jSONException) {}
        return jSONObject;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof WebImage)) {
            return false;
        }
        WebImage webImage = (WebImage)((Object)object);
        return Objects.equal((Object)this.zani, (Object)webImage.zani) && this.zanj == webImage.zanj && this.zank == webImage.zank;
    }

    public final int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.zani, this.zanj, this.zank});
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        WebImage webImage = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)1, (int)webImage.zali);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)2, (Parcelable)webImage.getUrl(), (int)n, (boolean)false);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)3, (int)webImage.getWidth());
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)4, (int)webImage.getHeight());
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }
}

