/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.base;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.SystemClock;
import com.google.android.gms.internal.base.zaf;
import com.google.android.gms.internal.base.zah;

public final class zae
extends Drawable
implements Drawable.Callback {
    private int zanl = 0;
    private long zanm;
    private int mFrom;
    private int zann;
    private int zano = 255;
    private int zanp;
    private int mAlpha = 0;
    private boolean zand = true;
    private boolean zanq;
    private zah zanr;
    private Drawable zans;
    private Drawable zant;
    private boolean zanu;
    private boolean zanv;
    private boolean zanw;
    private int zanx;

    public zae(Drawable drawable2, Drawable drawable3) {
        this(null);
        if (drawable2 == null) {
            drawable2 = zaf.zace();
        }
        this.zans = drawable2;
        drawable2.setCallback((Drawable.Callback)this);
        this.zanr.zaoa |= drawable2.getChangingConfigurations();
        if (drawable3 == null) {
            drawable3 = zaf.zace();
        }
        this.zant = drawable3;
        drawable3.setCallback((Drawable.Callback)this);
        this.zanr.zaoa |= drawable3.getChangingConfigurations();
    }

    zae(zah zah2) {
        this.zanr = new zah(zah2);
    }

    public final void invalidateDrawable(Drawable drawable2) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.invalidateDrawable((Drawable)this);
        }
    }

    public final void scheduleDrawable(Drawable drawable2, Runnable runnable, long l) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.scheduleDrawable((Drawable)this, runnable, l);
        }
    }

    public final void unscheduleDrawable(Drawable drawable2, Runnable runnable) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.unscheduleDrawable((Drawable)this, runnable);
        }
    }

    public final int getChangingConfigurations() {
        return super.getChangingConfigurations() | this.zanr.mChangingConfigurations | this.zanr.zaoa;
    }

    public final void setAlpha(int n) {
        if (this.mAlpha == this.zano) {
            this.mAlpha = n;
        }
        this.zano = n;
        this.invalidateSelf();
    }

    public final void setColorFilter(ColorFilter colorFilter) {
        this.zans.setColorFilter(colorFilter);
        this.zant.setColorFilter(colorFilter);
    }

    public final int getIntrinsicWidth() {
        return Math.max(this.zans.getIntrinsicWidth(), this.zant.getIntrinsicWidth());
    }

    public final int getIntrinsicHeight() {
        return Math.max(this.zans.getIntrinsicHeight(), this.zant.getIntrinsicHeight());
    }

    protected final void onBoundsChange(Rect rect) {
        this.zans.setBounds(rect);
        this.zant.setBounds(rect);
    }

    public final Drawable.ConstantState getConstantState() {
        if (this.canConstantState()) {
            this.zanr.mChangingConfigurations = this.getChangingConfigurations();
            return this.zanr;
        }
        return null;
    }

    public final int getOpacity() {
        if (!this.zanw) {
            this.zanx = Drawable.resolveOpacity((int)this.zans.getOpacity(), (int)this.zant.getOpacity());
            this.zanw = true;
        }
        return this.zanx;
    }

    private final boolean canConstantState() {
        if (!this.zanu) {
            this.zanv = this.zans.getConstantState() != null && this.zant.getConstantState() != null;
            this.zanu = true;
        }
        return this.zanv;
    }

    public final Drawable mutate() {
        if (!this.zanq && super.mutate() == this) {
            if (!this.canConstantState()) {
                throw new IllegalStateException("One or more children of this LayerDrawable does not have constant state; this drawable cannot be mutated.");
            }
            this.zans.mutate();
            this.zant.mutate();
            this.zanq = true;
        }
        return this;
    }

    public final Drawable zacd() {
        return this.zant;
    }

    public final void startTransition(int n) {
        this.mFrom = 0;
        this.zann = this.zano;
        this.mAlpha = 0;
        this.zanp = 250;
        this.zanl = 1;
        this.invalidateSelf();
    }

    public final void draw(Canvas canvas) {
        boolean bl = true;
        switch (this.zanl) {
            case 1: {
                this.zanm = SystemClock.uptimeMillis();
                bl = false;
                this.zanl = 2;
                break;
            }
            case 2: {
                float f;
                if (this.zanm < 0L) break;
                float f2 = (float)(SystemClock.uptimeMillis() - this.zanm) / (float)this.zanp;
                bl = f >= 1.0f;
                if (bl) {
                    this.zanl = 0;
                }
                f2 = Math.min(f2, 1.0f);
                this.mAlpha = (int)(0.0f + (float)this.zann * f2);
            }
        }
        int n = this.mAlpha;
        boolean bl2 = this.zand;
        Drawable drawable2 = this.zans;
        Drawable drawable3 = this.zant;
        if (bl) {
            if (!bl2 || n == 0) {
                drawable2.draw(canvas);
            }
            if (n == this.zano) {
                drawable3.setAlpha(this.zano);
                drawable3.draw(canvas);
            }
            return;
        }
        if (bl2) {
            drawable2.setAlpha(this.zano - n);
        }
        drawable2.draw(canvas);
        if (bl2) {
            drawable2.setAlpha(this.zano);
        }
        if (n > 0) {
            drawable3.setAlpha(n);
            drawable3.draw(canvas);
            drawable3.setAlpha(this.zano);
        }
        this.invalidateSelf();
    }
}

