/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.os.DeadObjectException;
import android.os.RemoteException;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.Feature;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.GoogleApiManager;
import com.google.android.gms.common.api.internal.StatusExceptionMapper;
import com.google.android.gms.common.api.internal.TaskApiCall;
import com.google.android.gms.common.api.internal.zaab;
import com.google.android.gms.common.api.internal.zab;
import com.google.android.gms.common.api.internal.zad;
import com.google.android.gms.tasks.TaskCompletionSource;

public final class zah<ResultT>
extends zad {
    private final TaskApiCall<Api.AnyClient, ResultT> zacv;
    private final TaskCompletionSource<ResultT> zacr;
    private final StatusExceptionMapper zacw;

    public zah(int n, TaskApiCall<Api.AnyClient, ResultT> taskApiCall, TaskCompletionSource<ResultT> taskCompletionSource, StatusExceptionMapper statusExceptionMapper) {
        super(n);
        this.zacr = taskCompletionSource;
        this.zacv = taskApiCall;
        this.zacw = statusExceptionMapper;
        if (n == 2 && taskApiCall.shouldAutoResolveMissingFeatures()) {
            throw new IllegalArgumentException("Best-effort write calls cannot pass methods that should auto-resolve missing features.");
        }
    }

    @Override
    public final void zaa(GoogleApiManager.zaa<?> zaa2) throws DeadObjectException {
        try {
            this.zacv.doExecute(zaa2.zaz(), this.zacr);
            return;
        }
        catch (DeadObjectException deadObjectException) {
            throw deadObjectException;
        }
        catch (RemoteException remoteException) {
            ((zab)this).zaa(zab.zab(remoteException));
            return;
        }
        catch (RuntimeException runtimeException) {
            ((zab)this).zaa(runtimeException);
            return;
        }
    }

    @Override
    public final void zaa(@NonNull Status status) {
        this.zacr.trySetException(this.zacw.getException(status));
    }

    @Override
    public final void zaa(@NonNull Exception exception) {
        this.zacr.trySetException(exception);
    }

    @Override
    public final void zaa(@NonNull zaab zaab2, boolean bl) {
        zaab2.zaa(this.zacr, bl);
    }

    @Override
    @Nullable
    public final Feature[] zac(GoogleApiManager.zaa<?> zaa2) {
        return this.zacv.zabr();
    }

    @Override
    public final boolean zad(GoogleApiManager.zaa<?> zaa2) {
        return this.zacv.shouldAutoResolveMissingFeatures();
    }
}

