/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.collection.ArrayMap;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.ApiKey;
import com.google.android.gms.common.api.internal.BaseImplementation;
import com.google.android.gms.common.api.internal.GoogleApiManager;
import com.google.android.gms.common.api.internal.SignInConnectionListener;
import com.google.android.gms.common.api.internal.zaau;
import com.google.android.gms.common.api.internal.zabs;
import com.google.android.gms.common.api.internal.zaq;
import com.google.android.gms.common.api.internal.zav;
import com.google.android.gms.common.api.internal.zay;
import com.google.android.gms.common.api.internal.zaz;
import com.google.android.gms.common.internal.ClientSettings;
import com.google.android.gms.common.util.concurrent.HandlerExecutor;
import com.google.android.gms.signin.SignInOptions;
import com.google.android.gms.signin.zad;
import com.google.android.gms.tasks.OnCompleteListener;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import javax.annotation.concurrent.GuardedBy;

public final class zax
implements zabs {
    private final Map<Api.AnyClientKey<?>, zav<?>> zaey = new HashMap();
    private final Map<Api.AnyClientKey<?>, zav<?>> zaez = new HashMap();
    private final Map<Api<?>, Boolean> zafa;
    private final GoogleApiManager zabp;
    private final zaau zafb;
    private final Lock zaet;
    private final Looper zabm;
    private final GoogleApiAvailabilityLight zafc;
    private final Condition zafd;
    private final ClientSettings zaex;
    private final boolean zafe;
    private final boolean zaff;
    private final Queue<BaseImplementation.ApiMethodImpl<?, ?>> zafg = new LinkedList();
    @GuardedBy(value="mLock")
    private boolean zafh;
    @GuardedBy(value="mLock")
    private Map<ApiKey<?>, ConnectionResult> zafi;
    @GuardedBy(value="mLock")
    private Map<ApiKey<?>, ConnectionResult> zafj;
    @GuardedBy(value="mLock")
    private zay zafk;
    @GuardedBy(value="mLock")
    private ConnectionResult zafl;

    public zax(Context context, Lock lock, Looper looper, GoogleApiAvailabilityLight googleApiAvailabilityLight, Map<Api.AnyClientKey<?>, Api.Client> map, ClientSettings clientSettings, Map<Api<?>, Boolean> map2, Api.AbstractClientBuilder<? extends zad, SignInOptions> abstractClientBuilder, ArrayList<zaq> arrayList, zaau zaau2, boolean bl) {
        this.zaet = lock;
        this.zabm = looper;
        this.zafd = lock.newCondition();
        this.zafc = googleApiAvailabilityLight;
        this.zafb = zaau2;
        this.zafa = map2;
        this.zaex = clientSettings;
        this.zafe = bl;
        HashMap hashMap = new HashMap();
        for (Api<?> api : map2.keySet()) {
            hashMap.put(api.getClientKey(), api);
        }
        HashMap hashMap2 = new HashMap();
        ArrayList<zaq> arrayList2 = arrayList;
        int n = arrayList2.size();
        for (int i = 0; i < n; ++i) {
            zaq zaq2 = arrayList2.get(i);
            zaq zaq3 = zaq2;
            hashMap2.put(zaq3.mApi, zaq3);
        }
        boolean bl2 = false;
        boolean bl3 = true;
        boolean bl4 = false;
        for (Map.Entry<Api.AnyClientKey<?>, Api.Client> entry : map.entrySet()) {
            Api api = (Api)hashMap.get(entry.getKey());
            Api.Client client = entry.getValue();
            if (client.requiresGooglePlayServices()) {
                bl4 = true;
                if (!this.zafa.get(api).booleanValue()) {
                    bl2 = true;
                }
            } else {
                bl3 = false;
            }
            zaq zaq4 = (zaq)hashMap2.get(api);
            zav zav2 = new zav(context, api, looper, client, zaq4, clientSettings, abstractClientBuilder);
            this.zaey.put(entry.getKey(), zav2);
            if (!client.requiresSignIn()) continue;
            this.zaez.put(entry.getKey(), zav2);
        }
        this.zaff = bl4 && !bl3 && !bl2;
        this.zabp = GoogleApiManager.zaaz();
    }

    @Override
    public final <A extends Api.AnyClient, R extends Result, T extends BaseImplementation.ApiMethodImpl<R, A>> T enqueue(@NonNull T t) {
        if (this.zafe && this.zab(t)) {
            return t;
        }
        if (!this.isConnected()) {
            this.zafg.add(t);
            return t;
        }
        this.zafb.zahj.zab(t);
        return this.zaey.get(t.getClientKey()).doRead(t);
    }

    @Override
    public final <A extends Api.AnyClient, T extends BaseImplementation.ApiMethodImpl<? extends Result, A>> T execute(@NonNull T t) {
        Api.AnyClientKey<A> anyClientKey = t.getClientKey();
        if (this.zafe && this.zab(t)) {
            return t;
        }
        this.zafb.zahj.zab(t);
        return this.zaey.get(anyClientKey).doWrite(t);
    }

    private final <T extends BaseImplementation.ApiMethodImpl<? extends Result, ? extends Api.AnyClient>> boolean zab(@NonNull T t) {
        Api.AnyClientKey<? extends Api.AnyClient> anyClientKey = t.getClientKey();
        ConnectionResult connectionResult = this.zaa(anyClientKey);
        if (connectionResult != null && connectionResult.getErrorCode() == 4) {
            t.setFailedResult(new Status(4, null, this.zabp.zaa(this.zaey.get(anyClientKey).getApiKey(), System.identityHashCode(this.zafb))));
            return true;
        }
        return false;
    }

    @Override
    public final void connect() {
        this.zaet.lock();
        try {
            if (this.zafh) {
                return;
            }
            this.zafh = true;
            this.zafi = null;
            this.zafj = null;
            this.zafk = null;
            this.zafl = null;
            this.zabp.zam();
            this.zabp.zaa(this.zaey.values()).addOnCompleteListener((Executor)new HandlerExecutor(this.zabm), (OnCompleteListener)new zaz(this, null));
            return;
        }
        finally {
            this.zaet.unlock();
        }
    }

    @Override
    @GuardedBy(value="mLock")
    public final ConnectionResult blockingConnect() {
        this.connect();
        while (this.isConnecting()) {
            try {
                this.zafd.await();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return new ConnectionResult(15, null);
            }
        }
        if (this.isConnected()) {
            return ConnectionResult.RESULT_SUCCESS;
        }
        if (this.zafl != null) {
            return this.zafl;
        }
        return new ConnectionResult(13, null);
    }

    @Override
    @GuardedBy(value="mLock")
    public final ConnectionResult blockingConnect(long l, TimeUnit timeUnit) {
        this.connect();
        long l2 = timeUnit.toNanos(l);
        while (this.isConnecting()) {
            try {
                if (l2 <= 0L) {
                    this.disconnect();
                    return new ConnectionResult(14, null);
                }
                l2 = this.zafd.awaitNanos(l2);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return new ConnectionResult(15, null);
            }
        }
        if (this.isConnected()) {
            return ConnectionResult.RESULT_SUCCESS;
        }
        if (this.zafl != null) {
            return this.zafl;
        }
        return new ConnectionResult(13, null);
    }

    @Override
    public final void disconnect() {
        this.zaet.lock();
        try {
            this.zafh = false;
            this.zafi = null;
            this.zafj = null;
            if (this.zafk != null) {
                this.zafk.cancel();
                this.zafk = null;
            }
            this.zafl = null;
            while (!this.zafg.isEmpty()) {
                BaseImplementation.ApiMethodImpl<?, ?> apiMethodImpl = this.zafg.remove();
                apiMethodImpl.zaa(null);
                ((PendingResult)apiMethodImpl).cancel();
            }
            this.zafd.signalAll();
            return;
        }
        finally {
            this.zaet.unlock();
        }
    }

    @Override
    @Nullable
    public final ConnectionResult getConnectionResult(@NonNull Api<?> api) {
        return this.zaa(api.getClientKey());
    }

    @Nullable
    private final ConnectionResult zaa(@NonNull Api.AnyClientKey<?> anyClientKey) {
        block2: {
            this.zaet.lock();
            try {
                zav<?> zav2 = this.zaey.get(anyClientKey);
                if (this.zafi == null || zav2 == null) break block2;
                ConnectionResult connectionResult = this.zafi.get(zav2.getApiKey());
                this.zaet.unlock();
                return connectionResult;
            }
            catch (Throwable throwable) {
                this.zaet.unlock();
                throw throwable;
            }
        }
        this.zaet.unlock();
        return null;
    }

    @Override
    public final boolean isConnected() {
        this.zaet.lock();
        try {
            boolean bl = this.zafi != null && this.zafl == null;
            return bl;
        }
        finally {
            this.zaet.unlock();
        }
    }

    @Override
    public final boolean isConnecting() {
        this.zaet.lock();
        try {
            boolean bl = this.zafi == null && this.zafh;
            return bl;
        }
        finally {
            this.zaet.unlock();
        }
    }

    private final boolean zaaa() {
        block4: {
            this.zaet.lock();
            if (this.zafh && this.zafe) break block4;
            this.zaet.unlock();
            return false;
        }
        try {
            for (Api.AnyClientKey<?> anyClientKey : this.zaez.keySet()) {
                ConnectionResult connectionResult = this.zaa(anyClientKey);
                if (connectionResult != null && connectionResult.isSuccess()) continue;
                this.zaet.unlock();
                return false;
            }
        }
        catch (Throwable throwable) {
            this.zaet.unlock();
            throw throwable;
        }
        this.zaet.unlock();
        return true;
    }

    @Override
    public final boolean maybeSignIn(SignInConnectionListener signInConnectionListener) {
        block2: {
            this.zaet.lock();
            try {
                if (!this.zafh || this.zaaa()) break block2;
                this.zabp.zam();
                this.zafk = new zay(this, signInConnectionListener);
                this.zabp.zaa(this.zaez.values()).addOnCompleteListener((Executor)new HandlerExecutor(this.zabm), (OnCompleteListener)this.zafk);
                this.zaet.unlock();
                return true;
            }
            catch (Throwable throwable) {
                this.zaet.unlock();
                throw throwable;
            }
        }
        this.zaet.unlock();
        return false;
    }

    @Override
    public final void maybeSignOut() {
        this.zaet.lock();
        try {
            this.zabp.maybeSignOut();
            if (this.zafk != null) {
                this.zafk.cancel();
                this.zafk = null;
            }
            if (this.zafj == null) {
                this.zafj = new ArrayMap(this.zaez.size());
            }
            ConnectionResult connectionResult = new ConnectionResult(4);
            for (zav<?> zav2 : this.zaez.values()) {
                this.zafj.put(zav2.getApiKey(), connectionResult);
            }
            if (this.zafi != null) {
                this.zafi.putAll(this.zafj);
            }
            return;
        }
        finally {
            this.zaet.unlock();
        }
    }

    @Override
    public final void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
    }

    @Override
    public final void zau() {
    }

    @GuardedBy(value="mLock")
    private final void zaab() {
        if (this.zaex == null) {
            this.zafb.zahe = Collections.emptySet();
            return;
        }
        HashSet<Scope> hashSet = new HashSet<Scope>(this.zaex.getRequiredScopes());
        Map<Api<?>, ClientSettings.OptionalApiSettings> map = this.zaex.getOptionalApiSettings();
        for (Api<?> api : map.keySet()) {
            ConnectionResult connectionResult = this.getConnectionResult(api);
            if (connectionResult == null || !connectionResult.isSuccess()) continue;
            hashSet.addAll(map.get(api).mScopes);
        }
        this.zafb.zahe = hashSet;
    }

    @GuardedBy(value="mLock")
    private final void zaac() {
        while (!this.zafg.isEmpty()) {
            this.execute(this.zafg.remove());
        }
        this.zafb.zab((Bundle)null);
    }

    private final boolean zaa(zav<?> zav2, ConnectionResult connectionResult) {
        return !connectionResult.isSuccess() && !connectionResult.hasResolution() && this.zafa.get(zav2.getApi()) != false && zav2.zaz().requiresGooglePlayServices() && this.zafc.isUserResolvableError(connectionResult.getErrorCode());
    }

    @GuardedBy(value="mLock")
    @Nullable
    private final ConnectionResult zaad() {
        ConnectionResult connectionResult = null;
        int n = 0;
        ConnectionResult connectionResult2 = null;
        int n2 = 0;
        for (zav<?> zav2 : this.zaey.values()) {
            int n3;
            Api api = zav2.getApi();
            ApiKey apiKey = zav2.getApiKey();
            ConnectionResult connectionResult3 = this.zafi.get(apiKey);
            if (connectionResult3.isSuccess() || this.zafa.get(api).booleanValue() && !connectionResult3.hasResolution() && !this.zafc.isUserResolvableError(connectionResult3.getErrorCode())) continue;
            if (connectionResult3.getErrorCode() == 4 && this.zafe) {
                n3 = api.zah().getPriority();
                if (connectionResult2 != null && n2 <= n3) continue;
                connectionResult2 = connectionResult3;
                n2 = n3;
                continue;
            }
            n3 = api.zah().getPriority();
            if (connectionResult != null && n <= n3) continue;
            connectionResult = connectionResult3;
            n = n3;
        }
        if (connectionResult != null && connectionResult2 != null && n > n2) {
            return connectionResult2;
        }
        return connectionResult;
    }

    static /* synthetic */ Lock zaa(zax zax2) {
        return zax2.zaet;
    }

    static /* synthetic */ boolean zab(zax zax2) {
        return zax2.zafh;
    }

    static /* synthetic */ Map zaa(zax zax2, Map map) {
        zax2.zafi = map;
        return zax2.zafi;
    }

    static /* synthetic */ Map zac(zax zax2) {
        return zax2.zaey;
    }

    static /* synthetic */ Map zad(zax zax2) {
        return zax2.zafi;
    }

    static /* synthetic */ boolean zae(zax zax2) {
        return zax2.zaff;
    }

    static /* synthetic */ boolean zaa(zax zax2, zav zav2, ConnectionResult connectionResult) {
        return zax2.zaa(zav2, connectionResult);
    }

    static /* synthetic */ ConnectionResult zaa(zax zax2, ConnectionResult connectionResult) {
        zax2.zafl = connectionResult;
        return zax2.zafl;
    }

    static /* synthetic */ ConnectionResult zaf(zax zax2) {
        return zax2.zaad();
    }

    static /* synthetic */ Map zag(zax zax2) {
        return zax2.zafj;
    }

    static /* synthetic */ ConnectionResult zah(zax zax2) {
        return zax2.zafl;
    }

    static /* synthetic */ void zai(zax zax2) {
        zax2.zaab();
    }

    static /* synthetic */ void zaj(zax zax2) {
        zax2.zaac();
    }

    static /* synthetic */ boolean zaa(zax zax2, boolean bl) {
        zax2.zafh = false;
        return false;
    }

    static /* synthetic */ zaau zak(zax zax2) {
        return zax2.zafb;
    }

    static /* synthetic */ Condition zal(zax zax2) {
        return zax2.zafd;
    }

    static /* synthetic */ Map zab(zax zax2, Map map) {
        zax2.zafj = map;
        return zax2.zafj;
    }

    static /* synthetic */ Map zam(zax zax2) {
        return zax2.zaez;
    }
}

