/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.data;

import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.data.DataBuffer;
import com.google.android.gms.common.internal.Preconditions;
import java.util.Iterator;
import java.util.NoSuchElementException;

@KeepForSdk
public class DataBufferIterator<T>
implements Iterator<T> {
    protected final DataBuffer<T> zalp;
    protected int zalq;

    public DataBufferIterator(DataBuffer<T> dataBuffer) {
        this.zalp = (DataBuffer)Preconditions.checkNotNull(dataBuffer);
        this.zalq = -1;
    }

    @Override
    public boolean hasNext() {
        return this.zalq < this.zalp.getCount() - 1;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            int n = this.zalq;
            throw new NoSuchElementException(new StringBuilder(46).append("Cannot advance the iterator beyond ").append(n).toString());
        }
        return this.zalp.get(++this.zalq);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Cannot remove elements from a DataBufferIterator");
    }
}

