/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.data;

import android.content.ContentValues;
import android.database.CharArrayBuffer;
import android.database.Cursor;
import android.database.CursorIndexOutOfBoundsException;
import android.database.CursorWindow;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.annotation.KeepName;
import com.google.android.gms.common.data.zab;
import com.google.android.gms.common.data.zac;
import com.google.android.gms.common.internal.Asserts;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.sqlite.CursorWrapper;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@KeepName
@SafeParcelable.Class(creator="DataHolderCreator", validate=true)
@KeepForSdk
public final class DataHolder
extends AbstractSafeParcelable
implements Closeable {
    @KeepForSdk
    public static final Parcelable.Creator<DataHolder> CREATOR = new zac();
    @SafeParcelable.VersionField(id=1000)
    private final int zalk;
    @SafeParcelable.Field(id=1, getter="getColumns")
    private final String[] zalv;
    private Bundle zalw;
    @SafeParcelable.Field(id=2, getter="getWindows")
    private final CursorWindow[] zalx;
    @SafeParcelable.Field(id=3, getter="getStatusCode")
    private final int zaly;
    @SafeParcelable.Field(id=4, getter="getMetadata")
    private final Bundle zalz;
    private int[] zama;
    private int zamb;
    private boolean mClosed = false;
    private boolean zamc = true;
    private static final Builder zamd = new zab(new String[0], null);

    @SafeParcelable.Constructor
    DataHolder(@SafeParcelable.Param(id=1000) int n, @SafeParcelable.Param(id=1) String[] stringArray, @SafeParcelable.Param(id=2) CursorWindow[] cursorWindowArray, @SafeParcelable.Param(id=3) int n2, @SafeParcelable.Param(id=4) Bundle bundle) {
        this.zalk = n;
        this.zalv = stringArray;
        this.zalx = cursorWindowArray;
        this.zaly = n2;
        this.zalz = bundle;
    }

    @KeepForSdk
    public DataHolder(String[] stringArray, CursorWindow[] cursorWindowArray, int n, Bundle bundle) {
        this.zalk = 1;
        this.zalv = (String[])Preconditions.checkNotNull((Object)stringArray);
        this.zalx = (CursorWindow[])Preconditions.checkNotNull((Object)cursorWindowArray);
        this.zaly = n;
        this.zalz = bundle;
        this.zaby();
    }

    private DataHolder(CursorWrapper cursorWrapper, int n, Bundle bundle) {
        this(cursorWrapper.getColumnNames(), DataHolder.zaa(cursorWrapper), n, bundle);
    }

    @KeepForSdk
    public DataHolder(Cursor cursor, int n, Bundle bundle) {
        this(new CursorWrapper(cursor), n, bundle);
    }

    private DataHolder(Builder builder, int n, Bundle bundle) {
        this(builder.zalv, DataHolder.zaa(builder, -1), n, null);
    }

    private DataHolder(Builder builder, int n, Bundle bundle, int n2) {
        this(builder.zalv, DataHolder.zaa(builder, -1), n, bundle);
    }

    public final void zaby() {
        int n;
        this.zalw = new Bundle();
        for (n = 0; n < this.zalv.length; ++n) {
            this.zalw.putInt(this.zalv[n], n);
        }
        this.zama = new int[this.zalx.length];
        n = 0;
        for (int i = 0; i < this.zalx.length; ++i) {
            this.zama[i] = n;
            int n2 = this.zalx[i].getStartPosition();
            int n3 = n - n2;
            n += this.zalx[i].getNumRows() - n3;
        }
        this.zamb = n;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        DataHolder dataHolder = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeStringArray((Parcel)parcel2, (int)1, (String[])dataHolder.zalv, (boolean)false);
        SafeParcelWriter.writeTypedArray((Parcel)parcel2, (int)2, (Parcelable[])dataHolder.zalx, (int)n, (boolean)false);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)3, (int)dataHolder.getStatusCode());
        SafeParcelWriter.writeBundle((Parcel)parcel2, (int)4, (Bundle)dataHolder.getMetadata(), (boolean)false);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)1000, (int)dataHolder.zalk);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
        if ((n & 1) != 0) {
            this.close();
        }
    }

    @KeepForSdk
    public final int getStatusCode() {
        return this.zaly;
    }

    @KeepForSdk
    public final Bundle getMetadata() {
        return this.zalz;
    }

    private static CursorWindow[] zaa(CursorWrapper cursorWrapper) {
        ArrayList<CursorWindow> arrayList = new ArrayList<CursorWindow>();
        try {
            int n = cursorWrapper.getCount();
            CursorWindow cursorWindow = cursorWrapper.getWindow();
            int n2 = 0;
            if (cursorWindow != null && cursorWindow.getStartPosition() == 0) {
                cursorWindow.acquireReference();
                cursorWrapper.setWindow(null);
                arrayList.add(cursorWindow);
                n2 = cursorWindow.getNumRows();
            }
            while (n2 < n && cursorWrapper.moveToPosition(n2)) {
                CursorWindow cursorWindow2 = cursorWrapper.getWindow();
                if (cursorWindow2 != null) {
                    cursorWindow2.acquireReference();
                    cursorWrapper.setWindow(null);
                } else {
                    cursorWindow2 = new CursorWindow(false);
                    cursorWindow2.setStartPosition(n2);
                    cursorWrapper.fillWindow(n2, cursorWindow2);
                }
                if (cursorWindow2.getNumRows() != 0) {
                    arrayList.add(cursorWindow2);
                    n2 = cursorWindow2.getStartPosition() + cursorWindow2.getNumRows();
                    continue;
                }
                break;
            }
        }
        finally {
            cursorWrapper.close();
        }
        return arrayList.toArray(new CursorWindow[arrayList.size()]);
    }

    private static CursorWindow[] zaa(Builder builder, int n) {
        if (builder.zalv.length == 0) {
            return new CursorWindow[0];
        }
        List list = n < 0 || n >= builder.zame.size() ? builder.zame : builder.zame.subList(0, n);
        int n2 = list.size();
        CursorWindow cursorWindow = new CursorWindow(false);
        ArrayList<CursorWindow> arrayList = new ArrayList<CursorWindow>();
        arrayList.add(cursorWindow);
        cursorWindow.setNumColumns(builder.zalv.length);
        boolean bl = false;
        try {
            for (int i = 0; i < n2; ++i) {
                int n3;
                if (!cursorWindow.allocRow()) {
                    int n4 = i;
                    Log.d((String)"DataHolder", (String)new StringBuilder(72).append("Allocating additional cursor window for large data set (row ").append(n4).append(")").toString());
                    cursorWindow = new CursorWindow(false);
                    cursorWindow.setStartPosition(i);
                    cursorWindow.setNumColumns(builder.zalv.length);
                    arrayList.add(cursorWindow);
                    if (!cursorWindow.allocRow()) {
                        Log.e((String)"DataHolder", (String)"Unable to allocate row to hold data.");
                        arrayList.remove(cursorWindow);
                        return arrayList.toArray(new CursorWindow[arrayList.size()]);
                    }
                }
                Map map = (Map)list.get(i);
                boolean bl2 = true;
                for (n3 = 0; n3 < builder.zalv.length && bl2; ++n3) {
                    String string2 = builder.zalv[n3];
                    Object v = map.get(string2);
                    if (v == null) {
                        bl2 = cursorWindow.putNull(i, n3);
                        continue;
                    }
                    if (v instanceof String) {
                        bl2 = cursorWindow.putString((String)v, i, n3);
                        continue;
                    }
                    if (v instanceof Long) {
                        bl2 = cursorWindow.putLong(((Long)v).longValue(), i, n3);
                        continue;
                    }
                    if (v instanceof Integer) {
                        bl2 = cursorWindow.putLong((long)((Integer)v).intValue(), i, n3);
                        continue;
                    }
                    if (v instanceof Boolean) {
                        boolean bl3 = (Boolean)v;
                        bl2 = cursorWindow.putLong(bl3 ? 1L : 0L, i, n3);
                        continue;
                    }
                    if (v instanceof byte[]) {
                        bl2 = cursorWindow.putBlob((byte[])v, i, n3);
                        continue;
                    }
                    if (v instanceof Double) {
                        bl2 = cursorWindow.putDouble(((Double)v).doubleValue(), i, n3);
                        continue;
                    }
                    if (v instanceof Float) {
                        bl2 = cursorWindow.putDouble((double)((Float)v).floatValue(), i, n3);
                        continue;
                    }
                    String string3 = String.valueOf(v);
                    throw new IllegalArgumentException(new StringBuilder(32 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Unsupported object for column ").append(string2).append(": ").append(string3).toString());
                }
                if (!bl2) {
                    if (bl) {
                        String string4 = "Could not add the value to a new CursorWindow. The size of value may be larger than what a CursorWindow can handle.";
                        throw new zaa(string4);
                    }
                    n3 = i;
                    Log.d((String)"DataHolder", (String)new StringBuilder(74).append("Couldn't populate window data for row ").append(n3).append(" - allocating new window.").toString());
                    cursorWindow.freeLastRow();
                    cursorWindow = new CursorWindow(false);
                    cursorWindow.setStartPosition(i);
                    cursorWindow.setNumColumns(builder.zalv.length);
                    arrayList.add(cursorWindow);
                    --i;
                    bl = true;
                    continue;
                }
                bl = false;
            }
        }
        catch (RuntimeException runtimeException) {
            int n5 = arrayList.size();
            for (int i = 0; i < n5; ++i) {
                ((CursorWindow)arrayList.get(i)).close();
            }
            throw runtimeException;
        }
        return arrayList.toArray(new CursorWindow[arrayList.size()]);
    }

    private final void zaa(String string2, int n) {
        if (this.zalw == null || !this.zalw.containsKey(string2)) {
            String string3 = String.valueOf(string2);
            throw new IllegalArgumentException(string3.length() != 0 ? "No such column: ".concat(string3) : new String("No such column: "));
        }
        if (this.isClosed()) {
            throw new IllegalArgumentException("Buffer is closed.");
        }
        if (n < 0 || n >= this.zamb) {
            throw new CursorIndexOutOfBoundsException(n, this.zamb);
        }
    }

    @KeepForSdk
    public final boolean hasColumn(String string2) {
        return this.zalw.containsKey(string2);
    }

    @KeepForSdk
    public final long getLong(String string2, int n, int n2) {
        this.zaa(string2, n);
        return this.zalx[n2].getLong(n, this.zalw.getInt(string2));
    }

    @KeepForSdk
    public final int getInteger(String string2, int n, int n2) {
        this.zaa(string2, n);
        return this.zalx[n2].getInt(n, this.zalw.getInt(string2));
    }

    @KeepForSdk
    public final String getString(String string2, int n, int n2) {
        this.zaa(string2, n);
        return this.zalx[n2].getString(n, this.zalw.getInt(string2));
    }

    @KeepForSdk
    public final boolean getBoolean(String string2, int n, int n2) {
        this.zaa(string2, n);
        return Long.valueOf(this.zalx[n2].getLong(n, this.zalw.getInt(string2))) == 1L;
    }

    public final float zaa(String string2, int n, int n2) {
        this.zaa(string2, n);
        return this.zalx[n2].getFloat(n, this.zalw.getInt(string2));
    }

    public final double zab(String string2, int n, int n2) {
        this.zaa(string2, n);
        return this.zalx[n2].getDouble(n, this.zalw.getInt(string2));
    }

    @KeepForSdk
    public final byte[] getByteArray(String string2, int n, int n2) {
        this.zaa(string2, n);
        return this.zalx[n2].getBlob(n, this.zalw.getInt(string2));
    }

    public final void zaa(String string2, int n, int n2, CharArrayBuffer charArrayBuffer) {
        this.zaa(string2, n);
        this.zalx[n2].copyStringToBuffer(n, this.zalw.getInt(string2), charArrayBuffer);
    }

    @KeepForSdk
    public final boolean hasNull(String string2, int n, int n2) {
        this.zaa(string2, n);
        return this.zalx[n2].isNull(n, this.zalw.getInt(string2));
    }

    @KeepForSdk
    public final int getCount() {
        return this.zamb;
    }

    @KeepForSdk
    public final int getWindowIndex(int n) {
        int n2;
        Preconditions.checkState((n >= 0 && n < this.zamb ? 1 : 0) != 0);
        for (n2 = 0; n2 < this.zama.length; ++n2) {
            if (n >= this.zama[n2]) continue;
            --n2;
            break;
        }
        if (n2 == this.zama.length) {
            --n2;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    public final boolean isClosed() {
        DataHolder dataHolder = this;
        synchronized (dataHolder) {
            return this.mClosed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @KeepForSdk
    public final void close() {
        DataHolder dataHolder = this;
        synchronized (dataHolder) {
            if (!this.mClosed) {
                this.mClosed = true;
                for (int i = 0; i < this.zalx.length; ++i) {
                    this.zalx[i].close();
                }
            }
            return;
        }
    }

    protected final void finalize() throws Throwable {
        try {
            if (this.zamc && this.zalx.length > 0 && !this.isClosed()) {
                this.close();
                String string2 = this.toString();
                Log.e((String)"DataBuffer", (String)new StringBuilder(178 + String.valueOf(string2).length()).append("Internal data leak within a DataBuffer object detected!  Be sure to explicitly call release() on all DataBuffer extending objects when you are done with them. (internal object: ").append(string2).append(")").toString());
            }
            return;
        }
        finally {
            super.finalize();
        }
    }

    @KeepForSdk
    public static Builder builder(String[] stringArray) {
        return new Builder(stringArray, null, null);
    }

    @KeepForSdk
    public static DataHolder empty(int n) {
        return new DataHolder(zamd, n, null);
    }

    /* synthetic */ DataHolder(Builder builder, int n, Bundle bundle, zab zab2) {
        this(builder, n, null);
    }

    /* synthetic */ DataHolder(Builder builder, int n, Bundle bundle, int n2, zab zab2) {
        this(builder, n, bundle, -1);
    }

    public static final class zaa
    extends RuntimeException {
        public zaa(String string2) {
            super(string2);
        }
    }

    @KeepForSdk
    public static class Builder {
        private final String[] zalv;
        private final ArrayList<HashMap<String, Object>> zame;
        private final String zamf;
        private final HashMap<Object, Integer> zamg;
        private boolean zamh;
        private String zami;

        private Builder(String[] stringArray, String string2) {
            this.zalv = (String[])Preconditions.checkNotNull((Object)stringArray);
            this.zame = new ArrayList();
            this.zamf = string2;
            this.zamg = new HashMap();
            this.zamh = false;
            this.zami = null;
        }

        public Builder zaa(HashMap<String, Object> hashMap) {
            int n;
            int n2;
            Asserts.checkNotNull(hashMap);
            HashMap<String, Object> hashMap2 = hashMap;
            Builder builder = this;
            if (builder.zamf == null) {
                n2 = -1;
            } else {
                Object object = hashMap2.get(builder.zamf);
                if (object == null) {
                    n2 = -1;
                } else {
                    Integer n3 = builder.zamg.get(object);
                    if (n3 == null) {
                        builder.zamg.put(object, builder.zame.size());
                        n2 = -1;
                    } else {
                        n2 = n = n3.intValue();
                    }
                }
            }
            if (n2 == -1) {
                this.zame.add(hashMap);
            } else {
                this.zame.remove(n);
                this.zame.add(n, hashMap);
            }
            this.zamh = false;
            return this;
        }

        @KeepForSdk
        public Builder withRow(ContentValues contentValues) {
            Asserts.checkNotNull((Object)contentValues);
            HashMap<String, Object> hashMap = new HashMap<String, Object>(contentValues.size());
            for (Map.Entry entry : contentValues.valueSet()) {
                hashMap.put((String)entry.getKey(), entry.getValue());
            }
            return this.zaa(hashMap);
        }

        @KeepForSdk
        public DataHolder build(int n) {
            return new DataHolder(this, n, null, null);
        }

        @KeepForSdk
        public DataHolder build(int n, Bundle bundle) {
            return new DataHolder(this, n, bundle, -1, null);
        }

        /* synthetic */ Builder(String[] stringArray, String string2, zab zab2) {
            this(stringArray, null);
        }
    }
}

